/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.app.manager.war.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.app.manager.ApplicationManager;
import com.ibm.ws.app.manager.CacheUtils;
import com.ibm.ws.app.manager.module.AbstractDeployedAppInfoFactory;
import com.ibm.ws.app.manager.module.DeployedAppInfo;
import com.ibm.ws.app.manager.module.DeployedAppInfoFactory;
import com.ibm.ws.app.manager.module.DeployedAppServices;
import com.ibm.ws.app.manager.module.internal.ModuleHandler;
import com.ibm.ws.app.manager.war.internal.WARDeployedAppInfo;
import com.ibm.ws.app.manager.war.internal.ZipUtils;
import com.ibm.ws.container.service.app.deploy.extended.ApplicationInfoForContainer;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.NonPersistentCache;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.application.handler.ApplicationInformation;
import com.ibm.wsspi.kernel.service.location.WsResource;
import java.io.File;
import java.io.IOException;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={DeployedAppInfoFactory.class}, property={"service.vendor=IBM", "type:String=war"})
public class WARDeployedAppInfoFactoryImpl
extends AbstractDeployedAppInfoFactory
implements DeployedAppInfoFactory {
    private static final TraceComponent tc = Tr.register(WARDeployedAppInfoFactoryImpl.class, (String[])new String[]{"webcontainer", "applications", "app.manager"}, (String)"com.ibm.ws.app.manager.war.internal.resources.Messages", (String)"com.ibm.ws.app.manager.war.internal.WARDeployedAppInfoFactoryImpl");
    private static final String DEFAULT_APP_LOCATION = "${server.config.dir}/apps/expanded/";
    @Reference
    protected DeployedAppServices deployedAppServices;
    @Reference(target="(type=web)")
    protected ModuleHandler webModuleHandler;
    @Reference
    protected ApplicationManager applicationManager;
    static final long serialVersionUID = 209138972697730943L;

    protected void prepareExpansion(String warName) throws IOException {
        try {
            WsResource expansionResource = this.deployedAppServices.getLocationAdmin().resolveResource(this.applicationManager.getExpandLocation());
            if (expansionResource != null && expansionResource.isType(WsResource.Type.DIRECTORY)) {
                expansionResource.create();
            } else {
                Tr.warning((TraceComponent)tc, (String)"warning.could.not.expand.app.loc", (Object[])new Object[]{warName, this.applicationManager.getExpandLocation()});
                expansionResource = null;
                expansionResource = this.deployedAppServices.getLocationAdmin().resolveResource(DEFAULT_APP_LOCATION);
                expansionResource.create();
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.app.manager.war.internal.WARDeployedAppInfoFactoryImpl", (String)"64", (Object)((Object)this), (Object[])new Object[]{warName});
            Tr.warning((TraceComponent)tc, (String)"warning.could.not.expand.app.loc", (Object[])new Object[]{warName, this.applicationManager.getExpandLocation()});
            WsResource expansionResource = null;
            expansionResource = this.deployedAppServices.getLocationAdmin().resolveResource(DEFAULT_APP_LOCATION);
            expansionResource.create();
        }
    }

    protected WsResource resolveExpansion(String appName) {
        return this.deployedAppServices.getLocationAdmin().resolveResource(this.applicationManager.getExpandLocation() + appName + ".war/");
    }

    protected void expand(String name, File collapsedFile, WsResource expandedResource, File expandedFile) throws IOException {
        File failedDelete;
        String collapsedPath = collapsedFile.getAbsolutePath();
        if (expandedFile.exists() && (failedDelete = ZipUtils.deleteWithRetry(expandedFile)) != null) {
            if (failedDelete == expandedFile) {
                throw new IOException("Failed to delete [ " + expandedFile.getAbsolutePath() + " ]");
            }
            throw new IOException("Failed to delete [ " + expandedFile.getAbsolutePath() + " ] because [ " + failedDelete.getAbsolutePath() + " ] could not be deleted.");
        }
        expandedResource.create();
        ZipUtils.unzip(collapsedFile, expandedFile, false, collapsedFile.lastModified());
    }

    /*
     * WARNING - void declaration
     */
    public WARDeployedAppInfo createDeployedAppInfo(ApplicationInformation<DeployedAppInfo> appInfo) throws UnableToAdaptException {
        String warId = (String)appInfo.getConfigProperty("id");
        String warPid = appInfo.getPid();
        String warName = appInfo.getName();
        String warPath = appInfo.getLocation();
        Tr.debug((TraceComponent)tc, (String)("Create deployed application: ID [ " + warId + " ] PID [ " + warPid + " ] Name [ " + warName + " ] Location [ " + warPath + " ]"), (Object[])new Object[0]);
        File warFile = new File(warPath);
        AbstractDeployedAppInfoFactory.BinaryType appType = this.getApplicationType(warFile, warPath);
        if (appType == AbstractDeployedAppInfoFactory.BinaryType.LOOSE) {
            Tr.info((TraceComponent)tc, (String)"info.loose.app", (Object[])new Object[]{warName, warPath});
        } else if (appType == AbstractDeployedAppInfoFactory.BinaryType.DIRECTORY) {
            Tr.info((TraceComponent)tc, (String)"info.directory.app", (Object[])new Object[]{warName, warPath});
        } else if (this.applicationManager.getExpandApps()) {
            try {
                this.prepareExpansion(warName);
                WsResource expandedResource = this.resolveExpansion(warName);
                File expandedFile = expandedResource.asFile();
                if (this.applicationManager.shouldExpand(expandedFile.getName(), warFile, expandedFile)) {
                    Tr.info((TraceComponent)tc, (String)"info.expanding.app", (Object[])new Object[]{warName, warPath, expandedFile.getAbsolutePath()});
                    this.expand(warName, warFile, expandedResource, expandedFile);
                }
                NonPersistentCache initialCache = (NonPersistentCache)appInfo.getContainer().adapt(NonPersistentCache.class);
                ApplicationInfoForContainer appContainerInfo = (ApplicationInfoForContainer)initialCache.getFromCache(ApplicationInfoForContainer.class);
                String cacheId = CacheUtils.getCacheId((String)warPid, (String)warId);
                Container expandedContainer = this.deployedAppServices.setupContainer(cacheId, expandedFile);
                appInfo.setContainer(expandedContainer);
                if (appContainerInfo != null) {
                    NonPersistentCache finalCache = (NonPersistentCache)appInfo.getContainer().adapt(NonPersistentCache.class);
                    finalCache.addToCache(ApplicationInfoForContainer.class, (Object)appContainerInfo);
                }
            }
            catch (IOException expandedResource) {
                void e;
                FFDCFilter.processException((Throwable)expandedResource, (String)"com.ibm.ws.app.manager.war.internal.WARDeployedAppInfoFactoryImpl", (String)"161", (Object)((Object)this), (Object[])new Object[]{appInfo});
                Tr.error((TraceComponent)tc, (String)"warning.could.not.expand.application", (Object[])new Object[]{warName, e.getMessage()});
            }
        } else {
            Tr.info((TraceComponent)tc, (String)"info.unexpanded.app", (Object[])new Object[]{warName, warPath});
        }
        WARDeployedAppInfo deployedApp = new WARDeployedAppInfo(appInfo, this.deployedAppServices, this.webModuleHandler);
        appInfo.setHandlerInfo((Object)deployedApp);
        return deployedApp;
    }
}

