/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.openapi.impl.validation;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.microprofile.openapi.impl.validation.OASValidationResult;
import com.ibm.ws.microprofile.openapi.impl.validation.TypeValidator;
import com.ibm.ws.microprofile.openapi.impl.validation.ValidationHelper;
import com.ibm.ws.microprofile.openapi.impl.validation.ValidatorUtils;
import com.ibm.ws.microprofile.openapi.utils.OpenAPIModelWalker;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.microprofile.openapi.models.media.XML;

public class XMLValidator
extends TypeValidator<XML> {
    private static final TraceComponent tc = Tr.register(XMLValidator.class);
    private static final XMLValidator INSTANCE = new XMLValidator();

    public static XMLValidator getInstance() {
        return INSTANCE;
    }

    private XMLValidator() {
    }

    @Override
    public void validate(ValidationHelper helper, OpenAPIModelWalker.Context context, String key, XML t) {
        String namespace;
        if (t != null && StringUtils.isNotBlank((CharSequence)t.getNamespace()) && !ValidatorUtils.isValidURI(namespace = t.getNamespace())) {
            String message = Tr.formatMessage((TraceComponent)tc, (String)"invalidUri", (Object[])new Object[]{namespace});
            helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message));
        }
    }
}

