/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.openapi.impl.validation;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.microprofile.openapi.impl.validation.OASValidationResult;
import com.ibm.ws.microprofile.openapi.impl.validation.RuntimeExpressionUtils;
import com.ibm.ws.microprofile.openapi.impl.validation.TypeValidator;
import com.ibm.ws.microprofile.openapi.impl.validation.ValidationHelper;
import com.ibm.ws.microprofile.openapi.impl.validation.ValidatorUtils;
import com.ibm.ws.microprofile.openapi.utils.OpenAPIModelWalker;
import com.ibm.ws.microprofile.openapi.utils.OpenAPIUtils;
import java.util.List;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.callbacks.Callback;

public class CallbackValidator
extends TypeValidator<Callback> {
    private static final TraceComponent tc = Tr.register(CallbackValidator.class);
    private static final CallbackValidator INSTANCE = new CallbackValidator();

    public static CallbackValidator getInstance() {
        return INSTANCE;
    }

    private CallbackValidator() {
    }

    @Override
    public void validate(ValidationHelper helper, OpenAPIModelWalker.Context context, String key, Callback t) {
        for (String urlTemplate : t.keySet()) {
            Object pathItem;
            String message;
            if (urlTemplate.isEmpty()) {
                message = Tr.formatMessage((TraceComponent)tc, (String)"callbackURLTemplateEmpty", (Object[])new Object[0]);
                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message));
                continue;
            }
            List<String> vars = RuntimeExpressionUtils.extractURLVars(urlTemplate);
            if (vars == null) {
                message = Tr.formatMessage((TraceComponent)tc, (String)"callbackInvalidSubstitutionVariables", (Object[])new Object[]{urlTemplate});
                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message));
            } else {
                for (String v : vars) {
                    if (RuntimeExpressionUtils.isRuntimeExpression(v)) continue;
                    message = Tr.formatMessage((TraceComponent)tc, (String)"callbackMustBeRuntimeExpression", (Object[])new Object[]{v});
                    helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message));
                }
                String buildURL = urlTemplate;
                for (String v : vars) {
                    String templateVar = "{" + v + "}";
                    buildURL = buildURL.replace(templateVar, "e");
                }
                if (urlTemplate.contains("{$")) {
                    if (OpenAPIUtils.isDebugEnabled(tc)) {
                        Tr.debug((TraceComponent)tc, (String)("Path contains variables. Skip validation of url: " + key), (Object[])new Object[0]);
                    }
                } else if (!ValidatorUtils.isValidURI(buildURL)) {
                    message = Tr.formatMessage((TraceComponent)tc, (String)"callbackInvalidURL", (Object[])new Object[]{urlTemplate});
                    helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message));
                }
            }
            if ((pathItem = t.get((Object)urlTemplate)) instanceof PathItem) continue;
            message = Tr.formatMessage((TraceComponent)tc, (String)"callbackInvalidPathItem", (Object[])new Object[]{urlTemplate});
            helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message));
        }
    }
}

