/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.mp.jwt.impl.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.security.jwt.JwtToken;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.ArrayList;
import java.util.Map;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class JwtPrincipalMapping {
    private static TraceComponent tc = Tr.register(JwtPrincipalMapping.class, (String)"MPJWT", (String)"com.ibm.ws.security.mp.jwt.resources.MicroProfileJwtMessages");
    protected static final String REALM_CLAIM = "realm";
    private Map claims = null;
    String realm = null;
    String userName = null;
    ArrayList<String> groupIds = null;
    static final long serialVersionUID = -812550881881354756L;

    @ManualTrace
    public JwtPrincipalMapping(JwtToken jwtToken, String userAttr, String groupAttr, boolean mapToUr) {
        String methodName = "<init>";
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[]{jwtToken, userAttr, groupAttr, mapToUr});
        }
        this.userName = this.getUserName(userAttr, jwtToken);
        if (this.userName == null) {
            if (tc.isDebugEnabled()) {
                Tr.exit((TraceComponent)tc, (String)methodName);
            }
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"user name = ", (Object[])new Object[]{this.userName});
        }
        if (!mapToUr) {
            this.realm = this.getRealm(REALM_CLAIM, jwtToken);
            this.populateGroupIds(jwtToken, groupAttr);
        }
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName);
        }
    }

    private String getRealm(String realmAttribute, JwtToken jwtToken) {
        Object realm;
        if (jwtToken != null && realmAttribute != null && (realm = this.getClaim(jwtToken, realmAttribute)) instanceof String) {
            return (String)realm;
        }
        return null;
    }

    public boolean isUserNameNull() {
        return this.userName == null || this.userName.isEmpty();
    }

    public String getMappedRealm() {
        return this.realm;
    }

    public String getMappedUser() {
        return this.userName;
    }

    public ArrayList<String> getMappedGroups() {
        return this.groupIds;
    }

    @ManualTrace
    private String getUserName(String userNameAttr, JwtToken jwtToken) {
        String methodName = "getUserName";
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[]{userNameAttr, jwtToken});
        }
        if (jwtToken != null && userNameAttr != null && !userNameAttr.isEmpty()) {
            Object user = this.getClaim(jwtToken, userNameAttr);
            this.setUserName(userNameAttr, user);
        }
        if (this.userName == null) {
            Tr.error((TraceComponent)tc, (String)"PRINCIPAL_MAPPING_MISSING_ATTR", (Object[])new Object[]{userNameAttr, "userNameAttribute"});
        }
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName, (Object)this.userName);
        }
        return this.userName;
    }

    void setUserName(String userNameAttr, Object user) {
        if (user == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Provided user name object is null. Current user name [" + this.userName + "] will not be changed"), (Object[])new Object[0]);
            }
            return;
        }
        if (user instanceof String) {
            this.userName = (String)user;
        } else {
            Tr.error((TraceComponent)tc, (String)"PRINCIPAL_MAPPING_INCORRECT_CLAIM_TYPE", (Object[])new Object[]{userNameAttr, "userNameAttribute"});
        }
    }

    @ManualTrace
    void populateGroupIds(JwtToken jwtToken, String groupAttr) {
        String methodName = "populateGroupIds";
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[]{jwtToken, groupAttr});
        }
        Object groupClaim = null;
        if (groupAttr != null) {
            groupClaim = this.getClaim(jwtToken, groupAttr);
        }
        this.populateGroupIdsFromGroupClaim(groupClaim);
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName);
        }
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    Object getClaim(JwtToken jwtToken, String claimAttr) {
        String methodName = "getClaim";
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[]{jwtToken, claimAttr});
        }
        Object claim = null;
        try {
            if (this.claims != null) {
                claim = this.claims.get(claimAttr);
            } else {
                this.claims = jwtToken.getClaims();
                if (this.claims != null) {
                    claim = this.claims.get(claimAttr);
                }
            }
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.mp.jwt.impl.utils.JwtPrincipalMapping", (String)"159", (Object)this, (Object[])new Object[]{jwtToken, claimAttr});
            Tr.error((TraceComponent)tc, (String)"CANNOT_GET_CLAIM_FROM_JSON", (Object[])new Object[]{claimAttr, e.getLocalizedMessage()});
        }
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName, claim);
        }
        return claim;
    }

    @ManualTrace
    void populateGroupIdsFromGroupClaim(Object groupClaim) {
        String methodName = "populateGroupIdsFromGroupClaim";
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[]{groupClaim});
        }
        if (groupClaim == null) {
            if (tc.isDebugEnabled()) {
                Tr.exit((TraceComponent)tc, (String)methodName);
            }
            return;
        }
        if (groupClaim instanceof ArrayList) {
            this.setGroupIdArrayList(groupClaim);
        } else {
            this.setGroupClaimAsOnlyGroupId(groupClaim);
        }
        if (this.groupIds != null && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"groups size = ", (Object[])new Object[]{this.groupIds.size()});
        }
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName);
        }
    }

    @ManualTrace
    void setGroupIdArrayList(Object groupClaim) {
        String methodName = "setGroupIdArrayList";
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[]{groupClaim});
        }
        this.groupIds = (ArrayList)groupClaim;
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName);
        }
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    void setGroupClaimAsOnlyGroupId(Object groupClaim) {
        String methodName;
        block4: {
            methodName = "setGroupClaimAsOnlyGroupId";
            if (tc.isDebugEnabled()) {
                Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[]{groupClaim});
            }
            try {
                String groupName = (String)groupClaim;
                this.groupIds = new ArrayList();
                this.groupIds.add(groupName);
            }
            catch (ClassCastException groupName) {
                void cce;
                FFDCFilter.processException((Throwable)groupName, (String)"com.ibm.ws.security.mp.jwt.impl.utils.JwtPrincipalMapping", (String)"213", (Object)this, (Object[])new Object[]{groupClaim});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block4;
                Tr.debug((TraceComponent)tc, (String)("cannot get meaningful group due to CCE: " + cce), (Object[])new Object[0]);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName);
        }
    }
}

