/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.config.cdi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.cdi.extension.WebSphereCDIExtension;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.microprofile.config.cdi.ConfigBean;
import com.ibm.ws.microprofile.config.cdi.ConfigProducer;
import com.ibm.ws.microprofile.config.cdi.ConfigPropertyBean;
import com.ibm.ws.microprofile.config.cdi.ConfigPropertyLiteral;
import com.ibm.ws.microprofile.config.cdi.ConfigTypeException;
import com.ibm.ws.microprofile.config.converters.DefaultConverters;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.ProcessInjectionTarget;
import javax.inject.Provider;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ConfigCDIExtension
implements Extension,
WebSphereCDIExtension {
    private static final TraceComponent tc = Tr.register(ConfigCDIExtension.class, (String)"APPCONFIG", (String)"com.ibm.ws.microprofile.config.cdi.resources.ConfigCDI");
    protected Set<Type> validInjectionTypes = new HashSet<Type>();
    protected Set<Type> badInjectionTypes = new HashSet<Type>();
    static final long serialVersionUID = 6137099578362140994L;

    public ConfigCDIExtension() {
        this.validInjectionTypes.addAll(this.getDefaultConverterTypes());
    }

    protected void addBadInjectionType(Type type) {
        this.badInjectionTypes.add(type);
    }

    protected Collection<? extends Type> getDefaultConverterTypes() {
        return DefaultConverters.getDefaultConverters().getTypes();
    }

    /*
     * WARNING - void declaration
     */
    void processInjectionTarget(@Observes ProcessInjectionTarget<?> pit) {
        final Class targetClass = pit.getAnnotatedType().getJavaClass();
        ClassLoader classLoader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){
            static final long serialVersionUID = -8532372968269337167L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public ClassLoader run() {
                return targetClass.getClassLoader();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.microprofile.config.cdi.ConfigCDIExtension$1", 1.class, (String)"APPCONFIG", (String)"com.ibm.ws.microprofile.config.cdi.resources.ConfigCDI");
            }
        });
        for (InjectionPoint injectionPoint : pit.getInjectionTarget().getInjectionPoints()) {
            ConfigProperty configProperty = ConfigProducer.getConfigPropertyAnnotation(injectionPoint);
            if (configProperty == null) continue;
            Type type = injectionPoint.getType();
            ConfigProperty qualifier = ConfigProducer.getConfigPropertyAnnotation(injectionPoint);
            String defaultValue = qualifier.defaultValue();
            String propertyName = null;
            Throwable configException = null;
            try {
                propertyName = ConfigProducer.getPropertyName(injectionPoint, qualifier);
                configException = this.validateConfigProperty(type, propertyName, defaultValue, classLoader);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                void e;
                FFDCFilter.processException((Throwable)illegalArgumentException, (String)"com.ibm.ws.microprofile.config.cdi.ConfigCDIExtension", (String)"83", (Object)this, (Object[])new Object[]{pit});
                configException = e;
            }
            if (configException == null) continue;
            Tr.error((TraceComponent)tc, (String)"unable.to.resolve.injection.point.CWMCG5003E", (Object[])new Object[]{injectionPoint, configException});
        }
    }

    protected Throwable validateConfigProperty(Type type, String propertyName, String defaultValue, ClassLoader classLoader) {
        Throwable configException = null;
        if (type instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)type;
            configException = this.processParameterizedType(propertyName, defaultValue, pType, classLoader);
        } else {
            configException = this.processConversionType(propertyName, defaultValue, type, classLoader);
        }
        return configException;
    }

    /*
     * WARNING - void declaration
     */
    void afterBeanDiscovery(@Observes AfterBeanDiscovery abd, BeanManager beanManager) {
        ConfigBean configBean = new ConfigBean(beanManager);
        abd.addBean((Bean)configBean);
        this.validInjectionTypes.removeAll(this.badInjectionTypes);
        for (Type type : this.validInjectionTypes) {
            try {
                if (type instanceof TypeVariable) {
                    Type[] bounds;
                    TypeVariable typeVar = (TypeVariable)type;
                    for (Type bound : bounds = typeVar.getBounds()) {
                        this.addConfigPropertyBean(abd, beanManager, bound);
                    }
                    continue;
                }
                this.addConfigPropertyBean(abd, beanManager, type);
            }
            catch (ConfigTypeException typeVar) {
                void e;
                FFDCFilter.processException((Throwable)typeVar, (String)"com.ibm.ws.microprofile.config.cdi.ConfigCDIExtension", (String)"122", (Object)this, (Object[])new Object[]{abd, beanManager});
                abd.addDefinitionError((Throwable)e);
            }
        }
    }

    protected Throwable processParameterizedType(String propertyName, String defaultValue, ParameterizedType pType, ClassLoader classLoader) {
        Throwable configException = null;
        Type rType = pType.getRawType();
        if (Provider.class.isAssignableFrom((Class)rType)) {
            Type[] aTypes = pType.getActualTypeArguments();
            Type type = aTypes[0];
            configException = this.processConversionType(propertyName, defaultValue, type, classLoader);
        } else {
            configException = this.processConversionType(propertyName, defaultValue, pType, classLoader);
        }
        return configException;
    }

    /*
     * WARNING - void declaration
     */
    protected Throwable processConversionType(String propertyName, String defaultValue, Type injectionType, ClassLoader classLoader) {
        Throwable configException = null;
        Config config = ConfigProvider.getConfig((ClassLoader)classLoader);
        try {
            ConfigProducer.newValue(config, propertyName, defaultValue, injectionType);
            this.validInjectionTypes.add(injectionType);
        }
        catch (Throwable throwable) {
            void e;
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.microprofile.config.cdi.ConfigCDIExtension", (String)"151", (Object)this, (Object[])new Object[]{propertyName, defaultValue, injectionType, classLoader});
            configException = e;
            this.addBadInjectionType(injectionType);
        }
        return configException;
    }

    private void addConfigPropertyBean(AfterBeanDiscovery abd, BeanManager beanManager, Type type) throws ConfigTypeException {
        if (type instanceof Class) {
            Class clazz = (Class)type;
            this.addConfigPropertyBean(abd, beanManager, clazz);
        } else if (type instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)type;
            this.addConfigPropertyBean(abd, beanManager, pType);
        } else {
            throw new ConfigTypeException(Tr.formatMessage((TraceComponent)tc, (String)"unable.to.determine.injection.type.CWMCG5001E", (Object[])new Object[]{type}));
        }
    }

    private void addConfigPropertyBean(AfterBeanDiscovery abd, BeanManager beanManager, Class<?> type) {
        if (!type.isPrimitive()) {
            this.addConfigPropertyBean(abd, beanManager, type, type);
        }
    }

    private void addConfigPropertyBean(AfterBeanDiscovery abd, BeanManager beanManager, ParameterizedType type) throws ConfigTypeException {
        Type rType = type.getRawType();
        if (!(rType instanceof Class)) {
            throw new ConfigTypeException(Tr.formatMessage((TraceComponent)tc, (String)"unable.to.determine.injection.type.CWMCG5001E", (Object[])new Object[]{type}));
        }
        Class clazz = (Class)rType;
        this.addConfigPropertyBean(abd, beanManager, type, clazz);
    }

    protected <T> void addConfigPropertyBean(AfterBeanDiscovery abd, BeanManager beanManager, Type beanType, Class<T> clazz) {
        ConfigPropertyBean<T> converterBean = new ConfigPropertyBean<T>(beanManager, beanType, clazz, ConfigPropertyLiteral.INSTANCE);
        abd.addBean(converterBean);
    }
}

