/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.boot;

import com.ibm.ws.kernel.boot.ReturnCode;
import com.ibm.ws.kernel.boot.internal.BootstrapConstants;
import io.openliberty.checkpoint.spi.CheckpointPhase;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;

public class LaunchArguments {
    static final String MESSAGE_ACTION = "--message:";
    static final String HELP_UNKNOWN_ACTION = "--help:actions:";
    private static final List<String> KNOWN_OPTIONS = Collections.unmodifiableList(Arrays.asList("archive", "include", "os", "pid", "pid-file", "script", "template", "force", "target", "no-password", "server-root"));
    private final String script = System.getenv("INVOKED");
    private final String actionOption;
    private final String processName;
    private final ReturnCode returnCode;
    Map<String, String> options = new HashMap<String, String>();
    private List<String> extraArguments = Collections.emptyList();

    LaunchArguments(List<String> cmdArgs, Map<String, String> initProps) {
        this(cmdArgs, initProps, false);
    }

    LaunchArguments(List<String> cmdArgs, Map<String, String> initProps, boolean isClient) {
        String includeValue;
        ReturnCode returnValue = ReturnCode.OK;
        String action = null;
        String processNameArg = null;
        String checkpointPhase = null;
        String helpAction = null;
        if (cmdArgs.size() > 0) {
            ListIterator<String> i = cmdArgs.listIterator();
            while (i.hasNext() && returnValue != ReturnCode.BAD_ARGUMENT) {
                String arg = (String)i.next();
                if (arg.equals("--")) {
                    i.remove();
                    break;
                }
                if (arg.startsWith("-D")) {
                    i.remove();
                    break;
                }
                if (arg.startsWith("-")) {
                    String key;
                    String argToLower = arg.toLowerCase(Locale.ENGLISH);
                    i.remove();
                    if (argToLower.contains("-help")) {
                        this.options.put("arg", argToLower);
                        if (argToLower.startsWith(HELP_UNKNOWN_ACTION)) {
                            String unknownAction = arg.substring(HELP_UNKNOWN_ACTION.length());
                            System.out.println(MessageFormat.format(BootstrapConstants.messages.getString("error.unknownArgument"), unknownAction));
                            System.out.println();
                            returnValue = ReturnCode.BAD_ARGUMENT;
                            break;
                        }
                        helpAction = argToLower;
                        continue;
                    }
                    if (argToLower.equals("--version")) {
                        returnValue = this.checkPreviousAction(returnValue, ReturnCode.VERSION_ACTION, arg);
                        action = this.setActionIfOk(returnValue, action, arg);
                        continue;
                    }
                    if (argToLower.equals("--list")) {
                        returnValue = this.checkPreviousAction(returnValue, ReturnCode.LIST_ACTION, arg);
                        action = this.setActionIfOk(returnValue, action, arg);
                        continue;
                    }
                    if (argToLower.equals("--create")) {
                        returnValue = this.checkPreviousAction(returnValue, ReturnCode.CREATE_ACTION, arg);
                        action = this.setActionIfOk(returnValue, action, arg);
                        continue;
                    }
                    if (argToLower.equals("--stop")) {
                        returnValue = this.checkPreviousAction(returnValue, ReturnCode.STOP_ACTION, arg);
                        action = this.setActionIfOk(returnValue, action, arg);
                        continue;
                    }
                    if (argToLower.startsWith("--status")) {
                        if (argToLower.equals("--status")) {
                            returnValue = this.checkPreviousAction(returnValue, ReturnCode.STATUS_ACTION, arg);
                        } else if (argToLower.equals("--status:starting")) {
                            returnValue = this.checkPreviousAction(returnValue, ReturnCode.STARTING_STATUS_ACTION, arg);
                        } else if (argToLower.equals("--status:start")) {
                            returnValue = this.checkPreviousAction(returnValue, ReturnCode.START_STATUS_ACTION, arg);
                        } else {
                            System.out.println(MessageFormat.format(BootstrapConstants.messages.getString("error.unknownArgument"), arg));
                            System.out.println();
                            returnValue = ReturnCode.BAD_ARGUMENT;
                            break;
                        }
                        action = this.setActionIfOk(returnValue, action, arg);
                        continue;
                    }
                    if (argToLower.equals("--package")) {
                        returnValue = this.checkPreviousAction(returnValue, ReturnCode.PACKAGE_ACTION, arg);
                        action = this.setActionIfOk(returnValue, action, arg);
                        continue;
                    }
                    if (argToLower.equals("--dump")) {
                        returnValue = this.checkPreviousAction(returnValue, ReturnCode.DUMP_ACTION, arg);
                        action = this.setActionIfOk(returnValue, action, arg);
                        continue;
                    }
                    if (argToLower.equals("--javadump")) {
                        returnValue = this.checkPreviousAction(returnValue, ReturnCode.JAVADUMP_ACTION, arg);
                        action = this.setActionIfOk(returnValue, action, arg);
                        continue;
                    }
                    if (argToLower.equals("--pause")) {
                        returnValue = this.checkPreviousAction(returnValue, ReturnCode.PAUSE_ACTION, arg);
                        action = this.setActionIfOk(returnValue, action, arg);
                        continue;
                    }
                    if (argToLower.equals("--resume")) {
                        returnValue = this.checkPreviousAction(returnValue, ReturnCode.RESUME_ACTION, arg);
                        action = this.setActionIfOk(returnValue, action, arg);
                        continue;
                    }
                    if (argToLower.startsWith(MESSAGE_ACTION)) {
                        returnValue = this.checkPreviousAction(returnValue, ReturnCode.MESSAGE_ACTION, arg);
                        action = this.setActionIfOk(returnValue, action, arg);
                        String value = arg.substring(MESSAGE_ACTION.length());
                        this.options.put("message", value);
                        break;
                    }
                    if (argToLower.equals("--clean")) {
                        initProps.put("org.osgi.framework.storage.clean", "onFirstInit");
                        System.clearProperty("org.osgi.framework.storage.clean");
                        continue;
                    }
                    if (argToLower.startsWith("--internal-checkpoint-at=")) {
                        if (LaunchArguments.isBetaEdition()) {
                            checkpointPhase = argToLower.substring("--internal-checkpoint-at=".length());
                            continue;
                        }
                        System.out.println(MessageFormat.format(BootstrapConstants.messages.getString("error.unknownArgument"), "checkpoint"));
                        System.out.println();
                        returnValue = ReturnCode.BAD_ARGUMENT;
                        continue;
                    }
                    if (isClient && argToLower.equals("--autoacceptsigner")) {
                        initProps.put("autoAcceptSignerCertificate", "true");
                        continue;
                    }
                    int index = arg.indexOf(61);
                    String value = "";
                    if (argToLower.startsWith("--")) {
                        if (index != -1) {
                            key = argToLower.substring(2, index);
                            value = arg.substring(index + 1);
                        } else {
                            key = arg.substring(2);
                        }
                    } else {
                        key = null;
                    }
                    if (KNOWN_OPTIONS.contains(key)) {
                        this.options.put(key, value);
                        continue;
                    }
                    System.out.println(MessageFormat.format(BootstrapConstants.messages.getString("error.unknownArgument"), arg));
                    System.out.println();
                    returnValue = ReturnCode.BAD_ARGUMENT;
                    break;
                }
                i.remove();
                if (processNameArg != null) {
                    if (isClient) {
                        System.out.println(MessageFormat.format(BootstrapConstants.messages.getString("warning.singleClient"), processNameArg, arg));
                        continue;
                    }
                    System.out.println(MessageFormat.format(BootstrapConstants.messages.getString("warning.singleServer"), processNameArg, arg));
                    continue;
                }
                processNameArg = arg;
            }
        }
        if (helpAction != null) {
            returnValue = ReturnCode.HELP_ACTION;
            if (action == null) {
                action = helpAction;
            }
        }
        if (returnValue == ReturnCode.OK || returnValue == ReturnCode.MESSAGE_ACTION) {
            this.extraArguments = cmdArgs;
        }
        if (returnValue == ReturnCode.PACKAGE_ACTION && "wlp".equals(includeValue = this.options.get("include"))) {
            this.options.remove("include");
            returnValue = ReturnCode.PACKAGE_WLP_ACTION;
        }
        this.returnCode = this.setCheckpointPhase(checkpointPhase, returnValue);
        this.processName = processNameArg;
        this.actionOption = action;
    }

    private ReturnCode setCheckpointPhase(String checkpointPhase, ReturnCode returnValue) {
        try {
            Method setPhase = CheckpointPhase.class.getDeclaredMethod("setPhase", String.class);
            setPhase.setAccessible(true);
            setPhase.invoke((Object)setPhase, checkpointPhase);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (CheckpointPhase.getPhase() == CheckpointPhase.INACTIVE && checkpointPhase != null) {
            System.out.println(MessageFormat.format(BootstrapConstants.messages.getString("error.invalidPhaseName"), checkpointPhase));
            System.out.println();
            return ReturnCode.BAD_ARGUMENT;
        }
        return returnValue;
    }

    public static boolean isBetaEdition() {
        return Boolean.getBoolean("com.ibm.ws.beta.edition");
    }

    private ReturnCode checkPreviousAction(ReturnCode oldRC, ReturnCode newActionRC, String arg) {
        if (oldRC == ReturnCode.OK) {
            return newActionRC;
        }
        System.out.println(MessageFormat.format(BootstrapConstants.messages.getString("error.unknownArgument"), arg));
        System.out.println();
        return ReturnCode.BAD_ARGUMENT;
    }

    private String setActionIfOk(ReturnCode returnCode, String oldAction, String newAction) {
        if (returnCode != ReturnCode.BAD_ARGUMENT) {
            return newAction;
        }
        return oldAction;
    }

    public ReturnCode getRc() {
        return this.returnCode;
    }

    public String getAction() {
        return this.actionOption;
    }

    public String getOption(String name) {
        return this.options.get(name);
    }

    public List<String> getExtraArguments() {
        return this.extraArguments;
    }

    public String getProcessName() {
        return this.processName;
    }

    public String getScript() {
        return this.script;
    }
}

