/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.spi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.recoverylog.spi.Configuration;
import com.ibm.ws.recoverylog.spi.DistributedRecoveryLog;
import com.ibm.ws.recoverylog.spi.FailureScope;
import com.ibm.ws.recoverylog.spi.FileLogProperties;
import com.ibm.ws.recoverylog.spi.HoldingExclusiveLockException;
import com.ibm.ws.recoverylog.spi.InternalLogException;
import com.ibm.ws.recoverylog.spi.InvalidRecoverableUnitException;
import com.ibm.ws.recoverylog.spi.Lock;
import com.ibm.ws.recoverylog.spi.LogAllocationException;
import com.ibm.ws.recoverylog.spi.LogClosedException;
import com.ibm.ws.recoverylog.spi.LogCorruptedException;
import com.ibm.ws.recoverylog.spi.LogCursor;
import com.ibm.ws.recoverylog.spi.LogCursorCallback;
import com.ibm.ws.recoverylog.spi.LogCursorImpl;
import com.ibm.ws.recoverylog.spi.LogFullException;
import com.ibm.ws.recoverylog.spi.LogHandle;
import com.ibm.ws.recoverylog.spi.LogIncompatibleException;
import com.ibm.ws.recoverylog.spi.LogOpenException;
import com.ibm.ws.recoverylog.spi.LogProperties;
import com.ibm.ws.recoverylog.spi.MultiScopeLog;
import com.ibm.ws.recoverylog.spi.NoExclusiveLockException;
import com.ibm.ws.recoverylog.spi.NoSharedLockException;
import com.ibm.ws.recoverylog.spi.RLSUtils;
import com.ibm.ws.recoverylog.spi.ReadableLogRecord;
import com.ibm.ws.recoverylog.spi.RecoverableUnit;
import com.ibm.ws.recoverylog.spi.RecoverableUnitImpl;
import com.ibm.ws.recoverylog.spi.RecoveryAgent;
import com.ibm.ws.recoverylog.utils.DirUtils;
import com.ibm.ws.recoverylog.utils.RecoverableUnitIdTable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class MultiScopeRecoveryLog
implements LogCursorCallback,
MultiScopeLog {
    private static final TraceComponent tc = Tr.register(MultiScopeRecoveryLog.class, (String)"Transaction", (String)"com.ibm.ws.recoverylog.resources.RecoveryLogMsgs");
    private static int DEFAULT_LOGFILE_SIZE = 1024;
    private static final int MIN_LOGFILE_SIZE = 8;
    private static final int LOCK_REQUEST_ID_MSRL_CREATE = 1;
    private static final int LOCK_REQUEST_ID_MSRL_REMOVE = 2;
    protected static final int MEMORY_BACKED = 1;
    protected static final int FILE_BACKED = 2;
    protected static final int IN_MEMORY_MAXIMUM = 5120;
    private static float TOTAL_DATA_RESIZE_TRIGGER = 0.95f;
    private static float TOTAL_DATA_RESIZE_MULTIPLIER = 1.25f;
    private final RecoveryAgent _recoveryAgent;
    private final String _clientName;
    private final int _clientVersion;
    private final String _logName;
    private final int _logIdentifier;
    private final String _serverName;
    private String _logDirectory;
    private int _logFileSize;
    private int _maxLogFileSize;
    private HashMap<Long, RecoverableUnit> _recoverableUnits;
    private LogHandle _logHandle;
    private final Lock _controlLock;
    private int _closesRequired;
    private static String _fileSeparator;
    private final FileLogProperties _fileLogProperties;
    private final AtomicInteger _unwrittenDataSize = new AtomicInteger();
    private int _totalDataSize;
    private int _storageMode = 1;
    private boolean _failed;
    private boolean _incompatible;
    private boolean _logWarningIssued;
    private static final int LOG_WARNING_FACTOR = 3;
    private final RecoverableUnitIdTable _recUnitIdTable = new RecoverableUnitIdTable();
    private String _traceId;
    private final boolean _bypassContainmentCheck;
    FailureScope _failureScope;
    volatile MultiScopeLog _associatedLog = null;
    volatile boolean _failAssociatedLog = false;
    private boolean _retainLogsInPeerRecoveryEnv;
    static final long serialVersionUID = 4848038975055772696L;

    @ManualTrace
    MultiScopeRecoveryLog(FileLogProperties fileLogProperties, RecoveryAgent recoveryAgent, FailureScope fs) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"MultiScopeRecoveryLog", (Object[])new Object[]{fileLogProperties, recoveryAgent, fs});
        }
        this._fileLogProperties = fileLogProperties;
        this._recoveryAgent = recoveryAgent;
        this._logName = this._fileLogProperties.logName();
        this._logIdentifier = this._fileLogProperties.logIdentifier();
        this._logDirectory = this._fileLogProperties.logDirectory();
        this._logFileSize = this._fileLogProperties.logFileSize();
        this._maxLogFileSize = this._fileLogProperties.maxLogFileSize();
        this._clientName = recoveryAgent.clientName();
        this._clientVersion = recoveryAgent.clientVersion();
        this._serverName = fs.serverName();
        this._failureScope = fs;
        if (_fileSeparator == null) {
            _fileSeparator = AccessController.doPrivileged(new PrivilegedAction<String>(){
                static final long serialVersionUID = -5409235925276305951L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public String run() {
                    return System.getProperty("file.separator");
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog$1", 1.class, null, null);
                }
            });
        }
        if (this._logDirectory == null) {
            this._logDirectory = Configuration.WASInstallDirectory() + _fileSeparator + "recoveryLogs" + _fileSeparator + DirUtils.createDirectoryPath(this._serverName) + _fileSeparator + this._clientName + _fileSeparator + this._logName;
        }
        if (this._logFileSize == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Using default values for log file size and maximum size", (Object[])new Object[0]);
            }
            this._logFileSize = DEFAULT_LOGFILE_SIZE;
            this._maxLogFileSize = DEFAULT_LOGFILE_SIZE;
        }
        if (this._logFileSize < 8) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Log file size is too small. Enforcing minimum size", (Object[])new Object[0]);
            }
            this._logFileSize = 8;
        }
        if (this._maxLogFileSize < 8) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Log file maximum size is too small. Enforcing minimum size", (Object[])new Object[0]);
            }
            this._maxLogFileSize = 8;
        }
        if (this._logFileSize > this._maxLogFileSize) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Log file size is greater than maximum. Constraining log file size", (Object[])new Object[0]);
            }
            this._logFileSize = this._maxLogFileSize;
        }
        String lockId = "serverName=" + this._serverName + ":clientName=" + this._clientName + ":clientVersion=" + this._clientVersion + ":logName=" + this._logName + ":logIdentifier=" + this._logIdentifier;
        this._controlLock = new Lock(lockId);
        if (this._maxLogFileSize >= 5120) {
            this._storageMode = 2;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Using a 'retain only on disk' model for forced log data", (Object[])new Object[0]);
            }
        } else {
            this._storageMode = 1;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Using a 'retain in memory' model for forced log data", (Object[])new Object[0]);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Recovery log belongs to server " + this._serverName), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("Recovery log created by client service " + this._clientName + " at version " + this._clientVersion), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("Recovery log name is " + this._logName), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("Recovery log identifier is " + this._logIdentifier), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("Recovery log directory is " + this._logDirectory), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("Recovery log file size is " + this._logFileSize), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("Recovery log file size is " + this._maxLogFileSize), (Object[])new Object[0]);
        }
        boolean bl = this._bypassContainmentCheck = !Configuration.HAEnabled();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("_bypassContainmentCheck = " + this._bypassContainmentCheck), (Object[])new Object[0]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"MultiScopeRecoveryLog", (Object)this);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @ManualTrace
    public synchronized void openLog() throws LogCorruptedException, LogAllocationException, InternalLogException, LogIncompatibleException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"openLog", (Object[])new Object[]{this});
        }
        if (this.incompatible()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"openLog", (Object)"LogIncompatibleException");
            }
            throw new LogIncompatibleException();
        }
        if (this.failed()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"openLog", (Object)"InternalLogException");
            }
            throw new InternalLogException(null);
        }
        if (this._logHandle == null) {
            this._logHandle = new LogHandle(this, this._clientName, this._clientVersion, this._serverName, this._logName, this._logDirectory, this._logFileSize, this._maxLogFileSize, this._failureScope);
            this._recoverableUnits = new HashMap();
            try {
                this._logHandle.openLog();
            }
            catch (LogOpenException logOpenException) {
                void exc;
                FFDCFilter.processException((Throwable)logOpenException, (String)"com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog", (String)"546", (Object)this, (Object[])new Object[0]);
                FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog.openLog", (String)"464", (Object)this);
                this.markFailed((Throwable)exc);
                this._logHandle = null;
                this._recoverableUnits = null;
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"openLog", (Object)"InternalLogException");
                }
                throw new InternalLogException((Throwable)exc);
            }
            catch (LogCorruptedException exc) {
                FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog", (String)"557", (Object)this, (Object[])new Object[0]);
                FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog.openLog", (String)"473", (Object)this);
                this.markFailed(exc);
                this._logHandle = null;
                this._recoverableUnits = null;
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"openLog", (Object)exc);
                }
                throw exc;
            }
            catch (LogIncompatibleException exc) {
                FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog", (String)"565", (Object)this, (Object[])new Object[0]);
                this.markIncompatible();
                this._logHandle = null;
                this._recoverableUnits = null;
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"openLog", (Object)exc);
                }
                throw exc;
            }
            catch (LogAllocationException exc) {
                FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog", (String)"586", (Object)this, (Object[])new Object[0]);
                FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog.openLog", (String)"482", (Object)this);
                this.markFailed(exc);
                this._logHandle = null;
                this._recoverableUnits = null;
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"openLog", (Object)exc);
                }
                throw exc;
            }
            catch (InternalLogException exc) {
                FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog", (String)"594", (Object)this, (Object[])new Object[0]);
                FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog.openLog", (String)"491", (Object)this);
                this.markFailed(exc);
                this._logHandle = null;
                this._recoverableUnits = null;
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"openLog", (Object)exc);
                }
                throw exc;
            }
            catch (Throwable exc) {
                FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog", (String)"602", (Object)this, (Object[])new Object[0]);
                FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog.openLog", (String)"500", (Object)this);
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Unexpected exception caught in openLog", (Object[])new Object[]{exc});
                }
                this.markFailed(exc);
                this._logHandle = null;
                this._recoverableUnits = null;
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"openLog", (Object)"InternalLogException");
                }
                throw new InternalLogException(exc);
            }
            ArrayList<ReadableLogRecord> records = this._logHandle.recoveredRecords();
            if (records != null && records.size() > 0) {
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("MultiScopeRecoveryLog " + this._logName + " contains " + records.size() + " records to recover"), (Object[])new Object[0]);
                    }
                    for (int i = 0; i < records.size(); ++i) {
                        ReadableLogRecord record = records.get(i);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Recovering record " + i), (Object[])new Object[0]);
                        }
                        RecoverableUnitImpl.recover(this, record, this._logHandle, this._storageMode, this._controlLock);
                    }
                }
                catch (LogCorruptedException i) {
                    void exc;
                    FFDCFilter.processException((Throwable)i, (String)"com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog", (String)"632", (Object)this, (Object[])new Object[0]);
                    FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog.openLog", (String)"531", (Object)this);
                    this.markFailed((Throwable)exc);
                    this._logHandle = null;
                    this._recoverableUnits = null;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"A LogCorruptedException exception occured when reconstructng a RecoverableUnit", (Object[])new Object[0]);
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"openLog", (Object)exc);
                    }
                    throw exc;
                }
                catch (InternalLogException exc) {
                    FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog", (String)"642", (Object)this, (Object[])new Object[0]);
                    FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog.openLog", (String)"541", (Object)this);
                    this.markFailed(exc);
                    this._logHandle = null;
                    this._recoverableUnits = null;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"An InternalLogException exception occured when reconstructng a RecoverableUnit", (Object[])new Object[0]);
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"openLog", (Object)exc);
                    }
                    throw exc;
                }
                catch (Throwable exc) {
                    FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog", (String)"652", (Object)this, (Object[])new Object[0]);
                    FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog.openLog", (String)"551", (Object)this);
                    this.markFailed(exc);
                    this._logHandle = null;
                    this._recoverableUnits = null;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"An exception occured reconstructng a RecoverableUnit", (Object[])new Object[]{exc});
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"openLog", (Object)"InternalLogException");
                    }
                    throw new InternalLogException(exc);
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("MultiScopeRecoveryLog " + this._logName + " is empty"), (Object[])new Object[0]);
            }
        }
        ++this._closesRequired;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Closes required: " + this._closesRequired), (Object[])new Object[0]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"openLog");
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @ManualTrace
    public byte[] serviceData() throws LogClosedException, InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"serviceData", (Object[])new Object[]{this});
        }
        if (this._logHandle == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"serviceData", (Object)"LogClosedException");
            }
            throw new LogClosedException(null);
        }
        byte[] serviceData = null;
        try {
            serviceData = this._logHandle.getServiceData();
        }
        catch (InternalLogException internalLogException) {
            void exc;
            FFDCFilter.processException((Throwable)internalLogException, (String)"com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog", (String)"711", (Object)this, (Object[])new Object[0]);
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog.serviceData", (String)"609", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"serviceData", (Object)exc);
            }
            throw exc;
        }
        catch (Throwable exc) {
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog", (String)"716", (Object)this, (Object[])new Object[0]);
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog.serviceData", (String)"615", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"serviceData", (Object)"InternalLogException");
            }
            throw new InternalLogException(exc);
        }
        byte[] serviceDataCopy = null;
        if (serviceData != null) {
            serviceDataCopy = new byte[serviceData.length];
            System.arraycopy(serviceData, 0, serviceDataCopy, 0, serviceData.length);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"serviceData", (Object)RLSUtils.toHexString(serviceDataCopy, 32));
        }
        return serviceDataCopy;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @ManualTrace
    public void recoveryComplete() throws LogClosedException, InternalLogException, LogIncompatibleException, LogIncompatibleException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"recoveryComplete", (Object[])new Object[]{this});
        }
        if (this.incompatible()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"recoveryComplete", (Object)"LogIncompatibleException");
            }
            throw new LogIncompatibleException();
        }
        if (this.failed()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"recoveryComplete", (Object)this);
            }
            throw new InternalLogException(null);
        }
        if (this._logHandle == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"recoveryComplete", (Object)"LogClosedException");
            }
            throw new LogClosedException(null);
        }
        try {
            this.keypoint();
        }
        catch (LogClosedException logClosedException) {
            void exc;
            FFDCFilter.processException((Throwable)logClosedException, (String)"com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog", (String)"794", (Object)this, (Object[])new Object[0]);
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog.recoveryComplete", (String)"686", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"recoveryComplete", (Object)exc);
            }
            throw exc;
        }
        catch (InternalLogException exc) {
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog", (String)"803", (Object)this, (Object[])new Object[0]);
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog.recoveryComplete", (String)"692", (Object)this);
            this.markFailed(exc);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"recoveryComplete", (Object)exc);
            }
            throw exc;
        }
        catch (Throwable exc) {
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog", (String)"809", (Object)this, (Object[])new Object[0]);
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog.recoveryComplete", (String)"699", (Object)this);
            this.markFailed(exc);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"recoveryComplete", (Object)"InternalLogException");
            }
            throw new InternalLogException(exc);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"recoveryComplete");
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @ManualTrace
    public void recoveryComplete(byte[] serviceData) throws LogClosedException, InternalLogException, LogIncompatibleException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"recoveryComplete", (Object[])new Object[]{RLSUtils.toHexString(serviceData, 32), this});
        }
        if (this.incompatible()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"recoveryComplete", (Object)"LogIncompatibleException");
            }
            throw new LogIncompatibleException();
        }
        if (this.failed()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"recoveryComplete", (Object)this);
            }
            throw new InternalLogException(null);
        }
        if (this._logHandle == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"recoveryComplete", (Object)"LogClosedException");
            }
            throw new LogClosedException(null);
        }
        byte[] serviceDataCopy = null;
        if (serviceData != null) {
            serviceDataCopy = new byte[serviceData.length];
            System.arraycopy(serviceData, 0, serviceDataCopy, 0, serviceData.length);
        }
        try {
            this._logHandle.setServiceData(serviceDataCopy);
            this.keypoint();
        }
        catch (LogClosedException logClosedException) {
            void exc;
            FFDCFilter.processException((Throwable)logClosedException, (String)"com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog", (String)"901", (Object)this, (Object[])new Object[]{serviceData});
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog.recoveryComplete", (String)"785", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"recoveryComplete", (Object)exc);
            }
            throw exc;
        }
        catch (InternalLogException exc) {
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog", (String)"910", (Object)this, (Object[])new Object[]{serviceData});
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog.recoveryComplete", (String)"791", (Object)this);
            this.markFailed(exc);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"recoveryComplete", (Object)exc);
            }
            throw exc;
        }
        catch (Throwable exc) {
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog", (String)"916", (Object)this, (Object[])new Object[]{serviceData});
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog.recoveryComplete", (String)"798", (Object)this);
            this.markFailed(exc);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"recoveryComplete", (Object)"InternalLogException");
            }
            throw new InternalLogException(exc);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"recoveryComplete");
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @ManualTrace
    public void closeLog(byte[] serviceData) throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"closeLog", (Object[])new Object[]{RLSUtils.toHexString(serviceData, 32), this});
        }
        if (this._logHandle != null) {
            try {
                this._logHandle.setServiceData(serviceData);
                this.closeLog();
            }
            catch (InternalLogException internalLogException) {
                void exc;
                FFDCFilter.processException((Throwable)internalLogException, (String)"com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog", (String)"987", (Object)this, (Object[])new Object[]{serviceData});
                FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog.closeLog", (String)"870", (Object)this);
                this.markFailed((Throwable)exc);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"closeLog", (Object)exc);
                }
                throw exc;
            }
            catch (Throwable exc) {
                FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog", (String)"993", (Object)this, (Object[])new Object[]{serviceData});
                FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog.closeLog", (String)"877", (Object)this);
                this.markFailed(exc);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"closeLog", (Object)"InternalLogException");
                }
                throw new InternalLogException(exc);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"closeLog");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @ManualTrace
    public void closeLog() throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"closeLog", (Object[])new Object[]{this});
        }
        if (this._logHandle != null) {
            if (!this.failed() && !this.incompatible()) {
                try {
                    this.keypoint();
                }
                catch (LogClosedException logClosedException) {
                    void exc;
                    FFDCFilter.processException((Throwable)logClosedException, (String)"com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog", (String)"1058", (Object)this, (Object[])new Object[0]);
                    FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog.closeLog", (String)"944", (Object)this);
                }
                catch (InternalLogException exc) {
                    FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog", (String)"1061", (Object)this, (Object[])new Object[0]);
                    FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog.closeLog", (String)"948", (Object)this);
                    this.markFailed(exc);
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"closeLog", (Object)exc);
                    }
                    throw exc;
                }
                catch (Throwable exc) {
                    FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog", (String)"1067", (Object)this, (Object[])new Object[0]);
                    FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog.closeLog", (String)"955", (Object)this);
                    this.markFailed(exc);
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"closeLog", (Object)"InternalLogException");
                    }
                    throw new InternalLogException(exc);
                }
            }
            MultiScopeRecoveryLog multiScopeRecoveryLog = this;
            synchronized (multiScopeRecoveryLog) {
                --this._closesRequired;
                if (this._closesRequired <= 0) {
                    try {
                        this._logHandle.closeLog();
                    }
                    catch (InternalLogException internalLogException) {
                        void exc;
                        FFDCFilter.processException((Throwable)internalLogException, (String)"com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog", (String)"1082", (Object)this, (Object[])new Object[0]);
                        FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog.closeLog", (String)"974", (Object)this);
                        this.markFailed((Throwable)exc);
                        if (tc.isEntryEnabled()) {
                            Tr.exit((TraceComponent)tc, (String)"closeLog", (Object)exc);
                        }
                        throw exc;
                    }
                    catch (Throwable exc) {
                        FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog", (String)"1088", (Object)this, (Object[])new Object[0]);
                        FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog.closeLog", (String)"981", (Object)this);
                        this.markFailed(exc);
                        if (tc.isEntryEnabled()) {
                            Tr.exit((TraceComponent)tc, (String)"closeLog", (Object)"InternalLogException");
                        }
                        throw new InternalLogException(exc);
                    }
                    if (Configuration.HAEnabled() && !this._retainLogsInPeerRecoveryEnv) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Working in a peer recovery environment retain logHandle on close", (Object[])new Object[0]);
                        }
                    } else {
                        this._logHandle = null;
                    }
                    this._recoverableUnits = null;
                    this._closesRequired = 0;
                    this._unwrittenDataSize.set(0);
                    this._totalDataSize = 0;
                    this._failed = false;
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Closes required: " + this._closesRequired), (Object[])new Object[0]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"closeLog");
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @ManualTrace
    public void closeLogImmediate() throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"closeLogImmediate", (Object[])new Object[]{this});
        }
        if (this._logHandle != null) {
            try {
                this._logHandle.closeLog();
            }
            catch (InternalLogException internalLogException) {
                void exc;
                FFDCFilter.processException((Throwable)internalLogException, (String)"com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog", (String)"1133", (Object)this, (Object[])new Object[0]);
                FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog.closeLogImmediate", (String)"1173", (Object)this);
                this.markFailed((Throwable)exc);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"closeLogImmediate", (Object)exc);
                }
                throw exc;
            }
            catch (Throwable exc) {
                FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog", (String)"1139", (Object)this, (Object[])new Object[0]);
                FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog.closeLogImmediate", (String)"1180", (Object)this);
                this.markFailed(exc);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"closeLogImmediate", (Object)"InternalLogException");
                }
                throw new InternalLogException(exc);
            }
            this._logHandle = null;
            this._recoverableUnits = null;
            this._closesRequired = 0;
            this._unwrittenDataSize.set(0);
            this._totalDataSize = 0;
            this._failed = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"closeLogImmediate");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @ManualTrace
    public RecoverableUnit createRecoverableUnit(FailureScope failureScope) throws LogClosedException, InternalLogException, LogIncompatibleException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createRecoverableUnit", (Object[])new Object[]{failureScope, this});
        }
        if (this.incompatible()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createRecoverableUnit", (Object)"LogIncompatibleException");
            }
            throw new LogIncompatibleException();
        }
        if (this.failed()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createRecoverableUnit", (Object)"InternalLogException");
            }
            throw new InternalLogException(null);
        }
        if (this._logHandle == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createRecoverableUnit", (Object)"LogClosedException");
            }
            throw new LogClosedException(null);
        }
        RecoverableUnitImpl recoverableUnit = null;
        this._controlLock.getSharedLock(1);
        MultiScopeRecoveryLog multiScopeRecoveryLog = this;
        synchronized (multiScopeRecoveryLog) {
            long identity = this._recUnitIdTable.nextId(this);
            recoverableUnit = new RecoverableUnitImpl(this, identity, failureScope, this._logHandle, this._storageMode, this._controlLock);
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("MultiScopeRecoveryLog '" + this._logName + "' created a new RecoverableUnit with id '" + identity + "'"), (Object[])new Object[0]);
            }
        }
        try {
            this._controlLock.releaseSharedLock(1);
        }
        catch (NoSharedLockException noSharedLockException) {
            void exc;
            FFDCFilter.processException((Throwable)noSharedLockException, (String)"com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog", (String)"1232", (Object)this, (Object[])new Object[]{failureScope});
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog.createRecoverableUnit", (String)"1070", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createRecoverableUnit", (Object)"InternalLogException");
            }
            throw new InternalLogException((Throwable)exc);
        }
        catch (Throwable exc) {
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog", (String)"1240", (Object)this, (Object[])new Object[]{failureScope});
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog.createRecoverableUnit", (String)"1076", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createRecoverableUnit", (Object)"InternalLogException");
            }
            throw new InternalLogException(exc);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createRecoverableUnit", (Object)recoverableUnit);
        }
        return recoverableUnit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @ManualTrace
    public void removeRecoverableUnit(long identity) throws LogClosedException, InvalidRecoverableUnitException, InternalLogException, LogIncompatibleException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeRecoverableUnit", (Object[])new Object[]{identity, this});
        }
        if (this.incompatible()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"removeRecoverableUnit", (Object)"LogIncompatibleException");
            }
            throw new LogIncompatibleException();
        }
        if (this.failed()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"removeRecoverableUnit", (Object)this);
            }
            throw new InternalLogException(null);
        }
        if (this._logHandle == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"removeRecoverableUnit", (Object)"LogClosedException");
            }
            throw new LogClosedException(null);
        }
        this._controlLock.getSharedLock(2);
        RecoverableUnitImpl recoverableUnit = null;
        MultiScopeRecoveryLog multiScopeRecoveryLog = this;
        synchronized (multiScopeRecoveryLog) {
            recoverableUnit = this.removeRecoverableUnitMapEntries(identity);
        }
        if (recoverableUnit == null) {
            try {
                this._controlLock.releaseSharedLock(2);
            }
            catch (Exception exception) {
                void exc;
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog", (String)"1335", (Object)this, (Object[])new Object[]{identity});
                FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog.removeRecoverableUnit", (String)"1165", (Object)this);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"removeRecoverableUnit", (Object)"InvalidRecoverableUnitException");
            }
            throw new InvalidRecoverableUnitException(null);
        }
        try {
            recoverableUnit.remove();
        }
        catch (InternalLogException exc) {
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog", (String)"1353", (Object)this, (Object[])new Object[]{identity});
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog.removeRecoverableUnit", (String)"1182", (Object)this);
            this.markFailed(exc);
            try {
                this._controlLock.releaseSharedLock(2);
            }
            catch (Exception exception) {
                void exc2;
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog", (String)"1360", (Object)this, (Object[])new Object[]{identity});
                FFDCFilter.processException((Throwable)exc2, (String)"com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog.removeRecoverableUnit", (String)"1195", (Object)this);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"removeRecoverableUnit", (Object)exc);
            }
            throw exc;
        }
        try {
            this._controlLock.releaseSharedLock(2);
        }
        catch (NoSharedLockException exc) {
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog", (String)"1375", (Object)this, (Object[])new Object[]{identity});
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog.removeRecoverableUnit", (String)"1212", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"removeRecoverableUnit", (Object)"InternalLogException");
            }
            throw new InternalLogException(exc);
        }
        catch (Throwable exc) {
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog", (String)"1383", (Object)this, (Object[])new Object[]{identity});
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog.removeRecoverableUnit", (String)"1218", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"removeRecoverableUnit", (Object)"InternalLogException");
            }
            throw new InternalLogException(exc);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeRecoverableUnit");
        }
    }

    @Override
    @ManualTrace
    public synchronized LogCursor recoverableUnits(FailureScope failureScope) throws LogClosedException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"recoverableUnits", (Object[])new Object[]{failureScope, this});
        }
        if (this._logHandle == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"recoverableUnits", (Object)"LogClosedException");
            }
            throw new LogClosedException(null);
        }
        ArrayList<RecoverableUnitImpl> recoverableUnits = new ArrayList<RecoverableUnitImpl>();
        for (RecoverableUnitImpl recoverableUnitImpl : this._recoverableUnits.values()) {
            if (!this._bypassContainmentCheck && !recoverableUnitImpl.failureScope().isContainedBy(failureScope)) continue;
            recoverableUnits.add(recoverableUnitImpl);
        }
        LogCursorImpl logCursorImpl = new LogCursorImpl(this._controlLock, recoverableUnits, true, this);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"recoverableUnits", (Object)logCursorImpl);
        }
        return logCursorImpl;
    }

    @Override
    @ManualTrace
    public LogCursor recoverableUnits() throws LogClosedException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"recoverableUnits", (Object[])new Object[]{this});
        }
        LogCursor cursor = this.recoverableUnits(this._failureScope);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"recoverableUnits", (Object)cursor);
        }
        return cursor;
    }

    @Override
    @ManualTrace
    public RecoverableUnit lookupRecoverableUnit(long identity) throws LogClosedException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"lookupRecoverableUnit", (Object[])new Object[]{identity, this});
        }
        RecoverableUnitImpl runit = this.getRecoverableUnit(identity);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"lookupRecoverableUnit", (Object)runit);
        }
        return runit;
    }

    @Override
    @ManualTrace
    public RecoverableUnit createRecoverableUnit() throws LogClosedException, InternalLogException, LogIncompatibleException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createRecoverableUnit", (Object[])new Object[]{this});
        }
        RecoverableUnit runit = this.createRecoverableUnit(this._failureScope);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createRecoverableUnit", (Object)runit);
        }
        return runit;
    }

    @Override
    public LogProperties logProperties() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"logProperties", (Object[])new Object[]{this._fileLogProperties});
        }
        return this._fileLogProperties;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @ManualTrace
    public void keypoint() throws LogClosedException, InternalLogException, LogIncompatibleException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"keypoint", (Object[])new Object[]{this});
        }
        if (this.incompatible()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"keypoint", (Object)"LogIncompatibleException");
            }
            throw new LogIncompatibleException();
        }
        if (this.failed()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"keypoint", (Object)this);
            }
            throw new InternalLogException(null);
        }
        if (this._logHandle == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"keypoint", (Object)"LogClosedException");
            }
            throw new LogClosedException(null);
        }
        boolean obtainedLock = false;
        try {
            obtainedLock = this._controlLock.attemptExclusiveLock();
        }
        catch (HoldingExclusiveLockException holdingExclusiveLockException) {
            void exc;
            FFDCFilter.processException((Throwable)holdingExclusiveLockException, (String)"com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog", (String)"1567", (Object)this, (Object[])new Object[0]);
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog.keypoint", (String)"1353", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"The keypoint operation has triggered a keypoint operation.", (Object[])new Object[0]);
            }
            this.markFailed((Throwable)exc);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"keypoint", (Object)"InternalLogException");
            }
            throw new InternalLogException((Throwable)exc);
        }
        if (obtainedLock) {
            try {
                this._logHandle.keypointStarting();
            }
            catch (InternalLogException exc) {
                FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog", (String)"1589", (Object)this, (Object[])new Object[0]);
                FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog.keypoint", (String)"1373", (Object)this);
                this.markFailed(exc);
                try {
                    this._controlLock.releaseExclusiveLock();
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog", (String)"1596", (Object)this, (Object[])new Object[0]);
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog.keypoint", (String)"1384", (Object)this);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"keypoint", (Object)exc);
                }
                throw exc;
            }
            catch (Throwable exc) {
                FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog", (String)"1604", (Object)this, (Object[])new Object[0]);
                FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog.keypoint", (String)"1392", (Object)this);
                this.markFailed(exc);
                try {
                    this._controlLock.releaseExclusiveLock();
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog", (String)"1611", (Object)this, (Object[])new Object[0]);
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog.keypoint", (String)"1403", (Object)this);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"keypoint", (Object)"InternalLogException");
                }
                throw new InternalLogException(exc);
            }
            if (tc.isDebugEnabled()) {
                int targetFreeSpace = this._logHandle.getFreeSpace();
                Tr.debug((TraceComponent)tc, (String)("Recovery log contains " + this._totalDataSize + " payload bytes"), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("Target keypoint file has " + targetFreeSpace + " available free bytes"), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("Resize trigger constant is " + TOTAL_DATA_RESIZE_TRIGGER), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("Resize trigger value is " + (float)targetFreeSpace * TOTAL_DATA_RESIZE_TRIGGER + " bytes"), (Object[])new Object[0]);
            }
            if ((float)this._totalDataSize > (float)this._logHandle.getFreeSpace() * TOTAL_DATA_RESIZE_TRIGGER) {
                int logFileHeaderSize;
                try {
                    logFileHeaderSize = this._logHandle.logFileHeader().length();
                }
                catch (InternalLogException internalLogException) {
                    FFDCFilter.processException((Throwable)internalLogException, (String)"com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog", (String)"1643", (Object)this, (Object[])new Object[0]);
                    if (tc.isEventEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Could not get log file header length", (Object[])new Object[]{internalLogException});
                    }
                    FFDCFilter.processException((Throwable)internalLogException, (String)"com.ibm.ws.recoverylog.spi.RecoveryLogImpl.keypoint", (String)"1780", (Object)this);
                    this.markFailed(internalLogException);
                    try {
                        this._controlLock.releaseExclusiveLock();
                    }
                    catch (Throwable throwable) {
                        void exc;
                        FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog", (String)"1656", (Object)this, (Object[])new Object[0]);
                        FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.RecoveryLogImpl.keypoint", (String)"1791", (Object)this);
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"keypoint");
                    }
                    throw internalLogException;
                }
                catch (LogIncompatibleException logIncompatibleException) {
                    FFDCFilter.processException((Throwable)logIncompatibleException, (String)"com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog", (String)"1666", (Object)this, (Object[])new Object[0]);
                    FFDCFilter.processException((Throwable)logIncompatibleException, (String)"com.ibm.ws.recoverylog.spi.RecoveryLogImpl.keypoint", (String)"1575", (Object)this);
                    this.markFailed(logIncompatibleException);
                    try {
                        this._controlLock.releaseExclusiveLock();
                    }
                    catch (Throwable exc) {
                        FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog", (String)"1678", (Object)this, (Object[])new Object[0]);
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"keypoint");
                    }
                    throw new InternalLogException(logIncompatibleException);
                }
                int n = Math.min((int)((float)this._totalDataSize * TOTAL_DATA_RESIZE_MULTIPLIER), this._maxLogFileSize * 1024 - logFileHeaderSize);
                if (n < this._totalDataSize) {
                    LogFullException lfe = new LogFullException(null);
                    this.markFailed(lfe);
                    try {
                        this._controlLock.releaseExclusiveLock();
                    }
                    catch (Throwable throwable) {
                        void exc2;
                        FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog", (String)"1700", (Object)this, (Object[])new Object[0]);
                        FFDCFilter.processException((Throwable)exc2, (String)"com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog.keypoint", (String)"1446", (Object)this);
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"keypoint", (Object)"LogFullException");
                    }
                    throw lfe;
                }
                this._logHandle.resizeLog(n);
            }
            try {
                for (RecoverableUnitImpl recoverableUnitImpl : this._recoverableUnits.values()) {
                    recoverableUnitImpl.writeSections(true);
                }
                this._logHandle.keypoint();
            }
            catch (Throwable recoverableUnits) {
                FFDCFilter.processException((Throwable)recoverableUnits, (String)"com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog", (String)"1723", (Object)this, (Object[])new Object[0]);
                FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog.keypoint", (String)"1478", (Object)this);
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Exception caught performing keypoint", (Object[])new Object[]{exc});
                }
                this.markFailed((Throwable)exc);
                try {
                    this._controlLock.releaseExclusiveLock();
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog", (String)"1735", (Object)this, (Object[])new Object[0]);
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog.keypoint", (String)"1491", (Object)this);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"keypoint", (Object)"InternalLogException");
                }
                throw new InternalLogException((Throwable)exc);
            }
            if (!this._logWarningIssued && this._totalDataSize > (this._maxLogFileSize * 1024 - this._totalDataSize) * 3) {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Logfile is filling up, issuing warning.", (Object[])new Object[]{this._logName});
                }
                this._logWarningIssued = true;
                try {
                    this._recoveryAgent.logFileWarning(this._logName, this._totalDataSize, this._maxLogFileSize * 1024);
                }
                catch (Throwable exc) {
                    void t;
                    FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog", (String)"1753", (Object)this, (Object[])new Object[0]);
                    FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog.keypoint", (String)"1511", (Object)this);
                }
            }
            try {
                this._controlLock.releaseExclusiveLock();
            }
            catch (NoExclusiveLockException t) {
                void exc2;
                FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog", (String)"1761", (Object)this, (Object[])new Object[0]);
                FFDCFilter.processException((Throwable)exc2, (String)"com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog.keypoint", (String)"1506", (Object)this);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"keypoint", (Object)"InternalLogException");
                }
                throw new InternalLogException((Throwable)exc2);
            }
            catch (Throwable exc2) {
                FFDCFilter.processException((Throwable)exc2, (String)"com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog", (String)"1768", (Object)this, (Object[])new Object[0]);
                FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog.keypoint", (String)"1512", (Object)this);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"keypoint", (Object)"InternalLogException");
                }
                throw new InternalLogException((Throwable)exc);
            }
        }
        if (this.failed()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"keypoint", (Object)this);
            }
            throw new InternalLogException(null);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"keypoint");
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @ManualTrace
    public void removing(Object target) throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removing", (Object[])new Object[]{target, this});
        }
        if (this.failed() || this.incompatible()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"removing", (Object)this);
            }
            throw new InternalLogException(null);
        }
        try {
            ((RecoverableUnitImpl)target).remove();
        }
        catch (InternalLogException internalLogException) {
            void exc;
            FFDCFilter.processException((Throwable)internalLogException, (String)"com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog", (String)"1831", (Object)this, (Object[])new Object[]{target});
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog.removing", (String)"1573", (Object)this);
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"An unexpected error occured whilst removing a RecoverableUnit", (Object[])new Object[0]);
            }
            this.markFailed((Throwable)exc);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"removing", (Object)exc);
            }
            throw exc;
        }
        catch (Exception exc) {
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog", (String)"1839", (Object)this, (Object[])new Object[]{target});
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog.removing", (String)"1581", (Object)this);
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"An unexpected error occured whilst removing a RecoverableUnit", (Object[])new Object[0]);
            }
            this.markFailed(exc);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"removing", (Object)"InternalLogException");
            }
            throw new InternalLogException(exc);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removing");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManualTrace
    protected void payloadAdded(int unwrittenPayloadSize, int totalPayloadSize) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"payloadAdded", (Object[])new Object[]{this, unwrittenPayloadSize, totalPayloadSize});
        }
        this._unwrittenDataSize.addAndGet(unwrittenPayloadSize);
        MultiScopeRecoveryLog multiScopeRecoveryLog = this;
        synchronized (multiScopeRecoveryLog) {
            this._totalDataSize += totalPayloadSize;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("unwrittenDataSize = " + this._unwrittenDataSize.get() + " totalDataSize = " + this._totalDataSize), (Object[])new Object[0]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"payloadAdded");
        }
    }

    @ManualTrace
    protected void payloadWritten(int payloadSize) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"payloadWritten", (Object[])new Object[]{this, payloadSize});
        }
        this._unwrittenDataSize.addAndGet(-payloadSize);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("unwrittenDataSize = " + this._unwrittenDataSize.get() + " totalDataSize = " + this._totalDataSize), (Object[])new Object[0]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"payloadWritten");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManualTrace
    protected void payloadDeleted(int totalPayloadSize, int unwrittenPayloadSize) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"payloadDeleted", (Object[])new Object[]{this, totalPayloadSize, unwrittenPayloadSize});
        }
        this._unwrittenDataSize.addAndGet(-unwrittenPayloadSize);
        MultiScopeRecoveryLog multiScopeRecoveryLog = this;
        synchronized (multiScopeRecoveryLog) {
            this._totalDataSize -= totalPayloadSize;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("unwrittenDataSize = " + this._unwrittenDataSize.get() + " totalDataSize = " + this._totalDataSize), (Object[])new Object[0]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"payloadDeleted");
        }
    }

    @Trivial
    protected boolean failed() {
        if (tc.isDebugEnabled() && this._failed) {
            Tr.debug((TraceComponent)tc, (String)("failed: RecoveryLog has been marked as failed. [" + this + "]"), (Object[])new Object[0]);
        }
        return this._failed;
    }

    protected boolean incompatible() {
        if (tc.isDebugEnabled() && this._incompatible) {
            Tr.debug((TraceComponent)tc, (String)("incompatible: RecoveryLog has been marked as incompatible. [" + this + "]"), (Object[])new Object[0]);
        }
        return this._incompatible;
    }

    protected void markFailed(Throwable t) {
        this.markFailed(t, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void markFailed(Throwable t, boolean report) {
        boolean newFailure = false;
        MultiScopeRecoveryLog multiScopeRecoveryLog = this;
        synchronized (multiScopeRecoveryLog) {
            if (tc.isDebugEnabled() && this._failed) {
                Tr.debug((TraceComponent)tc, (String)("markFailed: RecoveryLog has been marked as failed. [" + this + "]"), (Object[])new Object[0]);
            }
            if (!this._failed) {
                newFailure = true;
                this._failed = true;
                if (report) {
                    Object[] errorObject = new Object[]{this._logIdentifier, this._clientName};
                    Tr.audit((TraceComponent)tc, (String)"CWRLS0008_RECOVERY_LOG_FAILED", (Object[])errorObject);
                    Tr.info((TraceComponent)tc, (String)"CWRLS0009_RECOVERY_LOG_FAILED_DETAIL", (Object[])new Object[]{t});
                }
                if (Configuration.HAEnabled()) {
                    if (Configuration.localFailureScope().equals(this._failureScope)) {
                        Tr.error((TraceComponent)tc, (String)"CWRLS0024_EXC_DURING_RECOVERY", (Object[])new Object[]{t});
                        this._recoveryAgent.terminateServer();
                    } else {
                        Configuration.getRecoveryLogComponent().leaveGroup(this._failureScope);
                    }
                }
            }
        }
        if (newFailure && this._associatedLog != null) {
            if (this._failAssociatedLog) {
                if (tc.isDebugEnabled() && this._failed) {
                    Tr.debug((TraceComponent)tc, (String)"associated log will be marked as failed", (Object[])new Object[]{this._associatedLog});
                }
                this._associatedLog.markFailedByAssociation();
            } else {
                this._associatedLog.provideServiceability();
            }
        }
    }

    @Override
    public synchronized void markFailedByAssociation() {
        if (!this._failed) {
            this._failed = true;
            if (tc.isDebugEnabled() && this._failed) {
                Tr.debug((TraceComponent)tc, (String)("markFailedByAssociation: RecoveryLog has been marked as failed by association. [" + this + "]"), (Object[])new Object[0]);
            }
            this.provideServiceability();
        } else if (tc.isDebugEnabled() && this._failed) {
            Tr.debug((TraceComponent)tc, (String)("markFailedByAssociation: RecoveryLog was already failed when marked as failed by association. [" + this + "]"), (Object[])new Object[0]);
        }
    }

    protected synchronized void markIncompatible() {
        if (tc.isDebugEnabled() && this._incompatible) {
            Tr.debug((TraceComponent)tc, (String)("markIncompatible: RecoveryLog has been marked as incompatible. [" + this + "]"), (Object[])new Object[0]);
        }
        this._incompatible = true;
    }

    @ManualTrace
    protected void addRecoverableUnit(RecoverableUnit recoverableUnit, boolean recovered) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addRecoverableUnit", (Object[])new Object[]{recoverableUnit, recovered, this});
        }
        long identity = recoverableUnit.identity();
        this._recoverableUnits.put(identity, recoverableUnit);
        if (recovered) {
            this._recUnitIdTable.reserveId(identity, recoverableUnit);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addRecoverableUnit");
        }
    }

    @ManualTrace
    protected RecoverableUnitImpl removeRecoverableUnitMapEntries(long identity) {
        RecoverableUnitImpl recoverableUnit;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeRecoverableUnitMapEntries", (Object[])new Object[]{identity, this});
        }
        if ((recoverableUnit = (RecoverableUnitImpl)this._recoverableUnits.remove(identity)) != null) {
            this._recUnitIdTable.removeId(identity);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeRecoverableUnitMapEntries", (Object)recoverableUnit);
        }
        return recoverableUnit;
    }

    @ManualTrace
    protected RecoverableUnitImpl getRecoverableUnit(long identity) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getRecoverableUnit", (Object[])new Object[]{identity, this});
        }
        RecoverableUnitImpl recoverableUnit = null;
        if (!this.incompatible() && !this.failed()) {
            recoverableUnit = (RecoverableUnitImpl)this._recoverableUnits.get(identity);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getRecoverableUnit", recoverableUnit);
        }
        return recoverableUnit;
    }

    String serverName() {
        return this._serverName;
    }

    String clientName() {
        return this._clientName;
    }

    public int clientVersion() {
        return this._clientVersion;
    }

    public String logName() {
        return this._logName;
    }

    public int logIdentifier() {
        return this._logIdentifier;
    }

    public String getLogDirectory() {
        return this._logDirectory;
    }

    public String toString() {
        if (this._traceId == null) {
            this._traceId = "MultiScopeRecoveryLog:serverName=" + this._serverName + ":clientName=" + this._clientName + ":clientVersion=" + this._clientVersion + ":logName=" + this._logName + ":logDirectory=" + this._logDirectory + ":logIdentifier=" + this._logIdentifier + " @" + System.identityHashCode(this);
        }
        return this._traceId;
    }

    @Override
    @ManualTrace
    public void associateLog(DistributedRecoveryLog otherLog, boolean failAssociatedLog) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"associateLog", (Object[])new Object[]{otherLog, failAssociatedLog, this});
        }
        if (otherLog instanceof MultiScopeLog) {
            this._associatedLog = (MultiScopeLog)otherLog;
            this._failAssociatedLog = failAssociatedLog;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"associateLog");
        }
    }

    @Override
    public void provideServiceability() {
        Exception e = new Exception();
        try {
            HashMap<Long, RecoverableUnit> rus;
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog.provideServiceability", (String)"2469", (Object)this);
            LogHandle lh = this._logHandle;
            if (lh != null) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog.provideServiceability", (String)"2471", (Object)lh);
            }
            if ((rus = this._recoverableUnits) != null) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog.provideServiceability", (String)"2473", rus);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog", (String)"2423", (Object)this, (Object[])new Object[0]);
        }
    }

    @Override
    @ManualTrace
    public void delete() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"delete", (Object[])new Object[]{this});
        }
        if (this.failed() || this._closesRequired > 0) {
            Exception e = new Exception();
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog.delete", (String)"2431", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Do not delete logs as failed state is {0} or closesRequired is {1}", (Object[])new Object[]{this.failed(), this._closesRequired});
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Attempt to delete log with handle {0}", (Object[])new Object[]{this._logHandle});
            }
            if (this._logHandle != null) {
                try {
                    this._logHandle.delete();
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog", (String)"2445", (Object)this, (Object[])new Object[0]);
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog.delete", (String)"2445", (Object)this);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"delete");
        }
    }

    @Override
    @ManualTrace
    public void retainLogsInPeerRecoveryEnv(boolean retainLogs) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"retainLogsInPeerRecoveryEnv", (Object[])new Object[]{retainLogs, this});
        }
        this._retainLogsInPeerRecoveryEnv = retainLogs;
        if (this._retainLogsInPeerRecoveryEnv) {
            this._logHandle.retainLogsInPeerRecoveryEnv(true);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"retainLogsInPeerRecoveryEnv", (Object)this);
        }
    }
}

