/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.validator;

import com.ibm.security.validator.EndEntityChecker;
import com.ibm.security.validator.KeyStores;
import com.ibm.security.validator.PKIXValidator;
import com.ibm.security.validator.SimpleValidator;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Date;

public abstract class Validator {
    static final X509Certificate[] CHAIN0 = new X509Certificate[0];
    public static final String TYPE_SIMPLE = "Simple";
    public static final String TYPE_PKIX = "PKIX";
    public static final String VAR_GENERIC = "generic";
    public static final String VAR_CODE_SIGNING = "code signing";
    public static final String VAR_JCE_SIGNING = "jce signing";
    public static final String VAR_TLS_CLIENT = "tls client";
    public static final String VAR_TLS_SERVER = "tls server";
    public static final String VAR_TSA_SERVER = "tsa server";
    public static final String VAR_PLUGIN_CODE_SIGNING = "plugin code signing";
    final EndEntityChecker endEntityChecker;
    final String variant;
    @Deprecated
    volatile Date validationDate;

    Validator(String type, String variant) {
        this.variant = variant;
        this.endEntityChecker = EndEntityChecker.getInstance(type, variant);
    }

    public static Validator getInstance(String type, String variant, KeyStore ks) {
        return Validator.getInstance(type, variant, KeyStores.getTrustedCerts(ks));
    }

    public static Validator getInstance(String type, String variant, Collection trustedCerts) {
        if (type.equals(TYPE_SIMPLE)) {
            return new SimpleValidator(variant, trustedCerts);
        }
        if (type.equals(TYPE_PKIX)) {
            return new PKIXValidator(variant, trustedCerts);
        }
        throw new IllegalArgumentException("Unknown validator type: " + type);
    }

    public static Validator getInstance(String type, String variant, PKIXBuilderParameters params) {
        if (!type.equals(TYPE_PKIX)) {
            throw new IllegalArgumentException("getInstance(PKIXBuilderParameters) can only be used with PKIX validator");
        }
        return new PKIXValidator(variant, params);
    }

    public final X509Certificate[] validate(X509Certificate[] chain) throws CertificateException {
        return this.validate(chain, null, null);
    }

    public final X509Certificate[] validate(X509Certificate[] chain, Collection otherCerts) throws CertificateException {
        return this.validate(chain, otherCerts, null);
    }

    public final X509Certificate[] validate(X509Certificate[] chain, Collection otherCerts, Object parameter) throws CertificateException {
        if ((chain = this.engineValidate(chain, otherCerts, parameter)).length > 1) {
            this.endEntityChecker.check(chain[0], parameter);
        }
        return chain;
    }

    abstract X509Certificate[] engineValidate(X509Certificate[] var1, Collection var2, Object var3) throws CertificateException;

    public abstract Collection getTrustedCertificates();

    @Deprecated
    public void setValidationDate(Date validationDate) {
        this.validationDate = validationDate;
    }
}

