/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.smime.jmail;

import com.ibm.misc.BASE64Decoder;
import com.ibm.misc.Debug;
import com.ibm.security.pkcs10.CertificationRequest;
import com.ibm.security.util.DerOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataSource;

public class PKCS10MimeDataSource
implements DataSource,
Cloneable {
    private CertificationRequest certRequest;
    public static final String CONTENT_TYPE_PKCS10 = "application/x-pkcs10";
    private static final String CERTIFICATION_REQUEST_NAME = "CertificationRequest";
    private String provider = null;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.smime.jmail.PKCS10MimeDataSource";

    private PKCS10MimeDataSource(String provider) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "PKCS10MimeDataSource", provider);
        }
        if (provider != null) {
            this.provider = new String(provider);
        }
        if (debug != null) {
            debug.exit(8192L, className, "PKCS10MimeDataSource");
        }
    }

    public PKCS10MimeDataSource(CertificationRequest certRequest) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "PKCS10MimeDataSource", certRequest);
        }
        if (certRequest == null) {
            if (debug != null) {
                debug.text(16384L, className, "PKCS10MimeDataSource", "CertificationRequest is null.");
            }
            throw new IllegalArgumentException("CertificationRequest is null.");
        }
        this.certRequest = certRequest;
        if (debug != null) {
            debug.exit(16384L, className, "PKCS10MimeDataSource");
        }
    }

    public PKCS10MimeDataSource(CertificationRequest certRequest, String provider) {
        if (debug != null) {
            debug.entry(16384L, className, "PKCS10MimeDataSource", certRequest, provider);
        }
        if (provider != null) {
            this.provider = new String(provider);
        }
        if (certRequest == null) {
            if (debug != null) {
                debug.text(16384L, className, "PKCS10MimeDataSource", "CertificationRequest is null.");
            }
            throw new IllegalArgumentException("CertificationRequest is null.");
        }
        this.certRequest = certRequest;
        if (debug != null) {
            debug.exit(16384L, className, "PKCS10MimeDataSource");
        }
    }

    public PKCS10MimeDataSource(byte[] encoding, boolean base64) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "PKCS10MimeDataSource", encoding, new Boolean(base64));
        }
        if (encoding == null || encoding.length == 0) {
            if (debug != null) {
                debug.text(16384L, className, "PKCS10MimeDataSource", "encoding is null or empty");
            }
            throw new IllegalArgumentException("encoding is null or empty");
        }
        byte[] encoding2 = encoding;
        if (base64) {
            BASE64Decoder decoder = new BASE64Decoder();
            ByteArrayInputStream bais = new ByteArrayInputStream(encoding);
            encoding2 = decoder.decodeBuffer(bais);
        }
        this.certRequest = new CertificationRequest(encoding2, this.provider);
        if (debug != null) {
            debug.exit(16384L, className, "PKCS10MimeDataSource");
        }
    }

    public PKCS10MimeDataSource(byte[] encoding, boolean base64, String provider) throws IOException {
        if (debug != null) {
            Object[] parms = new Object[]{encoding, new Boolean(base64), provider};
            debug.entry(16384L, (Object)className, "PKCS10MimeDataSource", parms);
        }
        if (encoding == null || encoding.length == 0) {
            if (debug != null) {
                debug.text(16384L, className, "PKCS10MimeDataSource", "encoding is null or empty");
            }
            throw new IllegalArgumentException("encoding is null or empty");
        }
        byte[] encoding2 = encoding;
        if (provider != null) {
            this.provider = new String(provider);
        }
        if (base64) {
            BASE64Decoder decoder = new BASE64Decoder();
            ByteArrayInputStream bais = new ByteArrayInputStream(encoding);
            encoding2 = decoder.decodeBuffer(bais);
        }
        this.certRequest = new CertificationRequest(encoding2, this.provider);
        if (debug != null) {
            debug.exit(16384L, className, "PKCS10MimeDataSource");
        }
    }

    public Object clone() {
        try {
            if (debug != null) {
                debug.entry(16384L, className, "clone");
            }
            PKCS10MimeDataSource ds = new PKCS10MimeDataSource(this.certRequest, this.provider);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone_1", ds);
            }
            return ds;
        }
        catch (Exception e2) {
            if (debug != null) {
                debug.exception(16384L, className, "clone", e2);
                debug.exit(16384L, (Object)className, "clone", null);
            }
            return null;
        }
    }

    private void setCertificationRequest(CertificationRequest certRequest) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setCertificationRequest", certRequest);
            debug.exit(8192L, className, "setCertificationRequest");
        }
        this.certRequest = certRequest;
    }

    public CertificationRequest getCertificationRequest() {
        if (debug != null) {
            debug.entry(16384L, className, "getCertificationRequest");
            debug.exit(16384L, (Object)className, "getCertificationRequest", this.certRequest);
        }
        return this.certRequest;
    }

    public InputStream getInputStream() throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "getInputStream");
        }
        if (this.certRequest == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getInputStream_1", null);
            }
            return null;
        }
        DerOutputStream bytes = new DerOutputStream();
        this.certRequest.encode(bytes);
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes.toByteArray());
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getInputStream_2", bais);
        }
        return bais;
    }

    public OutputStream getOutputStream() throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "getOutputStream");
            debug.exit(16384L, (Object)className, "getOutputStream", new ByteArrayOutputStream());
        }
        return new ByteArrayOutputStream();
    }

    public String getContentType() {
        String contentType = null;
        if (debug != null) {
            debug.entry(16384L, className, "getContentType");
        }
        if (this.certRequest != null) {
            contentType = CONTENT_TYPE_PKCS10;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getContentType", contentType);
        }
        return contentType;
    }

    public String getName() {
        String name = null;
        if (debug != null) {
            debug.entry(16384L, className, "getName");
        }
        if (this.certRequest != null) {
            name = CERTIFICATION_REQUEST_NAME;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getName", name);
        }
        return name;
    }

    public String toString() {
        String out = "PKCS10MimeDataSource:  ";
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        out = this.certRequest != null ? out + this.certRequest.toString() : out + "Does not contain a CertificationRequest object.";
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", out);
        }
        return out;
    }
}

