/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.crmf;

import com.ibm.security.cmputil.CMPDerObject;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;

public final class POPOPrivKey
extends CMPDerObject {
    public static final int ENCR_CERT = 0;
    public static final int CHALLENGE_RESP = 1;
    private int choice;
    public static final int THIS_MESSAGE = 0;
    public static final int SUBSEQUENT_MESSAGE = 1;
    public static final int DH_MAC = 2;
    private static final byte TAG_THIS_MESSAGE = 0;
    private static final byte TAG_SUBSEQUENT_MESSAGE = 1;
    private static final byte TAG_DH_MAC = 2;
    private byte[] bitString;
    private int subsequentMessage;

    public POPOPrivKey(int n2, Object object) {
        this.setPOPOPrivKey(n2, object);
    }

    public POPOPrivKey(byte[] byArray) throws IOException {
        super(byArray);
    }

    public Object clone() {
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            this.encode(derOutputStream);
            return new POPOPrivKey(derOutputStream.toByteArray());
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void decode(DerValue derValue) throws IOException {
        this.bitString = null;
        if (derValue.isContextSpecific((byte)0) && !derValue.isConstructed()) {
            derValue.resetTag((byte)3);
            this.choice = 0;
            this.bitString = derValue.getBitString();
            return;
        } else if (derValue.isContextSpecific((byte)1) && !derValue.isConstructed()) {
            derValue.resetTag((byte)2);
            this.choice = 1;
            BigInteger bigInteger = derValue.getInteger();
            if (bigInteger.equals(BigInteger.valueOf(0L))) {
                this.subsequentMessage = 0;
                return;
            } else {
                if (!bigInteger.equals(BigInteger.valueOf(1L))) throw new IOException("POPOPrivKey parsing error, invalid subsequent message");
                this.subsequentMessage = 1;
            }
            return;
        } else {
            if (!derValue.isContextSpecific((byte)2) || derValue.isConstructed()) throw new IOException("POPOPrivKey parsing error, invalid tag");
            derValue.resetTag((byte)3);
            this.choice = 2;
            this.bitString = derValue.getBitString();
        }
    }

    public void encode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        if (this.choice == 0) {
            if (this.bitString == null) {
                throw new IOException("POPOPrivKey encoding error, this message not specified");
            }
            DerOutputStream derOutputStream2 = new DerOutputStream();
            derOutputStream2.putBitString(this.bitString);
            derOutputStream.writeImplicit(DerValue.createTag((byte)-128, false, (byte)0), derOutputStream2);
        } else if (this.choice == 1) {
            DerOutputStream derOutputStream3 = new DerOutputStream();
            derOutputStream3.putInteger(BigInteger.valueOf(this.subsequentMessage));
            derOutputStream.writeImplicit(DerValue.createTag((byte)-128, false, (byte)1), derOutputStream3);
        } else if (this.choice == 2) {
            if (this.bitString == null) {
                throw new IOException("POPOPrivKey encoding error, DH MAC value not specified");
            }
            DerOutputStream derOutputStream4 = new DerOutputStream();
            derOutputStream4.putBitString(this.bitString);
            derOutputStream.writeImplicit(DerValue.createTag((byte)-128, false, (byte)2), derOutputStream4);
        } else {
            throw new IOException("POPOPrivKey encoding error");
        }
        outputStream.write(derOutputStream.toByteArray());
    }

    public boolean equals(POPOPrivKey pOPOPrivKey) {
        DerValue derValue;
        DerValue derValue2;
        if (pOPOPrivKey == this) {
            return true;
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encode(derOutputStream);
            derValue2 = new DerValue(derOutputStream.toByteArray());
            pOPOPrivKey.encode(derOutputStream2);
            derValue = new DerValue(derOutputStream2.toByteArray());
        }
        catch (Exception exception) {
            return false;
        }
        return derValue2.equals(derValue);
    }

    public boolean equals(Object object) {
        if (object instanceof POPOPrivKey) {
            return this.equals((POPOPrivKey)object);
        }
        return false;
    }

    public Object getPOPOPrivKey() {
        switch (this.choice) {
            case 0: {
                return this.bitString;
            }
            case 1: {
                return new Integer(this.subsequentMessage);
            }
            case 2: {
                return this.bitString;
            }
        }
        throw new IllegalArgumentException("POPOPrivKey error, unknown type");
    }

    public int getPOPOPrivKeyType() {
        return this.choice;
    }

    private void setPOPOPrivKey(int n2, Object object) {
        switch (n2) {
            case 0: {
                if (object == null) {
                    throw new IllegalArgumentException("POPOPrivKey error, value not specified");
                }
                if (object instanceof byte[]) {
                    this.bitString = (byte[])object;
                    this.choice = 0;
                    break;
                }
                throw new IllegalArgumentException("POPOPrivKey error, invalid value");
            }
            case 1: {
                if (object == null) {
                    throw new IllegalArgumentException("POPOPrivKey error, value not specified");
                }
                if (object instanceof Integer) {
                    this.subsequentMessage = (Integer)object;
                    if (this.subsequentMessage != 0 && this.subsequentMessage != 1) {
                        throw new IllegalArgumentException("POPOPrivKey error, invalid subsequent message type");
                    }
                    this.choice = 1;
                    break;
                }
                throw new IllegalArgumentException("POPOPrivKey error, value not specified");
            }
            case 2: {
                if (object == null) {
                    throw new IllegalArgumentException("POPOPrivKey error, value not specified");
                }
                if (object instanceof byte[]) {
                    this.bitString = (byte[])object;
                    this.choice = 2;
                    break;
                }
                throw new IllegalArgumentException("POPOPrivKey error, value not specified");
            }
            default: {
                throw new IllegalArgumentException("POPOPrivKey error, invalid type");
            }
        }
    }

    public String toString() {
        String string = "POPOPrivKey:";
        if (this.choice == 0) {
            string = String.valueOf(string) + "\r\n\tthis message: " + new String(this.bitString);
        }
        if (this.choice == 1) {
            string = this.subsequentMessage == 0 ? String.valueOf(string) + "\r\n\tsubsequent message: encrypted certificate" : String.valueOf(string) + "\r\n\tsubsequent message: challenge response";
        }
        if (this.choice == 2) {
            string = String.valueOf(string) + "\r\n\tdhMAC: " + new String(this.bitString);
        }
        return string;
    }
}

