/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cmp;

import com.ibm.security.cmp.PKIFreeText;
import com.ibm.security.cmp.PKIStatusInfo;
import com.ibm.security.cmputil.CMPDerObject;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;

public final class ErrorMsgContent
extends CMPDerObject {
    private PKIStatusInfo pKIStatusInfo;
    private BigInteger errorCode;
    private PKIFreeText errorDetails;

    public ErrorMsgContent(PKIStatusInfo pKIStatusInfo, BigInteger bigInteger, PKIFreeText pKIFreeText) {
        if (pKIStatusInfo == null) {
            throw new IllegalArgumentException("ErrorMsgContent error, pki status info not specified");
        }
        this.pKIStatusInfo = pKIStatusInfo;
        this.errorCode = bigInteger;
        this.errorDetails = pKIFreeText;
    }

    public ErrorMsgContent(byte[] byArray) throws IOException {
        super(byArray);
    }

    public Object clone() {
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            this.encode(derOutputStream);
            return new ErrorMsgContent(derOutputStream.toByteArray());
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected void decode(DerValue derValue) throws IOException {
        if (derValue.getTag() != 48) {
            throw new IOException("ErrorMsgContent parsing error, not a SEQUENCE");
        }
        this.pKIStatusInfo = null;
        this.errorCode = null;
        this.errorDetails = null;
        if (derValue.getData().available() != 0) {
            this.pKIStatusInfo = new PKIStatusInfo(derValue.getData().getDerValue().toByteArray());
            if (derValue.getData().available() == 0) {
                return;
            }
        } else {
            throw new IOException("ErrorMsgContent parsing error, missing data");
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        if (derValue.getData().available() != 0 && derValue2.getTag() == 2) {
            this.errorCode = derValue2.getInteger();
            if (derValue.getData().available() != 0) {
                derValue2 = derValue.getData().getDerValue();
                this.errorDetails = new PKIFreeText(derValue2.toByteArray());
            }
            if (derValue.getData().available() == 0) {
                return;
            }
            derValue2 = derValue.getData().getDerValue();
        }
        this.errorDetails = new PKIFreeText(derValue2.toByteArray());
        if (derValue.getData().available() != 0) {
            throw new IOException("ErrorMsgContent parsing error, data overrun");
        }
    }

    public void encode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        if (this.pKIStatusInfo == null) {
            throw new IOException("ErrorMsgContent encoding error, PKIStatusInfo not specified");
        }
        this.pKIStatusInfo.encode(derOutputStream);
        if (this.errorCode != null) {
            derOutputStream.putInteger(this.errorCode);
        }
        if (this.errorDetails != null) {
            this.errorDetails.encode(derOutputStream);
        }
        derOutputStream2.write((byte)48, derOutputStream);
        outputStream.write(derOutputStream2.toByteArray());
    }

    public boolean equals(ErrorMsgContent errorMsgContent) {
        DerValue derValue;
        DerValue derValue2;
        if (errorMsgContent == this) {
            return true;
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encode(derOutputStream);
            derValue2 = new DerValue(derOutputStream.toByteArray());
            errorMsgContent.encode(derOutputStream2);
            derValue = new DerValue(derOutputStream2.toByteArray());
        }
        catch (Exception exception) {
            return false;
        }
        return derValue2.equals(derValue);
    }

    public boolean equals(Object object) {
        if (object instanceof ErrorMsgContent) {
            return this.equals((ErrorMsgContent)object);
        }
        return false;
    }

    public BigInteger getErrorCode() {
        if (this.errorCode == null) {
            return null;
        }
        return new BigInteger(this.errorCode.toByteArray());
    }

    public PKIFreeText getErrorDetails() {
        if (this.errorDetails == null) {
            return null;
        }
        return (PKIFreeText)this.errorDetails.clone();
    }

    public PKIStatusInfo getPKIStatusInfo() {
        return (PKIStatusInfo)this.pKIStatusInfo.clone();
    }

    public String toString() {
        String string = "";
        string = String.valueOf(string) + "ErrorMsgContent:";
        if (this.pKIStatusInfo != null) {
            string = String.valueOf(string) + "\r\n\tpKIStatusInfo: " + this.pKIStatusInfo.toString();
        }
        if (this.errorCode != null) {
            string = String.valueOf(string) + "\r\n\terrorCode: " + this.errorCode.toString();
        }
        if (this.errorDetails != null) {
            string = String.valueOf(string) + "\r\n\terrorDetails: " + this.errorDetails.toString();
        }
        return string;
    }
}

