/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.provider;

import com.ibm.crypto.provider.ECNamedCurve;
import com.ibm.crypto.provider.ECPrivateKey;
import com.ibm.crypto.provider.ECPublicKey;
import com.ibm.crypto.provider.ECUtils;
import com.ibm.crypto.provider.pc;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECFieldFp;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.EllipticCurve;
import java.security.spec.InvalidParameterSpecException;

public final class ECKeyPairGenerator
extends KeyPairGeneratorSpi {
    private int a = 192;
    SecureRandom b = null;
    ECParameterSpec c;
    private static String[] z;

    public void initialize(int n2, SecureRandom secureRandom) {
        if (n2 < 192 || n2 > 521 || n2 != 192 && n2 != 224 && n2 != 256 && n2 != 384 && n2 != 521) {
            throw new InvalidParameterException(z[1]);
        }
        this.a = n2;
        this.b = secureRandom;
    }

    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (!(algorithmParameterSpec instanceof ECParameterSpec)) {
            if (algorithmParameterSpec instanceof ECGenParameterSpec) {
                ECNamedCurve eCNamedCurve = new ECNamedCurve(((ECGenParameterSpec)algorithmParameterSpec).getName());
                this.c = eCNamedCurve.getECParameterSpec();
                this.b = secureRandom;
                this.a = this.c.getCurve().getField().getFieldSize();
                return;
            }
            throw new InvalidAlgorithmParameterException(z[2]);
        }
        this.c = (ECParameterSpec)algorithmParameterSpec;
        this.initialize(this.c.getCurve().getField().getFieldSize(), secureRandom);
    }

    public KeyPair generateKeyPair() {
        if (this.b == null) {
            this.b = null;
            try {
                this.b = SecureRandom.getInstance(z[0]);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                this.b = new SecureRandom();
            }
        }
        if (this.c == null) {
            this.a();
        }
        int n2 = this.c.getCurve().getField().getFieldSize();
        BigInteger bigInteger = new BigInteger(n2, this.b);
        bigInteger = bigInteger.abs();
        while (bigInteger.compareTo(this.c.getOrder()) != -1) {
            System.err.println(bigInteger);
            System.err.println(this.c.getOrder());
            bigInteger = new BigInteger(n2, this.b);
            bigInteger = bigInteger.abs();
        }
        try {
            ECPrivateKey eCPrivateKey = new ECPrivateKey(bigInteger, this.c);
            ECPublicKey eCPublicKey = new ECPublicKey(ECUtils.b(bigInteger, this.c.getGenerator(), this.c.getCurve()), this.c);
            KeyPair keyPair = new KeyPair(eCPublicKey, eCPrivateKey);
            return keyPair;
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new ProviderException(invalidKeyException.getMessage());
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new ProviderException(invalidParameterSpecException.getMessage());
        }
    }

    private void a() {
        switch (this.a) {
            case 192: {
                ECFieldFp eCFieldFp = new ECFieldFp(pc.a);
                byte[] byArray = new byte[24];
                this.b.nextBytes(byArray);
                EllipticCurve ellipticCurve = new EllipticCurve(eCFieldFp, pc.E.mod(pc.a), pc.c, byArray);
                this.c = new ECParameterSpec(ellipticCurve, pc.f, pc.b, 1);
                break;
            }
            case 224: {
                ECFieldFp eCFieldFp = new ECFieldFp(pc.g);
                byte[] byArray = new byte[28];
                this.b.nextBytes(byArray);
                EllipticCurve ellipticCurve = new EllipticCurve(eCFieldFp, pc.E.mod(pc.g), pc.i, byArray);
                this.c = new ECParameterSpec(ellipticCurve, pc.l, pc.h, 1);
                break;
            }
            case 256: {
                ECFieldFp eCFieldFp = new ECFieldFp(pc.m);
                byte[] byArray = new byte[32];
                this.b.nextBytes(byArray);
                EllipticCurve ellipticCurve = new EllipticCurve(eCFieldFp, pc.E.mod(pc.m), pc.o, byArray);
                this.c = new ECParameterSpec(ellipticCurve, pc.r, pc.n, 1);
                break;
            }
            case 384: {
                ECFieldFp eCFieldFp = new ECFieldFp(pc.s);
                byte[] byArray = new byte[48];
                this.b.nextBytes(byArray);
                EllipticCurve ellipticCurve = new EllipticCurve(eCFieldFp, pc.E.mod(pc.s), pc.u, byArray);
                this.c = new ECParameterSpec(ellipticCurve, pc.x, pc.t, 1);
                break;
            }
            case 521: {
                ECFieldFp eCFieldFp = new ECFieldFp(pc.y);
                byte[] byArray = new byte[65];
                this.b.nextBytes(byArray);
                EllipticCurve ellipticCurve = new EllipticCurve(eCFieldFp, pc.E.mod(pc.y), pc.A, byArray);
                this.c = new ECParameterSpec(ellipticCurve, pc.D, pc.z, 1);
            }
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        String[] stringArray;
        block29: {
            int n2;
            int n3;
            block28: {
                char[] cArray2;
                Object var0;
                block27: {
                    int n4;
                    block26: {
                        char[] cArray3;
                        block25: {
                            int n5;
                            block24: {
                                stringArray = new String[3];
                                var0 = null;
                                char[] cArray4 = "6xl\u0006\u0005\u001cOS02\u001eTE:\r".toCharArray();
                                cArray3 = cArray4;
                                n5 = cArray4.length;
                                n3 = 0;
                                if (!true) break block24;
                                n5 = n5;
                                if (n5 <= n3) break block25;
                            }
                            do {
                                int n6;
                                cArray3 = cArray3;
                                int n7 = n3;
                                char c2 = cArray3[n7];
                                switch (n3 % 5) {
                                    case 0: {
                                        n6 = 127;
                                        break;
                                    }
                                    case 1: {
                                        n6 = 58;
                                        break;
                                    }
                                    case 2: {
                                        n6 = 33;
                                        break;
                                    }
                                    case 3: {
                                        n6 = 85;
                                        break;
                                    }
                                    default: {
                                        n6 = 96;
                                    }
                                }
                                cArray3[n7] = (char)(c2 ^ n6);
                                ++n3;
                                n5 = n5;
                            } while (n5 > n3);
                        }
                        stringArray[0] = new String(cArray3).intern();
                        var0 = null;
                        char[] cArray5 = "/HH8\u0005_IH/\u0005_WT&\u0014_XDu\u000f\u0011_\u0001:\u0006E\u001a\u0010lRS\u001a\u0013gTS\u001a\u0013`VS\u001a\u0012mTS\u001a\u0014gQ".toCharArray();
                        cArray2 = cArray5;
                        n4 = cArray5.length;
                        n3 = 0;
                        if (!true) break block26;
                        n4 = n4;
                        if (n4 <= n3) break block27;
                    }
                    do {
                        int n8;
                        cArray2 = cArray2;
                        int n9 = n3;
                        char c3 = cArray2[n9];
                        switch (n3 % 5) {
                            case 0: {
                                n8 = 127;
                                break;
                            }
                            case 1: {
                                n8 = 58;
                                break;
                            }
                            case 2: {
                                n8 = 33;
                                break;
                            }
                            case 3: {
                                n8 = 85;
                                break;
                            }
                            default: {
                                n8 = 96;
                            }
                        }
                        cArray2[n9] = (char)(c3 ^ n8);
                        ++n3;
                        n4 = n4;
                    } while (n4 > n3);
                }
                stringArray[1] = new String(cArray2).intern();
                var0 = null;
                char[] cArray6 = "/[S4\r\f\u001aL \u0013\u000b\u001aC0@\u0016TR!\u0001\u0011YDu\u000f\u0019\u001ad\u00160\u001eH@8\u0005\u000b_S\u0006\u0010\u001aY\u0001:\u0012_\u007fb\u0012\u0005\u0011j@'\u0001\u0012_U0\u0012,JD6".toCharArray();
                cArray = cArray6;
                n2 = cArray6.length;
                n3 = 0;
                if (!true) break block28;
                n2 = n2;
                if (n2 <= n3) break block29;
            }
            do {
                int n10;
                cArray = cArray;
                int n11 = n3;
                char c4 = cArray[n11];
                switch (n3 % 5) {
                    case 0: {
                        n10 = 127;
                        break;
                    }
                    case 1: {
                        n10 = 58;
                        break;
                    }
                    case 2: {
                        n10 = 33;
                        break;
                    }
                    case 3: {
                        n10 = 85;
                        break;
                    }
                    default: {
                        n10 = 96;
                    }
                }
                cArray[n11] = (char)(c4 ^ n10);
                ++n3;
                n2 = n2;
            } while (n2 > n3);
        }
        stringArray[2] = new String(cArray).intern();
        z = stringArray;
    }
}

