/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.repository.connections;

import com.ibm.ws.repository.connections.RepositoryConnection;
import com.ibm.ws.repository.connections.internal.AbstractRepositoryConnection;
import com.ibm.ws.repository.transport.client.RepositoryReadableClient;
import com.ibm.ws.repository.transport.client.SingleFileClient;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public class SingleFileRepositoryConnection
extends AbstractRepositoryConnection
implements RepositoryConnection {
    private final File jsonFile;

    public SingleFileRepositoryConnection(File jsonFile) {
        this.jsonFile = jsonFile;
    }

    @Override
    public String getRepositoryLocation() {
        return this.jsonFile.getAbsolutePath();
    }

    @Override
    public RepositoryReadableClient createClient() {
        return new SingleFileClient(this.jsonFile);
    }

    public static SingleFileRepositoryConnection createEmptyRepository(File jsonFile) throws IOException {
        if (jsonFile.exists()) {
            throw new IOException("Cannot create empty repository as the file already exists: " + jsonFile.getAbsolutePath());
        }
        try (OutputStreamWriter writer = null;){
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(jsonFile), "UTF-8");
            writer.write("[]");
        }
        return new SingleFileRepositoryConnection(jsonFile);
    }
}

