/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.annocache.info.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.annocache.info.internal.AnnotationInfoImpl;
import com.ibm.ws.annocache.info.internal.ClassInfoImpl;
import com.ibm.ws.annocache.info.internal.DelayedClassInfoImpl;
import com.ibm.ws.annocache.info.internal.FieldInfoImpl;
import com.ibm.ws.annocache.info.internal.InfoStoreImpl;
import com.ibm.ws.annocache.info.internal.MethodInfoImpl;
import com.ibm.ws.annocache.info.internal.PackageInfoImpl;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class NonDelayedClassInfoImpl
extends ClassInfoImpl {
    private static final Logger logger = Logger.getLogger("com.ibm.ws.annocache.info");
    private static final String CLASS_NAME = NonDelayedClassInfoImpl.class.getSimpleName();
    protected static final boolean IS_ARTIFICIAL = true;
    protected static final boolean IS_NOT_ARTIFICIAL = false;
    private final boolean isArtificial;
    private final boolean isInterface;
    private final String packageName;
    private PackageInfoImpl packageInfo;
    private final boolean isJavaClass;
    private final String[] interfaceNames;
    private ClassInfoImpl[] interfaces;
    private final String superClassName;
    private ClassInfoImpl superClass;
    private List<FieldInfoImpl> declaredFields;
    private List<MethodInfoImpl> declaredConstructors;
    private List<MethodInfoImpl> declaredMethods;
    public static final String[] EMPTY_INTERFACE_NAMES = new String[0];
    public static final int MODIFIER_PUBLIC_NONINTERFACE = 1;
    private static final Comparator<MethodInfoImpl> METHOD_COMPARATOR = new Comparator<MethodInfoImpl>(){
        static final long serialVersionUID = -497442064218742008L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Override
        public int compare(MethodInfoImpl m1, MethodInfoImpl m2) {
            int result = m1.getName().compareTo(m2.getName());
            if (result == 0) {
                result = m1.getDescription().compareTo(m2.getDescription());
            }
            return result;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.annocache.info.internal.NonDelayedClassInfoImpl$1", 1.class, (String)"com.ibm.ws.annocache", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
        }
    };
    protected boolean isFieldAnnotationPresent;
    protected boolean isMethodAnnotationPresent;
    private List<AnnotationInfoImpl> annotations;
    protected DelayedClassInfoImpl delayedClassInfo;
    protected NonDelayedClassInfoImpl priorClassInfo;
    protected NonDelayedClassInfoImpl nextClassInfo;
    static final long serialVersionUID = 3854791401969806068L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static boolean isInterface(int modifiers) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.NonDelayedClassInfoImpl", "isInterface", new Object[]{modifiers});
        }
        boolean bl = Modifier.isInterface(modifiers);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.annocache.info.internal.NonDelayedClassInfoImpl", "isInterface", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected NonDelayedClassInfoImpl(String name, InfoStoreImpl infoStore) {
        this(name, "java.lang.Object", 1, EMPTY_INTERFACE_NAMES, true, infoStore);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.NonDelayedClassInfoImpl", "<init>", new Object[]{name, infoStore});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.info.internal.NonDelayedClassInfoImpl", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public NonDelayedClassInfoImpl(String name, String superClassName, int modifiers, String[] interfaceNames, InfoStoreImpl infoStore) {
        this(name, superClassName, modifiers, interfaceNames, false, infoStore);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.NonDelayedClassInfoImpl", "<init>", new Object[]{name, superClassName, modifiers, interfaceNames, infoStore});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.info.internal.NonDelayedClassInfoImpl", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public NonDelayedClassInfoImpl(String name, String superClassName, int modifiers, String[] interfaceNames, boolean isArtificial, InfoStoreImpl infoStore) {
        super(name, modifiers, infoStore);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.NonDelayedClassInfoImpl", "<init>", new Object[]{name, superClassName, modifiers, interfaceNames, isArtificial, infoStore});
        }
        String methodName = "<init>";
        if (name.equals("java.lang.Object")) {
            superClassName = null;
        }
        InfoStoreImpl useStore = this.getInfoStore();
        this.isArtificial = isArtificial;
        this.isInterface = NonDelayedClassInfoImpl.isInterface(modifiers);
        this.packageName = useStore.internPackageName(ClassInfoImpl.getPackageName(name));
        this.packageInfo = null;
        this.isJavaClass = ClassInfoImpl.isJavaClass(name);
        for (int nameNo = 0; nameNo < interfaceNames.length; ++nameNo) {
            interfaceNames[nameNo] = useStore.internClassName(interfaceNames[nameNo]);
        }
        this.interfaceNames = interfaceNames;
        this.interfaces = null;
        if (superClassName == null && !name.equals("java.lang.Object") && !this.isInterface && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "Strange: Null superclass name for non-interface!");
        }
        this.superClassName = useStore.internClassName(superClassName);
        this.superClass = null;
        this.declaredFields = Collections.emptyList();
        this.declaredConstructors = Collections.emptyList();
        this.declaredMethods = Collections.emptyList();
        if (logger.isLoggable(Level.FINER)) {
            if (this.isArtificial) {
                logger.logp(Level.FINER, CLASS_NAME, methodName, "<init> [ {0} ] Created [ ** ARTIFICIAL ** ]", this.getHashText());
            } else {
                logger.logp(Level.FINER, CLASS_NAME, methodName, "<init> [ {0} ] Created", this.getHashText());
            }
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.info.internal.NonDelayedClassInfoImpl", "<init>", this);
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isArtificial() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.NonDelayedClassInfoImpl", "isArtificial", new Object[0]);
        }
        boolean bl = this.isArtificial;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.annocache.info.internal.NonDelayedClassInfoImpl", "isArtificial", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isNonDelayed() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.NonDelayedClassInfoImpl", "isNonDelayed", new Object[0]);
        }
        boolean bl = true;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.annocache.info.internal.NonDelayedClassInfoImpl", "isNonDelayed", bl);
        }
        return bl;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public NonDelayedClassInfoImpl asNonDelayedClass() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.NonDelayedClassInfoImpl", "asNonDelayedClass", new Object[0]);
        }
        NonDelayedClassInfoImpl nonDelayedClassInfoImpl = this;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            nonDelayedClassInfoImpl = nonDelayedClassInfoImpl;
            logger.exiting("com.ibm.ws.annocache.info.internal.NonDelayedClassInfoImpl", "asNonDelayedClass", nonDelayedClassInfoImpl);
        }
        return nonDelayedClassInfoImpl;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getPackageName() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.NonDelayedClassInfoImpl", "getPackageName", new Object[0]);
        }
        String string = this.packageName;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.ws.annocache.info.internal.NonDelayedClassInfoImpl", "getPackageName", string);
        }
        return string;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public PackageInfoImpl getPackage() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.NonDelayedClassInfoImpl", "getPackage", new Object[0]);
        }
        if (this.packageInfo == null && this.packageName != null) {
            this.packageInfo = this.getInfoStore().getPackageInfo(this.packageName, true);
        }
        PackageInfoImpl packageInfoImpl = this.packageInfo;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            packageInfoImpl = packageInfoImpl;
            logger.exiting("com.ibm.ws.annocache.info.internal.NonDelayedClassInfoImpl", "getPackage", packageInfoImpl);
        }
        return packageInfoImpl;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isJavaClass() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.NonDelayedClassInfoImpl", "isJavaClass", new Object[0]);
        }
        boolean bl = this.isJavaClass;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.annocache.info.internal.NonDelayedClassInfoImpl", "isJavaClass", bl);
        }
        return bl;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<String> getInterfaceNames() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.NonDelayedClassInfoImpl", "getInterfaceNames", new Object[0]);
        }
        List<String> list = Arrays.asList(this.interfaceNames);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            list = list;
            logger.exiting("com.ibm.ws.annocache.info.internal.NonDelayedClassInfoImpl", "getInterfaceNames", list);
        }
        return list;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<ClassInfoImpl> getInterfaces() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.NonDelayedClassInfoImpl", "getInterfaces", new Object[0]);
        }
        if (this.interfaces == null) {
            this.interfaces = new ClassInfoImpl[this.interfaceNames.length];
            int interfaceNo = 0;
            for (String interfaceName : this.interfaceNames) {
                ClassInfoImpl nextInterface = this.getInfoStore().getDelayableClassInfo(interfaceName);
                this.interfaces[interfaceNo++] = nextInterface;
            }
        }
        List<ClassInfoImpl> list = Arrays.asList(this.interfaces);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            list = list;
            logger.exiting("com.ibm.ws.annocache.info.internal.NonDelayedClassInfoImpl", "getInterfaces", list);
        }
        return list;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isAnnotationClass() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.NonDelayedClassInfoImpl", "isAnnotationClass", new Object[0]);
        }
        boolean bl = (this.getModifiers() & 0x2000) != 0;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.annocache.info.internal.NonDelayedClassInfoImpl", "isAnnotationClass", bl);
        }
        return bl;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isInterface() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.NonDelayedClassInfoImpl", "isInterface", new Object[0]);
        }
        boolean bl = this.isInterface;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.annocache.info.internal.NonDelayedClassInfoImpl", "isInterface", bl);
        }
        return bl;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getSuperclassName() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.NonDelayedClassInfoImpl", "getSuperclassName", new Object[0]);
        }
        String string = this.superClassName;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.ws.annocache.info.internal.NonDelayedClassInfoImpl", "getSuperclassName", string);
        }
        return string;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ClassInfoImpl getSuperclass() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.NonDelayedClassInfoImpl", "getSuperclass", new Object[0]);
        }
        if (this.superClass == null && this.superClassName != null) {
            this.superClass = this.getInfoStore().getDelayableClassInfo(this.superClassName);
        }
        ClassInfoImpl classInfoImpl = this.superClass;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            classInfoImpl = classInfoImpl;
            logger.exiting("com.ibm.ws.annocache.info.internal.NonDelayedClassInfoImpl", "getSuperclass", classInfoImpl);
        }
        return classInfoImpl;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isInstanceOf(String className) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.NonDelayedClassInfoImpl", "isInstanceOf", new Object[]{className});
        }
        if (this.getName().equals(className)) {
            boolean bl = true;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bl = bl;
                logger.exiting("com.ibm.ws.annocache.info.internal.NonDelayedClassInfoImpl", "isInstanceOf", bl);
            }
            return bl;
        }
        for (String interfaceName : this.interfaceNames) {
            if (!className.equals(interfaceName)) continue;
            boolean bl = true;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bl = bl;
                logger.exiting("com.ibm.ws.annocache.info.internal.NonDelayedClassInfoImpl", "isInstanceOf", bl);
            }
            return bl;
        }
        if (this.isInterface()) {
            boolean bl = false;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bl = bl;
                logger.exiting("com.ibm.ws.annocache.info.internal.NonDelayedClassInfoImpl", "isInstanceOf", bl);
            }
            return bl;
        }
        ClassInfoImpl useSuperClass = this.getSuperclass();
        boolean bl = useSuperClass != null && useSuperClass.isInstanceOf(className);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.annocache.info.internal.NonDelayedClassInfoImpl", "isInstanceOf", bl);
        }
        return bl;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isAssignableFrom(String className) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.NonDelayedClassInfoImpl", "isAssignableFrom", new Object[]{className});
        }
        String useName = this.getName();
        if (useName.equals(className)) {
            boolean bl = true;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bl = bl;
                logger.exiting("com.ibm.ws.annocache.info.internal.NonDelayedClassInfoImpl", "isAssignableFrom", bl);
            }
            return bl;
        }
        boolean bl = this.getInfoStore().getDelayableClassInfo(className).isInstanceOf(useName);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.annocache.info.internal.NonDelayedClassInfoImpl", "isAssignableFrom", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void storeFields(List<FieldInfoImpl> fields) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.NonDelayedClassInfoImpl", "storeFields", new Object[]{fields});
        }
        this.declaredFields = fields == null || fields.isEmpty() ? Collections.emptyList() : new ArrayList<FieldInfoImpl>(fields);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.info.internal.NonDelayedClassInfoImpl", "storeFields");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<FieldInfoImpl> getDeclaredFields() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.NonDelayedClassInfoImpl", "getDeclaredFields", new Object[0]);
        }
        List<FieldInfoImpl> list = this.declaredFields;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            list = list;
            logger.exiting("com.ibm.ws.annocache.info.internal.NonDelayedClassInfoImpl", "getDeclaredFields", list);
        }
        return list;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void storeConstructors(List<MethodInfoImpl> constructors) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.NonDelayedClassInfoImpl", "storeConstructors", new Object[]{constructors});
        }
        this.declaredConstructors = constructors == null || constructors.isEmpty() ? Collections.emptyList() : new ArrayList<MethodInfoImpl>(constructors);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.info.internal.NonDelayedClassInfoImpl", "storeConstructors");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<MethodInfoImpl> getDeclaredConstructors() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.NonDelayedClassInfoImpl", "getDeclaredConstructors", new Object[0]);
        }
        List<MethodInfoImpl> list = this.declaredConstructors;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            list = list;
            logger.exiting("com.ibm.ws.annocache.info.internal.NonDelayedClassInfoImpl", "getDeclaredConstructors", list);
        }
        return list;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void storeMethods(List<MethodInfoImpl> methods) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.NonDelayedClassInfoImpl", "storeMethods", new Object[]{methods});
        }
        this.declaredMethods = methods == null || methods.isEmpty() ? Collections.emptyList() : new ArrayList<MethodInfoImpl>(methods);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.info.internal.NonDelayedClassInfoImpl", "storeMethods");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<MethodInfoImpl> getDeclaredMethods() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.NonDelayedClassInfoImpl", "getDeclaredMethods", new Object[0]);
        }
        List<MethodInfoImpl> list = this.declaredMethods;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            list = list;
            logger.exiting("com.ibm.ws.annocache.info.internal.NonDelayedClassInfoImpl", "getDeclaredMethods", list);
        }
        return list;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected static int compare(List<String> names1, List<String> names2) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.NonDelayedClassInfoImpl", "compare", new Object[]{names1, names2});
        }
        Iterator<String> useNames1 = names1.iterator();
        Iterator<String> useNames2 = names2.iterator();
        while (useNames1.hasNext()) {
            String useName2;
            if (!useNames2.hasNext()) {
                int n = 1;
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    n = n;
                    logger.exiting("com.ibm.ws.annocache.info.internal.NonDelayedClassInfoImpl", "compare", n);
                }
                return n;
            }
            String useName1 = useNames1.next();
            int comparison = useName1.compareTo(useName2 = useNames2.next());
            if (comparison == 0) continue;
            int n = comparison;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                n = n;
                logger.exiting("com.ibm.ws.annocache.info.internal.NonDelayedClassInfoImpl", "compare", n);
            }
            return n;
        }
        if (useNames2.hasNext()) {
            int n = -1;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                n = n;
                logger.exiting("com.ibm.ws.annocache.info.internal.NonDelayedClassInfoImpl", "compare", n);
            }
            return n;
        }
        int n = 0;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            n = n;
            logger.exiting("com.ibm.ws.annocache.info.internal.NonDelayedClassInfoImpl", "compare", n);
        }
        return n;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<MethodInfoImpl> getMethods() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.NonDelayedClassInfoImpl", "getMethods", new Object[0]);
        }
        LinkedList<MethodInfoImpl> allMethods = new LinkedList<MethodInfoImpl>();
        allMethods.addAll(this.declaredMethods);
        ClassInfoImpl useSuperClass = this.getSuperclass();
        if (useSuperClass != null) {
            Map<MethodInfoImpl, MethodInfoImpl> overloadingMethods;
            if (!this.declaredMethods.isEmpty()) {
                overloadingMethods = new TreeMap(METHOD_COMPARATOR);
                for (MethodInfoImpl declaredMethod : this.declaredMethods) {
                    if (declaredMethod.isPrivate()) continue;
                    overloadingMethods.put(declaredMethod, declaredMethod);
                }
            } else {
                overloadingMethods = Collections.emptyMap();
            }
            List<MethodInfoImpl> superMethods = useSuperClass.getMethods();
            String usePackageName = this.getPackageName();
            for (MethodInfoImpl superMethod : superMethods) {
                if (superMethod.isPackagePrivate() && !superMethod.getDeclaringClass().getPackageName().equals(usePackageName) || superMethod.isPrivate() || overloadingMethods.get(superMethod) != null) continue;
                allMethods.add(superMethod);
            }
        }
        LinkedList<MethodInfoImpl> linkedList = allMethods;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            linkedList = linkedList;
            logger.exiting("com.ibm.ws.annocache.info.internal.NonDelayedClassInfoImpl", "getMethods", linkedList);
        }
        return linkedList;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isFieldAnnotationPresent() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.NonDelayedClassInfoImpl", "isFieldAnnotationPresent", new Object[0]);
        }
        boolean bl = this.isFieldAnnotationPresent;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.annocache.info.internal.NonDelayedClassInfoImpl", "isFieldAnnotationPresent", bl);
        }
        return bl;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isMethodAnnotationPresent() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.NonDelayedClassInfoImpl", "isMethodAnnotationPresent", new Object[0]);
        }
        boolean bl = this.isMethodAnnotationPresent;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.annocache.info.internal.NonDelayedClassInfoImpl", "isMethodAnnotationPresent", bl);
        }
        return bl;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void storeDeclaredAnnotations(List<AnnotationInfoImpl> annos) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.NonDelayedClassInfoImpl", "storeDeclaredAnnotations", new Object[]{annos});
        }
        this.annotations = null;
        super.storeDeclaredAnnotations(annos);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.info.internal.NonDelayedClassInfoImpl", "storeDeclaredAnnotations");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<AnnotationInfoImpl> getAnnotations() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.NonDelayedClassInfoImpl", "getAnnotations", new Object[0]);
        }
        if (this.annotations == null) {
            ClassInfoImpl useSuperClass = this.getSuperclass();
            if (useSuperClass == null) {
                this.annotations = this.declaredAnnotations;
            } else {
                ArrayList<AnnotationInfoImpl> allAnnotations = new ArrayList<AnnotationInfoImpl>(this.declaredAnnotations.size());
                HashSet<String> declaredAnnotationNames = new HashSet<String>(this.declaredAnnotations.size());
                for (AnnotationInfoImpl declaredAnnotation : this.declaredAnnotations) {
                    declaredAnnotationNames.add(declaredAnnotation.getAnnotationClassName());
                    allAnnotations.add(declaredAnnotation);
                }
                for (AnnotationInfoImpl superAnnotation : useSuperClass.getAnnotations()) {
                    if (!superAnnotation.isInherited() || declaredAnnotationNames.contains(superAnnotation.getAnnotationClassName())) continue;
                    allAnnotations.add(superAnnotation);
                }
                this.annotations = allAnnotations.isEmpty() ? Collections.emptyList() : new ArrayList<AnnotationInfoImpl>(allAnnotations);
            }
        }
        List<AnnotationInfoImpl> list = this.annotations;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            list = list;
            logger.exiting("com.ibm.ws.annocache.info.internal.NonDelayedClassInfoImpl", "getAnnotations", list);
        }
        return list;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setDelayedClassInfo(DelayedClassInfoImpl delayedClassInfo) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.NonDelayedClassInfoImpl", "setDelayedClassInfo", new Object[]{delayedClassInfo});
        }
        this.delayedClassInfo = delayedClassInfo;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.info.internal.NonDelayedClassInfoImpl", "setDelayedClassInfo");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public DelayedClassInfoImpl getDelayedClassInfo() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.NonDelayedClassInfoImpl", "getDelayedClassInfo", new Object[0]);
        }
        DelayedClassInfoImpl delayedClassInfoImpl = this.delayedClassInfo;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            delayedClassInfoImpl = delayedClassInfoImpl;
            logger.exiting("com.ibm.ws.annocache.info.internal.NonDelayedClassInfoImpl", "getDelayedClassInfo", delayedClassInfoImpl);
        }
        return delayedClassInfoImpl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public NonDelayedClassInfoImpl setPriorClassInfo(NonDelayedClassInfoImpl newPriorClassInfo) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.NonDelayedClassInfoImpl", "setPriorClassInfo", new Object[]{newPriorClassInfo});
        }
        NonDelayedClassInfoImpl oldPriorClassInfo = this.priorClassInfo;
        this.priorClassInfo = newPriorClassInfo;
        NonDelayedClassInfoImpl nonDelayedClassInfoImpl = oldPriorClassInfo;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            nonDelayedClassInfoImpl = nonDelayedClassInfoImpl;
            logger.exiting("com.ibm.ws.annocache.info.internal.NonDelayedClassInfoImpl", "setPriorClassInfo", nonDelayedClassInfoImpl);
        }
        return nonDelayedClassInfoImpl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public NonDelayedClassInfoImpl getPriorClassInfo() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.NonDelayedClassInfoImpl", "getPriorClassInfo", new Object[0]);
        }
        NonDelayedClassInfoImpl nonDelayedClassInfoImpl = this.priorClassInfo;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            nonDelayedClassInfoImpl = nonDelayedClassInfoImpl;
            logger.exiting("com.ibm.ws.annocache.info.internal.NonDelayedClassInfoImpl", "getPriorClassInfo", nonDelayedClassInfoImpl);
        }
        return nonDelayedClassInfoImpl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public NonDelayedClassInfoImpl setNextClassInfo(NonDelayedClassInfoImpl newNextClassInfo) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.NonDelayedClassInfoImpl", "setNextClassInfo", new Object[]{newNextClassInfo});
        }
        NonDelayedClassInfoImpl oldNextClassInfo = this.nextClassInfo;
        this.nextClassInfo = newNextClassInfo;
        NonDelayedClassInfoImpl nonDelayedClassInfoImpl = oldNextClassInfo;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            nonDelayedClassInfoImpl = nonDelayedClassInfoImpl;
            logger.exiting("com.ibm.ws.annocache.info.internal.NonDelayedClassInfoImpl", "setNextClassInfo", nonDelayedClassInfoImpl);
        }
        return nonDelayedClassInfoImpl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public NonDelayedClassInfoImpl getNextClassInfo() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.NonDelayedClassInfoImpl", "getNextClassInfo", new Object[0]);
        }
        NonDelayedClassInfoImpl nonDelayedClassInfoImpl = this.nextClassInfo;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            nonDelayedClassInfoImpl = nonDelayedClassInfoImpl;
            logger.exiting("com.ibm.ws.annocache.info.internal.NonDelayedClassInfoImpl", "getNextClassInfo", nonDelayedClassInfoImpl);
        }
        return nonDelayedClassInfoImpl;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void log(Logger useLogger) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.NonDelayedClassInfoImpl", "log", new Object[]{useLogger});
        }
        String methodName = "log";
        if (!useLogger.isLoggable(Level.FINER)) {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.exiting("com.ibm.ws.annocache.info.internal.NonDelayedClassInfoImpl", "log");
            }
            return;
        }
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, " Non-Delayed Class [ {0} ]", this.getHashText());
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "  delayedClassInfo [ {0} ]", this.delayedClassInfo == null ? null : this.delayedClassInfo.getHashText());
        if (!useLogger.isLoggable(Level.FINEST)) {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.exiting("com.ibm.ws.annocache.info.internal.NonDelayedClassInfoImpl", "log");
            }
            return;
        }
        useLogger.logp(Level.FINEST, CLASS_NAME, methodName, "  isInterface [ {0} ]", this.isInterface);
        useLogger.logp(Level.FINEST, CLASS_NAME, methodName, "  packageName [ {0} ]", this.packageName);
        useLogger.logp(Level.FINEST, CLASS_NAME, methodName, "  packageInfo [ {0} ]", this.packageInfo == null ? null : this.packageInfo.getHashText());
        useLogger.logp(Level.FINEST, CLASS_NAME, methodName, "  isJavaClass [ {0} ]", this.isJavaClass);
        if (this.interfaceNames == null) {
            useLogger.logp(Level.FINEST, CLASS_NAME, methodName, "  interfaceNames [ null ]");
        } else {
            for (String interfaceName : this.interfaceNames) {
                useLogger.logp(Level.FINEST, CLASS_NAME, methodName, "  interfaceName [ {0} ]", interfaceName);
            }
        }
        if (this.interfaces == null) {
            useLogger.logp(Level.FINEST, CLASS_NAME, methodName, "  interfaces [ null ]");
        } else {
            for (ClassInfoImpl interfaceInfo : this.interfaces) {
                useLogger.logp(Level.FINEST, CLASS_NAME, methodName, "  interface [ {0} ]", interfaceInfo.getHashText());
            }
        }
        useLogger.logp(Level.FINEST, CLASS_NAME, methodName, "  superClassName [ {0} ]", this.superClassName);
        useLogger.logp(Level.FINEST, CLASS_NAME, methodName, "  superClass [ {0} ]", this.superClass == null ? null : this.superClass.getHashText());
        if (this.declaredFields == null) {
            useLogger.logp(Level.FINEST, CLASS_NAME, methodName, "  declaredFields [ null ]");
        } else {
            for (FieldInfoImpl fieldInfo : this.declaredFields) {
                useLogger.logp(Level.FINEST, CLASS_NAME, methodName, "  declaredFields [ {0} ]", fieldInfo.getHashText());
            }
        }
        if (this.declaredConstructors == null) {
            useLogger.logp(Level.FINEST, CLASS_NAME, methodName, "  declaredConstructors [ null ]");
        } else {
            for (MethodInfoImpl methodInfo : this.declaredConstructors) {
                useLogger.logp(Level.FINEST, CLASS_NAME, methodName, "  declaredConstructors [ {0} ]", methodInfo.getHashText());
            }
        }
        if (this.declaredMethods == null) {
            useLogger.logp(Level.FINEST, CLASS_NAME, methodName, "  declaredMethods [ null ]");
        } else {
            for (MethodInfoImpl methodInfo : this.declaredMethods) {
                useLogger.logp(Level.FINEST, CLASS_NAME, methodName, "  declaredMethods [ {0} ]", methodInfo.getHashText());
            }
        }
        useLogger.logp(Level.FINEST, CLASS_NAME, methodName, "  isFieldAnnotationPresent [ {0} ]", this.isFieldAnnotationPresent);
        useLogger.logp(Level.FINEST, CLASS_NAME, methodName, "  isMethodAnnotationPresent [ {0} ]", this.isMethodAnnotationPresent);
        useLogger.logp(Level.FINEST, CLASS_NAME, methodName, "  delayedClassInfo [ {0} ]", this.delayedClassInfo == null ? null : this.delayedClassInfo.getHashText());
        useLogger.logp(Level.FINEST, CLASS_NAME, methodName, "  priorClassInfo [ {0} ]", this.priorClassInfo == null ? null : this.priorClassInfo.getHashText());
        useLogger.logp(Level.FINEST, CLASS_NAME, methodName, "  nextClassInfo [ {0} ]", this.nextClassInfo == null ? null : this.nextClassInfo.getHashText());
        this.logAnnotations(useLogger);
        if (this.declaredConstructors != null) {
            for (MethodInfoImpl methodInfo : this.declaredConstructors) {
                methodInfo.log(useLogger);
            }
        }
        useLogger.logp(Level.FINEST, CLASS_NAME, methodName, " Non-Delayed Class [ {0} ]", this.getHashText());
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.info.internal.NonDelayedClassInfoImpl", "log");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void log(TraceComponent useLogger) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.NonDelayedClassInfoImpl", "log", new Object[]{useLogger});
        }
        Tr.debug((TraceComponent)useLogger, (String)MessageFormat.format(" Non-Delayed Class [ {0} ]", this.getHashText()), (Object[])new Object[0]);
        Tr.debug((TraceComponent)useLogger, (String)MessageFormat.format("  delayedClassInfo [ {0} ]", this.delayedClassInfo == null ? null : this.delayedClassInfo.getHashText()), (Object[])new Object[0]);
        if (!useLogger.isDumpEnabled()) {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.exiting("com.ibm.ws.annocache.info.internal.NonDelayedClassInfoImpl", "log");
            }
            return;
        }
        Tr.dump((TraceComponent)useLogger, (String)MessageFormat.format("  isInterface [ {0} ]", this.isInterface), (Object[])new Object[0]);
        Tr.dump((TraceComponent)useLogger, (String)MessageFormat.format("  packageName [ {0} ]", this.packageName), (Object[])new Object[0]);
        Tr.dump((TraceComponent)useLogger, (String)MessageFormat.format("  packageInfo [ {0} ]", this.packageInfo == null ? null : this.packageInfo.getHashText()), (Object[])new Object[0]);
        Tr.dump((TraceComponent)useLogger, (String)MessageFormat.format("  isJavaClass [ {0} ]", this.isJavaClass), (Object[])new Object[0]);
        if (this.interfaceNames == null) {
            Tr.dump((TraceComponent)useLogger, (String)"  interfaceNames [ null ]", (Object[])new Object[0]);
        } else {
            for (String interfaceName : this.interfaceNames) {
                Tr.dump((TraceComponent)useLogger, (String)MessageFormat.format("  interfaceName [ {0} ]", interfaceName), (Object[])new Object[0]);
            }
        }
        if (this.interfaces == null) {
            Tr.dump((TraceComponent)useLogger, (String)"  interfaces [ null ]", (Object[])new Object[0]);
        } else {
            for (ClassInfoImpl interfaceInfo : this.interfaces) {
                Tr.dump((TraceComponent)useLogger, (String)MessageFormat.format("  interface [ {0} ]", interfaceInfo.getHashText()), (Object[])new Object[0]);
            }
        }
        Tr.dump((TraceComponent)useLogger, (String)MessageFormat.format("  superClassName [ {0} ]", this.superClassName), (Object[])new Object[0]);
        Tr.dump((TraceComponent)useLogger, (String)MessageFormat.format("  superClass [ {0} ]", this.superClass == null ? null : this.superClass.getHashText()), (Object[])new Object[0]);
        if (this.declaredFields == null) {
            Tr.dump((TraceComponent)useLogger, (String)"  declaredFields [ null ]", (Object[])new Object[0]);
        } else {
            for (FieldInfoImpl fieldInfo : this.declaredFields) {
                Tr.dump((TraceComponent)useLogger, (String)MessageFormat.format("  declaredFields [ {0} ]", fieldInfo.getHashText()), (Object[])new Object[0]);
            }
        }
        if (this.declaredConstructors == null) {
            Tr.dump((TraceComponent)useLogger, (String)"  declaredConstructors [ null ]", (Object[])new Object[0]);
        } else {
            for (MethodInfoImpl methodInfo : this.declaredConstructors) {
                Tr.dump((TraceComponent)useLogger, (String)MessageFormat.format("  declaredConstructors [ {0} ]", methodInfo.getHashText()), (Object[])new Object[0]);
            }
        }
        if (this.declaredMethods == null) {
            Tr.dump((TraceComponent)useLogger, (String)"  declaredMethods [ null ]", (Object[])new Object[0]);
        } else {
            for (MethodInfoImpl methodInfo : this.declaredMethods) {
                Tr.dump((TraceComponent)useLogger, (String)MessageFormat.format("  declaredMethods [ {0} ]", methodInfo.getHashText()), (Object[])new Object[0]);
            }
        }
        Tr.dump((TraceComponent)useLogger, (String)MessageFormat.format("  isFieldAnnotationPresent [ {0} ]", this.isFieldAnnotationPresent), (Object[])new Object[0]);
        Tr.dump((TraceComponent)useLogger, (String)MessageFormat.format("  isMethodAnnotationPresent [ {0} ]", this.isMethodAnnotationPresent), (Object[])new Object[0]);
        Tr.dump((TraceComponent)useLogger, (String)MessageFormat.format("  delayedClassInfo [ {0} ]", this.delayedClassInfo == null ? null : this.delayedClassInfo.getHashText()), (Object[])new Object[0]);
        Tr.dump((TraceComponent)useLogger, (String)MessageFormat.format("  priorClassInfo [ {0} ]", this.priorClassInfo == null ? null : this.priorClassInfo.getHashText()), (Object[])new Object[0]);
        Tr.dump((TraceComponent)useLogger, (String)MessageFormat.format("  nextClassInfo [ {0} ]", this.nextClassInfo == null ? null : this.nextClassInfo.getHashText()), (Object[])new Object[0]);
        this.logAnnotations(useLogger);
        if (this.declaredConstructors != null) {
            for (MethodInfoImpl methodInfo : this.declaredConstructors) {
                methodInfo.log(useLogger);
            }
        }
        Tr.dump((TraceComponent)useLogger, (String)MessageFormat.format(" Non-Delayed Class [ {0} ]", this.getHashText()), (Object[])new Object[0]);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.info.internal.NonDelayedClassInfoImpl", "log");
        }
    }
}

