/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.annocache.info.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.annocache.info.internal.AnnotationInfoImpl;
import com.ibm.ws.annocache.info.internal.AnnotationValueImpl;
import com.ibm.ws.annocache.info.internal.ClassInfoImpl;
import com.ibm.ws.annocache.info.internal.InfoImpl;
import com.ibm.ws.annocache.info.internal.InfoStoreImpl;
import com.ibm.ws.annocache.info.internal.NonDelayedClassInfoImpl;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.anno.info.AnnotationInfo;
import com.ibm.wsspi.annocache.info.MethodInfo;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.objectweb.asm.Type;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class MethodInfoImpl
extends InfoImpl
implements MethodInfo {
    private static final Logger logger = Logger.getLogger("com.ibm.ws.annocache.info");
    private static final String CLASS_NAME = MethodInfoImpl.class.getSimpleName();
    protected ClassInfoImpl declaringClass;
    private final String description;
    private final List<String> exceptionClassNames;
    private List<ClassInfoImpl> exceptionClassInfos;
    private List<String> parameterTypeNames;
    private List<ClassInfoImpl> parameterClassInfos;
    private List<List<AnnotationInfoImpl>> parameterAnnotations;
    private ClassInfoImpl returnClassInfo;
    protected Type returnTypeAsType;
    protected String returnTypeName;
    protected AnnotationValueImpl annotationDefaultValue;
    static final long serialVersionUID = 445508735074898083L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static String getHashSuffix(NonDelayedClassInfoImpl declaringClass, String name, String description) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.MethodInfoImpl", "getHashSuffix", new Object[]{declaringClass, name, description});
        }
        String string = declaringClass.getName() + "." + name + ", " + description;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.ws.annocache.info.internal.MethodInfoImpl", "getHashSuffix", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public MethodInfoImpl(String name, String description, String[] exceptions, int modifiers, NonDelayedClassInfoImpl declaringClass) {
        super(name, modifiers, declaringClass.getInfoStore(), MethodInfoImpl.getHashSuffix(declaringClass, name, description));
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.MethodInfoImpl", "<init>", new Object[]{name, description, exceptions, modifiers, declaringClass});
        }
        String methodName = "<init>";
        InfoStoreImpl useInfoStore = this.getInfoStore();
        this.description = useInfoStore.internDescription(description);
        this.declaringClass = declaringClass;
        if (exceptions != null) {
            for (int exceptionNo = 0; exceptionNo < exceptions.length; ++exceptionNo) {
                String nextException = exceptions[exceptionNo];
                nextException = nextException.replace('/', '.');
                exceptions[exceptionNo] = useInfoStore.internClassName(nextException);
            }
        }
        this.exceptionClassNames = exceptions == null ? Collections.emptyList() : Arrays.asList(exceptions);
        this.exceptionClassInfos = null;
        this.parameterClassInfos = null;
        this.parameterAnnotations = Collections.emptyList();
        if (logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, CLASS_NAME, methodName, "{0} ] Created on [ {1} ] [ {2} ]", new Object[]{this.getHashText(), this.getDeclaringClass().getHashText(), this.getDescription()});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.info.internal.MethodInfoImpl", "<init>", this);
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ClassInfoImpl getDeclaringClass() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.MethodInfoImpl", "getDeclaringClass", new Object[0]);
        }
        ClassInfoImpl classInfoImpl = this.declaringClass;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            classInfoImpl = classInfoImpl;
            logger.exiting("com.ibm.ws.annocache.info.internal.MethodInfoImpl", "getDeclaringClass", classInfoImpl);
        }
        return classInfoImpl;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected String internName(String methodName) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.MethodInfoImpl", "internName", new Object[]{methodName});
        }
        String string = this.getInfoStore().internMethodName(methodName);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.ws.annocache.info.internal.MethodInfoImpl", "internName", string);
        }
        return string;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getQualifiedName() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.MethodInfoImpl", "getQualifiedName", new Object[0]);
        }
        String string = this.getDeclaringClass().getName() + '.' + this.getName();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.ws.annocache.info.internal.MethodInfoImpl", "getQualifiedName", string);
        }
        return string;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getDescription() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.MethodInfoImpl", "getDescription", new Object[0]);
        }
        String string = this.description;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.ws.annocache.info.internal.MethodInfoImpl", "getDescription", string);
        }
        return string;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<String> getExceptionTypeNames() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.MethodInfoImpl", "getExceptionTypeNames", new Object[0]);
        }
        List<String> list = this.exceptionClassNames;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            list = list;
            logger.exiting("com.ibm.ws.annocache.info.internal.MethodInfoImpl", "getExceptionTypeNames", list);
        }
        return list;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<ClassInfoImpl> getExceptionTypes() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.MethodInfoImpl", "getExceptionTypes", new Object[0]);
        }
        if (this.exceptionClassInfos == null) {
            if (this.exceptionClassNames.isEmpty()) {
                this.exceptionClassInfos = Collections.emptyList();
            } else {
                ClassInfoImpl[] exceptionInfos = new ClassInfoImpl[this.exceptionClassNames.size()];
                int i = 0;
                for (String exceptionClassName : this.exceptionClassNames) {
                    exceptionInfos[i++] = this.getDelayableClassInfo(exceptionClassName);
                }
                this.exceptionClassInfos = Arrays.asList(exceptionInfos);
            }
        }
        List<ClassInfoImpl> list = this.exceptionClassInfos;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            list = list;
            logger.exiting("com.ibm.ws.annocache.info.internal.MethodInfoImpl", "getExceptionTypes", list);
        }
        return list;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<String> getParameterTypeNames() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.MethodInfoImpl", "getParameterTypeNames", new Object[0]);
        }
        if (this.parameterTypeNames == null) {
            Type[] argumentTypes = Type.getArgumentTypes((String)this.getDescription());
            if (argumentTypes.length == 0) {
                this.parameterTypeNames = Collections.emptyList();
            } else {
                String[] parameterNames = new String[argumentTypes.length];
                int i = 0;
                for (Type nextType : argumentTypes) {
                    String nextTypeName = nextType.getClassName();
                    nextTypeName = this.getInfoStore().internClassName(nextTypeName);
                    parameterNames[i++] = nextTypeName;
                }
                this.parameterTypeNames = Arrays.asList(parameterNames);
            }
        }
        List<String> list = this.parameterTypeNames;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            list = list;
            logger.exiting("com.ibm.ws.annocache.info.internal.MethodInfoImpl", "getParameterTypeNames", list);
        }
        return list;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<ClassInfoImpl> getParameterTypes() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.MethodInfoImpl", "getParameterTypes", new Object[0]);
        }
        if (this.parameterClassInfos == null) {
            Type[] argumentTypes = Type.getArgumentTypes((String)this.getDescription());
            if (argumentTypes.length == 0) {
                this.parameterClassInfos = Collections.emptyList();
            } else {
                ClassInfoImpl[] parameterInfos = new ClassInfoImpl[argumentTypes.length];
                int i = 0;
                for (Type nextType : argumentTypes) {
                    parameterInfos[i++] = this.getDelayableClassInfo(nextType);
                }
                this.parameterClassInfos = Arrays.asList(parameterInfos);
            }
        }
        List<ClassInfoImpl> list = this.parameterClassInfos;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            list = list;
            logger.exiting("com.ibm.ws.annocache.info.internal.MethodInfoImpl", "getParameterTypes", list);
        }
        return list;
    }

    @Override
    @Deprecated
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<List<? extends AnnotationInfo>> getParameterAnnotations() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.MethodInfoImpl", "getParameterAnnotations", new Object[0]);
        }
        if (this.parameterAnnotations.isEmpty()) {
            List<List<? extends AnnotationInfo>> list = Collections.emptyList();
            if (logger != null && logger.isLoggable(Level.FINER)) {
                list = list;
                logger.exiting("com.ibm.ws.annocache.info.internal.MethodInfoImpl", "getParameterAnnotations", list);
            }
            return list;
        }
        ArrayList<List<? extends AnnotationInfo>> parmAnnotations = new ArrayList<List<? extends AnnotationInfo>>(this.parameterAnnotations.size());
        for (List<AnnotationInfoImpl> oneParmAnnos : this.parameterAnnotations) {
            parmAnnotations.add(oneParmAnnos);
        }
        ArrayList<List<? extends AnnotationInfo>> arrayList = parmAnnotations;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            arrayList = arrayList;
            logger.exiting("com.ibm.ws.annocache.info.internal.MethodInfoImpl", "getParameterAnnotations", arrayList);
        }
        return arrayList;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<List<AnnotationInfoImpl>> getParmAnnotations() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.MethodInfoImpl", "getParmAnnotations", new Object[0]);
        }
        List<List<AnnotationInfoImpl>> list = this.parameterAnnotations;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            list = list;
            logger.exiting("com.ibm.ws.annocache.info.internal.MethodInfoImpl", "getParmAnnotations", list);
        }
        return list;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setParameterAnnotations(List<AnnotationInfoImpl>[] parmAnnos) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.MethodInfoImpl", "setParameterAnnotations", new Object[]{parmAnnos});
        }
        if (parmAnnos == null || parmAnnos.length == 0) {
            this.parameterAnnotations = Collections.emptyList();
        } else {
            this.parameterAnnotations = new ArrayList<List<AnnotationInfoImpl>>(parmAnnos.length);
            for (List<AnnotationInfoImpl> oneParmAnnos : parmAnnos) {
                oneParmAnnos = oneParmAnnos == null || oneParmAnnos.isEmpty() ? Collections.emptyList() : new ArrayList<AnnotationInfoImpl>(oneParmAnnos);
                this.parameterAnnotations.add(oneParmAnnos);
            }
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.info.internal.MethodInfoImpl", "setParameterAnnotations");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Type getReturnTypeAsType() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.MethodInfoImpl", "getReturnTypeAsType", new Object[0]);
        }
        if (this.returnTypeAsType == null) {
            this.returnTypeAsType = Type.getReturnType((String)this.getDescription());
        }
        Type type = this.returnTypeAsType;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            type = type;
            logger.exiting("com.ibm.ws.annocache.info.internal.MethodInfoImpl", "getReturnTypeAsType", type);
        }
        return type;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getReturnTypeName() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.MethodInfoImpl", "getReturnTypeName", new Object[0]);
        }
        if (this.returnTypeName == null) {
            this.returnTypeName = this.getReturnTypeAsType().getClassName();
        }
        String string = this.returnTypeName;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.ws.annocache.info.internal.MethodInfoImpl", "getReturnTypeName", string);
        }
        return string;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ClassInfoImpl getReturnType() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.MethodInfoImpl", "getReturnType", new Object[0]);
        }
        if (this.returnClassInfo == null) {
            this.returnClassInfo = this.getInfoStore().getDelayableClassInfo(this.getReturnTypeAsType());
        }
        ClassInfoImpl classInfoImpl = this.returnClassInfo;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            classInfoImpl = classInfoImpl;
            logger.exiting("com.ibm.ws.annocache.info.internal.MethodInfoImpl", "getReturnType", classInfoImpl);
        }
        return classInfoImpl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setAnnotationDefaultValue(AnnotationValueImpl annotationDefaultValue) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.MethodInfoImpl", "setAnnotationDefaultValue", new Object[]{annotationDefaultValue});
        }
        String methodName = "setAnnotationDefaultValue";
        AnnotationValueImpl priorDefaultValue = this.annotationDefaultValue;
        this.annotationDefaultValue = annotationDefaultValue;
        if (logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, CLASS_NAME, methodName, "[ {0} ] of [ {1} ] Updated from [ {2} ] to [ {3} ]", new Object[]{this.getHashText(), this.getDeclaringClass().getHashText(), priorDefaultValue, this.annotationDefaultValue});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.info.internal.MethodInfoImpl", "setAnnotationDefaultValue");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public AnnotationValueImpl getAnnotationDefaultValue() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.MethodInfoImpl", "getAnnotationDefaultValue", new Object[0]);
        }
        AnnotationValueImpl annotationValueImpl = this.annotationDefaultValue;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            annotationValueImpl = annotationValueImpl;
            logger.exiting("com.ibm.ws.annocache.info.internal.MethodInfoImpl", "getAnnotationDefaultValue", annotationValueImpl);
        }
        return annotationValueImpl;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getSignature() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.MethodInfoImpl", "getSignature", new Object[0]);
        }
        String string = this.getQualifiedName() + '(' + this.getParametersText() + ')';
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.ws.annocache.info.internal.MethodInfoImpl", "getSignature", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected String getParametersText() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.MethodInfoImpl", "getParametersText", new Object[0]);
        }
        List<ClassInfoImpl> useParmTypes = this.getParameterTypes();
        if (useParmTypes.isEmpty()) {
            String string = "";
            if (logger != null && logger.isLoggable(Level.FINER)) {
                string = string;
                logger.exiting("com.ibm.ws.annocache.info.internal.MethodInfoImpl", "getParametersText", string);
            }
            return string;
        }
        StringBuffer parmsBuf = new StringBuffer();
        boolean isFirst = true;
        for (ClassInfoImpl classInfo : useParmTypes) {
            if (!isFirst) {
                parmsBuf.append(",");
                isFirst = false;
            }
            parmsBuf.append(classInfo.getName());
        }
        String string = parmsBuf.toString();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.ws.annocache.info.internal.MethodInfoImpl", "getParametersText", string);
        }
        return string;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void log(Logger useLogger) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.MethodInfoImpl", "log", new Object[]{useLogger});
        }
        String methodName = "log";
        if (!useLogger.isLoggable(Level.FINER)) {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.exiting("com.ibm.ws.annocache.info.internal.MethodInfoImpl", "log");
            }
            return;
        }
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "Method [ {0} ]", this.getHashText());
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "  Name [ {0} ]", this.getName());
        for (ClassInfoImpl nextParameterType : this.getParameterTypes()) {
            useLogger.logp(Level.FINER, CLASS_NAME, methodName, "  Parameter Type [ {0} ]", nextParameterType.getHashText());
        }
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "  Return Type [ {0} ]", this.getReturnType().getHashText());
        for (ClassInfoImpl nextExceptionType : this.getExceptionTypes()) {
            useLogger.logp(Level.FINER, CLASS_NAME, methodName, "  Exception Type [ {0} ]", nextExceptionType.getHashText());
        }
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "  Declaring Class [ {0} ]", this.getDeclaringClass().getHashText());
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "  Default Value [ {0} ]", this.getAnnotationDefaultValue());
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.info.internal.MethodInfoImpl", "log");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void log(TraceComponent useLogger) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.info.internal.MethodInfoImpl", "log", new Object[]{useLogger});
        }
        if (!useLogger.isDebugEnabled()) {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.exiting("com.ibm.ws.annocache.info.internal.MethodInfoImpl", "log");
            }
            return;
        }
        Tr.debug((TraceComponent)useLogger, (String)MessageFormat.format("Method [ {0} ]", this.getHashText()), (Object[])new Object[0]);
        Tr.debug((TraceComponent)useLogger, (String)MessageFormat.format("  Name [ {0} ]", this.getName()), (Object[])new Object[0]);
        for (ClassInfoImpl nextParameterType : this.getParameterTypes()) {
            Tr.debug((TraceComponent)useLogger, (String)MessageFormat.format("  Parameter Type [ {0} ]", nextParameterType.getHashText()), (Object[])new Object[0]);
        }
        Tr.debug((TraceComponent)useLogger, (String)MessageFormat.format("  Return Type [ {0} ]", this.getReturnType().getHashText()), (Object[])new Object[0]);
        for (ClassInfoImpl nextExceptionType : this.getExceptionTypes()) {
            Tr.debug((TraceComponent)useLogger, (String)MessageFormat.format("  Exception Type [ {0} ]", nextExceptionType.getHashText()), (Object[])new Object[0]);
        }
        Tr.debug((TraceComponent)useLogger, (String)MessageFormat.format("  Declaring Class [ {0} ]", this.getDeclaringClass().getHashText()), (Object[])new Object[0]);
        Tr.debug((TraceComponent)useLogger, (String)MessageFormat.format("  Default Value [ {0} ]", this.getAnnotationDefaultValue()), (Object[])new Object[0]);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.info.internal.MethodInfoImpl", "log");
        }
    }
}

