/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.annocache.classsource.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.annocache.classsource.internal.ClassSourceImpl;
import com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Factory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.anno.classsource.ClassSource;
import com.ibm.wsspi.anno.classsource.ClassSource_Aggregate;
import com.ibm.wsspi.anno.classsource.ClassSource_ScanCounts;
import com.ibm.wsspi.annocache.classsource.ClassSource_Exception;
import com.ibm.wsspi.annocache.classsource.ClassSource_MappedSimple;
import com.ibm.wsspi.annocache.classsource.ClassSource_Streamer;
import com.ibm.wsspi.annocache.util.Util_InternMap;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ClassSourceImpl_MappedSimple
extends ClassSourceImpl
implements ClassSource_MappedSimple {
    public static final String CLASS_NAME;
    protected final ClassSource_MappedSimple.SimpleClassProvider provider;
    static final long serialVersionUID = -2150611332545501092L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public ClassSourceImpl_MappedSimple(ClassSourceImpl_Factory factory, Util_InternMap internMap, String name, ClassSource_MappedSimple.SimpleClassProvider provider) throws ClassSource_Exception {
        this(factory, internMap, NO_ENTRY_PREFIX, name, provider);
    }

    public ClassSourceImpl_MappedSimple(ClassSourceImpl_Factory factory, Util_InternMap internMap, String entryPrefix, String name, ClassSource_MappedSimple.SimpleClassProvider provider) throws ClassSource_Exception {
        super(factory, internMap, entryPrefix, name, provider.getName());
        String methodName = "<init>";
        this.provider = provider;
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ]", this.getHashText());
        }
    }

    @Override
    protected String computeStamp() {
        return "** UNRECORDED **";
    }

    @Override
    public ClassSource_MappedSimple.SimpleClassProvider getProvider() {
        return this.provider;
    }

    @Override
    public void open() throws ClassSource_Exception {
        String methodName = "open";
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] ENTER/RETURN", this.getHashText());
        }
    }

    @Override
    public void close() throws ClassSource_Exception {
        String methodName = "close";
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] ENTER/RETURN", this.getHashText());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public InputStream openResourceStream(String className, String resourceName) throws ClassSource_Exception {
        InputStream result;
        String methodName = "openResourceStream";
        if (!this.getProvider().getResourceNames().contains(resourceName)) {
            return null;
        }
        try {
            result = this.getProvider().openResource(resourceName);
        }
        catch (Throwable throwable) {
            void th;
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_MappedSimple", (String)"182", (Object)this, (Object[])new Object[]{className, resourceName});
            String eMsg = "[ " + this.getHashText() + " ] Failed to open [ " + resourceName + " ] for class [ " + className + " ]";
            throw this.getFactory().wrapIntoClassSourceException(CLASS_NAME, methodName, eMsg, (Throwable)th);
        }
        if (result == null) {
            String eMsg = "[ " + this.getHashText() + " ] Failed to open [ " + resourceName + " ] for class [ " + className + " ]";
            throw this.getFactory().newClassSourceException(eMsg);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void closeResourceStream(String className, String resourceName, InputStream inputStream) {
        String methodName = "closeResourceStream";
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            void e;
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_MappedSimple", (String)"204", (Object)this, (Object[])new Object[]{className, resourceName, inputStream});
            logger.logp(Level.WARNING, CLASS_NAME, methodName, "ANNO_CLASSSOURCE_CLOSE3_EXCEPTION", new Object[]{this.getHashText(), resourceName, className, e});
        }
    }

    @Override
    public void log(Logger useLogger) {
        String methodName = "log";
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "Class Source [ {0} ]", this.getHashText());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int processFromScratch(ClassSource_Streamer streamer) throws ClassSource_Exception {
        String methodName = "processFromScratch";
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] ENTER", this.getHashText());
        }
        int classCount = 0;
        for (String nextResourceName : this.getProvider().getResourceNames()) {
            if (this.isDirectoryResource(nextResourceName) || !this.isClassResource(nextResourceName)) continue;
            String nextClassName = this.getClassNameFromResourceName(nextResourceName);
            if (ClassSourceImpl.isJava9PackageName(nextClassName)) {
                logger.logp(Level.FINER, CLASS_NAME, methodName, "Java9 class name [ {0} ]", nextClassName);
                continue;
            }
            ++classCount;
            String i_nextClassName = this.internClassName(nextClassName);
            try {
                this.scan(streamer, i_nextClassName, nextResourceName);
            }
            catch (ClassSource_Exception classSource_Exception) {
                void e;
                FFDCFilter.processException((Throwable)classSource_Exception, (String)"com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_MappedSimple", (String)"252", (Object)this, (Object[])new Object[]{streamer});
                logger.logp(Level.WARNING, CLASS_NAME, methodName, "ANNO_TARGETS_SCAN_EXCEPTION", (Throwable)e);
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] RETURN [ {1} ]", new Object[]{this.getHashText(), classCount});
        }
        return classCount;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void processSpecific(ClassSource_Streamer streamer, Set<String> i_classNames) throws ClassSource_Exception {
        String methodName = "processSpecific";
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] ENTER [ {1} ]", new Object[]{this.getHashText(), i_classNames.size()});
        }
        long scanStart = System.nanoTime();
        Collection<String> providerResourceNames = this.getProvider().getResourceNames();
        for (String i_className : i_classNames) {
            String resourceName = this.getResourceNameFromClassName(i_className);
            if (!providerResourceNames.contains(resourceName)) continue;
            try {
                this.scan(streamer, i_className, resourceName);
            }
            catch (ClassSource_Exception classSource_Exception) {
                void e;
                FFDCFilter.processException((Throwable)classSource_Exception, (String)"com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_MappedSimple", (String)"289", (Object)this, (Object[])new Object[]{streamer, i_classNames});
                logger.logp(Level.WARNING, CLASS_NAME, methodName, "ANNO_TARGETS_SCAN_EXCEPTION", (Throwable)e);
            }
        }
        long scanTime = System.nanoTime() - scanStart;
        this.setProcessTime(scanTime);
        this.setProcessCount(i_classNames.size());
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] RETURN", this.getHashText());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scan(ClassSource_Streamer streamer, String i_className, String resourceName) throws ClassSource_Exception {
        BufferedInputStream inputStream = this.openClassResourceStream(i_className, resourceName);
        try {
            streamer.process(i_className, inputStream);
        }
        finally {
            this.closeResourceStream(i_className, resourceName, inputStream);
        }
    }

    @Override
    @Trivial
    public void log(TraceComponent tc) {
        Tr.debug((TraceComponent)tc, (String)MessageFormat.format("Class Source [ {0} ]", this.getHashText()), (Object[])new Object[0]);
    }

    @Override
    public void setParentSource(ClassSource classSource) {
    }

    @Override
    public void scanClasses(com.ibm.wsspi.anno.classsource.ClassSource_Streamer streamer, Set<String> i_seedClassNamesSet, ClassSource_Aggregate.ScanPolicy scanPolicy) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ClassSource_ScanCounts getScanResults() {
        return null;
    }

    @Override
    public int getResult(ClassSource_ScanCounts.ResultField resultField) {
        return 0;
    }

    @Override
    public boolean scanSpecificSeedClass(String specificClassName, com.ibm.wsspi.anno.classsource.ClassSource_Streamer streamer) throws com.ibm.wsspi.anno.classsource.ClassSource_Exception {
        return false;
    }

    @Override
    public boolean scanReferencedClass(String referencedClassNam, com.ibm.wsspi.anno.classsource.ClassSource_Streamer streamer) throws com.ibm.wsspi.anno.classsource.ClassSource_Exception {
        return false;
    }

    @Override
    public String inconvertResourceName(String externalResourceName) {
        return null;
    }

    @Override
    public String outconvertResourceName(String internalResourceName) {
        return null;
    }

    @Override
    public InputStream openClassStream(String className) throws com.ibm.wsspi.anno.classsource.ClassSource_Exception {
        return null;
    }

    @Override
    public void closeClassStream(String className, InputStream inputStream) throws com.ibm.wsspi.anno.classsource.ClassSource_Exception {
    }

    @Override
    public int getResourceExclusionCount() {
        return 0;
    }

    @Override
    public int getClassExclusionCount() {
        return 0;
    }

    @Override
    public int getClassInclusionCount() {
        return 0;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_MappedSimple", ClassSourceImpl_MappedSimple.class, (String)"com.ibm.ws.annocache", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
        CLASS_NAME = ClassSourceImpl_MappedSimple.class.getSimpleName();
    }
}

