/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.anno.classsource.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.anno.classsource.internal.ClassSourceImpl;
import com.ibm.ws.anno.classsource.internal.ClassSourceImpl_Factory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.anno.classsource.ClassSource;
import com.ibm.wsspi.anno.classsource.ClassSource_Aggregate;
import com.ibm.wsspi.anno.classsource.ClassSource_Exception;
import com.ibm.wsspi.anno.classsource.ClassSource_Options;
import com.ibm.wsspi.anno.classsource.ClassSource_ScanCounts;
import com.ibm.wsspi.anno.classsource.ClassSource_Streamer;
import com.ibm.wsspi.anno.util.Util_InternMap;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ClassSourceImpl_Aggregate
extends ClassSourceImpl
implements ClassSource_Aggregate {
    public static final String CLASS_NAME = ClassSourceImpl_Aggregate.class.getName();
    private static final TraceComponent tc = Tr.register(ClassSourceImpl_Aggregate.class, (String)"com.ibm.ws.anno", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
    protected int openCount = 0;
    protected List<ClassSource> successfulOpens;
    protected Set<ClassSource> failedOpens;
    protected final List<ClassSource> classSources;
    protected final Map<String, String> classSourceNames;
    protected final Set<ClassSource> seedClassSources = new HashSet<ClassSource>();
    protected final Set<ClassSource> partialClassSources = new HashSet<ClassSource>();
    protected final Set<ClassSource> excludedClassSources = new HashSet<ClassSource>();
    protected final Set<ClassSource> externalClassSources = new HashSet<ClassSource>();
    protected long totalLookups = 0L;
    protected long repeatLookups = 0L;
    protected Map<String, Integer> i_lookupCounts;
    protected final Map<String, Boolean> i_globalResults;
    protected final Map<ClassSource, Set<String>> i_failedLookups;
    public Map<String, ClassSource> i_firstSuccesses;
    static final long serialVersionUID = 8833672715963184110L;

    public ClassSourceImpl_Aggregate(ClassSourceImpl_Factory factory, Util_InternMap internMap, String name, ClassSource_Options options) {
        super(factory, internMap, name, options, null);
        this.classSources = new ArrayList<ClassSource>();
        this.classSourceNames = new HashMap<String, String>();
        this.successfulOpens = new ArrayList<ClassSource>();
        this.failedOpens = new HashSet<ClassSource>();
        this.i_lookupCounts = new IdentityHashMap<String, Integer>();
        this.i_globalResults = new IdentityHashMap<String, Boolean>();
        this.i_failedLookups = new IdentityHashMap<ClassSource, Set<String>>();
        this.i_firstSuccesses = new IdentityHashMap<String, ClassSource>();
    }

    @Trivial
    public int getOpenCount() {
        return this.openCount;
    }

    @Trivial
    public boolean getIsOpen() {
        return this.openCount > 0;
    }

    protected List<ClassSource> retrieveSuccessfulOpens() {
        List<ClassSource> oldSuccessfulOpens = this.successfulOpens;
        this.successfulOpens = new ArrayList<ClassSource>();
        return oldSuccessfulOpens;
    }

    @Trivial
    protected List<ClassSource> getSuccessfulOpens() {
        return this.successfulOpens;
    }

    protected void addSuccessfulOpen(ClassSource classSource) {
        this.successfulOpens.add(classSource);
    }

    @Trivial
    protected Set<ClassSource> getFailedOpens() {
        return this.failedOpens;
    }

    protected void addFailedOpen(ClassSource classSource) {
        this.failedOpens.add(classSource);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Trivial
    @ManualTrace
    public void open() throws ClassSource_Exception {
        Object msg;
        String methodName = "open";
        if (tc.isEntryEnabled()) {
            msg = MessageFormat.format("[ {0} ] Open count [ {1} ]", this.getHashText(), this.openCount);
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[]{msg});
        }
        ++this.openCount;
        if (this.openCount == 1) {
            for (ClassSource nextClassSource : this.retrieveSuccessfulOpens()) {
                try {
                    nextClassSource.open();
                    this.addSuccessfulOpen(nextClassSource);
                }
                catch (ClassSource_Exception classSource_Exception) {
                    void e;
                    FFDCFilter.processException((Throwable)classSource_Exception, (String)"com.ibm.ws.anno.classsource.internal.ClassSourceImpl_Aggregate", (String)"178", (Object)this, (Object[])new Object[0]);
                    this.addFailedOpen(nextClassSource);
                    Tr.warning((TraceComponent)tc, (String)"ANNO_INFOSTORE_OPEN1_EXCEPTION", (Object[])new Object[]{this.getHashText(), nextClassSource.getHashText(), e.getMessage()});
                }
            }
        }
        if (tc.isEntryEnabled()) {
            msg = MessageFormat.format("[ {0} ] Open count [ {1} ]", this.getHashText(), this.openCount);
            Tr.exit((TraceComponent)tc, (String)methodName, (Object)msg);
        }
    }

    @Override
    @Trivial
    @ManualTrace
    public void close() throws ClassSource_Exception {
        String methodName = "close";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[]{this.getHashText()});
        }
        if (this.openCount == 0) {
            if (tc.isEntryEnabled()) {
                String msg = MessageFormat.format("[ {0} ] ENTER/RETURN [ {1} ]", this.getHashText(), this.openCount);
                Tr.exit((TraceComponent)tc, (String)methodName, (Object)msg);
            }
            return;
        }
        --this.openCount;
        if (this.openCount == 0) {
            for (ClassSource nextClassSource : this.getSuccessfulOpens()) {
                String nextClassSourceName = nextClassSource.getCanonicalName();
                try {
                    nextClassSource.close();
                }
                catch (ClassSource_Exception classSource_Exception) {
                    FFDCFilter.processException((Throwable)classSource_Exception, (String)"com.ibm.ws.anno.classsource.internal.ClassSourceImpl_Aggregate", (String)"229", (Object)this, (Object[])new Object[0]);
                    Tr.warning((TraceComponent)tc, (String)"ANNO_CLASSSOURCE_CLOSE1_EXCEPTION", (Object[])new Object[]{this.getHashText(), nextClassSourceName, nextClassSource.getHashText()});
                }
            }
        }
        if (tc.isEntryEnabled()) {
            String msg = MessageFormat.format("[{0}] Open Count [{1}]", this.getHashText(), this.openCount);
            Tr.exit((TraceComponent)tc, (String)methodName, (Object)msg);
        }
    }

    @Override
    public void addClassSource(ClassSource classSource) {
        this.addClassSource(classSource, ClassSource_Aggregate.ScanPolicy.SEED);
    }

    @Override
    @Trivial
    public void addClassSource(ClassSource classSource, ClassSource_Aggregate.ScanPolicy scanPolicy) {
        if (tc.isDebugEnabled()) {
            String msg = MessageFormat.format("[ {0} ] Adding [ {1} ] [ {2} ]", new Object[]{this.getHashText(), classSource.getHashText(), scanPolicy});
            Tr.debug((TraceComponent)tc, (String)msg, (Object[])new Object[0]);
        }
        this.basicAddClassSource(classSource, scanPolicy);
        this.addSuccessfulOpen(classSource);
    }

    @Trivial
    public Set<ClassSource> getClassSources(ClassSource_Aggregate.ScanPolicy scanPolicy) {
        if (scanPolicy == ClassSource_Aggregate.ScanPolicy.SEED) {
            return this.seedClassSources;
        }
        if (scanPolicy == ClassSource_Aggregate.ScanPolicy.PARTIAL) {
            return this.partialClassSources;
        }
        if (scanPolicy == ClassSource_Aggregate.ScanPolicy.EXCLUDED) {
            return this.excludedClassSources;
        }
        return this.externalClassSources;
    }

    @Trivial
    public Set<ClassSource> getSeedClassSources() {
        return this.seedClassSources;
    }

    @Trivial
    public Set<ClassSource> getPartialClassSources() {
        return this.partialClassSources;
    }

    @Trivial
    public Set<ClassSource> getExcludedClassSources() {
        return this.excludedClassSources;
    }

    @Trivial
    public Set<ClassSource> getExternalClassSources() {
        return this.externalClassSources;
    }

    @Trivial
    public List<ClassSource> getClassSources() {
        return this.classSources;
    }

    protected void basicAddClassSource(ClassSource classSource, ClassSource_Aggregate.ScanPolicy scanPolicy) {
        this.classSources.add(classSource);
        this.classSourceNames.put(classSource.getName(), classSource.getCanonicalName());
        if (scanPolicy == ClassSource_Aggregate.ScanPolicy.SEED) {
            this.seedClassSources.add(classSource);
        } else if (scanPolicy == ClassSource_Aggregate.ScanPolicy.PARTIAL) {
            this.partialClassSources.add(classSource);
        } else if (scanPolicy == ClassSource_Aggregate.ScanPolicy.EXCLUDED) {
            this.excludedClassSources.add(classSource);
        } else {
            this.externalClassSources.add(classSource);
        }
    }

    @Override
    public ClassSource_Aggregate.ScanPolicy getScanPolicy(ClassSource classSource) {
        if (this.seedClassSources.contains(classSource)) {
            return ClassSource_Aggregate.ScanPolicy.SEED;
        }
        if (this.partialClassSources.contains(classSource)) {
            return ClassSource_Aggregate.ScanPolicy.PARTIAL;
        }
        if (this.excludedClassSources.contains(classSource)) {
            return ClassSource_Aggregate.ScanPolicy.EXCLUDED;
        }
        return ClassSource_Aggregate.ScanPolicy.EXTERNAL;
    }

    @Override
    public String getCanonicalName(String classSourceName) {
        return this.classSourceNames.get(classSourceName);
    }

    @Override
    public Map<String, String> getCanonicalNames() {
        return this.classSourceNames;
    }

    @Override
    @Trivial
    public void scanClasses(ClassSource_Streamer streamer) {
        if (tc.isDebugEnabled()) {
            String msg = MessageFormat.format("ENTER [ {0} ] [ {1} ]", this.getHashText(), streamer);
            Tr.debug((TraceComponent)tc, (String)msg, (Object[])new Object[0]);
        }
        HashSet<String> i_seedClassNames = new HashSet<String>();
        int initialSize = 0;
        int finalSize = 0;
        int numClasses = 0;
        int numClassesProcessedUsingJandex = 0;
        int numArchivesProcessedUsingJandex = 0;
        for (ClassSource childSource : this.getSuccessfulOpens()) {
            String childName = childSource.getCanonicalName();
            ClassSource_Aggregate.ScanPolicy scanPolicy = this.getScanPolicy(childSource);
            if (scanPolicy == ClassSource_Aggregate.ScanPolicy.EXTERNAL) continue;
            childSource.scanClasses(streamer, i_seedClassNames, scanPolicy);
            ClassSource_ScanCounts childScanCounts = childSource.getScanResults();
            this.addResults(childScanCounts);
            int numChildClasses = childScanCounts.getResult(ClassSource_ScanCounts.ResultField.PROCESSED_CLASS);
            numClasses += numChildClasses;
            if (childSource.isProcessedUsingJandex()) {
                ++numArchivesProcessedUsingJandex;
                numClassesProcessedUsingJandex += numChildClasses;
            }
            int nextSize = i_seedClassNames.size();
            if (tc.isDebugEnabled()) {
                String msg = MessageFormat.format("[ {0} ] [ {1} ] [ {2} ] Added [ {3} ]", this.getHashText(), childName, childSource.getHashText(), nextSize - finalSize);
                Tr.debug((TraceComponent)tc, (String)msg, (Object[])new Object[0]);
            }
            finalSize = nextSize;
        }
        if (this.options.getUseJandex()) {
            Tr.info((TraceComponent)tc, (String)"ANNO_JANDEX_USAGE", (Object[])new Object[]{numArchivesProcessedUsingJandex, this.getSuccessfulOpens().size(), numClassesProcessedUsingJandex, numClasses, this.getName()});
        }
        if (tc.isDebugEnabled()) {
            Object[] logParms = new Object[]{this.getHashText(), null, null};
            logParms[1] = finalSize - initialSize;
            Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] RETURN [ {1} ] Added classes", logParms), (Object[])new Object[0]);
            for (ClassSource_ScanCounts.ResultField resultField : ClassSource_ScanCounts.ResultField.values()) {
                int nextResult = this.getResult(resultField);
                String nextResultTag = resultField.getTag();
                logParms[1] = nextResult;
                logParms[2] = nextResultTag;
                Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ]  [ {1} ] {0}", logParms), (Object[])new Object[0]);
            }
        }
    }

    @Override
    public void scanClasses(ClassSource_Streamer streamer, Set<String> i_seedClassNamesSet, ClassSource_Aggregate.ScanPolicy scanPolicy) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void processFromScratch(ClassSource_Streamer streamer, Set<String> i_seedClassNames, ClassSource_Aggregate.ScanPolicy scanPolicy) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Trivial
    public long getTotalLookups() {
        return this.totalLookups;
    }

    protected void recordLookup() {
        ++this.totalLookups;
    }

    @Override
    @Trivial
    public long getRepeatLookups() {
        return this.repeatLookups;
    }

    protected void recordRepeatLookup() {
        ++this.repeatLookups;
    }

    @Override
    @Trivial
    public Map<String, Integer> getLookupCounts() {
        return this.i_lookupCounts;
    }

    protected Integer i_recordLookup(String i_className) {
        Integer lookupCount = this.i_lookupCounts.get(i_className);
        if (lookupCount == null) {
            lookupCount = 1;
        } else {
            lookupCount = lookupCount + 1;
            this.recordRepeatLookup();
        }
        this.recordLookup();
        this.i_lookupCounts.put(i_className, lookupCount);
        return lookupCount;
    }

    @Trivial
    public Map<String, Boolean> getGlobalResults() {
        return this.i_globalResults;
    }

    @Override
    @Trivial
    public Boolean getGlobalResult(String className) {
        return this.i_getGlobalResult(this.internClassName(className));
    }

    protected Boolean i_getGlobalResult(String i_className) {
        return this.i_globalResults.get(i_className);
    }

    protected void i_setGlobalResult(String i_className, boolean value) {
        this.i_globalResults.put(i_className, value);
    }

    @Trivial
    public Map<ClassSource, Set<String>> getFailedLookups() {
        return this.i_failedLookups;
    }

    @Override
    @Trivial
    public Set<String> getFailedLookups(ClassSource classSource) {
        return this.i_failedLookups.get(classSource);
    }

    @Trivial
    protected Set<String> getFailedLookupsForcing(ClassSource classSource) {
        Set<String> specificFailedLookups = this.i_failedLookups.get(classSource);
        if (specificFailedLookups == null) {
            specificFailedLookups = new HashSet<String>();
            this.i_failedLookups.put(classSource, specificFailedLookups);
        }
        return specificFailedLookups;
    }

    protected boolean i_alreadyFailed(ClassSource classSource, String i_className) {
        Set<String> specificFailedLookups = this.getFailedLookups(classSource);
        return specificFailedLookups != null && specificFailedLookups.contains(i_className);
    }

    protected void i_markFailed(ClassSource classSource, String i_className) {
        this.getFailedLookupsForcing(classSource).add(i_className);
    }

    @Trivial
    public Map<String, ClassSource> getFirstSuccesses() {
        return this.i_firstSuccesses;
    }

    @Override
    @Trivial
    public ClassSource getFirstSuccess(String className) {
        return this.i_getFirstSuccess(this.internClassName(className));
    }

    protected ClassSource i_getFirstSuccess(String i_className) {
        return this.i_firstSuccesses.get(i_className);
    }

    protected void i_setFirstSuccess(String i_className, ClassSource ClassSource2) {
        this.i_firstSuccesses.put(i_className, ClassSource2);
    }

    protected void i_recordLookup(String i_className, ClassSource classSource) {
        this.i_setFirstSuccess(i_className, classSource);
        this.i_setGlobalResult(i_className, true);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public InputStream openResourceStream(String className, String resourceName) throws ClassSource_Exception {
        Object msg3;
        Object[] objectArray;
        if (tc.isDebugEnabled()) {
            Object[] objectArray2 = new Object[4];
            objectArray2[0] = this.getHashText();
            objectArray2[1] = className;
            objectArray2[2] = resourceName;
            objectArray = objectArray2;
            objectArray2[3] = null;
        } else {
            objectArray = null;
        }
        Object[] logParams = objectArray;
        String i_className = this.internClassName(className);
        this.i_recordLookup(i_className);
        Boolean globalSuccess = this.i_getGlobalResult(i_className);
        if (globalSuccess != null) {
            if (!globalSuccess.booleanValue()) {
                if (logParams != null && tc.isDebugEnabled()) {
                    String msg2 = MessageFormat.format("[ {0} ] Resource [ {1} ] Class [ {2} ]: ENTRY / RETURN [ null ] - prior failure", logParams);
                    Tr.debug((TraceComponent)tc, (String)msg2, (Object[])new Object[0]);
                }
                return null;
            }
            ClassSource firstSuccess = this.i_getFirstSuccess(i_className);
            if (logParams != null) {
                logParams[3] = firstSuccess;
                if (tc.isDebugEnabled()) {
                    String msg3 = MessageFormat.format("[ {0} ] Resource [ {1} ] Class [ {2} ] Found in [ {3} ]: RETURN [ non-null ] - prior lookup", logParams);
                    Tr.debug((TraceComponent)tc, (String)msg3, (Object[])new Object[0]);
                }
            }
            return firstSuccess.openResourceStream(className, resourceName);
        }
        if (logParams != null && tc.isDebugEnabled()) {
            String msg4 = MessageFormat.format("[ {0} ] Resource [ {1} ] Class [ {2} ] ENTRY - no prior lookup", logParams);
            Tr.debug((TraceComponent)tc, (String)msg4, (Object[])new Object[0]);
        }
        InputStream inputStream = null;
        for (ClassSource nextClassSource : this.getSuccessfulOpens()) {
            String msg5;
            if (logParams != null) {
                logParams[3] = nextClassSource.hashCode();
            }
            if (this.i_alreadyFailed(nextClassSource, i_className)) {
                if (logParams == null) continue;
                msg5 = MessageFormat.format("[ {0} ] Resource [ {1} ] Class [ {2} ] Skipping [ {3} ] - prior failure", logParams);
                Tr.debug((TraceComponent)tc, (String)msg5, (Object[])new Object[0]);
                continue;
            }
            try {
                inputStream = nextClassSource.openClassStream(className);
                if (inputStream == null) {
                    if (logParams != null && tc.isDebugEnabled()) {
                        msg5 = MessageFormat.format("[ {0} ] Resource [ {1} ] Class [ {2} ] Not found in [ {3} ]", logParams);
                        Tr.debug((TraceComponent)tc, (String)msg5, (Object[])new Object[0]);
                    }
                    this.i_markFailed(nextClassSource, i_className);
                    continue;
                }
                this.i_setGlobalResult(i_className, true);
                this.i_setFirstSuccess(i_className, nextClassSource);
                break;
            }
            catch (ClassSource_Exception msg6) {
                void e;
                FFDCFilter.processException((Throwable)msg6, (String)"com.ibm.ws.anno.classsource.internal.ClassSourceImpl_Aggregate", (String)"762", (Object)this, (Object[])new Object[]{className, resourceName});
                this.i_setGlobalResult(i_className, true);
                this.i_setFirstSuccess(i_className, nextClassSource);
                throw e;
            }
        }
        if (inputStream == null) {
            this.i_setGlobalResult(i_className, false);
            if (logParams != null && tc.isDebugEnabled()) {
                msg3 = MessageFormat.format("[ {0} ] Resource [ {1} ] Class [ {2} ]: ENTRY / RETURN [ null ] - first failure", logParams);
                Tr.debug((TraceComponent)tc, (String)msg3, (Object[])new Object[0]);
            }
            return null;
        }
        if (logParams != null && tc.isDebugEnabled()) {
            msg3 = MessageFormat.format("[ {0} ] Resource [ {1} ] Class [ {2} ] Found in [ {3} ]: RETURN [ non-null ] - first lookup", logParams);
            Tr.debug((TraceComponent)tc, (String)msg3, (Object[])new Object[0]);
        }
        return inputStream;
    }

    @Override
    public void closeResourceStream(String className, String resourceName, InputStream inputStream) {
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.anno.classsource.internal.ClassSourceImpl_Aggregate", (String)"802", (Object)this, (Object[])new Object[]{className, resourceName, inputStream});
            Tr.warning((TraceComponent)tc, (String)"ANNO_CLASSSOURCE_CLOSE2_EXCEPTION", (Object[])new Object[]{this.getHashText(), resourceName, className});
        }
    }

    @Override
    public int getResourceExclusionCount() {
        int exclusionCount = 0;
        for (ClassSource classSource : this.getClassSources()) {
            exclusionCount += classSource.getResourceExclusionCount();
        }
        return exclusionCount;
    }

    @Override
    public int getClassExclusionCount() {
        int exclusionCount = 0;
        for (ClassSource classSource : this.getClassSources()) {
            exclusionCount += classSource.getClassExclusionCount();
        }
        return exclusionCount;
    }

    @Override
    public int getClassInclusionCount() {
        int inclusionCount = 0;
        for (ClassSource classSource : this.getClassSources()) {
            inclusionCount += classSource.getClassInclusionCount();
        }
        return inclusionCount;
    }

    @Override
    @Trivial
    public void log(TraceComponent logger) {
        if (!logger.isDebugEnabled()) {
            return;
        }
        Tr.debug((TraceComponent)logger, (String)MessageFormat.format("BEGIN STATE [ {0} ]", this.getHashText()), (Object[])new Object[0]);
        Tr.debug((TraceComponent)logger, (String)"Class sources: BEGIN", (Object[])new Object[0]);
        for (ClassSource nextClassSource : this.getClassSources()) {
            Tr.debug((TraceComponent)logger, (String)MessageFormat.format("  [ {0} ]", nextClassSource), (Object[])new Object[0]);
        }
        Tr.debug((TraceComponent)logger, (String)"Class sources: END", (Object[])new Object[0]);
        this.logCounts(logger);
        Tr.debug((TraceComponent)logger, (String)"Overall results: BEGIN", (Object[])new Object[0]);
        this.log_lookupCounts(logger);
        this.log_globalResults(logger);
        this.log_failedLookups(logger);
        this.log_firstSuccesses(logger);
        Tr.debug((TraceComponent)logger, (String)"Overall results: END", (Object[])new Object[0]);
        Tr.debug((TraceComponent)logger, (String)MessageFormat.format("END STATE [ {0} ]", this.getHashText()), (Object[])new Object[0]);
    }

    @Trivial
    protected void log_lookupCounts(TraceComponent logger) {
        if (!logger.isDebugEnabled()) {
            return;
        }
        Tr.debug((TraceComponent)logger, (String)"Lookup Counts: BEGIN", (Object[])new Object[0]);
        Tr.debug((TraceComponent)logger, (String)MessageFormat.format("Total unique [ {0} ]", this.getLookupCounts().size()), (Object[])new Object[0]);
        Object[] params = new Object[]{null, null};
        for (Map.Entry<String, Integer> nextEntry : this.getLookupCounts().entrySet()) {
            params[0] = nextEntry.getKey();
            params[1] = nextEntry.getValue();
            Tr.debug((TraceComponent)logger, (String)MessageFormat.format("  [ {0} ] [ {1} ]", params), (Object[])new Object[0]);
        }
        Tr.debug((TraceComponent)logger, (String)"Lookup Counts: END", (Object[])new Object[0]);
    }

    @Trivial
    protected void log_globalResults(TraceComponent logger) {
        if (!logger.isDebugEnabled()) {
            return;
        }
        Tr.debug((TraceComponent)logger, (String)"Global Results: BEGIN", (Object[])new Object[0]);
        Tr.debug((TraceComponent)logger, (String)MessageFormat.format("Total unique [ {0} ]", this.getGlobalResults().size()), (Object[])new Object[0]);
        Object[] params = new Object[]{null, null};
        for (Map.Entry<String, Boolean> nextEntry : this.getGlobalResults().entrySet()) {
            params[0] = nextEntry.getKey();
            params[1] = nextEntry.getValue();
            Tr.debug((TraceComponent)logger, (String)MessageFormat.format("  [ {0} ] [ {1} ]", params), (Object[])new Object[0]);
        }
        Tr.debug((TraceComponent)logger, (String)"Global Results: END", (Object[])new Object[0]);
    }

    @Trivial
    protected void log_firstSuccesses(TraceComponent logger) {
        if (!logger.isDebugEnabled()) {
            return;
        }
        Tr.debug((TraceComponent)logger, (String)"First Successes: BEGIN", (Object[])new Object[0]);
        Object[] params = new Object[]{null, null};
        for (Map.Entry<String, ClassSource> nextEntry : this.getFirstSuccesses().entrySet()) {
            params[0] = nextEntry.getKey();
            params[1] = nextEntry.getValue().getHashText();
            Tr.debug((TraceComponent)logger, (String)MessageFormat.format("  [ {0} ] [ {1} ]", params), (Object[])new Object[0]);
        }
        Tr.debug((TraceComponent)logger, (String)"First Successes: END", (Object[])new Object[0]);
    }

    @Trivial
    protected void log_failedLookups(TraceComponent logger) {
        if (!logger.isDebugEnabled()) {
            return;
        }
        Tr.debug((TraceComponent)logger, (String)"Failed Lookups: BEGIN", (Object[])new Object[0]);
        for (Map.Entry<ClassSource, Set<String>> nextFailedLookups : this.getFailedLookups().entrySet()) {
            ClassSource nextClassSource = nextFailedLookups.getKey();
            Set<String> nextFailedClasses = nextFailedLookups.getValue();
            Tr.debug((TraceComponent)logger, (String)MessageFormat.format("  [ {0} ]", nextClassSource.getHashText()), (Object[])new Object[0]);
            for (String nextFailedClass : nextFailedClasses) {
                Tr.debug((TraceComponent)logger, (String)MessageFormat.format("    [ {0} ]", nextFailedClass), (Object[])new Object[0]);
            }
        }
        Tr.debug((TraceComponent)logger, (String)"Failed Lookups: END", (Object[])new Object[0]);
    }
}

