/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.security.common.config;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.security.common.http.SupportedHttpMethodHandler;
import java.util.HashSet;
import java.util.Set;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class SpecificEndpointSettings {
    private static final TraceComponent tc = Tr.register(SpecificEndpointSettings.class, null, null);
    protected String endpointName = null;
    protected Set<SupportedHttpMethodHandler.HttpMethod> supportedHttpMethods = new HashSet<SupportedHttpMethodHandler.HttpMethod>();
    static final long serialVersionUID = -756009693332125589L;

    public SpecificEndpointSettings(String endpointName) {
        this.endpointName = endpointName;
    }

    public String getEndpointName() {
        return this.endpointName;
    }

    public void setSupportedHttpMethods(String ... supportedHttpMethods) {
        this.supportedHttpMethods = new HashSet<SupportedHttpMethodHandler.HttpMethod>();
        if (supportedHttpMethods != null) {
            for (String method : supportedHttpMethods) {
                if (method == null) continue;
                if (this.isSpecialHttpMethodCase(method)) {
                    this.addSupportedMethodsForSpecialCase(method);
                    break;
                }
                this.addStandardHttpMethod(method);
            }
        }
    }

    boolean isSpecialHttpMethodCase(String method) {
        return "all".equalsIgnoreCase(method) || "none".equalsIgnoreCase(method);
    }

    void addSupportedMethodsForSpecialCase(String method) {
        if ("all".equalsIgnoreCase(method)) {
            for (SupportedHttpMethodHandler.HttpMethod httpMethod : SupportedHttpMethodHandler.HttpMethod.values()) {
                this.supportedHttpMethods.add(httpMethod);
            }
        } else if ("none".equalsIgnoreCase(method)) {
            this.supportedHttpMethods = new HashSet<SupportedHttpMethodHandler.HttpMethod>();
        }
    }

    @FFDCIgnore(value={IllegalArgumentException.class})
    void addStandardHttpMethod(String method) {
        block2: {
            try {
                SupportedHttpMethodHandler.HttpMethod convertedMethod = SupportedHttpMethodHandler.HttpMethod.valueOf(method.toUpperCase());
                this.supportedHttpMethods.add(convertedMethod);
            }
            catch (IllegalArgumentException e) {
                if (!tc.isDebugEnabled()) break block2;
                Tr.debug((TraceComponent)tc, (String)("Caught exception trying to add supported HTTP method: " + e), (Object[])new Object[0]);
            }
        }
    }

    public Set<SupportedHttpMethodHandler.HttpMethod> getSupportedHttpMethods() {
        return this.supportedHttpMethods;
    }

    public String toString() {
        return "[Endpoint: " + this.endpointName + ", Supported HTTP methods: " + this.supportedHttpMethods + "]";
    }
}

