/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jpa.container.v21.cdi.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import javax.enterprise.inject.spi.BeanManager;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class IBMHibernateExtendedBeanManager {
    private ClassLoader applicationClassLoader;
    private String earAppId;
    private BeanManager beanManager;
    private Queue<Object> hibernateLifecycleListeners = new LinkedList<Object>();
    static final long serialVersionUID = -4183524222552352024L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public IBMHibernateExtendedBeanManager(ClassLoader applicationClassLoader, String earAppId) {
        this.applicationClassLoader = applicationClassLoader;
        this.earAppId = earAppId;
    }

    @FFDCIgnore(value={ClassNotFoundException.class})
    public void registerLifecycleListener(Object lifecycleListener) {
        Class<?> lifeCycleListenerClass = null;
        try {
            lifeCycleListenerClass = Class.forName("org.hibernate.resource.beans.container.spi.ExtendedBeanManager$LifecycleListener", true, this.applicationClassLoader);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Failed to find org.hibernate.resource.beans.container.spi.ExtendedBeanManager$LifecycleListener", e);
        }
        if (!lifeCycleListenerClass.isAssignableFrom(lifecycleListener.getClass())) {
            String errorMsg = "Object " + lifecycleListener + " of class " + lifecycleListener.getClass().getCanonicalName() + " is not instance of org.hibernate.resource.beans.container.spi.ExtendedBeanManager.LifecycleListener";
            throw new IllegalArgumentException(errorMsg);
        }
        this.hibernateLifecycleListeners.add(lifecycleListener);
    }

    public void notifyHibernateAfterBeanDiscovery(String baseClassLoaderId, final BeanManager beanManager) throws SecurityException, IllegalArgumentException {
        if (this.earAppId.equals(baseClassLoaderId)) {
            this.beanManager = beanManager;
            for (final Object e : this.hibernateLifecycleListeners) {
                try {
                    AccessController.doPrivileged(new PrivilegedAction<Void>(){
                        static final long serialVersionUID = -5304244288488182542L;
                        private static final /* synthetic */ TraceComponent $$$tc$$$;

                        @Override
                        public Void run() {
                            try {
                                Method beanManagerInitialized = e.getClass().getMethod("beanManagerInitialized", BeanManager.class);
                                beanManagerInitialized.setAccessible(true);
                                beanManagerInitialized.invoke(e, beanManager);
                            }
                            catch (NoSuchMethodException noSuchMethodException) {
                                FFDCFilter.processException((Throwable)noSuchMethodException, (String)"com.ibm.ws.jpa.container.v21.cdi.internal.IBMHibernateExtendedBeanManager$1", (String)"83", (Object)this, (Object[])new Object[0]);
                            }
                            catch (IllegalAccessException illegalAccessException) {
                                FFDCFilter.processException((Throwable)illegalAccessException, (String)"com.ibm.ws.jpa.container.v21.cdi.internal.IBMHibernateExtendedBeanManager$1", (String)"84", (Object)this, (Object[])new Object[0]);
                            }
                            catch (InvocationTargetException invocationTargetException) {
                                FFDCFilter.processException((Throwable)invocationTargetException, (String)"com.ibm.ws.jpa.container.v21.cdi.internal.IBMHibernateExtendedBeanManager$1", (String)"85", (Object)this, (Object[])new Object[0]);
                            }
                            return null;
                        }

                        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                        static {
                            $$$tc$$$ = Tr.register(1.class, (String[])new String[]{"JCDI", "JPA"}, null, (String)"com.ibm.ws.jpa.container.v21.cdi.internal.IBMHibernateExtendedBeanManager$1");
                        }
                    });
                }
                catch (SecurityException securityException) {
                    FFDCFilter.processException((Throwable)securityException, (String)"com.ibm.ws.jpa.container.v21.cdi.internal.IBMHibernateExtendedBeanManager", (String)"90", (Object)this, (Object[])new Object[]{baseClassLoaderId, beanManager});
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean notifyHibernateBeforeShutdown(final BeanManager beanManager) throws SecurityException, IllegalArgumentException {
        boolean rightBeanManager = false;
        if (this.beanManager.equals(beanManager)) {
            rightBeanManager = true;
            Iterator it = this.hibernateLifecycleListeners.iterator();
            while (it.hasNext()) {
                final Object o = it.next();
                try {
                    AccessController.doPrivileged(new PrivilegedAction<Void>(){
                        static final long serialVersionUID = -619062785205529548L;
                        private static final /* synthetic */ TraceComponent $$$tc$$$;

                        @Override
                        public Void run() {
                            try {
                                Method beforeBeanManagerDestroyed = o.getClass().getMethod("beforeBeanManagerDestroyed", BeanManager.class);
                                beforeBeanManagerDestroyed.setAccessible(true);
                                beforeBeanManagerDestroyed.invoke(o, beanManager);
                            }
                            catch (NoSuchMethodException noSuchMethodException) {
                                FFDCFilter.processException((Throwable)noSuchMethodException, (String)"com.ibm.ws.jpa.container.v21.cdi.internal.IBMHibernateExtendedBeanManager$2", (String)"111", (Object)this, (Object[])new Object[0]);
                            }
                            catch (IllegalAccessException illegalAccessException) {
                                FFDCFilter.processException((Throwable)illegalAccessException, (String)"com.ibm.ws.jpa.container.v21.cdi.internal.IBMHibernateExtendedBeanManager$2", (String)"112", (Object)this, (Object[])new Object[0]);
                            }
                            catch (InvocationTargetException invocationTargetException) {
                                FFDCFilter.processException((Throwable)invocationTargetException, (String)"com.ibm.ws.jpa.container.v21.cdi.internal.IBMHibernateExtendedBeanManager$2", (String)"113", (Object)this, (Object[])new Object[0]);
                            }
                            return null;
                        }

                        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                        static {
                            $$$tc$$$ = Tr.register(2.class, (String[])new String[]{"JCDI", "JPA"}, null, (String)"com.ibm.ws.jpa.container.v21.cdi.internal.IBMHibernateExtendedBeanManager$2");
                        }
                    });
                }
                catch (SecurityException securityException) {
                    FFDCFilter.processException((Throwable)securityException, (String)"com.ibm.ws.jpa.container.v21.cdi.internal.IBMHibernateExtendedBeanManager", (String)"118", (Object)this, (Object[])new Object[]{beanManager});
                }
                finally {
                    it.remove();
                }
            }
        }
        return rightBeanManager;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(IBMHibernateExtendedBeanManager.class, (String[])new String[]{"JCDI", "JPA"}, null, (String)"com.ibm.ws.jpa.container.v21.cdi.internal.IBMHibernateExtendedBeanManager");
    }
}

