/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jndi.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(configurationPolicy=ConfigurationPolicy.REQUIRE, property={"service.vendor=IBM"}, immediate=true)
public class JNDIURLEntry
implements ObjectFactory {
    private static final TraceComponent tc = Tr.register(JNDIURLEntry.class, (String)"Naming", (String)"com.ibm.ws.jndi.internal.resources.JNDIMessages");
    private transient ServiceRegistration<?> serviceRegistration;
    static final long serialVersionUID = 3876825639019664394L;

    protected void activate(BundleContext context, Map<String, Object> props) {
        String jndiName = (String)props.get("jndiName");
        final String urlValue = (String)props.get("value");
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Registering JNDIURLEntry with value " + urlValue + " and JNDI name " + jndiName), (Object[])new Object[0]);
        }
        if (jndiName == null || jndiName.isEmpty() || urlValue == null || urlValue.isEmpty()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Unable to register JNDIURLEntry with jndiName [" + jndiName + "] and value [" + urlValue + "] because both must be set"), (Object[])new Object[0]);
            }
            return;
        }
        this.createURL(jndiName, urlValue);
        Hashtable<String, Object> propertiesForJndiService = new Hashtable<String, Object>();
        ((Dictionary)propertiesForJndiService).put("osgi.jndi.service.name", jndiName);
        ((Dictionary)propertiesForJndiService).put("objectClass", Reference.class);
        Reference ref = new Reference(URL.class.getName(), this.getClass().getName(), null);
        ref.add(new RefAddr("JndiURLEntry"){
            private static final long serialVersionUID = 5168161341101144689L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Object getContent() {
                return urlValue;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.jndi.internal.JNDIURLEntry$1", 1.class, (String)"Naming", (String)"com.ibm.ws.jndi.internal.resources.JNDIMessages");
            }
        });
        this.serviceRegistration = context.registerService(Reference.class, (Object)ref, propertiesForJndiService);
    }

    protected void deactivate(ComponentContext context) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Unregistering JNDIURLEntry " + this.serviceRegistration), (Object[])new Object[0]);
        }
        if (this.serviceRegistration != null) {
            this.serviceRegistration.unregister();
        }
    }

    @FFDCIgnore(value={PrivilegedActionException.class})
    private URL createURL(String jndiName, String urlValue) {
        try {
            return AccessController.doPrivileged(new CreateURL(urlValue));
        }
        catch (PrivilegedActionException e) {
            Throwable t = e.getCause() == null ? e : e.getCause();
            Tr.error((TraceComponent)tc, (String)"jndi.url.create.exception", (Object[])new Object[]{urlValue, jndiName, t.toString()});
            FFDCFilter.processException((Throwable)t, (String)(JNDIURLEntry.class.getName() + ".createURL"), (String)"147", (Object[])new Object[]{jndiName, urlValue});
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        if (obj instanceof Reference) {
            try {
                String jndiName = nameCtx == null ? "" : nameCtx.getNameInNamespace();
                jndiName = jndiName + (name == null ? "" : name.toString());
                String urlValue = (String)((Reference)obj).get(0).getContent();
                return this.createURL(jndiName, urlValue);
            }
            catch (Throwable jndiName) {
                void t;
                FFDCFilter.processException((Throwable)jndiName, (String)"com.ibm.ws.jndi.internal.JNDIURLEntry", (String)"156", (Object)this, (Object[])new Object[]{obj, name, nameCtx, environment});
                NamingException ne = new NamingException();
                ne.initCause((Throwable)t);
                throw ne;
            }
        }
        return null;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class CreateURL
    implements PrivilegedExceptionAction<URL> {
        private final String urlString;
        static final long serialVersionUID = 7340666973348164316L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private CreateURL(String urlString) {
            this.urlString = urlString;
        }

        @Override
        public URL run() throws MalformedURLException {
            return new URL(this.urlString);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.jndi.internal.JNDIURLEntry$CreateURL", CreateURL.class, (String)"Naming", (String)"com.ibm.ws.jndi.internal.resources.JNDIMessages");
        }
    }
}

