/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.requestContext;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.requestContext.Event;
import java.util.List;

public class EventStackFormatter {
    protected static final TraceNLS nls = TraceNLS.getTraceNLS(EventStackFormatter.class, (String)"com.ibm.ws.request.probe.internal.resources.LoggingMessages");

    public static StringBuffer getStackFormat(Event event, Boolean includeContextInfo) {
        StringBuffer sb = new StringBuffer();
        int noOfTabs = 0;
        long currentNanoTime = System.nanoTime();
        EventStackFormatter.getTreeFormat(sb, event, includeContextInfo, noOfTabs, currentNanoTime, 0);
        return sb;
    }

    private static void getTreeFormat(StringBuffer sb, Event event, Boolean includeContextInfo, int noOfTabs, long currentNanoTime, int spacesRequiredForDuration) {
        if (currentNanoTime < event.getStartTime()) {
            return;
        }
        String executionTimeStr = EventStackFormatter.getExecutionTimeStringFormat(currentNanoTime, event);
        try {
            if (event.getParentEvent() == null) {
                if (spacesRequiredForDuration == 0) {
                    spacesRequiredForDuration = executionTimeStr.length() + 5;
                }
                sb.append(EventStackFormatter.appendHeader(event, executionTimeStr));
            }
            if (event.getEndTime() == 0L) {
                sb.append(String.format("%n%" + spacesRequiredForDuration + "s", executionTimeStr + "ms + "));
            } else {
                sb.append(String.format("%n%" + spacesRequiredForDuration + "s", executionTimeStr + "ms   "));
            }
            if (event.getParentEvent() != null) {
                for (int i = 0; i < noOfTabs; ++i) {
                    sb.append("    ");
                }
            }
            if (includeContextInfo.booleanValue() && event.getContextInfo() != null) {
                sb.append(event.getType() + " | " + event.getContextInfo());
            } else {
                sb.append(event.getType());
            }
            List<Event> list = event.getChildEvents();
            for (int i = 0; i < list.size(); ++i) {
                EventStackFormatter.getTreeFormat(sb, list.get(i), includeContextInfo, noOfTabs + 1, currentNanoTime, spacesRequiredForDuration);
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)EventStackFormatter.class.getName(), (String)"94", (Object)event);
        }
    }

    private static String appendHeader(Event event, String executionTimeStr) {
        return String.format("%n%1$-" + (executionTimeStr.length() + 5) + "s", nls.getString("REQUEST_PROBE_FORMAT_HEADER_DURATION", "Duration")) + nls.getString("REQUEST_PROBE_FORMAT_HEADER_OPERATION", "Operation");
    }

    private static String getExecutionTimeStringFormat(long currentNanoTime, Event event) {
        double executionStr = 0.0;
        executionStr = event.getEndTime() == 0L ? (double)(currentNanoTime - event.getStartTime()) / 1000000.0 : (double)(event.getEndTime() - event.getStartTime()) / 1000000.0;
        return String.format("%.3f", executionStr);
    }
}

