/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.request.probe.bci;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.request.probe.RequestProbeService;
import com.ibm.ws.request.probe.bci.internal.RequestProbeBCIManagerImpl;
import com.ibm.wsspi.probeExtension.ProbeExtension;
import com.ibm.wsspi.request.probe.bci.RequestProbeTransformDescriptor;
import com.ibm.wsspi.requestContext.Event;
import com.ibm.wsspi.requestContext.RequestContext;
import java.util.List;

public class TransformDescriptorHelper {
    private static ThreadLocal<RequestContext> rcThreadLocalObj = new ThreadLocal();
    private Event currentEvent;
    private boolean isCounter;
    private String className;
    private String methodName;
    private String methodDesc;
    private static final TraceComponent tc = Tr.register(TransformDescriptorHelper.class);

    public boolean contextInfoRequired(String eventType, long requestNumber) {
        boolean needContextInfo = false;
        List<ProbeExtension> probeExtnList = RequestProbeService.getProbeExtensions();
        for (int i = 0; i < probeExtnList.size(); ++i) {
            ProbeExtension probeExtension = probeExtnList.get(i);
            if (requestNumber % (long)probeExtension.getRequestSampleRate() != 0L) continue;
            if (probeExtension.getContextInfoRequirement() == 0) {
                needContextInfo = true;
                break;
            }
            if (probeExtension.getContextInfoRequirement() != 1 || probeExtension.invokeForEventTypes() != null && !probeExtension.invokeForEventTypes().contains(eventType)) continue;
            needContextInfo = true;
            break;
        }
        return needContextInfo;
    }

    public void entryHelper(String className, String methodName, String methodDesc, String type, String td, Object thisInstance, Object objArrays) {
        RequestProbeTransformDescriptor requestProbeTransformDescriptor = TransformDescriptorHelper.getObjForInstrumentation(td);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            this.className = className;
            this.methodName = methodName;
            this.methodDesc = methodDesc;
            Tr.debug((TraceComponent)tc, (String)"entryHelper", (Object[])new Object[]{"[className=" + this.className + ", methodName=" + this.methodName + ", methodDesc=" + this.methodDesc + "]", "[type= " + type + "]", requestProbeTransformDescriptor != null ? requestProbeTransformDescriptor + " [isCounter=" + requestProbeTransformDescriptor.isCounter() + "]" : null});
        }
        if (requestProbeTransformDescriptor != null) {
            this.isCounter = requestProbeTransformDescriptor.isCounter();
            this.currentEvent = new Event(type);
            Object contextInfo = null;
            if (!this.isCounter) {
                RequestContext rcVal = rcThreadLocalObj.get();
                this.currentEvent.setStartTime(System.nanoTime());
                if (rcVal == null) {
                    rcVal = new RequestContext();
                    rcVal.setRequestState(10);
                    rcVal.setRootEvent(this.currentEvent);
                    rcVal.setCurrentEvent(this.currentEvent);
                    rcThreadLocalObj.set(rcVal);
                    rcVal.incrementEventCount();
                } else if (rcVal.getEventCount() < 500) {
                    Event tempCurrentEvent = rcVal.getCurrentEvent();
                    if (tempCurrentEvent != null) {
                        tempCurrentEvent.addChild(this.currentEvent);
                        this.currentEvent.setParentEvent(tempCurrentEvent);
                        rcVal.setCurrentEvent(this.currentEvent);
                        rcVal.incrementEventCount();
                    }
                } else if (rcVal.getRequestState() == 10) {
                    rcVal.setRequestState(11);
                }
                if (this.contextInfoRequired(type, rcVal.getRequestId().getSequenceNumber())) {
                    contextInfo = requestProbeTransformDescriptor.getContextInfo(thisInstance, objArrays);
                }
                if (contextInfo != null) {
                    this.currentEvent.setContextInfo(contextInfo);
                }
                RequestProbeService.processAllEntryProbeExtensions(this.currentEvent, rcVal);
            } else {
                contextInfo = requestProbeTransformDescriptor.getContextInfo(thisInstance, objArrays);
                if (contextInfo != null) {
                    this.currentEvent.setContextInfo(contextInfo);
                }
            }
        }
    }

    public void exitHelper() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"exitHelper", (Object[])new Object[]{"[className=" + this.className + ", methodName=" + this.methodName + ", methodDesc=" + this.methodDesc + "]"});
        }
        if (this.currentEvent != null) {
            if (!this.isCounter) {
                RequestContext rcVal = rcThreadLocalObj.get();
                if (rcVal != null) {
                    this.currentEvent.setEndTime(System.nanoTime());
                    RequestProbeService.processAllExitProbeExtensions(this.currentEvent, rcVal);
                    if (this.currentEvent.getParentEvent() != null) {
                        rcVal.setCurrentEvent(this.currentEvent.getParentEvent());
                    }
                    if (this.currentEvent == rcVal.getRootEvent()) {
                        rcThreadLocalObj.remove();
                        rcVal.setRequestState(100);
                    }
                }
            } else {
                RequestProbeService.processAllCounterProbeExtensions(this.currentEvent);
            }
        }
    }

    public static RequestProbeTransformDescriptor getObjForInstrumentation(String key) {
        RequestProbeTransformDescriptor requestProbeTransformDescriptor = RequestProbeBCIManagerImpl.getRequestProbeTransformDescriptors().get(key);
        return requestProbeTransformDescriptor;
    }
}

