/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.classloading.internal.util;

import com.ibm.websphere.ras.annotation.Trivial;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

@Trivial
public class MultiMap<K, V>
implements Cloneable {
    private final Map<K, Set<V>> map = new SimpleMultiMap<K, V>();
    private final Map<V, Set<K>> reverseMap = new SimpleMultiMap<V, K>();
    protected final String representation;

    public MultiMap() {
        this(" -> ");
    }

    public MultiMap(String representation) {
        this.representation = representation;
    }

    public boolean equals(Object o) {
        return o instanceof MultiMap && this.map.equals(((MultiMap)o).map);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public void clear() {
        this.map.clear();
        this.reverseMap.clear();
    }

    protected boolean containsKey(K key) {
        return this.map.containsKey(key);
    }

    public boolean containsValue(V value) {
        return this.reverseMap.containsKey(value);
    }

    public Set<V> get(K key) {
        return Collections.unmodifiableSet(this.map.get(key));
    }

    public Set<V> get(Iterable<? extends K> keys) {
        TreeSet<V> result = new TreeSet<V>();
        for (K key : keys) {
            result.addAll(this.get(key));
        }
        return Collections.unmodifiableSet(result);
    }

    public Set<K> keys(V value) {
        return Collections.unmodifiableSet(this.reverseMap.get(value));
    }

    public Set<K> keys(Iterable<? extends V> values) {
        HashSet<K> result = new HashSet<K>();
        for (V v : values) {
            result.addAll(this.keys(v));
        }
        return Collections.unmodifiableSet(result);
    }

    public Set<K> keys() {
        return Collections.unmodifiableSet(this.map.keySet());
    }

    public Set<V> values() {
        return Collections.unmodifiableSet(this.reverseMap.keySet());
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean add(K key, V value) {
        return this.map.get(key).add(value) && this.reverseMap.get(value).add(key);
    }

    public boolean remove(K key, V value) {
        return this.map.containsKey(key) && this.map.get(key).remove(value) && this.reverseMap.get(value).remove(key);
    }

    public MultiMap<K, V> clone() {
        try {
            MultiMap result = (MultiMap)this.getClass().getConstructor(String.class).newInstance(this.representation);
            for (K k : this.map.keySet()) {
                for (V v : this.map.get(k)) {
                    result.add(k, v);
                }
            }
            return result;
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    public String toString() {
        if (this.map.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder("{ \n");
        for (Map.Entry<K, Set<V>> e : this.map.entrySet()) {
            for (V v : e.getValue()) {
                sb.append(String.format("    %s%s%s,%n", e.getKey(), this.representation, v));
            }
        }
        sb.setLength(sb.lastIndexOf(","));
        sb.append(String.format("%n}", new Object[0]));
        return sb.toString();
    }

    @Trivial
    private static final class SimpleMultiMap<X, Y>
    extends HashMap<X, Set<Y>> {
        private SimpleMultiMap() {
        }

        @Override
        public Set<Y> get(Object key) {
            return this.containsKey(key) ? (Set)super.get(key) : new ValueSet(key);
        }

        @Trivial
        private final class ValueSet
        extends HashSet<Y> {
            private final Object key;
            boolean addedToMap;

            private ValueSet(Object key) {
                this.key = key;
            }

            @Override
            public boolean add(Y value) {
                if (!this.addedToMap) {
                    SimpleMultiMap.this.put(this.key, this);
                    this.addedToMap = true;
                }
                return super.add(value);
            }

            @Override
            public boolean remove(Object o) {
                if (super.remove(o)) {
                    if (super.isEmpty()) {
                        SimpleMultiMap.this.remove(this.key);
                        this.addedToMap = false;
                    }
                    return true;
                }
                return false;
            }
        }
    }
}

