/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.classloading.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(configurationPid={"ApplicationClassloadingServiceFactory"}, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.pid=com.ibm.wsspi.classloading.classloader"})
public class ApplicationClassloadingServiceFactory
implements ManagedServiceFactory {
    private static final TraceComponent tc = Tr.register(ApplicationClassloadingServiceFactory.class, (String)"ClassLoadingService", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
    private final ConcurrentMap<String, Configuration> instances = new ConcurrentHashMap<String, Configuration>();
    private volatile ConfigurationAdmin configAdmin;
    private static final String LIBRARY_REF_ATT = "privateLibraryRef";
    private static final String COMMON_LIBRARY_REF_ATT = "commonLibraryRef";
    public static final String COMPONENT_FACTORY_PID = "com.ibm.wsspi.classloading.classloader.app";
    static final long serialVersionUID = -2638407920941378269L;

    @Reference(name="configAdmin", policy=ReferencePolicy.STATIC)
    protected void setConfigAdmin(ConfigurationAdmin configAdmin) {
        this.configAdmin = configAdmin;
    }

    protected void unsetConfigAdmin(ConfigurationAdmin configAdmin) {
        if (this.configAdmin == configAdmin) {
            this.configAdmin = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void deleted(String pid) {
        block3: {
            Configuration instance = (Configuration)this.instances.remove(pid);
            if (instance != null) {
                try {
                    instance.delete();
                }
                catch (Exception exception) {
                    void e;
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.classloading.internal.ApplicationClassloadingServiceFactory", (String)"72", (Object)this, (Object[])new Object[]{pid});
                    if (!tc.isDebugEnabled()) break block3;
                    Tr.debug((TraceComponent)tc, (String)("Error while deleting application with classloader config pid:  " + pid + "Exception: " + e), (Object[])new Object[0]);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void updated(String pid, Dictionary config) throws ConfigurationException {
        block10: {
            Configuration existingInstance = (Configuration)this.instances.get(pid);
            try {
                Configuration newInstance;
                if (existingInstance == null) {
                    Configuration configuration = newInstance = this.configAdmin.createFactoryConfiguration(COMPONENT_FACTORY_PID);
                    synchronized (configuration) {
                        existingInstance = this.instances.putIfAbsent(pid, newInstance);
                        if (existingInstance == null) {
                            Dictionary<String, Object> properties = this.buildServicePropsAndFilterTargets(pid, config);
                            newInstance.update(properties);
                            return;
                        }
                    }
                }
                newInstance = existingInstance;
                synchronized (newInstance) {
                    existingInstance.update(config);
                }
            }
            catch (Exception newInstance) {
                void e;
                FFDCFilter.processException((Throwable)newInstance, (String)"com.ibm.ws.classloading.internal.ApplicationClassloadingServiceFactory", (String)"105", (Object)this, (Object[])new Object[]{pid, config});
                if (!tc.isDebugEnabled()) break block10;
                Tr.debug((TraceComponent)tc, (String)("Error while updating application with classloader config pid:  " + pid + "Exception: " + e), (Object[])new Object[0]);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private Dictionary<String, Object> buildServicePropsAndFilterTargets(String pid, Dictionary<String, Object> config) throws IOException, InvalidSyntaxException {
        String[] commonLibraryRefs;
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        ((Dictionary)result).put("classloader.config.pid", pid);
        String appFilter = "(classloader=" + pid + ")";
        Configuration[] appConfigs = this.configAdmin.listConfigurations(appFilter);
        if (appConfigs.length == 1) {
            String appName;
            block10: {
                Configuration appConfig = appConfigs[0];
                Dictionary properties = appConfig.getProperties();
                appName = (String)properties.get("name");
                if (appName != null) {
                    ((Dictionary)result).put("application.name", appName);
                }
                String appConfigPid = (String)properties.get("service.pid");
                try {
                    ((Dictionary)result).put("application.pid", appConfigPid);
                }
                catch (NullPointerException nullPointerException) {
                    void swallowed;
                    FFDCFilter.processException((Throwable)nullPointerException, (String)"com.ibm.ws.classloading.internal.ApplicationClassloadingServiceFactory", (String)"139", (Object)this, (Object[])new Object[]{pid, config});
                    if (!tc.isDebugEnabled()) break block10;
                    Tr.debug((TraceComponent)tc, (String)"service.pid is null", (Object[])new Object[]{swallowed});
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Creating ApplicationClassloadingService for application" + appName), (Object[])new Object[0]);
            }
        }
        ArrayList<String> allLibraries = new ArrayList<String>();
        String[] privateLibraryRefs = (String[])config.get(LIBRARY_REF_ATT);
        if (privateLibraryRefs != null) {
            allLibraries.addAll(Arrays.asList(privateLibraryRefs));
        }
        if ((commonLibraryRefs = (String[])config.get(COMMON_LIBRARY_REF_ATT)) != null) {
            allLibraries.addAll(Arrays.asList(commonLibraryRefs));
        }
        if (allLibraries.size() > 0) {
            String filter = this.buildTargetString(allLibraries);
            ((Dictionary)result).put("libraryStatus.target", filter);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"This application will wait for the following libraries ", (Object[])new Object[]{filter});
            }
        } else {
            ((Dictionary)result).put("libraryStatus.target", "(id=global)");
        }
        return result;
    }

    private String buildTargetString(List<String> privateLibraries) {
        StringBuilder filter = new StringBuilder();
        filter.append("(&");
        for (String lib : privateLibraries) {
            filter.append(String.format("(|(%s=%s)(%s=%s))", "active.library.ids", lib, "active.library.pids", lib));
        }
        filter.append(")");
        return filter.toString();
    }

    public String getName() {
        return "ApplicationClassloaderConfigurationHelper";
    }
}

