/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.config.xml.internal;

import com.ibm.websphere.config.ConfigRetrieverException;
import com.ibm.websphere.config.ConfigUpdateException;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.config.admin.ConfigID;
import com.ibm.ws.config.admin.ExtendedConfiguration;
import com.ibm.ws.config.admin.SystemConfigSupport;
import com.ibm.ws.config.xml.internal.ConfigElement;
import com.ibm.ws.config.xml.internal.ConfigNotFoundException;
import com.ibm.ws.config.xml.internal.variables.ConfigVariableRegistry;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.utils.FilterUtils;
import java.io.IOException;
import java.util.List;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
class ConfigRetriever {
    private static final TraceComponent tc = Tr.register(ConfigRetriever.class, (String)"config", (String)"com.ibm.ws.config.internal.resources.ConfigMessages");
    private final SystemConfigSupport caSupport;
    private final ConfigurationAdmin configAdmin;
    private final ConfigVariableRegistry variableRegistry;
    static final long serialVersionUID = 3228155593726775727L;

    ConfigRetriever(SystemConfigSupport caSupport, ConfigurationAdmin configAdmin, ConfigVariableRegistry vr) {
        this.caSupport = caSupport;
        this.configAdmin = configAdmin;
        this.variableRegistry = vr;
    }

    String lookupPid(ConfigID referenceId) {
        String pid;
        ExtendedConfiguration config = this.caSupport.lookupConfiguration(referenceId);
        String string = pid = config == null ? null : config.getPid();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("lookupPid(): Lookup of " + referenceId + " reference resolved to " + pid), (Object[])new Object[0]);
        }
        return pid;
    }

    String getPid(ConfigID configId) throws ConfigNotFoundException {
        ExtendedConfiguration config = this.getConfiguration(configId);
        String pid = config.getPid();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getPid(): Lookup of " + configId + " configuration id resolved to " + pid), (Object[])new Object[0]);
        }
        return pid;
    }

    ExtendedConfiguration lookupConfiguration(ConfigID configId) {
        return this.caSupport.lookupConfiguration(configId);
    }

    ExtendedConfiguration findConfiguration(String pid) {
        return this.caSupport.findConfiguration(pid);
    }

    /*
     * WARNING - void declaration
     */
    ExtendedConfiguration getConfiguration(ConfigID configId) throws ConfigNotFoundException {
        try {
            ExtendedConfiguration config = this.caSupport.lookupConfiguration(configId);
            if (config == null) {
                String pid = configId.getPid();
                String factoryFilter = configId.getId() != null ? this.getConfigurationFilter(configId) : null;
                config = (ExtendedConfiguration)this.getConfiguration(pid, factoryFilter);
                config.setInOverridesFile(true);
                for (String variable : config.getUniqueVariables()) {
                    this.variableRegistry.addVariableInUse(variable);
                }
                if (configId.getId() != null) {
                    this.caSupport.registerConfiguration(configId, config);
                }
            }
            return config;
        }
        catch (ConfigRetrieverException config) {
            void ex;
            FFDCFilter.processException((Throwable)config, (String)"com.ibm.ws.config.xml.internal.ConfigRetriever", (String)"104", (Object)this, (Object[])new Object[]{configId});
            throw new ConfigNotFoundException((Throwable)ex);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Configuration getConfiguration(String actualPID, String factoryFilter) throws ConfigRetrieverException {
        try {
            Configuration config = null;
            if (factoryFilter == null) return this.configAdmin.getConfiguration(actualPID, null);
            Configuration[] configs = this.configAdmin.listConfigurations(factoryFilter);
            if (configs == null) return this.configAdmin.createFactoryConfiguration(actualPID, null);
            if (configs.length == 0) {
                return this.configAdmin.createFactoryConfiguration(actualPID, null);
            }
            if (configs.length != 1) throw new ConfigRetrieverException("Too many factory configurations found: " + factoryFilter);
            return configs[0];
        }
        catch (InvalidSyntaxException config) {
            void e;
            FFDCFilter.processException((Throwable)config, (String)"com.ibm.ws.config.xml.internal.ConfigRetriever", (String)"125", (Object)this, (Object[])new Object[]{actualPID, factoryFilter});
            throw new ConfigRetrieverException("Error listing configurations with filter " + factoryFilter, (Throwable)e);
        }
        catch (IOException e) {
            void ex;
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.config.xml.internal.ConfigRetriever", (String)"128", (Object)this, (Object[])new Object[]{actualPID, factoryFilter});
            throw new ConfigRetrieverException("Encountered an IOException while getting configuration", (Throwable)ex);
        }
    }

    /*
     * WARNING - void declaration
     */
    Configuration[] listConfigurations(String filter) throws ConfigRetrieverException {
        try {
            return this.configAdmin.listConfigurations(filter);
        }
        catch (IOException iOException) {
            void e;
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.config.xml.internal.ConfigRetriever", (String)"137", (Object)this, (Object[])new Object[]{filter});
            throw new ConfigRetrieverException("Encountered an IOException while getting configuration", (Throwable)e);
        }
        catch (InvalidSyntaxException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.config.xml.internal.ConfigRetriever", (String)"140", (Object)this, (Object[])new Object[]{filter});
            throw new ConfigRetrieverException("Error listing configurations with filter " + filter, e);
        }
    }

    private String getConfigurationFilter(ConfigID configId) {
        String filter = null;
        if (configId.getId() != null) {
            String key = "config.id";
            String value = configId.toString();
            filter = "(&" + FilterUtils.createPropertyFilter((String)"service.factoryPid", (String)configId.getPid()) + FilterUtils.createPropertyFilter((String)key, (String)value) + ")";
        } else {
            filter = "(&(service.pid=" + configId.getPid() + "))";
        }
        return filter;
    }

    /*
     * WARNING - void declaration
     */
    void collectConfigurations(ConfigElement configElement, List<ExtendedConfiguration> configurations) throws ConfigUpdateException {
        if (configElement.hasNestedElements()) {
            for (Object attributeValue : configElement.getAttributes().values()) {
                if (!(attributeValue instanceof List)) continue;
                List values = (List)attributeValue;
                int size = values.size();
                for (int i = 0; i < size; ++i) {
                    if (!(values.get(i) instanceof ConfigElement)) continue;
                    ConfigElement nested = (ConfigElement)values.get(i);
                    ConfigID configID = null;
                    if (nested.getId() == null) {
                        String id = "default-" + i;
                        configID = new ConfigID(configElement.getConfigID(), nested.getNodeName(), id);
                    } else {
                        configID = nested.getConfigID();
                    }
                    try {
                        configurations.add(this.getConfiguration(configID));
                    }
                    catch (ConfigNotFoundException id) {
                        void e;
                        FFDCFilter.processException((Throwable)id, (String)"com.ibm.ws.config.xml.internal.ConfigRetriever", (String)"179", (Object)this, (Object[])new Object[]{configElement, configurations});
                        throw new ConfigUpdateException((Exception)e);
                    }
                    this.collectConfigurations(nested, configurations);
                }
            }
        }
    }

    ExtendedConfiguration[] listAllConfigurations() throws InvalidSyntaxException, IOException {
        return (ExtendedConfiguration[])this.configAdmin.listConfigurations(null);
    }

    /*
     * WARNING - void declaration
     */
    ExtendedConfiguration[] findConfigurations(ConfigID configID) throws ConfigRetrieverException {
        String filter = this.getConfigurationFilter(configID);
        try {
            return (ExtendedConfiguration[])this.configAdmin.listConfigurations(filter);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            void e;
            FFDCFilter.processException((Throwable)invalidSyntaxException, (String)"com.ibm.ws.config.xml.internal.ConfigRetriever", (String)"208", (Object)this, (Object[])new Object[]{configID});
            throw new ConfigRetrieverException("Error listing configurations with filter " + filter, (Throwable)e);
        }
        catch (IOException e) {
            void ex;
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.config.xml.internal.ConfigRetriever", (String)"211", (Object)this, (Object[])new Object[]{configID});
            throw new ConfigRetrieverException("Encountered an IOException while finding configurations", (Throwable)ex);
        }
    }

    /*
     * WARNING - void declaration
     */
    public ExtendedConfiguration[] findAllNestedConfigurations(ConfigID configID) throws ConfigRetrieverException {
        String filter = "(| (config.id=*//" + configID.getPid() + "[*)(" + "config.id" + "=*//" + configID.getPid() + "\\(*))";
        try {
            return (ExtendedConfiguration[])this.configAdmin.listConfigurations(filter);
        }
        catch (IOException iOException) {
            void e;
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.config.xml.internal.ConfigRetriever", (String)"230", (Object)this, (Object[])new Object[]{configID});
            throw new ConfigRetrieverException("Error listing configurations with filter " + filter, (Throwable)e);
        }
        catch (InvalidSyntaxException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.config.xml.internal.ConfigRetriever", (String)"233", (Object)this, (Object[])new Object[]{configID});
            throw new ConfigRetrieverException("Encountered an IOException while finding configurations", e);
        }
    }

    /*
     * WARNING - void declaration
     */
    public ExtendedConfiguration[] findAllConfigurationsByPid(String pid) throws ConfigRetrieverException {
        String filter = "(|(service.pid=" + pid + ")(" + "service.factoryPid" + "=" + pid + "))";
        try {
            return (ExtendedConfiguration[])this.configAdmin.listConfigurations(filter);
        }
        catch (IOException iOException) {
            void e;
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.config.xml.internal.ConfigRetriever", (String)"243", (Object)this, (Object[])new Object[]{pid});
            throw new ConfigRetrieverException("Error listing configurations with filter " + filter, (Throwable)e);
        }
        catch (InvalidSyntaxException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.config.xml.internal.ConfigRetriever", (String)"246", (Object)this, (Object[])new Object[]{pid});
            throw new ConfigRetrieverException("Encountered an IOException while finding configurations", e);
        }
    }
}

