/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.config.xml.internal;

import com.ibm.websphere.config.ConfigUpdateException;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.config.admin.ConfigID;
import com.ibm.ws.config.xml.LibertyVariable;
import com.ibm.ws.config.xml.internal.BaseConfiguration;
import com.ibm.ws.config.xml.internal.ComparableElement;
import com.ibm.ws.config.xml.internal.ConfigDelta;
import com.ibm.ws.config.xml.internal.ConfigElement;
import com.ibm.ws.config.xml.internal.ConfigMergeException;
import com.ibm.ws.config.xml.internal.FactoryElement;
import com.ibm.ws.config.xml.internal.MetaTypeRegistry;
import com.ibm.ws.config.xml.internal.ServerConfiguration;
import com.ibm.ws.config.xml.internal.SimpleElement;
import com.ibm.ws.config.xml.internal.SingletonElement;
import com.ibm.ws.config.xml.internal.XMLConfigConstants;
import com.ibm.ws.config.xml.internal.metatype.ExtendedAttributeDefinition;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ConfigComparator {
    private final BaseConfiguration oldConfiguration;
    private final BaseConfiguration newConfiguration;
    private final MetaTypeRegistry metatypeRegistry;
    private MetaTypeRegistry.RegistryEntry parentRegistryEntry;
    private final Map<String, DeltaType> variableChanges;
    static final long serialVersionUID = 6735207316063049845L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public ConfigComparator(BaseConfiguration oldConfiguration, BaseConfiguration newConfiguration, MetaTypeRegistry registry) {
        this(oldConfiguration, newConfiguration, registry, null);
    }

    public ConfigComparator(BaseConfiguration oldConfiguration, BaseConfiguration newConfiguration, MetaTypeRegistry registry, Map<String, DeltaType> variableDelta) {
        this.oldConfiguration = oldConfiguration;
        this.newConfiguration = newConfiguration;
        this.metatypeRegistry = registry;
        this.variableChanges = variableDelta;
    }

    private MetaTypeRegistry.RegistryEntry getRegistry(MetaTypeRegistry.RegistryEntry parent, String childNodeName) {
        if (this.metatypeRegistry == null) {
            return null;
        }
        MetaTypeRegistry.RegistryEntry entry = null;
        for (MetaTypeRegistry.RegistryEntry pe = parent; pe != null; pe = pe.getExtendedRegistryEntry()) {
            MetaTypeRegistry.RegistryEntry childAliasEntry;
            if (!pe.getObjectClassDefinition().supportsExtensions() || (childAliasEntry = this.metatypeRegistry.getRegistryEntry(pe.getPid(), childNodeName)) == null) continue;
            return childAliasEntry;
        }
        return entry == null ? this.metatypeRegistry.getRegistryEntryByPidOrAlias(childNodeName) : entry;
    }

    public ComparatorResult computeDelta() throws ConfigUpdateException {
        Map<String, DeltaType> variableDelta = this.computeVariableDelta();
        List<ConfigDelta> configDelta = this.computeConfigDelta(variableDelta);
        return new ComparatorResult(configDelta, variableDelta);
    }

    private List<ConfigDelta> computeConfigDelta(Map<String, DeltaType> variableDelta) throws ConfigMergeException {
        ArrayList<ConfigDelta> delta = new ArrayList<ConfigDelta>();
        HashSet<String> ignorePids = new HashSet<String>();
        Set<String> oldPids = this.oldConfiguration.getConfigurationNames();
        for (String pid : oldPids) {
            if (ignorePids.contains(pid)) continue;
            MetaTypeRegistry.RegistryEntry registry = this.getRegistry(this.parentRegistryEntry, pid);
            if (registry == null) {
                boolean oldIsFactory = this.oldConfiguration.hasId(pid);
                if (oldIsFactory) {
                    this.computeFactoryDelta(pid, null, null, delta, variableDelta);
                    continue;
                }
                this.computeSingletonDelta(pid, null, null, delta, variableDelta);
                continue;
            }
            if (registry.isSingleton()) {
                this.computeSingletonDelta(registry.getPid(), registry.getAlias(), registry, delta, variableDelta);
            } else {
                this.computeFactoryDelta(registry.getPid(), registry.getAlias(), registry, delta, variableDelta);
            }
            ignorePids.add(registry.getPid());
            ignorePids.add(registry.getAlias());
        }
        HashSet<String> remainingPids = new HashSet<String>(this.newConfiguration.getConfigurationNames());
        remainingPids.removeAll(oldPids);
        for (String pid : remainingPids) {
            if (ignorePids.contains(pid)) continue;
            MetaTypeRegistry.RegistryEntry registry = this.getRegistry(this.parentRegistryEntry, pid);
            if (registry == null) {
                boolean isFactory = this.newConfiguration.hasId(pid);
                if (isFactory) {
                    this.newFactoryDelta(pid, null, null, delta);
                    continue;
                }
                this.newSingletonDelta(pid, null, null, delta);
                continue;
            }
            if (registry.isSingleton()) {
                this.newSingletonDelta(registry.getPid(), registry.getAlias(), registry, delta);
            } else {
                this.newFactoryDelta(registry.getPid(), registry.getAlias(), registry, delta);
            }
            ignorePids.add(registry.getPid());
            ignorePids.add(registry.getAlias());
        }
        return delta;
    }

    private void computeSingletonDelta(String pid, String alias, MetaTypeRegistry.RegistryEntry registryEntry, List<ConfigDelta> delta, Map<String, DeltaType> variableDelta) throws ConfigMergeException {
        SingletonElement newConfig;
        SingletonElement oldConfig;
        ConfigDelta configDelta;
        if (registryEntry != null && registryEntry.getChildAlias() != null) {
            alias = registryEntry.getChildAlias();
        }
        if ((configDelta = this.computeDelta(oldConfig = this.oldConfiguration.getSingleton(pid, alias), newConfig = this.newConfiguration.getSingleton(pid, alias), registryEntry, variableDelta)) != null) {
            delta.add(configDelta);
        }
    }

    private void computeFactoryDelta(String pid, String alias, MetaTypeRegistry.RegistryEntry registryEntry, List<ConfigDelta> delta, Map<String, DeltaType> variableDelta) throws ConfigMergeException {
        ConfigDelta configDelta;
        ConfigElement newConfig;
        String defaultId = null;
        if (registryEntry != null) {
            if (registryEntry.getChildAlias() != null) {
                alias = registryEntry.getChildAlias();
            }
            defaultId = registryEntry.getDefaultId();
        }
        Map<ConfigID, FactoryElement> oldInstances = this.oldConfiguration.getFactoryInstancesUsingDefaultId(pid, alias, defaultId);
        Map<ConfigID, FactoryElement> newInstances = this.newConfiguration.getFactoryInstancesUsingDefaultId(pid, alias, defaultId);
        for (Map.Entry<ConfigID, FactoryElement> oldEntry : oldInstances.entrySet()) {
            FactoryElement oldConfig = oldEntry.getValue();
            configDelta = this.computeDelta(oldConfig, newConfig = newInstances.get(oldEntry.getKey()), registryEntry, variableDelta);
            if (configDelta == null) continue;
            delta.add(configDelta);
        }
        HashSet<ConfigID> remainingInstanceIds = new HashSet<ConfigID>(newInstances.keySet());
        remainingInstanceIds.removeAll(oldInstances.keySet());
        for (ConfigID id : remainingInstanceIds) {
            newConfig = newInstances.get(id);
            configDelta = this.computeDelta(null, newConfig, registryEntry, variableDelta);
            if (configDelta == null) continue;
            delta.add(configDelta);
        }
    }

    private void newSingletonDelta(String pid, String alias, MetaTypeRegistry.RegistryEntry registryEntry, List<ConfigDelta> delta) throws ConfigMergeException {
        SingletonElement newConfig = this.newConfiguration.getSingleton(pid, alias);
        ConfigDelta configDelta = this.computeDelta(null, newConfig, registryEntry, null);
        if (configDelta != null) {
            delta.add(configDelta);
        }
    }

    private void newFactoryDelta(String pid, String alias, MetaTypeRegistry.RegistryEntry registryEntry, List<ConfigDelta> delta) throws ConfigMergeException {
        String defaultId = null;
        if (registryEntry != null) {
            if (registryEntry.getChildAlias() != null) {
                alias = registryEntry.getChildAlias();
            }
            defaultId = registryEntry.getDefaultId();
        }
        Map<ConfigID, FactoryElement> instances = this.newConfiguration.getFactoryInstancesUsingDefaultId(pid, alias, defaultId);
        for (FactoryElement instance : instances.values()) {
            ConfigDelta configDelta = this.computeDelta(null, instance, registryEntry, null);
            if (configDelta == null) continue;
            delta.add(configDelta);
        }
    }

    private ConfigDelta computeDelta(ConfigElement oldConfig, ConfigElement newConfig, MetaTypeRegistry.RegistryEntry registryEntry, Map<String, DeltaType> variableDelta) throws ConfigMergeException {
        ConfigElement oldElement = oldConfig == null || !oldConfig.isEnabled() ? null : oldConfig;
        ConfigElement newElement = newConfig == null || !newConfig.isEnabled() ? null : newConfig;
        List<ConfigDelta> nestedDelta = null;
        if (oldElement != null && oldElement.hasNestedElements() || newElement != null && newElement.hasNestedElements()) {
            BaseConfiguration oldNestedConfiguration = this.buildConfiguration(oldElement, registryEntry);
            BaseConfiguration newNestedConfiguration = this.buildConfiguration(newElement, registryEntry);
            ConfigComparator nestedComparator = new ConfigComparator(oldNestedConfiguration, newNestedConfiguration, this.metatypeRegistry);
            nestedComparator.setParent(registryEntry);
            nestedDelta = nestedComparator.computeConfigDelta(variableDelta);
        }
        if (oldElement == null) {
            if (newElement == null) {
                return null;
            }
            return new ConfigDelta(newElement, DeltaType.ADDED, nestedDelta, registryEntry, ConfigDelta.REASON.PROPERTIES_UPDATE);
        }
        if (newElement == null) {
            ConfigElement removedConfig = newConfig == null ? oldConfig : newConfig;
            return new ConfigDelta(removedConfig, DeltaType.REMOVED, nestedDelta, registryEntry, ConfigDelta.REASON.PROPERTIES_UPDATE);
        }
        if (!this.compare(oldElement, newElement) || this.hasChangedVariables(newElement, registryEntry, variableDelta)) {
            return new ConfigDelta(newElement, DeltaType.MODIFIED, nestedDelta, registryEntry, ConfigDelta.REASON.PROPERTIES_UPDATE);
        }
        if (nestedDelta != null && !nestedDelta.isEmpty()) {
            return new ConfigDelta(newElement, DeltaType.MODIFIED, nestedDelta, registryEntry, ConfigDelta.REASON.NESTED_UPDATE_ONLY);
        }
        return null;
    }

    private void setParent(MetaTypeRegistry.RegistryEntry registryEntry) {
        this.parentRegistryEntry = registryEntry;
    }

    private boolean compare(ConfigElement obj1, ConfigElement obj2) {
        if (!obj1.getNodeName().equals(obj2.getNodeName())) {
            return false;
        }
        if (obj1.getId() == null ? obj2.getId() != null : !obj1.getId().equals(obj2.getId())) {
            return false;
        }
        if (obj1.getAttributes() == null) {
            return obj2.getAttributes() == null || obj2.getAttributes().isEmpty();
        }
        return this.compareAttributes(obj1.getAttributes(), obj2.getAttributes());
    }

    private boolean compareAttributes(Map<String, Object> attr1, Map<String, Object> attr2) {
        if (attr1 == attr2) {
            return true;
        }
        if (attr1.size() != attr2.size()) {
            return false;
        }
        for (Map.Entry<String, Object> entry : attr1.entrySet()) {
            List list2;
            List list1;
            String key = entry.getKey();
            if (!attr2.containsKey(key)) {
                return false;
            }
            Object value1 = entry.getValue();
            Object value2 = attr2.get(key);
            if (value2 == null) {
                return value1 == null;
            }
            if (!(value1 instanceof List && value2 instanceof List ? !this.compareLists(list1 = (List)value1, list2 = (List)value2) : !value2.equals(value1))) continue;
            return false;
        }
        return true;
    }

    private boolean compareLists(List<Object> value1, List<Object> value2) {
        if (value1.size() != value2.size()) {
            return false;
        }
        for (int i = 0; i < value1.size(); ++i) {
            Object o1 = value1.get(i);
            Object o2 = value2.get(i);
            if (o1 == null) {
                if (o2 == null) continue;
                return false;
            }
            if (o1 instanceof ConfigElement && o2 instanceof ConfigElement) {
                ConfigElement one = (ConfigElement)o1;
                ConfigElement two = (ConfigElement)o2;
                if (!one.getNodeName().equals(two.getNodeName())) {
                    return false;
                }
                if (one.getId() == null) continue;
                if (two.getId() == null) {
                    return false;
                }
                if (one.getId().equals(two.getId())) continue;
                return false;
            }
            if (o1.equals(o2)) continue;
            return false;
        }
        return true;
    }

    private boolean hasChangedVariables(ConfigElement configElement, MetaTypeRegistry.RegistryEntry registryEntry, Map<String, DeltaType> variableDelta) {
        if (variableDelta == null || variableDelta.isEmpty()) {
            return false;
        }
        for (Map.Entry<String, Object> attributeEntry : configElement.getAttributes().entrySet()) {
            Object attributeValue = attributeEntry.getValue();
            if (attributeValue instanceof String) {
                if (!this.hasVariable((String)attributeValue, variableDelta)) continue;
                return true;
            }
            if (!(attributeValue instanceof List)) continue;
            List values = (List)attributeValue;
            for (Object value : values) {
                if (value instanceof String) {
                    if (!this.hasVariable((String)value, variableDelta)) continue;
                    return true;
                }
                if (value instanceof ConfigElement.Reference) {
                    if (!this.hasVariable(((ConfigElement.Reference)value).getId(), variableDelta)) continue;
                    return true;
                }
                if (value instanceof ConfigElement) {
                    if (!this.hasVariable(((ConfigElement)value).getId(), variableDelta)) continue;
                    return true;
                }
                throw new IllegalStateException("Unexpected attribute type: " + value.getClass());
            }
        }
        if (registryEntry != null) {
            Map<String, ExtendedAttributeDefinition> metaTypeAttributes = registryEntry.getObjectClassDefinition().getAttributeMap();
            for (Map.Entry<String, ExtendedAttributeDefinition> attributeEntry : metaTypeAttributes.entrySet()) {
                String attributeName = attributeEntry.getKey();
                if (configElement.containsAttribute(attributeName)) continue;
                ExtendedAttributeDefinition attribute = attributeEntry.getValue();
                String variable = attribute.getVariable();
                if (variable != null && variableDelta.containsKey(variable)) {
                    return true;
                }
                String[] defaultValue = attribute.getDefaultValue();
                if (defaultValue == null || defaultValue.length <= 0) continue;
                for (String value : defaultValue) {
                    if (!this.hasVariable(value, variableDelta)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean hasVariable(String value, Map<String, DeltaType> variableDelta) {
        Matcher matcher = XMLConfigConstants.VAR_PATTERN.matcher(value);
        while (matcher.find()) {
            String variable = matcher.group(1);
            if (!variableDelta.containsKey(variable)) continue;
            return true;
        }
        return false;
    }

    private ExtendedAttributeDefinition getAttributeDefinition(String attribute, Map<String, ExtendedAttributeDefinition> attributes) {
        ExtendedAttributeDefinition attrDef = null;
        if (attributes != null && (attrDef = attributes.get(attribute)) == null) {
            attribute = attribute.endsWith("Ref") ? attribute.substring(0, attribute.length() - "Ref".length()) : attribute + "Ref";
            attrDef = attributes.get(attribute);
        }
        return attrDef;
    }

    private BaseConfiguration buildConfiguration(ConfigElement configElement, MetaTypeRegistry.RegistryEntry registryEntry) {
        BaseConfiguration configuration = new BaseConfiguration();
        if (configElement != null) {
            Map<String, ExtendedAttributeDefinition> metaTypeAttributes = null;
            if (registryEntry != null) {
                metaTypeAttributes = registryEntry.getObjectClassDefinition().getAttributeMap();
            }
            for (Map.Entry<String, Object> attributeEntry : configElement.getAttributes().entrySet()) {
                String attributeName = attributeEntry.getKey();
                Object attributeValue = attributeEntry.getValue();
                if (!(attributeValue instanceof List)) continue;
                ExtendedAttributeDefinition attrDef = this.getAttributeDefinition(attributeName, metaTypeAttributes);
                List values = (List)attributeValue;
                for (int i = 0; i < values.size(); ++i) {
                    String defaultId;
                    if (!(values.get(i) instanceof SimpleElement)) continue;
                    SimpleElement nested = (SimpleElement)values.get(i);
                    ComparableElement updated = null;
                    if (attrDef != null && attrDef.getType() == 1001) {
                        String pid = attrDef.getReferencePid();
                        defaultId = null;
                        MetaTypeRegistry.RegistryEntry nestedRegistryEntry = this.metatypeRegistry.getRegistryEntry(pid);
                        if (nestedRegistryEntry != null) {
                            defaultId = nestedRegistryEntry.getDefaultId();
                        }
                        updated = attrDef.getCardinality() == 0 ? new ComparableElement(nested, -1, pid, defaultId) : new ComparableElement(nested, i, pid, defaultId);
                        updated.setChildAttributeName(attributeName);
                        updated.setIdAttribute();
                        this.buildConfiguration(updated, nestedRegistryEntry);
                    } else {
                        MetaTypeRegistry.RegistryEntry nestedRegistryEntry = this.getRegistry(registryEntry, nested.getNodeName());
                        if (nestedRegistryEntry != null) {
                            defaultId = nestedRegistryEntry.getDefaultId();
                            updated = new ComparableElement(nested, i, nestedRegistryEntry.getPid(), defaultId);
                        } else {
                            updated = new ComparableElement(nested, i, null, null);
                        }
                    }
                    updated.setParent(configElement);
                    configuration.addConfigElement(updated);
                    values.set(i, updated);
                }
            }
        }
        return configuration;
    }

    private Map<String, DeltaType> computeVariableDelta() throws ConfigUpdateException {
        DeltaType delta;
        String variableName;
        if (this.variableChanges != null) {
            return this.variableChanges;
        }
        HashMap<String, DeltaType> deltaMap = new HashMap<String, DeltaType>();
        LinkedList<String> stack = new LinkedList<String>();
        Map<String, LibertyVariable> newVariables = this.newConfiguration.getVariables();
        Map<String, LibertyVariable> oldVariables = this.oldConfiguration.getVariables();
        for (LibertyVariable oldVariable : oldVariables.values()) {
            variableName = oldVariable.getName();
            delta = this.compareVariable(oldVariables, newVariables, variableName, stack);
            if (delta == null) continue;
            deltaMap.put(variableName, delta);
        }
        for (LibertyVariable newVariable : newVariables.values()) {
            variableName = newVariable.getName();
            if (oldVariables.containsKey(variableName)) continue;
            delta = this.compareVariable(oldVariables, newVariables, variableName, stack);
            deltaMap.put(variableName, delta);
        }
        return deltaMap;
    }

    private DeltaType compareVariable(Map<String, LibertyVariable> oldVariables, Map<String, LibertyVariable> newVariables, String variableName, LinkedList<String> stack) throws ConfigUpdateException {
        if (stack.contains(variableName)) {
            throw new ConfigUpdateException("Variable loop detected: " + stack.subList(stack.indexOf(variableName), stack.size()));
        }
        stack.add(variableName);
        LibertyVariable oldVariable = oldVariables.get(variableName);
        LibertyVariable newVariable = newVariables.get(variableName);
        DeltaType delta = null;
        delta = oldVariable == null ? (newVariable == null ? null : DeltaType.ADDED) : (newVariable == null ? DeltaType.REMOVED : (oldVariable.getValue() != null && oldVariable.getValue().equals(newVariable.getValue()) ? this.compareVariableReferences(oldVariables, newVariables, oldVariable.getValue(), stack) : (oldVariable.getDefaultValue() != null && oldVariable.getDefaultValue().equals(newVariable.getDefaultValue()) ? this.compareVariableReferences(oldVariables, newVariables, oldVariable.getDefaultValue(), stack) : DeltaType.MODIFIED)));
        stack.removeLast();
        return delta;
    }

    private DeltaType compareVariableReferences(Map<String, LibertyVariable> oldVariables, Map<String, LibertyVariable> newVariables, String variableValue, LinkedList<String> stack) throws ConfigUpdateException {
        Matcher matcher = XMLConfigConstants.VAR_PATTERN.matcher(variableValue);
        while (matcher.find()) {
            String variable = matcher.group(1);
            if (this.compareVariable(oldVariables, newVariables, variable, stack) == null) continue;
            return DeltaType.MODIFIED;
        }
        return null;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.config.xml.internal.ConfigComparator", ConfigComparator.class, (String)"config", (String)"com.ibm.ws.config.internal.resources.ConfigMessages");
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public static class ComparatorResult {
        private final List<ConfigDelta> configDelta;
        private final Map<String, DeltaType> variableDelta;
        private ServerConfiguration newConfiguration;
        static final long serialVersionUID = 689312837108247680L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public ComparatorResult(List<ConfigDelta> configDelta, Map<String, DeltaType> variableDelta) {
            this.configDelta = configDelta;
            this.variableDelta = variableDelta;
        }

        public List<ConfigDelta> getConfigDelta() {
            return this.configDelta;
        }

        public Map<String, DeltaType> getVariableDelta() {
            return this.variableDelta;
        }

        public boolean hasDelta() {
            return !this.configDelta.isEmpty() || !this.variableDelta.isEmpty();
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("ComparatorResult[");
            builder.append("configDelta=").append(this.configDelta).append(", ");
            builder.append("variableDelta=").append(this.variableDelta);
            builder.append("]");
            return builder.toString();
        }

        public void setNewConfiguration(ServerConfiguration newConfiguration) {
            this.newConfiguration = newConfiguration;
        }

        public ServerConfiguration getNewConfiguration() {
            return this.newConfiguration;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.config.xml.internal.ConfigComparator$ComparatorResult", ComparatorResult.class, (String)"config", (String)"com.ibm.ws.config.internal.resources.ConfigMessages");
        }
    }

    public static enum DeltaType {
        ADDED,
        MODIFIED,
        REMOVED;

    }
}

