/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.config.converters;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.microprofile.config.converters.PriorityConverter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class PriorityConverterMap {
    private static final TraceComponent tc = Tr.register(PriorityConverterMap.class, (String)"APPCONFIG", (String)"com.ibm.ws.microprofile.config.resources.Config");
    private final Map<Type, PriorityConverter> converters = new LinkedHashMap<Type, PriorityConverter>();
    private boolean unmodifiable = false;
    static final long serialVersionUID = 3670997306325895831L;

    @Trivial
    public PriorityConverterMap() {
    }

    @Trivial
    public PriorityConverterMap(PriorityConverterMap toCopy) {
        for (PriorityConverter converter : toCopy.getAll()) {
            this._addConverter(converter);
        }
    }

    @Trivial
    public PriorityConverter addConverter(PriorityConverter converter) {
        PriorityConverter existing = this._addConverter(converter);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Converter added to map @ priority {0}: {1}={2}", (Object[])new Object[]{existing.getPriority(), existing.getType(), existing});
        }
        return existing;
    }

    @Trivial
    private PriorityConverter _addConverter(PriorityConverter converter) {
        if (this.unmodifiable) {
            throw new UnsupportedOperationException();
        }
        Type type = converter.getType();
        PriorityConverter existing = this.converters.get(type);
        if (existing == null || existing.getPriority() <= converter.getPriority()) {
            this.converters.put(type, converter);
            existing = converter;
        }
        return existing;
    }

    @Trivial
    public void addAll(PriorityConverterMap convertersToAdd) {
        for (PriorityConverter converter : convertersToAdd.converters.values()) {
            this._addConverter(converter);
        }
    }

    public PriorityConverter getConverter(Type type) {
        PriorityConverter converter = this.converters.get(type);
        return converter;
    }

    @Trivial
    public void setUnmodifiable() {
        this.unmodifiable = true;
    }

    public boolean hasType(Type type) {
        return this.converters.containsKey(type);
    }

    public Collection<PriorityConverter> getAll() {
        return this.converters.values();
    }

    public Collection<? extends Type> getTypes() {
        return this.converters.keySet();
    }

    public String toString() {
        return "PriorityConverterMap:" + this.converters;
    }
}

