/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsoc;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.ws.transport.access.TransportConnectionAccess;
import com.ibm.ws.wsoc.AnnotatedEndpoint;
import com.ibm.ws.wsoc.EndpointManager;
import com.ibm.ws.wsoc.ParametersOfInterest;
import com.ibm.ws.wsoc.RemoteEndpointAsyncImpl;
import com.ibm.ws.wsoc.RemoteEndpointBasicImpl;
import com.ibm.ws.wsoc.ServiceManager;
import com.ibm.ws.wsoc.SessionIdleTimeout;
import com.ibm.ws.wsoc.WebSocketContainerManager;
import com.ibm.ws.wsoc.WebSocketVersionServiceManager;
import com.ibm.ws.wsoc.WsocConnLink;
import com.ibm.ws.wsoc.external.RemoteEndpointAsyncExt;
import com.ibm.ws.wsoc.external.RemoteEndpointBasicExt;
import com.ibm.ws.wsoc.external.SessionExt;
import com.ibm.ws.wsoc.external.WebSocketContainerExt;
import com.ibm.ws.wsoc.injection.InjectionProvider;
import com.ibm.ws.wsoc.injection.InjectionProvider12;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;
import com.ibm.wsspi.channelfw.VirtualConnection;
import com.ibm.wsspi.tcpchannel.TCPConnectionContext;
import java.net.URI;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpSession;
import javax.websocket.CloseReason;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.Extension;
import javax.websocket.MessageHandler;
import javax.websocket.RemoteEndpoint;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;
import javax.websocket.server.ServerEndpointConfig;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class SessionImpl {
    private static final TraceComponent tc = Tr.register(SessionImpl.class, (String)"websockets", (String)"com.ibm.ws.wsoc.internal.resources.WebSockets");
    WsocConnLink connLink = null;
    TCPConnectionContext tcpConnectionContext = null;
    VirtualConnection vc = null;
    SessionExt sessionExt = null;
    Endpoint endpoint = null;
    EndpointConfig endpointConfig = null;
    ParametersOfInterest things = null;
    RemoteEndpointAsyncImpl remoteEndpointAsyncImpl = null;
    RemoteEndpointAsyncExt remoteEndpointAsyncExt = null;
    RemoteEndpointBasicImpl remoteEndpointBasicImpl = null;
    RemoteEndpointBasicExt remoteEndpointBasicExt = null;
    WebSocketContainerManager manager = null;
    WebSocketContainerExt container = null;
    long maxIdleTimeout = 0L;
    int maxBinaryMessageBufferSize = 0;
    int maxTextMessageBufferSize = 0;
    HashMap<String, Object> userProperties = null;
    String sessionID = null;
    boolean clientSide = false;
    HashMap<String, String> pathParameters = new HashMap();
    SessionIdleTimeout sessionIdleTimeout = null;
    static final long serialVersionUID = -4263800096811441187L;

    public void initialize(Endpoint ep, EndpointConfig epc, TransportConnectionAccess access, SessionExt sesExt, WebSocketContainerExt wsce) {
        this.initialize(ep, epc, access, sesExt, wsce, false);
    }

    public void initialize(Endpoint ep, EndpointConfig epc, TransportConnectionAccess access, SessionExt sesExt, WebSocketContainerExt wsce, boolean clientSide) {
        this.endpoint = ep;
        this.endpointConfig = epc;
        this.sessionExt = sesExt;
        this.clientSide = clientSide;
        this.connLink = new WsocConnLink();
        this.connLink.initialize(this.endpoint, this.endpointConfig, this.sessionExt, access, clientSide);
        this.manager = WebSocketContainerManager.getRef();
        this.container = wsce;
        this.maxIdleTimeout = this.container.getDefaultMaxSessionIdleTimeout();
        this.maxBinaryMessageBufferSize = this.container.getDefaultMaxBinaryMessageBufferSize();
        this.maxTextMessageBufferSize = this.container.getDefaultMaxTextMessageBufferSize();
        this.sessionID = this.manager.generateNewId();
        this.sessionIdleTimeout = new SessionIdleTimeout(this.sessionID, this.maxIdleTimeout, this.connLink);
    }

    public void setParametersOfInterest(ParametersOfInterest value) {
        this.things = value;
        this.connLink.setParametersOfInterest(value);
    }

    public void signalAppOnOpen() {
        this.signalAppOnOpen(null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signalAppOnOpen(WsByteBuffer remainingBuf, boolean runWithDoPriv) {
        ClassLoader originalCL;
        block27: {
            ComponentMetaDataAccessorImpl cmdai = null;
            boolean appActivateResult = false;
            InjectionProvider ip = null;
            InjectionProvider12 ip12 = null;
            this.connLink.setLinkStatusesToOK();
            this.connLink.setEndpointManager(this.things.getEndpointManager());
            if (WebSocketVersionServiceManager.isWsoc21OrHigher()) {
                this.things.setUserProperties(this.endpointConfig.getUserProperties());
            } else {
                this.userProperties = new HashMap();
                this.things.setUserProperties(this.userProperties);
            }
            this.things.setSessionID(this.sessionID);
            if (!this.clientSide) {
                EndpointManager epm = this.things.getEndpointManager();
                epm.addSession(this.endpoint, this.sessionExt);
            }
            if (runWithDoPriv) {
                final Thread t = Thread.currentThread();
                originalCL = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){
                    static final long serialVersionUID = 403767190386972991L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    public ClassLoader run() {
                        ClassLoader cl = t.getContextClassLoader();
                        Thread.currentThread().setContextClassLoader(SessionImpl.this.things.getTccl());
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("classloader is: " + Thread.currentThread().getContextClassLoader()), (Object[])new Object[0]);
                        }
                        return cl;
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register((String)"com.ibm.ws.wsoc.SessionImpl$1", 1.class, (String)"websockets", (String)"com.ibm.ws.wsoc.internal.resources.WebSockets");
                    }
                });
            } else {
                originalCL = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(this.things.getTccl());
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("classloader is: " + Thread.currentThread().getContextClassLoader()), (Object[])new Object[0]);
                }
            }
            try {
                ComponentMetaData cmd = this.things.getCmd();
                if (cmd != null) {
                    cmdai = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor();
                    cmdai.beginContext(cmd);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("componentMetaData is: " + cmd), (Object[])new Object[0]);
                    Tr.debug((TraceComponent)tc, (String)("classloader is: " + Thread.currentThread().getContextClassLoader()), (Object[])new Object[0]);
                    Tr.debug((TraceComponent)tc, (String)("endpoint URI is: " + this.things.getURI()), (Object[])new Object[0]);
                }
                if ((ip12 = ServiceManager.getInjectionProvider12()) == null) {
                    ip = ServiceManager.getInjectionProvider();
                    if (ip != null) {
                        HttpSession httpSession = this.things.getHttpSession();
                        appActivateResult = ip.activateAppContext(cmd);
                        if (httpSession != null) {
                            ip.startSesContext(httpSession);
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("thread ID: " + Thread.currentThread().getId() + "Session ID: " + httpSession.getId()), (Object[])new Object[0]);
                            }
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Attempted to use sessions scope when there was no valid HttpSession, guess the HttpSession expired?", (Object[])new Object[0]);
                        }
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"InjectionProvider was null", (Object[])new Object[0]);
                }
                this.sessionIdleTimeout.restartIdleTimeout(this.getMaxIdleTimeout());
                this.connLink.setReadLinkStatus(WsocConnLink.READ_LINK_STATUS.ON_READ_THREAD);
                this.endpoint.onOpen((Session)this.sessionExt, this.endpointConfig);
                if (ip12 == null && ip != null) {
                    if (appActivateResult) {
                        ip.deActivateAppContext();
                    }
                    ip.deActivateSesContext();
                }
                if (cmdai == null) break block27;
            }
            catch (Throwable throwable) {
                if (cmdai != null) {
                    cmdai.endContext();
                }
                if (runWithDoPriv) {
                    AccessController.doPrivileged(new PrivilegedAction<Void>(originalCL){
                        final /* synthetic */ ClassLoader val$originalCL;
                        static final long serialVersionUID = 1596440007634696517L;
                        private static final /* synthetic */ TraceComponent $$$tc$$$;
                        {
                            this.val$originalCL = classLoader;
                        }

                        @Override
                        public Void run() {
                            Thread.currentThread().setContextClassLoader(this.val$originalCL);
                            return null;
                        }

                        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                        static {
                            $$$tc$$$ = Tr.register((String)"com.ibm.ws.wsoc.SessionImpl$2", 2.class, (String)"websockets", (String)"com.ibm.ws.wsoc.internal.resources.WebSockets");
                        }
                    });
                } else {
                    Thread.currentThread().setContextClassLoader(originalCL);
                }
                throw throwable;
            }
            cmdai.endContext();
        }
        if (runWithDoPriv) {
            AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
        } else {
            Thread.currentThread().setContextClassLoader(originalCL);
        }
        if (remainingBuf != null) {
            this.connLink.processDataThenStartRead(remainingBuf);
        } else {
            this.connLink.startReading();
        }
    }

    public void addMessageHandler(MessageHandler handler) throws IllegalStateException {
        this.connLink.addMessageHandler(handler);
    }

    public synchronized RemoteEndpoint.Async getAsyncRemote() {
        if (this.remoteEndpointAsyncImpl == null && this.connLink != null) {
            this.remoteEndpointAsyncImpl = new RemoteEndpointAsyncImpl();
            this.remoteEndpointAsyncImpl.initialize(this.connLink);
            this.remoteEndpointBasicImpl = new RemoteEndpointBasicImpl();
            this.remoteEndpointBasicImpl.initialize(this.connLink);
        }
        if (this.remoteEndpointAsyncImpl != null) {
            this.remoteEndpointAsyncExt = new RemoteEndpointAsyncExt(this.remoteEndpointAsyncImpl, this.remoteEndpointBasicImpl);
            return this.remoteEndpointAsyncExt;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"unexpectedly not able to create RemoteEndpoint.Async object ", (Object[])new Object[0]);
        }
        return null;
    }

    public synchronized RemoteEndpoint.Basic getBasicRemote() {
        if (this.remoteEndpointBasicImpl == null && this.connLink != null) {
            this.remoteEndpointBasicImpl = new RemoteEndpointBasicImpl();
            this.remoteEndpointBasicImpl.initialize(this.connLink);
        }
        if (this.remoteEndpointBasicImpl != null) {
            this.remoteEndpointBasicExt = new RemoteEndpointBasicExt(this.remoteEndpointBasicImpl);
            return this.remoteEndpointBasicExt;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"unexpectedly not able to create RemoteEndpoint.Basic object ", (Object[])new Object[0]);
        }
        return null;
    }

    public Set<MessageHandler> getMessageHandlers() {
        if (this.connLink != null) {
            return this.connLink.getMessageHandlers();
        }
        return null;
    }

    public void removeMessageHandler(MessageHandler handler) {
        if (this.connLink != null) {
            this.connLink.removeMessageHandler(handler);
        }
    }

    public long getMaxIdleTimeout() {
        return this.maxIdleTimeout;
    }

    public void setMaxIdleTimeout(long timeoutMillis) {
        this.maxIdleTimeout = timeoutMillis;
        this.sessionIdleTimeout.restartIdleTimeout(this.maxIdleTimeout);
    }

    public long getDefaultAsyncSendTimeout() {
        return this.container.getDefaultAsyncSendTimeout();
    }

    public int getMaxBinaryMessageBufferSize() {
        return this.maxBinaryMessageBufferSize;
    }

    public void setMaxBinaryMessageBufferSize(int size) {
        this.maxBinaryMessageBufferSize = size;
    }

    public int getMaxTextMessageBufferSize() {
        return this.maxTextMessageBufferSize;
    }

    public void setMaxTextMessageBufferSize(int size) {
        this.maxTextMessageBufferSize = size;
    }

    public WebSocketContainer getContainerExt() {
        return this.container;
    }

    public URI getRequestURI() {
        return this.things.getURI();
    }

    public Map<String, List<String>> getRequestParameterMap() {
        return this.things.getParameterMap();
    }

    public String getQueryString() {
        return this.things.getQueryString();
    }

    public Principal getUserPrincipal() {
        return this.things.getUserPrincipal();
    }

    public String getId() {
        return this.sessionID;
    }

    public String getProtocolVersion() {
        return this.things.getWsocProtocolVersion();
    }

    public Map<String, Object> getUserProperties() {
        return this.things.getUserProperties();
    }

    public String getNegotiatedSubprotocol() {
        return this.things.getAgreedSubProtocol();
    }

    public List<Extension> getNegotiatedExtensions() {
        return this.things.getNegotiatedExtensions();
    }

    public Set<Session> getOpenSessions() {
        EndpointManager epm = this.things.getEndpointManager();
        if (epm == null) {
            HashSet<Session> empty = new HashSet<Session>();
            return empty;
        }
        return epm.getOpenSessions(this.endpoint);
    }

    public boolean isOpen() {
        return this.connLink.getLinkStatus() == WsocConnLink.LINK_STATUS.IO_OK;
    }

    /*
     * WARNING - void declaration
     */
    public void closeBecauseAppStopping(CloseReason cr) {
        if (this.connLink.getLinkStatus() == WsocConnLink.LINK_STATUS.IO_OK) {
            try {
                this.connLink.close(cr, true, true);
            }
            catch (RuntimeException runtimeException) {
                FFDCFilter.processException((Throwable)runtimeException, (String)"com.ibm.ws.wsoc.SessionImpl", (String)"421", (Object)this, (Object[])new Object[]{cr});
                if (this.connLink.getLinkStatus() == WsocConnLink.LINK_STATUS.IO_OK) {
                    void e;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Runtime exception during application stop close.   IO status is ok so throwing exception.", (Object[])new Object[0]);
                    }
                    throw e;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Runtime exception during application stop close.   IO status is not ok so likely an exception during server shutdown, not throwing exception.", (Object[])new Object[0]);
                }
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Application stopped and tried to close connection, but IO status is not OK which is indicative of server shutting down, not attempting connection close.", (Object[])new Object[0]);
        }
    }

    public void close(CloseReason cr, boolean outgoing) {
        this.connLink.finishReadBeforeClose(this.sessionIdleTimeout);
        Object key = null;
        if (outgoing) {
            this.connLink.outgoingCloseConnection(cr);
        }
        if ((key = this.endpoint instanceof AnnotatedEndpoint ? ((AnnotatedEndpoint)this.endpoint).getAppInstance() : this.endpoint) != null) {
            WebSocketContainerManager.getRef().releaseCC(key);
        }
    }

    public void internalDestory() {
        this.things.setUserProperties(null);
        if (this.connLink != null) {
            this.connLink.destroy(null);
        }
    }

    protected void setPathParameters() {
        String[] endpointURIParts = null;
        endpointURIParts = this.endpoint instanceof AnnotatedEndpoint ? ((AnnotatedEndpoint)this.endpoint).getEndpointPath().split("/") : ((ServerEndpointConfig)this.endpointConfig).getPath().split("/");
        String[] requestURIParts = this.getRequestURI().getPath().split("/");
        int i = endpointURIParts.length - 1;
        int j = requestURIParts.length - 1;
        while (i > 1) {
            if (endpointURIParts[i].startsWith("{") && endpointURIParts[i].endsWith("}")) {
                String endpointPart = endpointURIParts[i].substring(1, endpointURIParts[i].length() - 1);
                this.pathParameters.put(endpointPart, requestURIParts[j]);
            }
            --i;
            --j;
        }
    }

    public Map<String, String> getPathParameters() {
        return this.pathParameters;
    }

    public boolean isSecure() {
        return this.things.isSecure();
    }

    public String getHttpSessionID() {
        return this.things.getHttpSessionID();
    }

    public void markHttpSessionInvalid() {
        this.things.setHttpSession(null);
    }

    public <T> void addMessageHandler(Class<T> clazz, MessageHandler.Whole<T> handler) {
        this.connLink.addMessageHandler(clazz, handler);
    }

    public <T> void addMessageHandler(Class<T> clazz, MessageHandler.Partial<T> handler) {
        this.connLink.addMessageHandler(clazz, handler);
    }
}

