/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.repository.internal;

import com.ibm.ws.install.internal.InstallLogUtils;
import com.ibm.ws.install.internal.asset.ESAVirtualAsset;
import com.ibm.ws.install.repository.RepositoryException;
import com.ibm.ws.install.repository.internal.BaseRepository;
import com.ibm.ws.install.repository.internal.RepositoryUtils;
import com.ibm.ws.kernel.feature.Visibility;
import com.ibm.ws.kernel.feature.provisioning.ProvisioningFeatureDefinition;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class ZipRepository
extends BaseRepository {
    private ZipFile zipFile = null;

    public ZipRepository(ZipFile zipFile) throws RepositoryException {
        this.classname = "ZipRepository";
        this.zipFile = zipFile;
        if (zipFile.getEntry("feature.properties") == null) {
            throw this.createException(RepositoryUtils.getMessage("ERROR_INVALID_INDEX_FILE", this.zipFile.getName()));
        }
    }

    @Override
    protected Collection<?> getEsaAsset(String productId, String productVersion, String productInstallType, String productLicenseType, String productEdition, Visibility visibility) {
        String method = "getEsaAsset()";
        ArrayList<ESAVirtualAsset> esaAssets = new ArrayList<ESAVirtualAsset>();
        Properties props = new Properties();
        props.put("com.ibm.websphere.productId", productId);
        props.put("com.ibm.websphere.productVersion", productVersion);
        props.put("com.ibm.websphere.productInstallType", productInstallType);
        props.put("com.ibm.websphere.productEdition", productEdition);
        if (productLicenseType != null) {
            props.put("com.ibm.websphere.productLicenseType", productLicenseType);
        }
        Enumeration<? extends ZipEntry> entries = this.zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (!entry.isDirectory() || entry.getName().indexOf(47) != entry.getName().lastIndexOf(47)) continue;
            try {
                ESAVirtualAsset esaAsset = new ESAVirtualAsset(this.zipFile, entry.getName(), "", false);
                if (esaAsset.getSubsystemEntry() == null) {
                    this.log(method, InstallLogUtils.Messages.PROVISIONER_MESSAGES.getLogMessage("tool.install.content.no.subsystem.manifest", new Object[0]));
                    continue;
                }
                ProvisioningFeatureDefinition fd = esaAsset.getProvisioningFeatureDefinition();
                if (fd.getVisibility() == visibility) {
                    if (fd.isSupportedFeatureVersion()) {
                        String appliesTo = fd.getHeader("IBM-AppliesTo");
                        if (!RepositoryUtils.matchAppliesTo("Feature", esaAsset.getFeatureName(), this.zipFile.getName(), appliesTo, productId, productVersion, productInstallType, productLicenseType, productEdition)) continue;
                        esaAssets.add(esaAsset);
                        continue;
                    }
                    this.log(method, InstallLogUtils.Messages.PROVISIONER_MESSAGES.getLogMessage("UNSUPPORTED_FEATURE_VERSION", fd.getFeatureName(), fd.getIbmFeatureVersion()));
                    continue;
                }
                this.log(method, "The feature " + fd.getFeatureName() + " is not " + visibility);
            }
            catch (ZipException e) {
                this.log(method, InstallLogUtils.Messages.PROVISIONER_MESSAGES.getLogMessage("tool.install.bad.zip", this.zipFile.getName()), e);
            }
            catch (IOException e) {
                this.log(method, InstallLogUtils.Messages.PROVISIONER_MESSAGES.getLogMessage("tool.install.bad.zip", this.zipFile.getName()), e);
            }
        }
        return esaAssets;
    }
}

