/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.cache.CacheEntry;
import com.ibm.ws.cache.ValueSet;
import com.ibm.ws.cache.intf.DCacheConfig;
import com.ibm.ws.util.ObjectPool;
import java.io.Serializable;
import java.util.Enumeration;

public class EntryInfo
implements com.ibm.websphere.cache.EntryInfo,
Serializable,
Cloneable {
    private static final long serialVersionUID = 0x50002002L;
    private static TraceComponent tc = Tr.register(EntryInfo.class, (String)"WebSphere Dynamic Cache", (String)"com.ibm.ws.cache.resources.dynacache");
    public static final int NOT_SHARED = 1;
    public static final int SHARED_PUSH = 2;
    public static final int SHARED_PULL = 3;
    public static final int SHARED_PUSH_PULL = 4;
    protected static final boolean SET = true;
    protected static final boolean UNSET = false;
    private boolean expirationTimeFlag = false;
    private boolean inactivityFlag = false;
    private boolean idFlag = false;
    private boolean priorityFlag = false;
    private boolean sharingPolicyFlag = false;
    private boolean lock = false;
    protected Object id = null;
    protected Object userMetaData = null;
    protected int timeLimit = -1;
    protected int inactivity = -1;
    protected long expirationTime = -1L;
    protected long validatorExpirationTime = -1L;
    protected int priority = -1;
    protected int sharingPolicy = 1;
    protected boolean persistToDisk = true;
    public ValueSet templates = new ValueSet(4);
    private String template = null;
    public ValueSet dataIds = new ValueSet(4);
    public ValueSet aliasList = new ValueSet(4);
    private transient EntryInfoPool entryInfoPool = null;
    public int cacheType = 0;
    public String externalCacheGroupId = null;

    public void reset() {
        this.expirationTimeFlag = false;
        this.inactivityFlag = false;
        this.idFlag = false;
        this.priorityFlag = false;
        this.sharingPolicyFlag = false;
        this.lock = false;
        this.id = null;
        this.timeLimit = -1;
        this.inactivity = -1;
        this.expirationTime = -1L;
        this.validatorExpirationTime = -1L;
        this.priority = -1;
        this.sharingPolicy = 1;
        this.persistToDisk = true;
        this.templates.clear();
        this.template = null;
        this.dataIds.clear();
        this.aliasList.clear();
        this.userMetaData = null;
        this.entryInfoPool = null;
        this.cacheType = 0;
        this.externalCacheGroupId = null;
    }

    @Override
    public String getId() {
        if (this.id != null) {
            return this.id.toString();
        }
        return null;
    }

    @Override
    public Object getIdObject() {
        return this.id;
    }

    public void setId(Object id) {
        if (this.lock) {
            throw new IllegalStateException("EntryInfo is locked");
        }
        this.idFlag = true;
        this.id = id;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("set id=" + id), (Object[])new Object[0]);
        }
    }

    @Override
    public void setId(String id) {
        this.setId((Object)id);
    }

    boolean wasIdSet() {
        return this.idFlag;
    }

    @Override
    public boolean isBatchEnabled() {
        return true;
    }

    @Override
    public void setBatchEnabled(boolean flag) {
    }

    @Override
    public int getSharingPolicy() {
        return this.sharingPolicy;
    }

    @Override
    public boolean getPersistToDisk() {
        return this.persistToDisk;
    }

    @Override
    public void setSharingPolicy(int sharingPolicy) {
        if (this.lock) {
            throw new IllegalStateException("EntryInfo is locked");
        }
        this.sharingPolicyFlag = true;
        this.sharingPolicy = sharingPolicy;
        if (sharingPolicy != 1 && sharingPolicy != 2 && sharingPolicy != 3 && sharingPolicy != 4) {
            throw new IllegalArgumentException("Illegal sharing policy: " + sharingPolicy);
        }
    }

    @Override
    public void setPersistToDisk(boolean persistToDisk) {
        if (this.lock) {
            throw new IllegalStateException("EntryInfo is locked");
        }
        this.persistToDisk = persistToDisk;
    }

    boolean wasSharingPolicySet() {
        return this.sharingPolicyFlag;
    }

    @Override
    public boolean isNotShared() {
        return this.sharingPolicy == 1;
    }

    @Override
    public boolean isSharedPush() {
        return this.sharingPolicy == 2 || this.sharingPolicy == 4;
    }

    @Override
    public boolean isSharedPull() {
        return this.sharingPolicy == 3 || this.sharingPolicy == 4;
    }

    @Override
    public int getTimeLimit() {
        return this.timeLimit;
    }

    @Override
    public void setTimeLimit(int timeLimit) {
        if (this.lock) {
            throw new IllegalStateException("EntryInfo is locked");
        }
        this.expirationTimeFlag = true;
        this.timeLimit = timeLimit;
        if (timeLimit > 0) {
            long ttlmsec = (long)timeLimit * 1000L;
            this.expirationTime = ttlmsec + System.currentTimeMillis();
        }
    }

    @Override
    public int getInactivity() {
        return this.inactivity;
    }

    @Override
    public void setInactivity(int inactivity) {
        if (this.lock) {
            throw new IllegalStateException("EntryInfo is locked");
        }
        this.inactivityFlag = true;
        this.inactivity = inactivity;
    }

    @Override
    public long getExpirationTime() {
        return this.expirationTime;
    }

    @Override
    public void setExpirationTime(long expirationTime) {
        if (this.lock) {
            throw new IllegalStateException("EntryInfo is locked");
        }
        this.expirationTimeFlag = true;
        this.expirationTime = expirationTime;
        this.timeLimit = (int)((expirationTime - System.currentTimeMillis()) / 1000L);
    }

    @Override
    public long getValidatorExpirationTime() {
        return this.validatorExpirationTime;
    }

    public void setValidatorExpirationTime(long validatorExpirationTime) {
        if (this.lock) {
            throw new IllegalStateException("EntryInfo is locked");
        }
        this.validatorExpirationTime = validatorExpirationTime;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int priority) {
        if (this.lock) {
            throw new IllegalStateException("EntryInfo is locked");
        }
        this.priorityFlag = true;
        this.priority = priority;
    }

    public boolean wasPrioritySet() {
        return this.priorityFlag;
    }

    @Override
    public Enumeration getTemplates() {
        return this.templates.elements();
    }

    @Override
    public String getTemplate() {
        return (String)this.templates.getOne();
    }

    @Override
    public void addTemplate(String template) {
        if (this.lock) {
            throw new IllegalStateException("EntryInfo is locked");
        }
        if (template != null && !template.equals("")) {
            this.templates.add(template);
        }
    }

    @Override
    public Enumeration getDataIds() {
        return this.dataIds.elements();
    }

    @Override
    public void addDataId(String dataId) {
        this.addDataId((Object)dataId);
    }

    public void addDataId(Object dataId) {
        if (this.lock) {
            throw new IllegalStateException("EntryInfo is locked");
        }
        if (dataId != null && !dataId.equals("")) {
            this.dataIds.add(dataId);
        }
    }

    public void unionDependencies(com.ibm.websphere.cache.EntryInfo eInfo) {
        EntryInfo entryInfo = (EntryInfo)eInfo;
        if (entryInfo == this) {
            return;
        }
        if (this.lock) {
            throw new IllegalStateException("EntryInfo is locked");
        }
        this.dataIds.union(entryInfo.dataIds);
        this.templates.union(entryInfo.templates);
        if (entryInfo.id != null) {
            this.dataIds.add(entryInfo.id);
        }
        if (this.expirationTimeFlag) {
            this.setTimeLimit(entryInfo.timeLimit);
        } else if (entryInfo.timeLimit == -1 || entryInfo.timeLimit != -1 && entryInfo.timeLimit < this.timeLimit) {
            this.timeLimit = entryInfo.timeLimit;
        }
        if (this.inactivityFlag) {
            this.setInactivity(entryInfo.inactivity);
        } else if (entryInfo.inactivity == -1 || entryInfo.inactivity != -1 && entryInfo.inactivity < this.inactivity) {
            this.inactivity = entryInfo.inactivity;
        }
    }

    final void lock() {
        this.lock = true;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public Enumeration getAliasList() {
        return this.aliasList.elements();
    }

    @Override
    public void addAlias(Object alias) {
        if (this.lock) {
            throw new IllegalStateException("EntryInfo is locked");
        }
        if (alias != null && !alias.equals("")) {
            this.aliasList.add(alias);
        }
    }

    @Override
    public Object getUserMetaData() {
        return this.userMetaData;
    }

    @Override
    public void setUserMetaData(Object userMetaData) {
        if (this.lock) {
            throw new IllegalStateException("EntryInfo is locked");
        }
        this.userMetaData = userMetaData;
    }

    public static EntryInfoPool createEntryInfoPool(String poolName, int size) {
        String methodName = "createEntryInfoPool()";
        EntryInfoPool pool = new EntryInfoPool(poolName, size);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("createEntryInfoPool() poolName=" + poolName), (Object[])new Object[0]);
        }
        return pool;
    }

    public void returnToPool() {
        EntryInfoPool eip = this.entryInfoPool;
        assert (this.entryInfoPool != null);
        this.reset();
        eip.add(this);
    }

    @Override
    public int getCacheType() {
        return this.cacheType;
    }

    public void setCacheType(int cacheType) {
        this.cacheType = cacheType;
    }

    public void copyMetadata(CacheEntry cacheEntry) {
        int i;
        this.id = cacheEntry.id;
        this.timeLimit = cacheEntry.timeLimit;
        this.inactivity = cacheEntry.inactivity;
        this.expirationTime = cacheEntry.expirationTime;
        this.validatorExpirationTime = cacheEntry.validatorExpirationTime;
        this.priority = cacheEntry.priority;
        for (i = 0; i < cacheEntry._templates.length; ++i) {
            this.templates.add(cacheEntry._templates[i]);
        }
        for (i = 0; i < cacheEntry._dataIds.length; ++i) {
            this.dataIds.add(cacheEntry._dataIds[i]);
        }
        for (i = 0; i < cacheEntry.aliasList.length; ++i) {
            this.aliasList.add(cacheEntry.aliasList[i]);
        }
        this.sharingPolicy = cacheEntry.sharingPolicy;
        this.persistToDisk = cacheEntry.persistToDisk;
        this.userMetaData = cacheEntry.userMetaData;
        this.cacheType = cacheEntry.cacheType;
        this.externalCacheGroupId = cacheEntry.externalCacheGroupId;
    }

    public void setExternalCacheGroupId(String externalCacheGroup) {
        this.externalCacheGroupId = externalCacheGroup;
    }

    public String getExternalCacheGroupId() {
        return this.externalCacheGroupId;
    }

    static class EntryInfoPool
    extends ObjectPool {
        private boolean disableDependencyId = false;
        private String poolName = null;

        public EntryInfoPool(String poolName, int size) {
            super(poolName, size);
            this.poolName = poolName;
        }

        public Object createObject() {
            EntryInfo ei = new EntryInfo();
            ei.reset();
            return ei;
        }

        public EntryInfo allocate(Object key, Object[] dependencyIds, Object[] aliasIds) {
            int i;
            EntryInfo ei = (EntryInfo)this.remove();
            ei.entryInfoPool = this;
            ei.setId(key);
            if (dependencyIds != null && !this.disableDependencyId) {
                for (i = 0; i < dependencyIds.length; ++i) {
                    ei.addDataId(dependencyIds[i]);
                }
            }
            if (aliasIds != null) {
                for (i = 0; i < aliasIds.length; ++i) {
                    ei.addAlias(aliasIds[i]);
                }
            }
            return ei;
        }

        public void setFeatures(DCacheConfig cacheConfig) {
            String methodName = "setFeatures()";
            this.disableDependencyId = cacheConfig.isDisableDependencyId();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("setFeatures() poolName=" + this.poolName + " disableDependencyId=" + this.disableDependencyId), (Object[])new Object[0]);
            }
        }
    }
}

