/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache;

import com.ibm.websphere.cache.CacheLocal;
import com.ibm.websphere.cache.ChangeListener;
import com.ibm.websphere.cache.DistributedNioMapObject;
import com.ibm.websphere.cache.DistributedObjectCache;
import com.ibm.websphere.cache.InvalidationListener;
import com.ibm.websphere.cache.PreInvalidationListener;
import com.ibm.websphere.cache.exception.DiskCacheEntrySizeOverLimitException;
import com.ibm.websphere.cache.exception.DiskIOException;
import com.ibm.websphere.cache.exception.DiskOffloadNotEnabledException;
import com.ibm.websphere.cache.exception.DiskSizeInEntriesOverLimitException;
import com.ibm.websphere.cache.exception.DiskSizeOverLimitException;
import com.ibm.websphere.cache.exception.DynamicCacheException;
import com.ibm.websphere.cache.exception.MiscellaneousException;
import com.ibm.websphere.cache.exception.SerializationException;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.cache.CacheEntry;
import com.ibm.ws.cache.CacheProviderWrapper;
import com.ibm.ws.cache.EntryInfo;
import com.ibm.ws.cache.FreeLruEntryResult;
import com.ibm.ws.cache.intf.DCache;
import com.ibm.ws.cache.intf.DCacheConfig;
import com.ibm.ws.cache.util.ExceptionUtility;
import com.ibm.ws.cache.util.ValidateUtility;
import com.ibm.ws.ffdc.FFDCFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DistributedObjectCacheAdapter
extends DistributedObjectCache
implements CacheLocal {
    protected static final boolean IS_UNIT_TEST = false;
    private static TraceComponent tc = Tr.register(DistributedObjectCacheAdapter.class, (String)"WebSphere Dynamic Cache", (String)"com.ibm.ws.cache.resources.dynacache");
    private static final boolean INCREMENT_REF_COUNT = true;
    private static final boolean SKIP_MEMORY_WRITE_TO_DISK = true;
    private static final Object[] NULL_ALIASIDs = null;
    private static final Object[] NULL_DEPIDs = null;
    protected DCache cache = null;
    protected String cacheName = null;
    protected String myTemplate = null;
    protected int sharingPolicy = 1;
    protected int timeToLive = -1;
    protected int priority = -1;
    protected EntryInfo.EntryInfoPool entryInfoPool = null;
    protected CacheEntry.CacheEntryPool cacheEntryPool = null;
    protected int mapType = -1;
    protected String transactionIdPrefix = null;
    protected boolean useLockManager = false;
    protected static final String LOCK_MANAGER_DISABLED = "Lock Manager is disabled";
    protected static final String INVALID_ARGUMENTS = "Invalid arguments";
    private DCacheConfig cacheConfig = null;

    private DistributedObjectCacheAdapter() {
    }

    protected DistributedObjectCacheAdapter(DCache cache, int mapType) {
        String methodName = "DistributedObjectCacheAdapter() - CTOR";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("DistributedObjectCacheAdapter() - CTOR " + cache.getCacheName() + " Cache=" + cache + " CacheConfig=" + cache.getCacheConfig() + " enableReplication=" + cache.getCacheConfig().isEnableCacheReplication()), (Object[])new Object[0]);
        }
        this.cache = cache;
        this.cacheName = cache.getCacheName();
        this.cacheConfig = cache.getCacheConfig();
        this.transactionIdPrefix = this.cacheConfig.getServerNodeName() + "." + this.cacheConfig.getServerServerName() + ".";
        this.myTemplate = this.transactionIdPrefix + this.cacheName;
        this.setMapType(mapType);
        this.setSharingPolicy(this.cacheConfig.getDefaultShareType());
        this.createMapSpecificObjects();
        if (this.entryInfoPool != null) {
            this.entryInfoPool.setFeatures(this.cacheConfig);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("DistributedObjectCacheAdapter() - CTOR Adapter Impl=" + this), (Object[])new Object[0]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("DistributedObjectCacheAdapter() - CTOR MapType:" + mapType));
        }
    }

    protected void finalize() {
        String methodName = "finalize";
        this.destroyMapSpecificObjects();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("finalize Object destroyed:" + this), (Object[])new Object[0]);
        }
    }

    protected void createMapSpecificObjects() {
        throw new RuntimeException("You must override this method!!");
    }

    protected void destroyMapSpecificObjects() {
        throw new RuntimeException("You must override this method!!");
    }

    @Override
    public final int getMapType() {
        return this.mapType;
    }

    public final String getTransactionIdPrefix() {
        return this.transactionIdPrefix;
    }

    @Override
    public final void setSharingPolicy(int sharingPolicy) {
        ValidateUtility.sharingPolicy(sharingPolicy);
        this.sharingPolicy = sharingPolicy;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setSharingPolicy() set global sharingPolicy to " + this.sharingPolicy + " for cacheName=" + this.cache.getCacheName()), (Object[])new Object[0]);
        }
    }

    @Override
    public final void setDRSBootstrap(boolean drsBootstrap) {
        this.cache.getCacheConfig().setDrsBootstrapEnabled(drsBootstrap);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setDRSBootstrap() set DRSBootStrap to " + drsBootstrap + " for cacheName=" + this.cache.getCacheName()), (Object[])new Object[0]);
        }
    }

    @Override
    public final boolean isDRSBootstrapEnabled() {
        return this.cache.getCacheConfig().isDrsBootstrapEnabled();
    }

    @Override
    public final void setPriority(int priority) {
        ValidateUtility.priority(priority);
        this.priority = priority;
    }

    @Override
    public final void setTimeToLive(int timeToLive) {
        ValidateUtility.timeToLive(timeToLive);
        this.timeToLive = timeToLive;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setTimeToLive() set global timeToLive to " + timeToLive + " for cacheName=" + this.cache.getCacheName()), (Object[])new Object[0]);
        }
    }

    @Override
    public final int getSharingPolicy() {
        return this.sharingPolicy;
    }

    @Override
    public final int size() {
        return this.cache.getNumberCacheEntries();
    }

    @Override
    public int size(boolean includeDiskCache) {
        int mappings = 0;
        mappings = this.cache.getNumberCacheEntries();
        if (includeDiskCache) {
            if (this.cache instanceof CacheProviderWrapper) {
                CacheProviderWrapper cpw = (CacheProviderWrapper)this.cache;
                if (cpw.featureSupport.isDiskCacheSupported()) {
                    mappings += this.cache.getIdsSizeDisk();
                }
            } else {
                mappings += this.cache.getIdsSizeDisk();
            }
        }
        return mappings;
    }

    @Override
    public final boolean isEmpty() {
        return this.cache.getNumberCacheEntries() == 0;
    }

    @Override
    public boolean isEmpty(boolean includeDiskCache) {
        boolean isCacheEmpty = false;
        boolean bl = isCacheEmpty = this.cache.getNumberCacheEntries() == 0;
        if (includeDiskCache && isCacheEmpty) {
            if (this.cache instanceof CacheProviderWrapper) {
                if (((CacheProviderWrapper)this.cache).featureSupport.isDiskCacheSupported()) {
                    isCacheEmpty = this.cache.getIdsSizeDisk() == 0;
                }
            } else {
                isCacheEmpty = this.cache.getIdsSizeDisk() == 0;
            }
        }
        return isCacheEmpty;
    }

    @Override
    public final boolean containsKey(Object key) {
        ValidateUtility.objectNotNull(key, "key");
        return this.cache.containsCacheId(key);
    }

    @Override
    public boolean containsKey(Object key, boolean includeDiskCache) {
        ValidateUtility.objectNotNull(key, "key");
        boolean found = this.cache.containsCacheId(key);
        if (found) {
            return found;
        }
        if (includeDiskCache) {
            if (this.cache instanceof CacheProviderWrapper) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"containKey instanceof CacheProviderWrapper", (Object[])new Object[0]);
                }
                CacheProviderWrapper cpw = (CacheProviderWrapper)this.cache;
                if (cpw.featureSupport.isDiskCacheSupported()) {
                    found = this.cache.containsKeyDisk(key);
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"containKey not instanceof CacheProviderWrapper", (Object[])new Object[0]);
                }
                found = this.cache.containsKeyDisk(key);
            }
        }
        return found;
    }

    @Override
    public final boolean containsValue(Object value) {
        ValidateUtility.objectNotNull(value, "value");
        Enumeration vEnum = this.cache.getAllIds();
        while (vEnum.hasMoreElements()) {
            Object key = vEnum.nextElement();
            Object val = this.get(key);
            if (val != value && (val == null || !val.equals(value))) continue;
            return true;
        }
        return false;
    }

    public final void putAll(Map map) {
        ValidateUtility.objectNotNull(map, "map");
        for (Map.Entry e : map.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public final boolean equals(Object o) {
        return o == this;
    }

    @Override
    public final int hashCode() {
        return super.hashCode();
    }

    @Override
    public final void clear() {
        boolean waitOnInvalidation = true;
        this.cache.clear(waitOnInvalidation);
    }

    @Override
    public void clearMemory(boolean clearDisk) {
        this.cache.clearMemory(clearDisk);
    }

    @Override
    public Object get(Object key) {
        String methodName = "get(key)";
        return this.functionNotAvailable("get(key)");
    }

    protected final Object common_get(Object key) {
        ValidateUtility.objectNotNull(key, "key");
        Object value = this.cache.getValue(key, this.cache.shouldPull(this.sharingPolicy, key));
        return value;
    }

    @Override
    public com.ibm.websphere.cache.CacheEntry getCacheEntry(Object key) {
        String methodName = "getCacheEntry(key)";
        return (com.ibm.websphere.cache.CacheEntry)this.functionNotAvailable("getCacheEntry(key)");
    }

    protected final com.ibm.websphere.cache.CacheEntry common_getCacheEntry(Object key) {
        String methodName = "getCacheEntry(key)";
        ValidateUtility.objectNotNull(key, "key");
        EntryInfo ei = this.entryInfoPool.allocate(key, NULL_DEPIDs, NULL_ALIASIDs);
        ei.setSharingPolicy(this.sharingPolicy);
        com.ibm.websphere.cache.CacheEntry cacheEntry = this.cache.getEntry(ei, true);
        ei.returnToPool();
        if (tc.isDebugEnabled() && cacheEntry != null) {
            Tr.debug((TraceComponent)tc, (String)("getCacheEntry(key) " + this.cache.getCacheName() + " id=" + cacheEntry.getIdObject()), (Object[])new Object[0]);
        }
        return cacheEntry;
    }

    @Override
    public void put(Object key, Object value, Object userMetaData, int priority, int timeToLive, int sharingPolicy, Object[] dependencyIds, Object[] alias) {
        String methodName = "put(key,value,userMetaData...)";
        this.functionNotAvailable("put(key,value,userMetaData...)");
    }

    @Override
    public void put(Object key, Object value, Object userMetaData, int priority, int timeToLive, int inactivityTime, int sharingPolicy, Object[] dependencyIds, Object[] alias) {
        String methodName = "put(key,value,userMetaData...)";
        this.functionNotAvailable("put(key,value,userMetaData...)");
    }

    @Override
    public void put(Object key, Object value, Object userMetaData, int priority, int timeToLive, int inactivityTime, int sharingPolicy, Object[] dependencyIds, Object[] alias, boolean skipMemoryAndWriteToDisk) throws DynamicCacheException {
        String methodName = "put(key,value,userMetaData...)";
        this.functionNotAvailable("put(key,value,userMetaData...)");
    }

    @Override
    public com.ibm.websphere.cache.CacheEntry putAndGet(Object key, Object value, Object userMetaData, int priority, int timeToLive, int sharingPolicy, Object[] dependencyIds, Object[] alias) {
        String methodName = "putAndGet(key,value,userMetaData...)";
        return (com.ibm.websphere.cache.CacheEntry)this.functionNotAvailable("putAndGet(key,value,userMetaData...)");
    }

    @Override
    public com.ibm.websphere.cache.CacheEntry putAndGet(Object key, Object value, Object userMetaData, int priority, int timeToLive, int inactivityTime, int sharingPolicy, Object[] dependencyIds, Object[] alias) {
        String methodName = "putAndGet(key,value,userMetaData...)";
        return (com.ibm.websphere.cache.CacheEntry)this.functionNotAvailable("putAndGet(key,value,userMetaData...)");
    }

    protected final void common_put(Object key, Object value, Object userMetaData, int priority, int timeToLive, int sharingPolicy, Object[] dependencyIds, Object[] aliasIds) {
        block2: {
            try {
                this.internal_putAndGet(key, value, userMetaData, priority, timeToLive, -1, sharingPolicy, dependencyIds, aliasIds, false, false);
            }
            catch (DynamicCacheException ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.cache.DistribtedObjectCacheAdapter", (String)"669", (Object)this);
                if (!tc.isDebugEnabled()) break block2;
                Tr.debug((TraceComponent)tc, (String)("common_put - exception: " + ExceptionUtility.getStackTrace(ex)), (Object[])new Object[0]);
            }
        }
    }

    protected final void common_put(Object key, Object value, Object userMetaData, int priority, int timeToLive, int inactivityTime, int sharingPolicy, Object[] dependencyIds, Object[] aliasIds) {
        block2: {
            try {
                this.internal_putAndGet(key, value, userMetaData, priority, timeToLive, inactivityTime, sharingPolicy, dependencyIds, aliasIds, false, false);
            }
            catch (DynamicCacheException ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.cache.DistribtedObjectCacheAdapter", (String)"690", (Object)this);
                if (!tc.isDebugEnabled()) break block2;
                Tr.debug((TraceComponent)tc, (String)("common_put - exception: " + ExceptionUtility.getStackTrace(ex)), (Object[])new Object[0]);
            }
        }
    }

    protected final void common_put(Object key, Object value, Object userMetaData, int priority, int timeToLive, int inactivityTime, int sharingPolicy, Object[] dependencyIds, Object[] aliasIds, boolean skipMemoryAndWriteToDisk) throws DynamicCacheException {
        this.internal_putAndGet(key, value, userMetaData, priority, timeToLive, inactivityTime, sharingPolicy, dependencyIds, aliasIds, false, skipMemoryAndWriteToDisk);
    }

    protected final com.ibm.websphere.cache.CacheEntry common_putAndGet(Object key, Object value, Object userMetaData, int priority, int timeToLive, int sharingPolicy, Object[] dependencyIds, Object[] aliasIds) {
        try {
            return this.internal_putAndGet(key, value, userMetaData, priority, timeToLive, -1, sharingPolicy, dependencyIds, aliasIds, true, false);
        }
        catch (DynamicCacheException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.cache.DistribtedObjectCacheAdapter", (String)"724", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("common_putAndGet - exception: " + ExceptionUtility.getStackTrace(ex)), (Object[])new Object[0]);
            }
            return null;
        }
    }

    protected final com.ibm.websphere.cache.CacheEntry common_putAndGet(Object key, Object value, Object userMetaData, int priority, int timeToLive, int inactivityTime, int sharingPolicy, Object[] dependencyIds, Object[] aliasIds) {
        try {
            return this.internal_putAndGet(key, value, userMetaData, priority, timeToLive, inactivityTime, sharingPolicy, dependencyIds, aliasIds, true, false);
        }
        catch (DynamicCacheException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.cache.DistribtedObjectCacheAdapter", (String)"745", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("common_putAndGet - exception: " + ExceptionUtility.getStackTrace(ex)), (Object[])new Object[0]);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final com.ibm.websphere.cache.CacheEntry internal_putAndGet(Object key, Object value, Object userMetaData, int priority, int timeToLive, int inactivityTime, int sharingPolicy, Object[] dependencyIds, Object[] aliasIds, boolean incrementRefCount, boolean skipMemoryAndWriteToDisk) throws DynamicCacheException {
        String methodName = "putAndGet(..)";
        ValidateUtility.objectNotNull(key, "key", value, "value");
        if (skipMemoryAndWriteToDisk && !this.cache.getSwapToDisk()) {
            throw new DiskOffloadNotEnabledException("DiskOffloadNotEnabledException occurred. The disk offload feature for cache instance \"" + this.cache.getCacheName() + "\" is not enabled.");
        }
        if (skipMemoryAndWriteToDisk && sharingPolicy != 1) {
            Tr.warning((TraceComponent)tc, (String)"DYNA1072W", (Object[])new Object[]{key});
            sharingPolicy = 1;
        }
        ValidateUtility.sharingPolicy(sharingPolicy);
        if (sharingPolicy == 4 || sharingPolicy == 3) {
            this.invalidate(key, true);
        }
        EntryInfo ei = this.entryInfoPool.allocate(key, dependencyIds, aliasIds);
        ei.setUserMetaData(userMetaData);
        ei.setPriority(priority);
        ei.setTimeLimit(timeToLive);
        ei.setSharingPolicy(sharingPolicy);
        ei.setInactivity(inactivityTime);
        CacheEntry ce = this.cacheEntryPool.allocate();
        ce.copyMetaData(ei);
        ce.setValue(value);
        ce.setSkipMemoryAndWriteToDisk(skipMemoryAndWriteToDisk);
        if (value instanceof DistributedNioMapObject) {
            ce.useByteBuffer = true;
        }
        com.ibm.websphere.cache.CacheEntry newEntry = this.cache.setEntry(ce, 5, false, true, incrementRefCount);
        ei.returnToPool();
        try {
            if (!this.cache.getCacheConfig().isDefaultCacheProvider()) return newEntry;
            if (tc.isDebugEnabled() && newEntry != null) {
                Tr.debug((TraceComponent)tc, (String)("putAndGet(..) " + this.cache.getCacheName() + " id=" + newEntry.getIdObject() + " incRefCount=" + incrementRefCount + " skipMemoryWriteToDisk=" + skipMemoryAndWriteToDisk), (Object[])new Object[0]);
            }
            if (!ce.skipMemoryAndWriteToDisk) return newEntry;
            int errorCode = ce.skipMemoryAndWriteToDiskErrorCode;
            StringBuffer message = new StringBuffer();
            Exception ex = null;
            switch (errorCode) {
                case 0: {
                    return newEntry;
                }
                case 1: {
                    message.append("The disk IO exception has occurred when writing cache ID: ");
                    message.append(ce.id);
                    message.append(" to the disk cache. ");
                    ex = this.cache.getDiskCacheException();
                    if (ex == null) throw new DiskIOException(message.toString());
                    message.append(ex.getMessage());
                    throw new DiskIOException(message.toString());
                }
                case 2: {
                    message.append("Exception has occurred either (1) there is no disk space available, or (2) the disk cache size in GB s over the (diskCacheSizeInGB) limit when writing cache ID: ");
                    message.append(ce.id);
                    message.append(" to the disk cache. ");
                    ex = this.cache.getDiskCacheException();
                    if (ex == null) throw new DiskSizeOverLimitException(message.toString());
                    message.append(ex.getMessage());
                    throw new DiskSizeOverLimitException(message.toString());
                }
                case 3: {
                    message.append("The runtime exception other than a Disk IOException has occurred when writing cache ID: ");
                    message.append(ce.id);
                    message.append(" to the disk cache. ");
                    ex = this.cache.getDiskCacheException();
                    if (ex == null) throw new MiscellaneousException(message.toString());
                    message.append(ex.getMessage());
                    throw new MiscellaneousException(message.toString());
                }
                case 4: {
                    message.append("The serialization exception has occurred when writing cache ID: ");
                    message.append(ce.id);
                    message.append(" to the disk cache. ");
                    throw new SerializationException(message.toString());
                }
                case 5: {
                    message.append("The disk cache size in entries is over the (diskCacheSize) limit when writing cache ID: ");
                    message.append(ce.id);
                    message.append(" to the disk cache. ");
                    throw new DiskSizeInEntriesOverLimitException(message.toString());
                }
                case 6: {
                    message.append("The cache entry size is over the configured disk cache entry size (diskCacheEntrySizeInMB) limit when writing cache ID: ");
                    message.append(ce.id);
                    message.append(" to the disk cache. ");
                    throw new DiskCacheEntrySizeOverLimitException(message.toString());
                }
            }
            return newEntry;
        }
        finally {
            ce.serializedValue = null;
            ce.value = null;
            ce.returnToPool();
        }
    }

    @Override
    public void addAlias(Object key, Object[] aliasArray) {
        String methodName = "addAlias(key, aliasArray)";
        this.functionNotAvailable("addAlias(key, aliasArray)");
    }

    protected final void common_addAlias(Object key, Object[] aliasArray) {
        ValidateUtility.objectNotNull(key, "key", aliasArray, "aliasArray");
        this.cache.addAlias(key, aliasArray, this.cache.shouldPull(this.sharingPolicy, key), true);
    }

    @Override
    public void removeAlias(Object alias) {
        String methodName = "removeAlias( alias )";
        this.functionNotAvailable("removeAlias( alias )");
    }

    protected final void common_removeAlias(Object alias) {
        ValidateUtility.objectNotNull(alias, "alias");
        this.cache.removeAlias(alias, this.cache.shouldPull(this.sharingPolicy, alias), true);
    }

    @Override
    public void releaseLruEntries(int numOfEntries) {
        String methodName = "releaseLruEntries(numOfEntries)";
        this.functionNotAvailable("releaseLruEntries(numOfEntries)");
    }

    protected final void common_releaseLruEntries(int numOfEntries) {
        if (numOfEntries > 0) {
            int entriesRemoved = 0;
            for (int i = 0; i < numOfEntries; ++i) {
                FreeLruEntryResult result = this.cache.freeLruEntry();
                if (!result.success) break;
                ++entriesRemoved;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("releaseLruEntries(): cacheName=" + this.cacheName + " entriesToRemove=" + numOfEntries + " entriesRemoved=" + entriesRemoved), (Object[])new Object[0]);
            }
        }
    }

    @Override
    public Object put(Object key, Object value) {
        String methodName = "put(key, value)";
        return this.functionNotAvailable("put(key, value)");
    }

    protected final Object common_put(Object key, Object value) {
        EntryInfo ei = this.entryInfoPool.allocate(key, NULL_DEPIDs, NULL_DEPIDs);
        ei.setTimeLimit(this.timeToLive);
        ei.setSharingPolicy(this.sharingPolicy);
        Object retValue = this.cache.invalidateAndSet(ei, value, this.cache.getCacheConfig().isEnableCacheReplication());
        ei.returnToPool();
        return retValue;
    }

    @Override
    public Object put(Object key, Object value, int priority, int timeToLive, int sharingPolicy, Object[] dependencyIds) {
        String methodName = "put(key, value, priority, timeToLive, sharingPolicy, dependencyIds)";
        return this.functionNotAvailable("put(key, value, priority, timeToLive, sharingPolicy, dependencyIds)");
    }

    protected Object common_put(Object key, Object value, int priority, int timeToLive, int sharingPolicy, Object[] dependencyIds) {
        return this.common_put(key, value, priority, timeToLive, -1, sharingPolicy, dependencyIds);
    }

    @Override
    public Object put(Object key, Object value, int priority, int timeToLive, int inactivityTime, int sharingPolicy, Object[] dependencyIds) {
        String methodName = "put(key, value, priority, timeToLive, inactivityTime, sharingPolicy, dependencyIds)";
        return this.functionNotAvailable("put(key, value, priority, timeToLive, inactivityTime, sharingPolicy, dependencyIds)");
    }

    protected Object common_put(Object key, Object value, int priority, int timeToLive, int inactivityTime, int sharingPolicy, Object[] dependencyIds) {
        EntryInfo ei = this.entryInfoPool.allocate(key, dependencyIds, NULL_ALIASIDs);
        ei.setPriority(priority);
        ei.setTimeLimit(timeToLive);
        if (inactivityTime != -1) {
            ei.setInactivity(inactivityTime);
        }
        ei.setSharingPolicy(sharingPolicy);
        Object retValue = this.cache.invalidateAndSet(ei, value, this.cache.getCacheConfig().isEnableCacheReplication());
        ei.returnToPool();
        return retValue;
    }

    @Override
    public void invalidate(Object key) {
        String methodName = "invalidate(key)";
        this.functionNotAvailable("invalidate(key)");
    }

    protected void common_invalidate(Object key) {
        ValidateUtility.objectNotNull(key, "key");
        this.cache.invalidateById(key, true);
    }

    @Override
    public void invalidate(Object key, boolean wait) {
        String methodName = "invalidate(key, wait)";
        this.functionNotAvailable("invalidate(key, wait)");
    }

    protected void common_invalidate(Object key, boolean waitOnInvalidation) {
        ValidateUtility.objectNotNull(key, "key");
        this.cache.invalidateById(key, waitOnInvalidation);
    }

    @Override
    public void invalidate(Object key, boolean wait, boolean checkPreInvalidationListener) {
        String methodName = "invalidate(key, wait, checkPreInvalidationListener)";
        this.functionNotAvailable("invalidate(key, wait, checkPreInvalidationListener)");
    }

    protected void common_invalidate(Object key, boolean waitOnInvalidation, boolean checkPreInvalidationListener) {
        ValidateUtility.objectNotNull(key, "key");
        this.cache.invalidateById(key, waitOnInvalidation, checkPreInvalidationListener);
    }

    public Object remove(Object key) {
        String methodName = "remove(key)";
        return this.functionNotAvailable("remove(key)");
    }

    protected Object common_remove(Object key) {
        ValidateUtility.objectNotNull(key, "key");
        Object old = this.get(key);
        this.cache.invalidateById(key, true);
        return old;
    }

    public Set keySet() {
        String methodName = "keySet()";
        this.functionNotAvailable("keySet()");
        return null;
    }

    protected Set common_keySet() {
        return this.cache.getCacheIds();
    }

    @Override
    public Set keySet(boolean includeDiskCache) {
        String methodName = "keySet(boolean)";
        this.functionNotAvailable("keySet(boolean)");
        return null;
    }

    protected Set common_keySet(boolean includeDiskCache) {
        Set cacheIds = this.cache.getCacheIds();
        if (this.cache instanceof CacheProviderWrapper) {
            includeDiskCache = ((CacheProviderWrapper)this.cache).featureSupport.isDiskCacheSupported();
        }
        if (includeDiskCache && this.cache.getIdsSizeDisk() > 0) {
            int index = 0;
            boolean more = true;
            Set cacheIdsDisk = null;
            do {
                if ((cacheIdsDisk = this.cache.getIdsByRangeDisk(index, 100)) != null) {
                    cacheIds.addAll(cacheIdsDisk);
                    if (!cacheIdsDisk.contains("DISKCACHE_MORE")) {
                        more = false;
                    }
                } else {
                    more = false;
                }
                index = 1;
            } while (more);
            cacheIds.remove("DISKCACHE_MORE");
        }
        return cacheIds;
    }

    public Collection values() {
        String methodName = "values()";
        this.functionNotAvailable("values()");
        return null;
    }

    protected final Collection common_values() {
        ArrayList<Object> al = new ArrayList<Object>();
        Enumeration vEnum = this.cache.getAllIds();
        while (vEnum.hasMoreElements()) {
            al.add(this.get(vEnum.nextElement()));
        }
        return al;
    }

    public Set entrySet() {
        String methodName = "values()";
        this.functionNotAvailable("values()");
        return null;
    }

    protected final Set common_entrySet() {
        HashSet<DMIEntry> hs = new HashSet<DMIEntry>();
        Enumeration vEnum = this.cache.getAllIds();
        while (vEnum.hasMoreElements()) {
            Object key = vEnum.nextElement();
            hs.add(new DMIEntry(key, this.get(key)));
        }
        return hs;
    }

    @Override
    public boolean enableListener(boolean enable) {
        String methodName = "enableListener(enable)";
        this.functionNotAvailable("enableListener(enable)");
        return false;
    }

    protected final boolean common_enableListener(boolean enable) {
        return this.cache.enableListener(enable);
    }

    @Override
    public boolean addInvalidationListener(InvalidationListener listener) {
        String methodName = "addInvalidationListener(listener)";
        this.functionNotAvailable("addInvalidationListener(listener)");
        return false;
    }

    protected final boolean common_addInvalidationListener(InvalidationListener listener) {
        if (listener != null) {
            return this.cache.addInvalidationListener(listener);
        }
        return false;
    }

    @Override
    public boolean removeInvalidationListener(InvalidationListener listener) {
        String methodName = "removeInvalidationListener(listener)";
        this.functionNotAvailable("removeInvalidationListener(listener)");
        return false;
    }

    protected final boolean common_removeInvalidationListener(InvalidationListener listener) {
        if (listener != null) {
            return this.cache.removeInvalidationListener(listener);
        }
        return false;
    }

    @Override
    public boolean addChangeListener(ChangeListener listener) {
        String methodName = "addChangeListener(listener)";
        this.functionNotAvailable("addChangeListener(listener)");
        return false;
    }

    protected final boolean common_addChangeListener(ChangeListener listener) {
        if (listener != null) {
            return this.cache.addChangeListener(listener);
        }
        return false;
    }

    @Override
    public boolean removeChangeListener(ChangeListener listener) {
        String methodName = "removeChangeListener(listener)";
        this.functionNotAvailable("removeChangeListener(listener)");
        return false;
    }

    protected final boolean common_removeChangeListener(ChangeListener listener) {
        if (listener != null) {
            return this.cache.removeChangeListener(listener);
        }
        return false;
    }

    @Override
    public boolean addPreInvalidationListener(PreInvalidationListener listener) {
        String methodName = "addPreInvalidationListener(listener)";
        this.functionNotAvailable("addPreInvalidationListener(listener)");
        return false;
    }

    protected final boolean common_addPreInvalidationListener(PreInvalidationListener listener) {
        if (listener != null) {
            return this.cache.addPreInvalidationListener(listener);
        }
        return false;
    }

    @Override
    public boolean removePreInvalidationListener(PreInvalidationListener listener) {
        String methodName = "removePreInvalidationListener(listener)";
        this.functionNotAvailable("removePreInvalidationListener(listener)");
        return false;
    }

    protected final boolean common_removePreInvalidationListener(PreInvalidationListener listener) {
        if (listener != null) {
            return this.cache.removePreInvalidationListener(listener);
        }
        return false;
    }

    private void setMapType(int mapType) {
        String methodName = "setMapType";
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setMapType " + this.cache.getCacheName() + " MapTypeOld:" + this.mapType + " MapTypeNew:" + mapType), (Object[])new Object[0]);
        }
        this.mapType = mapType;
    }

    private Object functionNotAvailable(String method) {
        throw new RuntimeException(method + " not implemented in " + this);
    }

    public DCache getCache() {
        return this.cache;
    }

    class DMIEntry
    implements Map.Entry {
        Object key;
        Object value;

        DMIEntry(Object key, Object value) {
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object value) {
            throw new UnsupportedOperationException();
        }
    }
}

