/*
 * Decompiled with CFR 0.152.
 */
package wlp.lib.extract.platform;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import wlp.lib.extract.ReturnCode;
import wlp.lib.extract.SelfExtract;
import wlp.lib.extract.platform.AbstractPlatformPolicyFactory;
import wlp.lib.extract.platform.PlatformUtils;

class PPPlatformUtils
extends AbstractPlatformPolicyFactory {
    static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle(SelfExtract.class.getName() + "Messages");
    private static final PPPlatformUtils INSTANCE = new PPPlatformUtils();

    PPPlatformUtils() {
    }

    @Override
    protected Object createLinuxPolicy() {
        return new PPLinux();
    }

    @Override
    protected Object createSolarisPolicy() {
        return new PPSolaris();
    }

    @Override
    protected Object createWindowsPolicy() {
        return new PPWindows();
    }

    @Override
    protected Object createZOSPolicy() {
        return new PPZOS();
    }

    @Override
    protected Object createOS400Policy() {
        return new PPOS400();
    }

    @Override
    protected Object createMACOSPolicy() {
        return new PPMACOS();
    }

    static PPCommon getPolicy() {
        return (PPCommon)INSTANCE.getPlatformPolicy();
    }

    class PPMACOS
    extends PPLinux {
        PPMACOS() {
        }
    }

    class PPOS400
    extends PPLinux {
        PPOS400() {
        }
    }

    class PPZOS
    extends PPLinux {
        static final String DEFAULT_EBCDIC_CODESET = "IBM-1047";
        private final String[] extattr_locations;
        private final String[] chcp_locations;
        private String systemASCII;
        private String systemEBCDIC;

        PPZOS() {
            this.extattr_locations = new String[]{"/bin/extattr", "/usr/bin/extattr"};
            this.chcp_locations = new String[]{"/bin/chcp", "/usr/bin/chcp"};
            this.systemASCII = null;
            this.systemEBCDIC = null;
        }

        @Override
        ReturnCode extattr(String[] fileList, String attr) throws IOException {
            if (null == attr || "".equals(attr)) {
                return ReturnCode.OK;
            }
            if (!this.validateExtAttrArgs(attr)) {
                return new ReturnCode(3, "ERROR_INVALID_EXTATTR_PARMS", new String[]{attr});
            }
            String extattrCmd = this.getCmdLocation(this.extattr_locations);
            if ("".equals(extattrCmd)) {
                return new ReturnCode(1, "ERROR_UNABLE_TO_LOCATE_COMMAND_EXE", new String[]{"extattr", this.convertListToString(Arrays.asList(this.extattr_locations), ", ")});
            }
            String[] attrArgs = attr.split(" ");
            return this.runCommand(extattrCmd, fileList, attrArgs);
        }

        boolean validateExtAttrArgs(String attr) {
            boolean valid = attr.length() <= 7 && attr.length() >= 2 && attr.indexOf("a") == attr.lastIndexOf("a") && attr.indexOf("p") == attr.lastIndexOf("p") && attr.indexOf("s") == attr.lastIndexOf("s") && attr.indexOf("l") == attr.lastIndexOf("l");
            return valid && attr.matches("^[+-][alps]{1,4}([\\s][+-][alps]{1,4})?$");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ReturnCode getSystemASCIIandEBCDICvalues() throws IOException {
            String chcpCmd = this.getCmdLocation(this.chcp_locations);
            if ("".equals(chcpCmd)) {
                return new ReturnCode(1, "ERROR_UNABLE_TO_LOCATE_COMMAND_EXE", new String[]{"chcp", this.convertListToString(Arrays.asList(this.chcp_locations), ", ")});
            }
            ArrayList<String> chcpCmdList = new ArrayList<String>();
            chcpCmdList.add(chcpCmd);
            chcpCmdList.add("-q");
            int returnStatus = 0;
            StringWriter err = new StringWriter();
            StringWriter out = new StringWriter();
            returnStatus = PlatformUtils.executeCommand(chcpCmdList.toArray(new String[chcpCmdList.size()]), null, null, out, err);
            if (returnStatus != 0) {
                return new ReturnCode(4, "ERROR_EXECUTING_COMMAND", new String[]{this.convertListToString(chcpCmdList, " "), Integer.toString(returnStatus), ((Object)err).toString()});
            }
            if (((Object)out).toString().length() > 0) {
                String ascii_regex = "^.*ASCII.*:\\s*(.*)$";
                String ebcdic_regex = "^.*EBCDIC.*:\\s*(.*)$";
                Pattern pa = Pattern.compile(ascii_regex);
                Pattern pe = Pattern.compile(ebcdic_regex);
                Scanner chcpOutput = null;
                try {
                    chcpOutput = new Scanner(((Object)out).toString());
                    while (chcpOutput.hasNext()) {
                        String line = chcpOutput.nextLine();
                        Matcher ma = pa.matcher(line);
                        Matcher me = pe.matcher(line);
                        if (ma.matches()) {
                            this.systemASCII = ma.group(1);
                            continue;
                        }
                        if (!me.matches()) continue;
                        this.systemEBCDIC = me.group(1);
                    }
                }
                finally {
                    if (null != chcpOutput) {
                        chcpOutput.close();
                    }
                }
            }
            return ReturnCode.OK;
        }

        private void setASCIIandEBCDICvalues() {
            String termPath = System.getenv("_BPX_TERMPATH");
            if (!"OMVS".equalsIgnoreCase(termPath)) {
                try {
                    this.getSystemASCIIandEBCDICvalues();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (null == this.systemASCII) {
                this.systemASCII = "ASCII";
            }
            if (null == this.systemEBCDIC) {
                this.systemEBCDIC = DEFAULT_EBCDIC_CODESET;
            }
        }

        @Override
        String getASCIISystemCharSet() {
            if (null == this.systemASCII) {
                this.setASCIIandEBCDICvalues();
            }
            return this.systemASCII;
        }

        @Override
        String getEBCIDICSystemCharSet() {
            if (null == this.systemEBCDIC) {
                this.setASCIIandEBCDICvalues();
            }
            return this.systemEBCDIC;
        }
    }

    class PPHpux
    extends PPLinux {
        PPHpux() {
        }
    }

    class PPAix
    extends PPLinux {
        PPAix() {
        }
    }

    class PPSolaris
    extends PPLinux {
        PPSolaris() {
        }
    }

    class PPLinux
    extends PPCommon {
        private final String[] chmod_locations;

        PPLinux() {
            this.chmod_locations = new String[]{"/bin/chmod", "/usr/bin/chmod"};
        }

        @Override
        int getUmask() throws IOException {
            String shellCommand = this.getCmdLocation(new String[]{"/bin/bash", "/bin/sh"});
            if ("".equals(shellCommand)) {
                throw new IOException(MessageFormat.format(RESOURCE_BUNDLE.getString("ERROR_UNABLE_TO_LOCATE_COMMAND_EXE"), "sh", "/bin/sh"));
            }
            ArrayList<String> umaskCmdList = new ArrayList<String>();
            umaskCmdList.add(shellCommand);
            umaskCmdList.add("-c");
            umaskCmdList.add("umask");
            int returnStatus = 0;
            StringWriter err = new StringWriter();
            StringWriter out = new StringWriter();
            returnStatus = PlatformUtils.executeCommand(umaskCmdList.toArray(new String[umaskCmdList.size()]), null, null, out, err);
            if (returnStatus != 0) {
                throw new IOException(MessageFormat.format(RESOURCE_BUNDLE.getString("ERROR_EXECUTING_COMMAND"), this.convertListToString(umaskCmdList, " "), Integer.toString(returnStatus), ((Object)err).toString()));
            }
            if (((Object)out).toString().length() == 0) {
                throw new IOException(MessageFormat.format(RESOURCE_BUNDLE.getString("ERROR_UNABLE_TO_GET_UMASK"), this.convertListToString(umaskCmdList, " ")));
            }
            String umask = ((Object)out).toString().trim();
            try {
                return Integer.parseInt(umask, 8);
            }
            catch (NumberFormatException e) {
                return this.parseSymbolicUmask(umask);
            }
        }

        private int parseSymbolicUmask(String umask) {
            int octalUmask = 511;
            umask.toLowerCase(Locale.ENGLISH);
            String[] perms = umask.split(",");
            block5: for (int i = 0; i < perms.length; ++i) {
                switch (perms[i].charAt(0)) {
                    case 'u': {
                        if (perms[i].contains("r")) {
                            octalUmask -= 256;
                        }
                        if (perms[i].contains("w")) {
                            octalUmask -= 128;
                        }
                        if (!perms[i].contains("x")) continue block5;
                        octalUmask -= 64;
                        continue block5;
                    }
                    case 'g': {
                        if (perms[i].contains("r")) {
                            octalUmask -= 32;
                        }
                        if (perms[i].contains("w")) {
                            octalUmask -= 16;
                        }
                        if (!perms[i].contains("x")) continue block5;
                        octalUmask -= 8;
                        continue block5;
                    }
                    case 'o': {
                        if (perms[i].contains("r")) {
                            octalUmask -= 4;
                        }
                        if (perms[i].contains("w")) {
                            octalUmask -= 2;
                        }
                        if (!perms[i].contains("x")) continue block5;
                        --octalUmask;
                        continue block5;
                    }
                }
            }
            return octalUmask;
        }

        @Override
        ReturnCode chmod(String[] fileList, String perm) throws IOException {
            String chmodCmd = this.getCmdLocation(this.chmod_locations);
            if (null == perm || "".equals(perm)) {
                return ReturnCode.OK;
            }
            if ("".equals(chmodCmd)) {
                return new ReturnCode(1, "ERROR_UNABLE_TO_LOCATE_COMMAND_EXE", new String[]{"chmod", this.convertListToString(Arrays.asList(this.chmod_locations), ", ")});
            }
            return this.runCommand(chmodCmd, fileList, new String[]{perm});
        }

        String getCmdLocation(String[] cmdLocations) {
            String cmdLocation = null;
            for (int i = 0; i < cmdLocations.length; ++i) {
                if (!new File(cmdLocations[i]).exists()) continue;
                cmdLocation = cmdLocations[i];
                break;
            }
            return cmdLocation;
        }

        @Override
        ReturnCode extattr(String[] fileList, String attr) throws IOException {
            return ReturnCode.OK;
        }

        @Override
        String getASCIISystemCharSet() {
            return "ASCII";
        }

        @Override
        String getEBCIDICSystemCharSet() {
            return null;
        }
    }

    class PPWindows
    extends PPCommon {
        PPWindows() {
        }

        @Override
        ReturnCode chmod(String[] fileList, String perm) {
            return ReturnCode.OK;
        }

        @Override
        int getUmask() {
            return 1024;
        }

        @Override
        ReturnCode extattr(String[] fileList, String attr) {
            return ReturnCode.OK;
        }

        @Override
        String getASCIISystemCharSet() {
            return "ASCII";
        }

        @Override
        String getEBCIDICSystemCharSet() {
            return null;
        }
    }

    abstract class PPCommon {
        static final String DEFAULT_ASCII_CODESET = "ASCII";

        PPCommon() {
        }

        abstract ReturnCode chmod(String[] var1, String var2) throws IOException;

        abstract ReturnCode extattr(String[] var1, String var2) throws IOException;

        abstract int getUmask() throws IOException;

        ReturnCode runCommand(String cmExe, String[] fileList, String[] cmdArgs) throws IOException {
            ArrayList<String> filePaths = new ArrayList<String>();
            for (int i = 0; i < fileList.length; ++i) {
                File file = new File(fileList[i]);
                if (!file.exists()) continue;
                filePaths.add(new File(fileList[i]).getAbsolutePath());
            }
            if (filePaths.isEmpty()) {
                return ReturnCode.OK;
            }
            ArrayList<String> cmdList = new ArrayList<String>();
            cmdList.add(cmExe);
            if (cmdArgs.length > 0) {
                cmdList.addAll(Arrays.asList(cmdArgs));
            }
            cmdList.addAll(filePaths);
            int returnStatus = 0;
            StringWriter out = new StringWriter();
            StringWriter err = new StringWriter();
            returnStatus = PlatformUtils.executeCommand(cmdList.toArray(new String[cmdList.size()]), null, null, out, err);
            if (returnStatus != 0) {
                return new ReturnCode(4, "ERROR_EXECUTING_COMMAND", new String[]{this.convertListToString(cmdList, " "), Integer.toString(returnStatus), ((Object)err).toString()});
            }
            return ReturnCode.OK;
        }

        abstract String getASCIISystemCharSet();

        abstract String getEBCIDICSystemCharSet();

        protected String convertListToString(List list, String delimiter) {
            StringBuilder sb = new StringBuilder();
            if (null == delimiter) {
                delimiter = ",";
            }
            if (null != list && !list.isEmpty()) {
                Iterator it = list.iterator();
                sb.append((String)it.next());
                while (it.hasNext()) {
                    sb.append(delimiter).append((String)it.next());
                }
            }
            return sb.toString();
        }
    }
}

