/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.collective.member.metadata;

import com.ibm.websphere.collective.repository.AdminMetadataManagerMBean;
import com.ibm.websphere.kernel.server.ServerInfoMBean;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.collective.member.DockerEnvironmentUtil;
import com.ibm.ws.collective.member.metadata.AdminMetadataFileMonitor;
import com.ibm.ws.collective.member.metadata.AdminMetadataParser;
import com.ibm.ws.collective.utils.RepositoryPathUtility;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.collective.member.connection.CollectiveConnectionService;
import com.ibm.wsspi.collective.repository.RepositoryClient;
import com.ibm.wsspi.collective.repository.RepositoryConnectionFactory;
import com.ibm.wsspi.kernel.filemonitor.FileMonitor;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.location.WsResource;
import java.io.File;
import java.io.IOException;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import javax.management.DynamicMBean;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={AdminMetadataPublisher.class}, configurationPolicy=ConfigurationPolicy.IGNORE, immediate=true, property={"service.vendor=IBM"})
public class AdminMetadataPublisher
implements NotificationListener {
    private static final TraceComponent tc = Tr.register(AdminMetadataPublisher.class, (String)"Collective", (String)"com.ibm.ws.collective.member.internal.resources.CollectiveMemberMessages");
    public static final String CLUSTER_MEMBER_MBEAN_OBJECT_NAME = "WebSphere:feature=clusterMember,type=ClusterMember,name=ClusterMember";
    private ServerInfoMBean serverInfoMBean = null;
    private volatile boolean serviceActivated = false;
    private String clusterName = "";
    private String serverName = "";
    private String wlpInstallDir = null;
    private Map<String, Object> adminMetadata;
    private List<String> appList = new ArrayList<String>();
    private static final String DEFAULT_SERVER_ADMIN_METADATA_DIRECTORY = "${server.config.dir}";
    private static final String DEFAULT_RUNTIME_ADMIN_METADATA_LOCATION = "${wlp.install.dir}/etc/admin-metadata.xml";
    private static final String DEFAULT_SERVER_ADMIN_METADATA_LOCATION = "${server.config.dir}/admin-metadata.xml";
    private String adminRuntimeMetadataFile = null;
    private String adminServerMetadataFile = null;
    protected static final String CFG_KEY_MONITOR_INTERVAL = "monitorInterval";
    protected static final String CFG_KEY_ADMIN_METADATA_FILE = "adminMetadataFile";
    protected static final String CFG_KEY_MONITOR_ENABLED = "monitorEnabled";
    private long monitorInterval = 5000L;
    private boolean monitorEnabled = true;
    private AdminMetadataFileMonitor adminMetadataFileMonitor;
    private final AdminMetadataParser parser = new AdminMetadataParser();
    private ServiceRegistration<FileMonitor> adminMetadataFileMonitorRegistration;
    private BundleContext bundleContext;
    private WsLocationAdmin locationAdmin = null;
    private CollectiveConnectionService collectiveConnectionService = null;
    private AdminMetadataManagerMBean metadataManager = null;
    private ExecutorService executorService = null;
    private String serverIdentity = null;
    private String runtimeIdentity = null;
    private final List<String> clusterIdentities = new ArrayList<String>();
    private final List<String> appIdentities = new ArrayList<String>();
    private boolean isCollectiveController = false;
    private boolean isCollectiveMember = false;
    private Map<String, Object> activationProps = null;
    private ComponentContext activationComponentContext = null;
    private RepositoryConnectionFactory repositoryConnectionFactory = null;
    protected final Runnable startPublisherAction = new Runnable(){
        static final long serialVersionUID = 1674751810208338562L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Override
        @Trivial
        public void run() {
            if (AdminMetadataPublisher.this.isCollectiveController || AdminMetadataPublisher.this.isCollectiveMember) {
                AdminMetadataPublisher.this.serviceActivated = true;
                AdminMetadataPublisher.this.loadMonitorConfig(AdminMetadataPublisher.this.activationProps);
                AdminMetadataPublisher.this.bundleContext = AdminMetadataPublisher.this.activationComponentContext.getBundleContext();
                AdminMetadataPublisher.this.modified(AdminMetadataPublisher.this.activationProps);
                AdminMetadataPublisher.this.registerAdminMetadataFileMonitor();
                AdminMetadataPublisher.this.publishRuntimeAdminMetadata(AdminMetadataPublisher.this.adminMetadata);
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.collective.member.metadata.AdminMetadataPublisher$1", 1.class, (String)"Collective", (String)"com.ibm.ws.collective.member.internal.resources.CollectiveMemberMessages");
        }
    };
    static final long serialVersionUID = 7643460074106013619L;

    @Reference(service=WsLocationAdmin.class, policy=ReferencePolicy.DYNAMIC)
    protected void setLocationService(WsLocationAdmin locAdmin) {
        this.locationAdmin = locAdmin;
    }

    protected void unsetLocationService(WsLocationAdmin locAdmin) {
        if (this.locationAdmin == locAdmin) {
            this.locationAdmin = null;
        }
    }

    @Reference(service=CollectiveConnectionService.class, cardinality=ReferenceCardinality.OPTIONAL, policyOption=ReferencePolicyOption.GREEDY)
    protected void setCollectiveConnectionService(CollectiveConnectionService reference) {
        this.collectiveConnectionService = reference;
        this.isCollectiveMember = true;
    }

    protected void unsetCollectiveConnectionService(CollectiveConnectionService reference) {
        if (this.collectiveConnectionService == reference) {
            this.collectiveConnectionService = null;
            this.isCollectiveMember = false;
        }
    }

    @Reference(service=AdminMetadataManagerMBean.class, cardinality=ReferenceCardinality.OPTIONAL, policyOption=ReferencePolicyOption.GREEDY)
    protected void setAdminMetadataManagerMBean(AdminMetadataManagerMBean reference) {
        this.metadataManager = reference;
        this.isCollectiveController = true;
    }

    protected void unsetAdminMetadataManagerMBean(AdminMetadataManagerMBean reference) {
        if (this.metadataManager == reference) {
            this.metadataManager = null;
            this.isCollectiveController = false;
        }
    }

    @Reference(service=ExecutorService.class)
    protected void seExecutorService(ExecutorService reference) {
        this.executorService = reference;
    }

    protected void unsetExecutorService(ExecutorService reference) {
        if (this.executorService == reference) {
            this.executorService = null;
        }
    }

    @Reference(service=ServerInfoMBean.class)
    protected void setServerIdentityMBean(ServerInfoMBean reference) {
        this.serverInfoMBean = reference;
    }

    protected void unsetServerIdentityMBean(ServerInfoMBean reference) {
        if (this.serverInfoMBean == reference) {
            this.serverInfoMBean = null;
        }
    }

    @Reference(service=RepositoryConnectionFactory.class)
    protected void setRepositoryConnectionFactory(RepositoryConnectionFactory reference) {
        this.repositoryConnectionFactory = reference;
    }

    protected void unsetRepositoryConnectionFactory(RepositoryConnectionFactory reference) {
        if (this.repositoryConnectionFactory == reference) {
            this.repositoryConnectionFactory = null;
        }
    }

    protected void setAdminMetadataFileMonitorRegistration(ServiceRegistration<FileMonitor> adminMetadataFileMonitorRegistration) {
        this.adminMetadataFileMonitorRegistration = adminMetadataFileMonitorRegistration;
    }

    protected void unsetAdminMetadataFileMonitorRegistration() {
        if (this.adminMetadataFileMonitorRegistration != null) {
            this.adminMetadataFileMonitorRegistration.unregister();
            this.adminMetadataFileMonitorRegistration = null;
            this.adminMetadataFileMonitor = null;
        }
    }

    protected void activate(ComponentContext cc, Map<String, Object> props) {
        this.activationProps = props;
        this.activationComponentContext = cc;
        this.performAction(this.startPublisherAction);
    }

    protected void deactivate(ComponentContext cc) {
        this.serviceActivated = false;
        this.unsetAdminMetadataFileMonitorRegistration();
    }

    @Trivial
    private void performAction(Runnable action) {
        try {
            this.executorService.submit(action);
        }
        catch (NullPointerException nullPointerException) {
            FFDCFilter.processException((Throwable)nullPointerException, (String)"com.ibm.ws.collective.member.metadata.AdminMetadataPublisher", (String)"285", (Object)this, (Object[])new Object[]{action});
            IllegalStateException ise = new IllegalStateException("The action could not be performed - it was likely accessed after the ExecutorService was deactivated.");
            ise.fillInStackTrace();
            throw ise;
        }
    }

    public boolean publishMetadata(String resourceType, String updatedName) {
        boolean result = false;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("cluster name " + this.clusterName), (Object[])new Object[0]);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("appList " + this.appList), (Object[])new Object[0]);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("clusterIdentities " + this.clusterIdentities), (Object[])new Object[0]);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("appIdentities " + this.appIdentities), (Object[])new Object[0]);
        }
        if (this.adminMetadata == null || this.adminMetadata.size() == 0) {
            this.getAdminMetadata();
        }
        if (resourceType.equals("cluster")) {
            String[] identities;
            boolean appPublishedOnCluster;
            if (updatedName != null && !updatedName.equalsIgnoreCase(this.clusterName)) {
                this.clusterName = updatedName;
            }
            if (this.clusterIdentities != null && !this.clusterIdentities.contains(this.clusterName)) {
                result = this.publishClusterMetaData(this.adminMetadata);
            }
            if (this.appList != null && this.appList.size() > 0 && !(appPublishedOnCluster = this.checkIfAppPublishOnCluster(identities = this.appIdentities.toArray(new String[0]), this.clusterName))) {
                this.publishApplicationMetaData(this.adminMetadata);
            }
            if (updatedName == null || updatedName.length() == 0) {
                this.clusterName = updatedName;
                this.publishAdminMetadata(this.adminMetadata);
            }
        }
        if (resourceType.equals("application")) {
            if (this.appList != null && !this.appList.contains(updatedName)) {
                this.appList.add(updatedName);
            }
            String appIdentity = this.getApplicationIdentity(updatedName);
            if (this.appIdentities != null && !this.appIdentities.contains(appIdentity) && this.adminMetadata != null && this.adminMetadata.get("application") != null) {
                Map appMetadata = (Map)this.adminMetadata.get("application");
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("appMetadata " + appMetadata), (Object[])new Object[0]);
                }
                if (appMetadata.containsKey(updatedName)) {
                    this.publishApplicationMetaData(this.adminMetadata);
                    this.appIdentities.add(appIdentity);
                    result = true;
                }
            }
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public void publishAdminMetadata(Map<String, Object> adminMetadata) {
        boolean result = false;
        try {
            if (adminMetadata != null) {
                if (adminMetadata.containsKey("server")) {
                    Map serverMetadata = (Map)adminMetadata.get("server");
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"Publish server metadata ...", (Object[])new Object[]{this.serverName});
                    }
                    this.serverIdentity = this.getServerIdentity();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("server identity " + this.serverIdentity), (Object[])new Object[0]);
                    }
                    if (this.isCollectiveController) {
                        this.metadataManager.deployAdminMetadata("server", this.serverIdentity, serverMetadata);
                        result = true;
                    }
                    if (this.isCollectiveMember) {
                        this.invokeAdminMetadataMBeanFromMember("server", this.serverIdentity, serverMetadata, "deployAdminMetadata");
                        result = true;
                    }
                    if (result) {
                        Tr.info((TraceComponent)tc, (String)"ADMIN_METADATA_PUBLISHED", (Object[])new Object[]{"server", this.serverName});
                    }
                }
                this.publishClusterMetaData(adminMetadata);
                this.publishApplicationMetaData(adminMetadata);
                if (adminMetadata.isEmpty()) {
                    if (this.isCollectiveController) {
                        this.metadataManager.deployAdminMetadata("server", this.serverIdentity, adminMetadata);
                    }
                    if (this.isCollectiveMember) {
                        this.invokeAdminMetadataMBeanFromMember("server", this.serverIdentity, adminMetadata, "deployAdminMetadata");
                    }
                }
            }
        }
        catch (IllegalArgumentException serverMetadata) {
            void iae;
            FFDCFilter.processException((Throwable)serverMetadata, (String)"com.ibm.ws.collective.member.metadata.AdminMetadataPublisher", (String)"429", (Object)this, (Object[])new Object[]{adminMetadata});
            Tr.warning((TraceComponent)tc, (String)"ADMIN_METADATA_PUBLISHED_METADATA_ERROR", (Object[])new Object[]{iae.getMessage()});
            throw iae;
        }
        catch (InstanceNotFoundException iae) {
            void infe;
            FFDCFilter.processException((Throwable)iae, (String)"com.ibm.ws.collective.member.metadata.AdminMetadataPublisher", (String)"432", (Object)this, (Object[])new Object[]{adminMetadata});
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Caught InstanceNotFoundException. Unable to invoke the method on the AdminMetadataManager MBean ", (Object[])new Object[0]);
            }
            Tr.warning((TraceComponent)tc, (String)"ADMIN_METADATA_PUBLISHED_MBEAN_INCOMPATIBLE_ERROR", (Object[])new Object[]{infe.getMessage()});
        }
        catch (IOException infe) {
            void ioe;
            FFDCFilter.processException((Throwable)infe, (String)"com.ibm.ws.collective.member.metadata.AdminMetadataPublisher", (String)"437", (Object)this, (Object[])new Object[]{adminMetadata});
            this.handleIOException((IOException)ioe, "server");
        }
        catch (Exception ioe) {
            void e;
            FFDCFilter.processException((Throwable)ioe, (String)"com.ibm.ws.collective.member.metadata.AdminMetadataPublisher", (String)"439", (Object)this, (Object[])new Object[]{adminMetadata});
            Tr.warning((TraceComponent)tc, (String)"ADMIN_METADATA_PUBLISHED_GENERAL_ERROR", (Object[])new Object[]{e.getMessage()});
        }
    }

    /*
     * WARNING - void declaration
     */
    public void publishRuntimeAdminMetadata(Map<String, Object> adminMetadata) {
        if (this.serviceActivated) {
            Map runtimeMetadata = null;
            boolean result = false;
            try {
                if (adminMetadata != null && adminMetadata.containsKey("runtime")) {
                    runtimeMetadata = (Map)adminMetadata.get("runtime");
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"get runtime metadata from parser ", (Object[])new Object[0]);
                    }
                    runtimeMetadata = this.getRuntimeMetadata();
                }
                if (runtimeMetadata != null && !runtimeMetadata.isEmpty()) {
                    this.runtimeIdentity = this.getRuntimeIdentity();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("runtime identity " + this.runtimeIdentity), (Object[])new Object[0]);
                    }
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"Publish runtime metadata ...", (Object[])new Object[]{this.wlpInstallDir});
                    }
                    if (this.isCollectiveController) {
                        this.metadataManager.deployAdminMetadata("runtime", this.runtimeIdentity, runtimeMetadata);
                        result = true;
                    }
                    if (this.isCollectiveMember) {
                        this.invokeAdminMetadataMBeanFromMember("runtime", this.runtimeIdentity, runtimeMetadata, "deployAdminMetadata");
                        result = true;
                    }
                }
                if (result) {
                    Tr.info((TraceComponent)tc, (String)"ADMIN_METADATA_PUBLISHED", (Object[])new Object[]{"runtime", this.wlpInstallDir});
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                void iae;
                FFDCFilter.processException((Throwable)illegalArgumentException, (String)"com.ibm.ws.collective.member.metadata.AdminMetadataPublisher", (String)"488", (Object)this, (Object[])new Object[]{adminMetadata});
                Tr.warning((TraceComponent)tc, (String)"ADMIN_METADATA_PUBLISHED_METADATA_ERROR", (Object[])new Object[]{iae.getMessage()});
                iae.fillInStackTrace();
                throw iae;
            }
            catch (InstanceNotFoundException iae) {
                void infe;
                FFDCFilter.processException((Throwable)iae, (String)"com.ibm.ws.collective.member.metadata.AdminMetadataPublisher", (String)"492", (Object)this, (Object[])new Object[]{adminMetadata});
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Caught InstanceNotFoundException. Unable to invoke the method on the AdminMetadataManager MBean ", (Object[])new Object[0]);
                }
                Tr.warning((TraceComponent)tc, (String)"ADMIN_METADATA_PUBLISHED_MBEAN_INCOMPATIBLE_ERROR", (Object[])new Object[]{infe.getMessage()});
            }
            catch (IOException infe) {
                void ioe;
                FFDCFilter.processException((Throwable)infe, (String)"com.ibm.ws.collective.member.metadata.AdminMetadataPublisher", (String)"497", (Object)this, (Object[])new Object[]{adminMetadata});
                this.handleIOException((IOException)ioe, "runtime");
            }
            catch (Exception ioe) {
                void e;
                FFDCFilter.processException((Throwable)ioe, (String)"com.ibm.ws.collective.member.metadata.AdminMetadataPublisher", (String)"499", (Object)this, (Object[])new Object[]{adminMetadata});
                Tr.warning((TraceComponent)tc, (String)"ADMIN_METADATA_PUBLISHED_GENERAL_ERROR", (Object[])new Object[]{e.getMessage()});
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void invokeAdminMetadataMBeanFromMember(String resourceType, String identity, Map<String, Object> metadata, String operation) throws InstanceNotFoundException, IOException {
        if (this.collectiveConnectionService != null) {
            MBeanServerConnection mbcs = this.collectiveConnectionService.getMBeanServerConnection((NotificationListener)this, null, null);
            String[] signature = new String[]{"java.lang.String", "java.lang.String"};
            Object[] params = new Object[]{resourceType, identity};
            if (metadata != null) {
                signature = new String[]{"java.lang.String", "java.lang.String", "java.util.Map"};
                params = new Object[]{resourceType, identity, metadata};
            }
            try {
                ObjectName mbeanName = new ObjectName("WebSphere:feature=collectiveController,type=AdminMetadataManager,name=AdminMetadataManager");
                mbcs.invoke(mbeanName, operation, params, signature);
            }
            catch (InstanceNotFoundException mbeanName) {
                void infe;
                FFDCFilter.processException((Throwable)mbeanName, (String)"com.ibm.ws.collective.member.metadata.AdminMetadataPublisher", (String)"531", (Object)this, (Object[])new Object[]{resourceType, identity, metadata, operation});
                throw infe;
            }
            catch (Exception infe) {
                void e;
                FFDCFilter.processException((Throwable)infe, (String)"com.ibm.ws.collective.member.metadata.AdminMetadataPublisher", (String)"534", (Object)this, (Object[])new Object[]{resourceType, identity, metadata, operation});
                IOException ioe = new IOException(e.getMessage(), e.getCause());
                ioe.fillInStackTrace();
                throw ioe;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private String[] invokeAdminMetadataMBeanFromMember(String resourceType, String operation) throws InstanceNotFoundException, IOException {
        String[] returnList = null;
        if (this.collectiveConnectionService != null) {
            MBeanServerConnection mbcs = this.collectiveConnectionService.getMBeanServerConnection((NotificationListener)this, null, null);
            String[] signature = new String[]{"java.lang.String"};
            Object[] params = new Object[]{resourceType};
            try {
                ObjectName mbeanName = new ObjectName("WebSphere:feature=collectiveController,type=AdminMetadataManager,name=AdminMetadataManager");
                returnList = (String[])mbcs.invoke(mbeanName, operation, params, signature);
            }
            catch (InstanceNotFoundException mbeanName) {
                void infe;
                FFDCFilter.processException((Throwable)mbeanName, (String)"com.ibm.ws.collective.member.metadata.AdminMetadataPublisher", (String)"568", (Object)this, (Object[])new Object[]{resourceType, operation});
                throw infe;
            }
            catch (Exception infe) {
                void e;
                FFDCFilter.processException((Throwable)infe, (String)"com.ibm.ws.collective.member.metadata.AdminMetadataPublisher", (String)"571", (Object)this, (Object[])new Object[]{resourceType, operation});
                IOException ioe = new IOException(e.getMessage(), e.getCause());
                ioe.fillInStackTrace();
                throw ioe;
            }
        }
        return returnList;
    }

    /*
     * WARNING - void declaration
     */
    private void invokeAdminMetadataMBeanFromMember(String resourceType, String identity, String operation) throws InstanceNotFoundException, IOException {
        Object returnList = null;
        if (this.collectiveConnectionService != null) {
            MBeanServerConnection mbcs = this.collectiveConnectionService.getMBeanServerConnection((NotificationListener)this, null, null);
            String[] signature = new String[]{"java.lang.String", "java.lang.String"};
            Object[] params = new Object[]{resourceType, identity};
            try {
                ObjectName mbeanName = new ObjectName("WebSphere:feature=collectiveController,type=AdminMetadataManager,name=AdminMetadataManager");
                mbcs.invoke(mbeanName, operation, params, signature);
            }
            catch (InstanceNotFoundException mbeanName) {
                void infe;
                FFDCFilter.processException((Throwable)mbeanName, (String)"com.ibm.ws.collective.member.metadata.AdminMetadataPublisher", (String)"605", (Object)this, (Object[])new Object[]{resourceType, identity, operation});
                throw infe;
            }
            catch (Exception infe) {
                void e;
                FFDCFilter.processException((Throwable)infe, (String)"com.ibm.ws.collective.member.metadata.AdminMetadataPublisher", (String)"608", (Object)this, (Object[])new Object[]{resourceType, identity, operation});
                IOException ioe = new IOException(e.getMessage(), e.getCause());
                ioe.fillInStackTrace();
                throw ioe;
            }
        }
    }

    private void loadMonitorConfig(Map<String, Object> props) {
        this.monitorEnabled = props.get(CFG_KEY_MONITOR_ENABLED) != null ? (Boolean)props.get(CFG_KEY_MONITOR_ENABLED) : true;
        this.monitorInterval = props.get(CFG_KEY_MONITOR_INTERVAL) != null ? (Long)props.get(CFG_KEY_MONITOR_INTERVAL) : 5000L;
    }

    private void resolveRuntimeAdminMetadataFileLocation() {
        WsResource adminMetadataFileInServerConfig;
        if (this.serviceActivated && this.locationAdmin != null && (adminMetadataFileInServerConfig = this.locationAdmin.resolveResource(DEFAULT_RUNTIME_ADMIN_METADATA_LOCATION)) != null && adminMetadataFileInServerConfig.exists()) {
            String expandedAdminRuntimeMetadataFileInConfig;
            this.adminRuntimeMetadataFile = expandedAdminRuntimeMetadataFileInConfig = this.locationAdmin.resolveString(DEFAULT_RUNTIME_ADMIN_METADATA_LOCATION);
            if (this.adminRuntimeMetadataFile != null && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Admin runtime metadata file " + this.adminRuntimeMetadataFile), (Object[])new Object[0]);
            }
        }
    }

    private void resolveServerAdminMetadataFileLocation() {
        WsResource adminMetadataFileInServerConfig;
        if (this.serviceActivated && this.locationAdmin != null && (adminMetadataFileInServerConfig = this.locationAdmin.resolveResource(DEFAULT_SERVER_ADMIN_METADATA_LOCATION)) != null && adminMetadataFileInServerConfig.exists()) {
            String expandedAdminServerMetadataFileInConfig;
            this.adminServerMetadataFile = expandedAdminServerMetadataFileInConfig = this.locationAdmin.resolveString(DEFAULT_SERVER_ADMIN_METADATA_LOCATION);
            if (this.adminServerMetadataFile != null && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Admin metadata file " + this.adminServerMetadataFile), (Object[])new Object[0]);
            }
        }
    }

    private void getAdminMetadata() {
        if (this.adminMetadata != null && this.adminMetadata.size() > 0) {
            return;
        }
        this.resolveServerAdminMetadataFileLocation();
        if (this.adminServerMetadataFile != null) {
            File metadataFile = new File(this.adminServerMetadataFile);
            if (metadataFile.exists()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"admin-metadata.xml was found.", (Object[])new Object[0]);
                }
                this.adminMetadata = this.parser.parseAdminMetadata(metadataFile, "server");
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"admin-metadata.xml was not found.", (Object[])new Object[0]);
            }
        }
    }

    protected void modified(Map<String, Object> props) {
        Long oldMonitorInterval = this.monitorInterval;
        boolean oldMonitorEnabled = this.monitorEnabled;
        this.loadMonitorConfig(props);
        if (this.isMonitorEnabledChanged(oldMonitorEnabled)) {
            if (this.monitorEnabled) {
                this.registerAdminMetadataFileMonitor();
            } else {
                this.unsetAdminMetadataFileMonitorRegistration();
            }
        } else if (this.isMonitorIntervalChanged(oldMonitorInterval) && this.monitorEnabled) {
            this.unsetAdminMetadataFileMonitorRegistration();
            this.registerAdminMetadataFileMonitor();
        }
    }

    private boolean isMonitorIntervalChanged(Long oldMonitorInterval) {
        return oldMonitorInterval != this.monitorInterval;
    }

    private boolean isMonitorEnabledChanged(boolean oldMonitorEnabled) {
        return oldMonitorEnabled != this.monitorEnabled;
    }

    /*
     * WARNING - void declaration
     */
    private void registerAdminMetadataFileMonitor() {
        block3: {
            try {
                this.adminMetadataFileMonitor = new AdminMetadataFileMonitor(this, this.parser);
                this.setAdminMetadataFileMonitorRegistration(this.adminMetadataFileMonitor.monitorFiles(this.bundleContext, Arrays.asList(DEFAULT_SERVER_ADMIN_METADATA_DIRECTORY), this.monitorInterval));
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Admin metadata file monitor was registered.", (Object[])new Object[0]);
                }
            }
            catch (Exception exception) {
                void e;
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.collective.member.metadata.AdminMetadataPublisher", (String)"748", (Object)this, (Object[])new Object[0]);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block3;
                Tr.debug((TraceComponent)tc, (String)"Exception creating the admin metadata file monitor.", (Object[])new Object[]{e});
            }
        }
    }

    @Reference(service=DynamicMBean.class, target="(jmx.objectname=WebSphere:feature=clusterMember,type=ClusterMember,name=ClusterMember)", cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setClusterMemberMBean(ServiceReference<DynamicMBean> ref) {
        this.clusterName = (String)ref.getProperty("Name");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"The clusterMember feature was detected present in the config and clusterName: ", (Object[])new Object[]{this.clusterName});
        }
    }

    protected void unsetClusterMemberMBean(ServiceReference<DynamicMBean> ref) {
        if (this.clusterName != null && this.clusterName.equals(ref.getProperty("Name")) && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"The clusterMember feature was detected removed in the config and clusterName: ", (Object[])new Object[]{this.clusterName});
        }
    }

    private String getServerIdentity() {
        if (this.serverIdentity == null) {
            if (DockerEnvironmentUtil.isMemberInDockerEnvironment()) {
                String tuple = RepositoryPathUtility.buildServerTuple((String)DockerEnvironmentUtil.getContainerPropertyFromEnvironment("containerHost"), (String)"Docker", (String)DockerEnvironmentUtil.getContainerPropertyFromEnvironment("containerName"));
                this.serverIdentity = RepositoryPathUtility.encodeServerTuple((String)tuple);
            } else if (this.serverInfoMBean != null) {
                String hostName = this.serverInfoMBean.getDefaultHostname();
                String userDir = this.serverInfoMBean.getUserDirectory();
                this.serverName = this.serverInfoMBean.getName();
                String tuple = RepositoryPathUtility.buildServerTuple((String)hostName, (String)userDir, (String)this.serverName);
                this.serverIdentity = RepositoryPathUtility.encodeServerTuple((String)tuple);
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Unable to compute the server path. The ServerInfoMBean is unavailable.", (Object[])new Object[0]);
                }
                return null;
            }
        }
        return this.serverIdentity;
    }

    @Trivial
    private String getRuntimeIdentity() {
        if (this.runtimeIdentity == null) {
            if (this.serverInfoMBean != null) {
                String hostName = this.serverInfoMBean.getDefaultHostname();
                if (DockerEnvironmentUtil.isMemberInDockerEnvironment()) {
                    hostName = DockerEnvironmentUtil.getContainerPropertyFromEnvironment("containerHost");
                }
                this.wlpInstallDir = this.serverInfoMBean.getInstallDirectory();
                if (hostName == null || this.wlpInstallDir == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Unable to compute the runtime identity. Required information missing. hostName=" + hostName + " wlpInstallDir=" + this.wlpInstallDir), (Object[])new Object[0]);
                    }
                    return null;
                }
                String encodedInstallDir = RepositoryPathUtility.getURLEncodedPath((String)this.wlpInstallDir);
                this.runtimeIdentity = hostName + "," + encodedInstallDir;
                return this.runtimeIdentity;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Unable to compute the runtime path. The ServerIdentityMBean is unavailable.", (Object[])new Object[0]);
            }
            return null;
        }
        return this.runtimeIdentity;
    }

    @Trivial
    private String getApplicationIdentity(String appname) {
        String appIdentity = null;
        if (this.clusterName != null && this.clusterName.length() > 0) {
            appIdentity = this.clusterName + "," + appname;
        } else {
            if (this.serverIdentity == null) {
                this.serverIdentity = this.getServerIdentity();
            }
            appIdentity = this.serverIdentity + "," + appname;
        }
        return appIdentity;
    }

    private String getAppName(String objectName) {
        String appName = objectName.substring(objectName.indexOf("name=") + 5);
        return appName.split(",")[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void publishApplicationMetaData(Map<String, Object> adminMetadata) {
        Map metadata = null;
        boolean result = false;
        if (adminMetadata != null && adminMetadata.containsKey("application")) {
            metadata = (Map)adminMetadata.get("application");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("application metadata " + metadata), (Object[])new Object[0]);
        }
        try {
            this.appList = this.getApplicationList();
            String[] identities = this.getResourceIdentities("application");
            this.syncWithRepository(identities);
            if (metadata != null) {
                Set entries = metadata.entrySet();
                for (Map.Entry entry : entries) {
                    String app = (String)entry.getKey();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("app name in metadata " + app), (Object[])new Object[0]);
                    }
                    Map appMetadata = (Map)entry.getValue();
                    String appIdentity = this.getApplicationIdentity(app);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("app identity " + appIdentity), (Object[])new Object[0]);
                    }
                    if (this.appList != null && this.appList.contains(app)) {
                        if (this.appIdentities == null || this.appIdentities.contains(appIdentity)) continue;
                        if (tc.isEventEnabled()) {
                            Tr.event((TraceComponent)tc, (String)("Publish application metadata ..." + app), (Object[])new Object[0]);
                        }
                        String string = appIdentity;
                        synchronized (string) {
                            String oldAppIdentity;
                            if (this.isCollectiveController) {
                                this.metadataManager.deployAdminMetadata("application", appIdentity, appMetadata);
                                if (this.clusterName != null && this.clusterName.length() > 0) {
                                    oldAppIdentity = this.serverIdentity + "," + app;
                                    this.metadataManager.removeAllAdminMetadata("application", oldAppIdentity);
                                }
                                result = true;
                            }
                            if (this.isCollectiveMember) {
                                this.invokeAdminMetadataMBeanFromMember("application", appIdentity, appMetadata, "deployAdminMetadata");
                                if (this.clusterName != null && this.clusterName.length() > 0) {
                                    oldAppIdentity = this.serverIdentity + "," + app;
                                    this.invokeAdminMetadataMBeanFromMember("application", oldAppIdentity, "removeAllAdminMetadata");
                                }
                                result = true;
                            }
                            if (result) {
                                this.appIdentities.add(appIdentity);
                                if (tc.isInfoEnabled()) {
                                    Tr.info((TraceComponent)tc, (String)"ADMIN_METADATA_PUBLISHED", (Object[])new Object[]{"application", app});
                                }
                            }
                            continue;
                        }
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("application is not found in the repository " + app), (Object[])new Object[0]);
                }
            }
        }
        catch (IllegalArgumentException identities) {
            void iae;
            FFDCFilter.processException((Throwable)identities, (String)"com.ibm.ws.collective.member.metadata.AdminMetadataPublisher", (String)"967", (Object)this, (Object[])new Object[]{adminMetadata});
            Tr.warning((TraceComponent)tc, (String)"ADMIN_METADATA_PUBLISHED_METADATA_ERROR", (Object[])new Object[]{iae.getMessage()});
            iae.fillInStackTrace();
            throw iae;
        }
        catch (InstanceNotFoundException iae) {
            void infe;
            FFDCFilter.processException((Throwable)iae, (String)"com.ibm.ws.collective.member.metadata.AdminMetadataPublisher", (String)"971", (Object)this, (Object[])new Object[]{adminMetadata});
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Caught InstanceNotFoundException. Unable to invoke the method on the AdminMetadataManager MBean ", (Object[])new Object[0]);
            }
            Tr.warning((TraceComponent)tc, (String)"ADMIN_METADATA_PUBLISHED_MBEAN_INCOMPATIBLE_ERROR", (Object[])new Object[]{infe.getMessage()});
        }
        catch (IOException infe) {
            void ioe;
            FFDCFilter.processException((Throwable)infe, (String)"com.ibm.ws.collective.member.metadata.AdminMetadataPublisher", (String)"976", (Object)this, (Object[])new Object[]{adminMetadata});
            this.handleIOException((IOException)ioe, "application");
        }
        catch (Exception ioe) {
            void e;
            FFDCFilter.processException((Throwable)ioe, (String)"com.ibm.ws.collective.member.metadata.AdminMetadataPublisher", (String)"979", (Object)this, (Object[])new Object[]{adminMetadata});
            Tr.warning((TraceComponent)tc, (String)"ADMIN_METADATA_PUBLISHED_GENERAL_ERROR", (Object[])new Object[]{e.getMessage()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private boolean publishClusterMetaData(Map<String, Object> adminMetadata) {
        boolean result;
        block18: {
            result = false;
            Map clusterMetadata = null;
            if (adminMetadata != null && adminMetadata.containsKey("cluster")) {
                clusterMetadata = (Map)adminMetadata.get("cluster");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("cluster metadata " + clusterMetadata), (Object[])new Object[0]);
            }
            try {
                if (clusterMetadata == null) break block18;
                if (this.clusterName != null && this.clusterName.length() > 0) {
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("Publish cluster metadata ..." + this.clusterName), (Object[])new Object[0]);
                    }
                    String string = this.clusterName;
                    synchronized (string) {
                        if (this.isCollectiveController) {
                            this.metadataManager.deployAdminMetadata("cluster", this.clusterName, clusterMetadata);
                            result = true;
                        }
                        if (this.isCollectiveMember) {
                            this.invokeAdminMetadataMBeanFromMember("cluster", this.clusterName, clusterMetadata, "deployAdminMetadata");
                            result = true;
                        }
                        if (result) {
                            this.clusterIdentities.add(this.clusterName);
                            if (tc.isInfoEnabled()) {
                                Tr.info((TraceComponent)tc, (String)"ADMIN_METADATA_PUBLISHED", (Object[])new Object[]{"cluster", this.clusterName});
                            }
                        }
                        break block18;
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("cluster is not found in the repository " + this.clusterName), (Object[])new Object[0]);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                void iae;
                FFDCFilter.processException((Throwable)illegalArgumentException, (String)"com.ibm.ws.collective.member.metadata.AdminMetadataPublisher", (String)"1037", (Object)this, (Object[])new Object[]{adminMetadata});
                Tr.warning((TraceComponent)tc, (String)"ADMIN_METADATA_PUBLISHED_METADATA_ERROR", (Object[])new Object[]{iae.getMessage()});
                iae.fillInStackTrace();
                throw iae;
            }
            catch (InstanceNotFoundException iae) {
                void infe;
                FFDCFilter.processException((Throwable)iae, (String)"com.ibm.ws.collective.member.metadata.AdminMetadataPublisher", (String)"1041", (Object)this, (Object[])new Object[]{adminMetadata});
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Caught InstanceNotFoundException. Unable to invoke the method on the AdminMetadataManager MBean ", (Object[])new Object[0]);
                }
                Tr.warning((TraceComponent)tc, (String)"ADMIN_METADATA_PUBLISHED_MBEAN_INCOMPATIBLE_ERROR", (Object[])new Object[]{infe.getMessage()});
            }
            catch (IOException infe) {
                void ioe;
                FFDCFilter.processException((Throwable)infe, (String)"com.ibm.ws.collective.member.metadata.AdminMetadataPublisher", (String)"1046", (Object)this, (Object[])new Object[]{adminMetadata});
                this.handleIOException((IOException)ioe, "cluster");
            }
            catch (Exception ioe) {
                void e;
                FFDCFilter.processException((Throwable)ioe, (String)"com.ibm.ws.collective.member.metadata.AdminMetadataPublisher", (String)"1048", (Object)this, (Object[])new Object[]{adminMetadata});
                Tr.warning((TraceComponent)tc, (String)"ADMIN_METADATA_PUBLISHED_GENERAL_ERROR", (Object[])new Object[]{e.getMessage()});
            }
        }
        return result;
    }

    private Map<String, Object> getRuntimeMetadata() {
        Map<String, Object> runtimeMetadata = new HashMap<String, Object>();
        this.resolveRuntimeAdminMetadataFileLocation();
        if (this.adminRuntimeMetadataFile != null) {
            File runtimeMetadataFile = new File(this.adminRuntimeMetadataFile);
            if (runtimeMetadataFile.exists()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Runtime admin-metadata.xml was found.", (Object[])new Object[0]);
                }
                Map<String, Object> metadata = this.parser.parseAdminMetadata(runtimeMetadataFile, "runtime");
                runtimeMetadata = (Map)metadata.get("runtime");
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("runtime metadata " + runtimeMetadata), (Object[])new Object[0]);
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"runtime admin-metadata.xml was not found.", (Object[])new Object[0]);
            }
        }
        return runtimeMetadata;
    }

    public void updateAdminMetadata(Map<String, Object> metadata) {
        this.adminMetadata = metadata;
        Tr.info((TraceComponent)tc, (String)"ADMIN_METADATA_MODIFIED", (Object[])new Object[]{this.adminMetadata});
    }

    @Override
    public void handleNotification(Notification notification, Object handback) {
    }

    private Map<String, String> getAppNamesFromIdentities(String[] appIdentities) {
        HashMap<String, String> appListFromIdentities = new HashMap<String, String>();
        if (appIdentities != null && appIdentities.length > 0) {
            for (int i = 0; i < appIdentities.length; ++i) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("appIdentities[i] " + appIdentities[i]), (Object[])new Object[0]);
                }
                if (appIdentities[i].isEmpty()) continue;
                String[] tokens = appIdentities[i].split(",");
                String appName = tokens[tokens.length - 1];
                if (appListFromIdentities.containsValue(appIdentities[i])) continue;
                appListFromIdentities.put(appName, appIdentities[i]);
            }
        }
        return appListFromIdentities;
    }

    /*
     * WARNING - void declaration
     */
    private List<String> getApplicationList() throws IOException {
        block7: {
            if (this.repositoryConnectionFactory != null) {
                RepositoryClient client = this.repositoryConnectionFactory.obtainRepositoryClient();
                if (this.serverIdentity != null) {
                    String tuple = RepositoryPathUtility.decodeServerTuple((String)this.serverIdentity);
                    try {
                        String mbeanPath = RepositoryPathUtility.buildServerRepositoryPath((String)tuple) + "/sys.mbeans/";
                        Collection mbeans = client.getChildren(mbeanPath, false);
                        if (mbeans != null) {
                            for (String mbean : mbeans) {
                                if (!mbean.contains("service=com.ibm.websphere.application.ApplicationMBean")) continue;
                                String app_name = this.getAppName(mbean);
                                if (this.appList != null && !this.appList.contains(app_name)) {
                                    this.appList.add(app_name);
                                }
                                if (!tc.isDebugEnabled()) continue;
                                Tr.debug((TraceComponent)tc, (String)("appList " + this.appList), (Object[])new Object[0]);
                            }
                        }
                    }
                    catch (IOException mbeanPath) {
                        void io;
                        FFDCFilter.processException((Throwable)mbeanPath, (String)"com.ibm.ws.collective.member.metadata.AdminMetadataPublisher", (String)"1153", (Object)this, (Object[])new Object[0]);
                        if (!tc.isDebugEnabled()) break block7;
                        Tr.debug((TraceComponent)tc, (String)("Unable to get the application mbeans. The IO exception has occurred" + io.toString()), (Object[])new Object[0]);
                    }
                }
            }
        }
        return this.appList;
    }

    /*
     * WARNING - void declaration
     */
    private String[] getResourceIdentities(String resourceType) {
        String[] resourceIdentities;
        block8: {
            resourceIdentities = null;
            try {
                if (this.isCollectiveController) {
                    resourceIdentities = this.metadataManager.getResourceIdentities(resourceType);
                }
                if (this.isCollectiveMember) {
                    resourceIdentities = this.invokeAdminMetadataMBeanFromMember(resourceType, "getResourceIdentities");
                }
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
                FFDCFilter.processException((Throwable)instanceNotFoundException, (String)"com.ibm.ws.collective.member.metadata.AdminMetadataPublisher", (String)"1174", (Object)this, (Object[])new Object[]{resourceType});
                if (tc.isDebugEnabled()) {
                    void infe;
                    Tr.debug((TraceComponent)tc, (String)("Unable to get the resource identities. The InstanceNotFoundException has occurred" + infe.toString()), (Object[])new Object[0]);
                }
            }
            catch (IOException infe) {
                void io;
                FFDCFilter.processException((Throwable)infe, (String)"com.ibm.ws.collective.member.metadata.AdminMetadataPublisher", (String)"1178", (Object)this, (Object[])new Object[]{resourceType});
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Unable to get the resource identities. The IO exception has occurred" + io.toString()), (Object[])new Object[0]);
                }
                this.handleIOException((IOException)io, resourceType);
            }
            catch (Exception io) {
                void e;
                FFDCFilter.processException((Throwable)io, (String)"com.ibm.ws.collective.member.metadata.AdminMetadataPublisher", (String)"1183", (Object)this, (Object[])new Object[]{resourceType});
                if (!tc.isDebugEnabled()) break block8;
                Tr.debug((TraceComponent)tc, (String)("Unable to get the resource identities. The IO exception has occurred" + e.toString()), (Object[])new Object[0]);
            }
        }
        return resourceIdentities;
    }

    private boolean checkIfAppPublishOnCluster(String[] identities, String clusterName) {
        boolean resourcePublished = false;
        if (identities != null && identities.length > 0) {
            for (int i = 0; i < identities.length; ++i) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("identities[i] " + identities[i]), (Object[])new Object[0]);
                }
                String[] tokens = identities[i].split(",");
                String appName = tokens[tokens.length - 1];
                String appIdentity = clusterName + "," + appName;
                if (!identities[i].equalsIgnoreCase(appIdentity)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"application is published on the cluster already", (Object[])new Object[]{clusterName});
                }
                resourcePublished = true;
                break;
            }
        }
        return resourcePublished;
    }

    /*
     * WARNING - void declaration
     */
    private void syncWithRepository(String[] appIdentities) {
        Map<String, String> appListFromIdentities = this.getAppNamesFromIdentities(appIdentities);
        try {
            if (appListFromIdentities.size() != this.appList.size() && appListFromIdentities.size() > this.appList.size()) {
                for (int i = 0; i < appListFromIdentities.size(); ++i) {
                    Set<String> appKeys = appListFromIdentities.keySet();
                    for (String appname : appKeys) {
                        String appIdentity;
                        if (this.appList == null || this.appList.contains(appname) || !(appIdentity = this.getApplicationIdentity(appname)).equals(appListFromIdentities.get(appname))) continue;
                        if (this.isCollectiveController) {
                            this.metadataManager.removeAllAdminMetadata("application", appListFromIdentities.get(appname));
                        }
                        if (!this.isCollectiveMember) continue;
                        this.invokeAdminMetadataMBeanFromMember("application", appListFromIdentities.get(appname), "removeAllAdminMetadata");
                    }
                }
            }
        }
        catch (InstanceNotFoundException i) {
            FFDCFilter.processException((Throwable)i, (String)"com.ibm.ws.collective.member.metadata.AdminMetadataPublisher", (String)"1246", (Object)this, (Object[])new Object[]{appIdentities});
            if (tc.isDebugEnabled()) {
                void infe;
                Tr.debug((TraceComponent)tc, (String)("Unable to remove the admin metadata. The InstanceNotFoundException has occurred" + infe.toString()), (Object[])new Object[0]);
            }
        }
        catch (IOException infe) {
            void io;
            FFDCFilter.processException((Throwable)infe, (String)"com.ibm.ws.collective.member.metadata.AdminMetadataPublisher", (String)"1250", (Object)this, (Object[])new Object[]{appIdentities});
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Unable to remove the admin metadata. The IO exception has occurred" + io.toString()), (Object[])new Object[0]);
            }
            this.handleIOException((IOException)io, "application");
        }
    }

    private void handleIOException(IOException ioe, String metatype) {
        Throwable cause = ioe.getCause();
        String message = null;
        if (cause instanceof ConnectException || ioe.getMessage().contains("CWWKX0206E") || ioe.getMessage().contains("Failed to get JMXConnector:")) {
            message = "A network, communication or security error has occured. The " + metatype + " metadata will not be published to or remove from the repository. Cause: " + ioe.getMessage();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("An IOException was caught due to connection lost " + message), (Object[])new Object[0]);
            }
        } else {
            message = ioe.getMessage();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("An IOException was caught." + message), (Object[])new Object[0]);
            }
        }
    }
}

