/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.bluemix.utility.utils;

import com.ibm.ws.bluemix.utility.utils.Option;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class Arguments {
    private final String _command;
    private final Map<String, String> _options = new HashMap<String, String>();
    private final List<String> _args = new ArrayList<String>();

    public Arguments(String[] args) {
        if (args.length > 0) {
            this._command = args[0];
            for (int i = 1; i < args.length; ++i) {
                String arg = args[i];
                if (arg.startsWith("--")) {
                    String key;
                    int index = arg.indexOf(61);
                    String value = "";
                    if (index != -1) {
                        key = arg.substring(2, index);
                        value = arg.substring(index + 1);
                    } else {
                        key = arg.substring(2);
                    }
                    this._options.put(Arguments.toLowerCase(key), value);
                    continue;
                }
                this._args.add(args[i]);
            }
        } else {
            this._command = null;
        }
    }

    public boolean hasOption(Option option) {
        return this.getOption(option) != null;
    }

    public String getOption(String name) {
        return this._options.get(Arguments.toLowerCase(name));
    }

    public String getOption(Option option) {
        if (option.supportsParameters()) {
            throw new IllegalArgumentException();
        }
        return this._options.get(Arguments.toLowerCase(option.getName()));
    }

    public Map<String, String> getParameterOption(Option option) {
        if (!option.supportsParameters()) {
            throw new IllegalArgumentException();
        }
        HashMap<String, String> map = null;
        String optionName = Arguments.toLowerCase(option.getName());
        for (Map.Entry<String, String> entry : this._options.entrySet()) {
            String name = entry.getKey();
            if (!name.startsWith(optionName)) continue;
            name = name.substring(optionName.length());
            if (map == null) {
                map = new HashMap<String, String>();
            }
            map.put(name, entry.getValue());
        }
        return map;
    }

    public Collection<String> findInvalidOptions(Collection<Option> supportedOptions) {
        HashMap<String, String> setOptions = new HashMap<String, String>(this._options);
        for (Option option : supportedOptions) {
            String optionName = Arguments.toLowerCase(option.getName());
            if (option.supportsParameters()) {
                Iterator iter = setOptions.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    if (!((String)entry.getKey()).startsWith(optionName)) continue;
                    iter.remove();
                }
                continue;
            }
            setOptions.remove(optionName);
        }
        return setOptions.keySet();
    }

    public List<String> getPositionalArguments() {
        return this._args;
    }

    public String getAction() {
        return this._command;
    }

    private static String toLowerCase(String str) {
        return str.toLowerCase(Locale.ENGLISH);
    }
}

