/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.bluemix.utility.api;

import com.ibm.websphere.crypto.PasswordUtil;
import com.ibm.ws.bluemix.utility.api.ServiceConfiguration;
import com.ibm.ws.bluemix.utility.api.ServiceConfigurationException;
import com.ibm.ws.bluemix.utility.utils.DOMUtils;
import com.ibm.ws.bluemix.utility.utils.NLS;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ServiceConfigurationWriter {
    private static final String ENCODE = "#encode:";
    private String encodeAlgorithm;
    private String encodeKey;

    public void setEncodeAlgorithm(String encodeAlgorithm) {
        this.encodeAlgorithm = encodeAlgorithm;
    }

    public void setEncodeKey(String encodeKey) {
        this.encodeKey = encodeKey;
    }

    public void write(File serviceXmlFile, ServiceConfiguration serviceConfiguration) throws ServiceConfigurationException {
        String serviceName = serviceConfiguration.getName();
        try {
            Document doc = DOMUtils.newDocument();
            this.createElement(serviceName, doc, serviceConfiguration.getServiceXml());
            DOMUtils.save(doc, serviceXmlFile);
        }
        catch (ServiceConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServiceConfigurationException(NLS.getMessage("CONFIGURATION_WRITE_ERROR", serviceName, e.getMessage()), e);
        }
    }

    private void createElement(String serviceName, Node parent, ServiceConfiguration.ConfigElement element) throws ServiceConfigurationException {
        List<ServiceConfiguration.ConfigElement> children;
        Document doc = this.getDocument(parent);
        Element domElement = doc.createElement(element.getName());
        parent.appendChild(domElement);
        Map<String, String> attributes = element.getAttributes();
        if (attributes != null) {
            for (Map.Entry<String, String> entry : attributes.entrySet()) {
                String value = this.evaluateValue(serviceName, entry.getValue());
                domElement.setAttribute(entry.getKey(), value);
            }
        }
        if ((children = element.getChildren()) != null) {
            for (ServiceConfiguration.ConfigElement child : children) {
                this.createElement(serviceName, domElement, child);
            }
        } else {
            String string = element.getValue();
            if (string != null) {
                String string2 = this.evaluateValue(serviceName, string);
                domElement.appendChild(doc.createTextNode(string2));
            }
        }
    }

    private Document getDocument(Node node) {
        if (node instanceof Document) {
            return (Document)node;
        }
        return node.getOwnerDocument();
    }

    private String evaluateValue(String serviceName, String value) throws ServiceConfigurationException {
        if (value.startsWith(ENCODE)) {
            String toEncode = value.substring(ENCODE.length());
            String algorithm = this.encodeAlgorithm == null ? "xor" : this.encodeAlgorithm;
            try {
                value = PasswordUtil.encode((String)toEncode, (String)algorithm, (String)this.encodeKey);
            }
            catch (Exception e) {
                String message = e.getMessage() == null ? e.getClass().getName() : e.getMessage();
                throw new ServiceConfigurationException(NLS.getMessage("PASSWORD_ENCODING_ERROR", serviceName, message), e);
            }
        }
        return value;
    }
}

