/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.bluemix.utility.api;

import com.ibm.ws.bluemix.utility.utils.HttpRequestBuilder;
import com.ibm.ws.install.InstallEventListener;
import com.ibm.ws.install.InstallException;
import com.ibm.ws.install.InstallKernelFactory;
import com.ibm.ws.install.InstallKernelInteractive;
import com.ibm.ws.install.InstallLicense;
import com.ibm.ws.install.InstallProgressEvent;
import com.ibm.ws.install.RepositoryConfigUtils;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FeatureInstallation {
    private static final Logger logger = Logger.getLogger(FeatureInstallation.class.getName());
    private static final String UNSPECIFIED_LICENSE_TYPE = "UNSPECIFIED";
    private final InstallKernelInteractive install = InstallKernelFactory.getInteractiveInstance();

    public FeatureInstallation() throws InstallException {
        this.install.setUserAgent(HttpRequestBuilder.DEFAULT_USER_AGENT);
        Properties repoProperties = RepositoryConfigUtils.loadRepoProperties();
        if (repoProperties != null) {
            this.install.setRepositoryProperties(repoProperties);
        }
    }

    public boolean resolveFeatures(Collection<String> features) throws InstallException {
        try {
            this.install.resolve(features, false);
            return true;
        }
        catch (InstallException e) {
            if (22 == e.getRc()) {
                return false;
            }
            throw e;
        }
    }

    public String getFeatureLicenseAgreement() throws InstallException {
        Set licenses = this.install.getFeatureLicense(Locale.getDefault());
        String agreement = this.getLicenseAgreement(licenses);
        return agreement;
    }

    public Map<String, Collection<String>> installFeatures() throws InstallException {
        return this.install.install(null, false, false);
    }

    private String getLicenseAgreement(Set<InstallLicense> licenses) {
        for (InstallLicense license : licenses) {
            if (!this.isUnspecifiedType(license) || "".equals(license.getAgreement().trim())) continue;
            return license.getAgreement();
        }
        return null;
    }

    private boolean isUnspecifiedType(InstallLicense license) {
        return license.getType() != null && license.getType().equals(UNSPECIFIED_LICENSE_TYPE);
    }

    public void addListener(InstallEventListener listener) {
        this.install.addListener(listener, "PROGRESS");
    }

    public void removeListener(InstallEventListener listener) {
        if (listener != null) {
            this.install.removeListener(listener);
        }
    }

    public InstallEventListener getListener() {
        return new InstallEventListener(){

            public void handleInstallEvent(InstallProgressEvent event) throws Exception {
                logger.log(Level.FINE, "[" + event.progress + "%] " + event.message);
            }
        };
    }
}

