/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.utility.internal.cmdline;

import com.ibm.ws.install.InstallException;
import com.ibm.ws.install.InstallKernel;
import com.ibm.ws.install.InstallKernelFactory;
import com.ibm.ws.install.internal.InstallLogUtils;
import com.ibm.ws.install.internal.InstallUtils;
import com.ibm.ws.install.utility.internal.cmdline.Action;
import com.ibm.ws.install.utility.internal.cmdline.CmdUtils;
import com.ibm.ws.kernel.boot.cmdline.ActionHandler;
import com.ibm.ws.kernel.boot.cmdline.Arguments;
import com.ibm.ws.kernel.feature.internal.cmdline.ArgumentsImpl;
import com.ibm.ws.kernel.feature.internal.cmdline.ReturnCode;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import wlp.lib.extract.SelfExtract;

public class UninstallAction
implements ActionHandler {
    public ReturnCode handleTask(PrintStream stdout, PrintStream stderr, Arguments args) {
        List argList = args.getPositionalArguments();
        if (argList.isEmpty()) {
            InstallLogUtils.getInstallLogger().log(Level.SEVERE, CmdUtils.getMessage("ERROR_NO_ARGUMENT", "uninstall"));
            Action.help.handleTask((Arguments)new ArgumentsImpl(new String[]{"help", "uninstall"}));
            return ReturnCode.BAD_ARGUMENT;
        }
        String cmdLineOption = args.getOption("noprompts");
        boolean noInteractive = cmdLineOption != null && (cmdLineOption.isEmpty() || Boolean.valueOf(cmdLineOption) != false);
        cmdLineOption = args.getOption("force");
        boolean forceUninstall = cmdLineOption != null && (cmdLineOption.isEmpty() || Boolean.valueOf(cmdLineOption) != false);
        ArrayList features = new ArrayList(argList);
        if (forceUninstall && features.size() > 1) {
            InstallLogUtils.getInstallLogger().log(Level.SEVERE, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_INVALID_NUMBER_OF_FEATURES_FORCE_UNINSTALL", new Object[0]));
            return ReturnCode.BAD_ARGUMENT;
        }
        InstallKernel installKernel = InstallKernelFactory.getInstance();
        try {
            if (forceUninstall) {
                installKernel.uninstallFeaturePrereqChecking((String)features.get(0), true, forceUninstall);
            } else {
                installKernel.uninstallFeaturePrereqChecking(features);
            }
            if (!noInteractive && !SelfExtract.getResponse((String)InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("TOOL_UNININSTALL_FEATURE_CONFIRMATION", new Object[0]), (String)"", (String)"Xx")) {
                return ReturnCode.OK;
            }
            if (forceUninstall) {
                installKernel.uninstallFeature((String)features.get(0), forceUninstall);
            } else {
                installKernel.uninstallFeature(features);
            }
        }
        catch (InstallException ie) {
            InstallLogUtils.getInstallLogger().log(Level.SEVERE, ie.getMessage(), ie);
            return ReturnCode.RUNTIME_EXCEPTION;
        }
        catch (Exception e) {
            InstallLogUtils.getInstallLogger().log(Level.SEVERE, CmdUtils.getMessage("ERROR_UNINSTALL_FEATURES_FAIL", InstallUtils.getFeatureListOutput(features)), e);
            return ReturnCode.RUNTIME_EXCEPTION;
        }
        InstallLogUtils.getInstallLogger().log(Level.INFO, CmdUtils.getMessage("MSG_UNINSTALL_FEATURES", InstallUtils.getFeatureListOutput(features)));
        return ReturnCode.OK;
    }
}

