/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.internal.inbound;

import com.ibm.websphere.channelfw.ChannelData;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.http.channel.internal.CallbackIDs;
import com.ibm.ws.http.channel.internal.HttpChannelConfig;
import com.ibm.ws.http.channel.internal.HttpObjectFactory;
import com.ibm.ws.http.channel.internal.inbound.HttpInboundChannelFactory;
import com.ibm.ws.http.channel.internal.inbound.HttpInboundLink;
import com.ibm.ws.http.channel.internal.inbound.HttpInboundServiceContextImpl;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;
import com.ibm.wsspi.channelfw.Channel;
import com.ibm.wsspi.channelfw.ConnectionLink;
import com.ibm.wsspi.channelfw.DiscriminationProcess;
import com.ibm.wsspi.channelfw.Discriminator;
import com.ibm.wsspi.channelfw.InboundChannel;
import com.ibm.wsspi.channelfw.VirtualConnection;
import com.ibm.wsspi.genericbnf.exception.MalformedMessageException;
import com.ibm.wsspi.http.channel.HttpRequestMessage;
import com.ibm.wsspi.http.channel.inbound.HttpInboundServiceContext;
import com.ibm.wsspi.tcpchannel.TCPConnectionContext;

public class HttpInboundChannel
implements InboundChannel,
Discriminator {
    private static final TraceComponent tc = Tr.register(HttpInboundChannel.class, (String)"HTTPChannel", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");
    private static final int STATE_STOPPED = 0;
    private static final int STATE_STOPPING = 1;
    private static final int STATE_RUNNING = 2;
    private HttpObjectFactory myObjectFactory = null;
    private HttpInboundChannelFactory channelFactory = null;
    private HttpChannelConfig myConfig = null;
    private int myState = 0;
    private ChannelData config = null;
    private DiscriminationProcess discriminationProcess = null;

    public HttpInboundChannel(ChannelData cc, HttpInboundChannelFactory cf, HttpObjectFactory of) {
        this.channelFactory = cf;
        this.myObjectFactory = of;
        this.update(cc);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Created: " + this), (Object[])new Object[0]);
        }
    }

    public final Discriminator getDiscriminator() {
        return this;
    }

    public final Class<?> getApplicationInterface() {
        return HttpInboundServiceContext.class;
    }

    public final Class<?> getDeviceInterface() {
        return TCPConnectionContext.class;
    }

    public final Channel getChannel() {
        return this;
    }

    public final Class<?> getDiscriminatoryDataType() {
        return WsByteBuffer.class;
    }

    public final Class<?> getDiscriminatoryType() {
        return HttpRequestMessage.class;
    }

    public final HttpChannelConfig getHttpConfig() {
        return this.myConfig;
    }

    public final void setHttpConfig(HttpChannelConfig hcc) {
        this.myConfig = hcc;
    }

    public final HttpInboundChannelFactory getFactory() {
        return this.channelFactory;
    }

    public final HttpObjectFactory getObjectFactory() {
        return this.myObjectFactory;
    }

    public final int getWeight() {
        return this.config.getDiscriminatorWeight();
    }

    public ConnectionLink getConnectionLink(VirtualConnection vc) {
        HttpInboundLink link = (HttpInboundLink)((Object)vc.getStateMap().get(CallbackIDs.CALLBACK_HTTPICL));
        if (null == link) {
            link = new HttpInboundLink(this, vc);
        }
        return link;
    }

    public boolean isRunning() {
        return 2 == this.myState;
    }

    public boolean isStopping() {
        return 2 != this.myState;
    }

    public boolean isStopped() {
        return 0 == this.myState;
    }

    private void setState(int state) {
        this.myState = state;
    }

    public void start() {
        this.setState(2);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Start: " + this), (Object[])new Object[0]);
        }
    }

    public void stop(long millisec) {
        if (0L == millisec) {
            this.setState(0);
        } else {
            this.setState(1);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Stop: " + this), (Object[])new Object[0]);
        }
    }

    public void init() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("init: " + this), (Object[])new Object[0]);
        }
    }

    public void destroy() {
        this.setState(0);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("destroy: " + this), (Object[])new Object[0]);
        }
        this.channelFactory.removeChannel(this.getName());
        this.channelFactory = null;
        this.myConfig = null;
        this.myObjectFactory = null;
    }

    public int discriminate(VirtualConnection vc, Object discrimData) {
        WsByteBuffer[] buffs;
        if (this.isStopped()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Channel stopped, ignoring discriminate on: " + vc), (Object[])new Object[0]);
            }
            return 0;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Discriminating against " + vc + " with " + discrimData), (Object[])new Object[0]);
        }
        if (null == (buffs = (WsByteBuffer[])discrimData) || 0 == buffs.length) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No data provided, returning MAYBE", (Object[])new Object[0]);
            }
            return -1;
        }
        HttpInboundLink link = (HttpInboundLink)((Object)vc.getStateMap().get(CallbackIDs.CALLBACK_HTTPICL));
        if (null == link) {
            link = new HttpInboundLink(this, vc);
        } else {
            link.init(vc, this);
        }
        HttpInboundServiceContextImpl mySvcCtxt = (HttpInboundServiceContextImpl)link.getChannelAccessor();
        boolean retVal = false;
        for (int i = 0; i < buffs.length && null != buffs[i]; ++i) {
            WsByteBuffer buff = buffs[i];
            int limit = buff.limit();
            int position = buff.position();
            mySvcCtxt.enableBufferModification();
            mySvcCtxt.configurePostReadBuffer(buff);
            try {
                retVal = mySvcCtxt.getRequestImpl().parseLineDiscrim(buff);
            }
            catch (MalformedMessageException mme) {
                buff.limit(limit);
                buff.position(position);
                link.destroy(null);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Discriminate returning NO for non-HTTP msg", (Object[])new Object[0]);
                }
                return 0;
            }
            catch (Exception e) {
                buff.limit(limit);
                buff.position(position);
                link.destroy(null);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Unexpected exception [" + e + "]"), (Object[])new Object[0]);
                    Tr.debug((TraceComponent)tc, (String)"Discriminate returning NO", (Object[])new Object[0]);
                }
                return 0;
            }
            mySvcCtxt.setOldLimit(buff.limit());
            if (retVal) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Discrimination returning YES", (Object[])new Object[0]);
                }
                vc.getStateMap().put(CallbackIDs.CALLBACK_HTTPICL, link);
                return 1;
            }
            buff.limit(limit);
            buff.position(position);
        }
        vc.getStateMap().put(CallbackIDs.CALLBACK_HTTPICL, link);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Returning MAYBE for " + vc), (Object[])new Object[0]);
        }
        return -1;
    }

    public void cleanUpState(VirtualConnection vc) {
        HttpInboundLink link = (HttpInboundLink)((Object)vc.getStateMap().get(CallbackIDs.CALLBACK_HTTPICL));
        if (null != link) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Performing cleanup after discrim MAYBE", (Object[])new Object[0]);
            }
            link.destroy(null);
        }
    }

    public void update(ChannelData cc) {
        this.setHttpConfig(new HttpChannelConfig(cc));
        this.config = cc;
    }

    public String toString() {
        return this.config.getName() + " state=" + this.myState;
    }

    public String getName() {
        return this.config.getName();
    }

    public final DiscriminationProcess getDiscriminationProcess() {
        return this.discriminationProcess;
    }

    public final void setDiscriminationProcess(DiscriminationProcess dp) {
        this.discriminationProcess = dp;
    }
}

