/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.internal;

import com.ibm.websphere.channelfw.ChannelData;
import com.ibm.websphere.channelfw.ChannelFactoryData;
import com.ibm.ws.http.channel.internal.HttpFactoryConfig;
import com.ibm.ws.http.channel.internal.HttpObjectFactory;
import com.ibm.wsspi.channelfw.Channel;
import com.ibm.wsspi.channelfw.ChannelFactory;
import com.ibm.wsspi.channelfw.exception.ChannelException;
import com.ibm.wsspi.tcpchannel.TCPConnectionContext;
import java.util.HashMap;
import java.util.Map;

public abstract class HttpChannelFactory
implements ChannelFactory {
    private HttpFactoryConfig myConfig;
    private Class<?> appInterface = null;
    private Class<?>[] devInterfaces = new Class[]{TCPConnectionContext.class};
    private static final HttpObjectFactory myObjectFactory = new HttpObjectFactory();
    private boolean allowLargeMessage = true;
    private Object key = new Object(){};
    private Map<String, Channel> existingChannels = null;
    private Map<Object, Object> commonProperties = null;

    public HttpChannelFactory(Class<?> input_class) {
        this.appInterface = input_class;
        this.existingChannels = new HashMap<String, Channel>();
    }

    public Class<?> getApplicationInterface() {
        return this.appInterface;
    }

    public Class<?>[] getDeviceInterface() {
        return this.devInterfaces;
    }

    public void init(ChannelFactoryData data) {
        this.updateProperties(data.getProperties());
    }

    public void destroy() {
    }

    protected HttpObjectFactory getObjectFactory() {
        return myObjectFactory;
    }

    public void updateProperties(Map<Object, Object> properties) {
        this.commonProperties = properties;
        this.myConfig = new HttpFactoryConfig(properties);
    }

    public HttpFactoryConfig getConfig() {
        return this.myConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseLargeMessage() {
        if (this.getConfig().areMessagesLimited()) {
            Object object = this.key;
            synchronized (object) {
                this.allowLargeMessage = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean allowLargeMessage(long size) {
        if (!this.getConfig().areMessagesLimited()) {
            return true;
        }
        if (-1L == this.getConfig().getLargerBufferSize()) {
            return false;
        }
        if (size > this.getConfig().getLargerBufferSize()) {
            return false;
        }
        Object object = this.key;
        synchronized (object) {
            if (this.allowLargeMessage) {
                this.allowLargeMessage = false;
                return true;
            }
            return false;
        }
    }

    public synchronized Channel findOrCreateChannel(ChannelData channelData) throws ChannelException {
        String channelName = channelData.getName();
        Channel rc = this.existingChannels.get(channelName);
        if (null == rc) {
            rc = this.createChannel(channelData);
            this.existingChannels.put(channelName, rc);
        }
        return rc;
    }

    protected abstract Channel createChannel(ChannelData var1) throws ChannelException;

    public synchronized void removeChannel(String channelName) {
        this.existingChannels.remove(channelName);
    }

    public Map<Object, Object> getProperties() {
        return this.commonProperties;
    }
}

