/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.webcontainer.logging;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class LoggerHelper
extends Logger {
    private static boolean override = false;
    private static ClassLoader classloader = LoggerHelper.class.getClassLoader();
    private static String classname = LoggerHelper.class.getName();

    protected LoggerHelper(String arg0, String arg1) {
        super(arg0, arg1);
    }

    public static Logger getNewLogger(String name, String bundle) {
        if (override) {
            try {
                Class[] args = new Class[2];
                Class<?> clazz = classloader.loadClass(classname);
                args[0] = String.class;
                args[1] = String.class;
                Method m = clazz.getMethod("getNewLogger", args);
                Object[] arg = new Object[]{name, bundle};
                return (Logger)m.invoke(null, arg);
            }
            catch (ClassNotFoundException e) {
                return Logger.getLogger(name, bundle);
            }
            catch (NoSuchMethodException e) {
                return Logger.getLogger(name, bundle);
            }
            catch (IllegalAccessException e) {
                return Logger.getLogger(name, bundle);
            }
            catch (InvocationTargetException e) {
                return Logger.getLogger(name, bundle);
            }
        }
        return Logger.getLogger(name, bundle);
    }

    public static ClassLoader getClassloader() {
        return classloader;
    }

    public static void setClassloader(ClassLoader loader) {
        classloader = loader;
    }

    public static String getClassname() {
        return classname;
    }

    public static void setClassname(String name) {
        classname = name;
    }

    public static void setOverride(boolean value) {
        override = value;
    }

    public static void logParamsAndException(Logger l, Level lev, String methodClassName, String methodName, String message, Object[] p, Throwable t) {
        LogRecord logRecord = new LogRecord(lev, message);
        if (logRecord != null) {
            logRecord.setLoggerName(l.getName());
            logRecord.setResourceBundle(l.getResourceBundle());
            logRecord.setResourceBundleName(l.getResourceBundleName());
            logRecord.setSourceClassName(methodClassName);
            logRecord.setSourceMethodName(methodName);
            logRecord.setParameters(p);
            logRecord.setThrown(t);
            l.log(logRecord);
        }
    }
}

