/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.checkpoint.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.checkpoint.spi.CheckpointHook;
import io.openliberty.checkpoint.spi.CheckpointPhase;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleReference;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.FrameworkWiring;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(property={"io.openliberty.checkpoint.hook.multi.threaded:Boolean=true"})
public class CheckpointOSGiConsole
implements CheckpointHook {
    private final Bundle console;
    private final FrameworkWiring fwkWiring;
    static final long serialVersionUID = 6558009921780070026L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Activate
    public CheckpointOSGiConsole(@Reference(target="(!(io.openliberty.checkpoint=INACTIVE))") CheckpointPhase phase, BundleContext context) {
        Requirement consolePkg = new Requirement(){
            static final long serialVersionUID = 5399221301585088990L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            public Resource getResource() {
                return null;
            }

            public String getNamespace() {
                return "osgi.wiring.package";
            }

            public Map<String, String> getDirectives() {
                return Collections.singletonMap("filter", "(osgi.wiring.package=org.eclipse.equinox.console.common)");
            }

            public Map<String, Object> getAttributes() {
                return Collections.emptyMap();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"io.openliberty.checkpoint.internal.CheckpointOSGiConsole$1", 1.class, (String)"checkpoint", (String)"io.openliberty.checkpoint.resources.CheckpointMessages");
            }
        };
        this.fwkWiring = (FrameworkWiring)context.getBundle("System Bundle").adapt(FrameworkWiring.class);
        this.console = this.fwkWiring.findProviders(consolePkg).stream().findFirst().map(BundleCapability::getRevision).map(BundleReference::getBundle).orElse(null);
    }

    public void prepare() {
        if (this.console == null) {
            return;
        }
        try {
            this.console.stop();
            CountDownLatch refreshDone = new CountDownLatch(1);
            this.fwkWiring.refreshBundles(Collections.singleton(this.console), new FrameworkListener[]{e -> refreshDone.countDown()});
            refreshDone.await(30L, TimeUnit.SECONDS);
        }
        catch (BundleException refreshDone) {
            FFDCFilter.processException((Throwable)refreshDone, (String)"io.openliberty.checkpoint.internal.CheckpointOSGiConsole", (String)"91", (Object)this, (Object[])new Object[0]);
        }
        catch (InterruptedException refreshDone) {
            FFDCFilter.processException((Throwable)refreshDone, (String)"io.openliberty.checkpoint.internal.CheckpointOSGiConsole", (String)"94", (Object)this, (Object[])new Object[0]);
            Thread.currentThread().interrupt();
        }
    }

    public void restore() {
        if (this.console == null) {
            return;
        }
        try {
            this.console.start();
        }
        catch (BundleException bundleException) {
            FFDCFilter.processException((Throwable)bundleException, (String)"io.openliberty.checkpoint.internal.CheckpointOSGiConsole", (String)"107", (Object)this, (Object[])new Object[0]);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.openliberty.checkpoint.internal.CheckpointOSGiConsole", CheckpointOSGiConsole.class, (String)"checkpoint", (String)"io.openliberty.checkpoint.resources.CheckpointMessages");
    }
}

