/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.security.common.jwt.jws;

import com.ibm.websphere.ras.ProtectedString;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.common.http.HttpUtils;
import com.ibm.ws.security.common.jwk.impl.JWKSet;
import com.ibm.ws.security.common.jwk.impl.JwKRetriever;
import io.openliberty.security.common.jwt.exceptions.SharedKeyMissingException;
import io.openliberty.security.common.jwt.exceptions.UnsupportedSignatureAlgorithmException;
import io.openliberty.security.common.jwt.jwk.RemoteJwkData;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.Key;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.http.NameValuePair;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwx.JsonWebStructure;
import org.jose4j.keys.HmacKey;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class JwsVerificationKeyHelper {
    public static final Set<String> SUPPORTED_SIGNATURE_ALGORITHMS;
    private String clientId;
    @Sensitive
    private ProtectedString clientSecret;
    private RemoteJwkData remoteJwkData;
    private JWKSet jwkSet;
    static final long serialVersionUID = 4533906498012938390L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    private JwsVerificationKeyHelper(Builder builder) {
        this.clientId = builder.clientId;
        this.clientSecret = builder.clientSecret;
        this.remoteJwkData = builder.remoteJwkData;
        this.jwkSet = builder.jwkSet;
    }

    public Key getVerificationKey(JsonWebStructure jws) throws Exception {
        String signatureAlgorithmFromJws = this.getSignatureAlgorithmFromJws(jws);
        if (signatureAlgorithmFromJws != null && signatureAlgorithmFromJws.startsWith("HS")) {
            return this.getSharedKey();
        }
        return this.retrievePublicKey(jws, signatureAlgorithmFromJws);
    }

    String getSignatureAlgorithmFromJws(JsonWebStructure jws) throws UnsupportedSignatureAlgorithmException {
        String algorithm = null;
        if (jws != null && jws instanceof JsonWebSignature) {
            algorithm = ((JsonWebSignature)jws).getAlgorithmHeaderValue();
        }
        if (SUPPORTED_SIGNATURE_ALGORITHMS.contains(algorithm)) {
            return algorithm;
        }
        throw new UnsupportedSignatureAlgorithmException(algorithm);
    }

    Key getSharedKey() throws SharedKeyMissingException, UnsupportedEncodingException {
        if (this.clientSecret == null || this.clientSecret.isEmpty()) {
            throw new SharedKeyMissingException();
        }
        String clientSecretProtectedString = new String(this.clientSecret.getChars());
        return new HmacKey(clientSecretProtectedString.getBytes("UTF-8"));
    }

    Key retrievePublicKey(JsonWebStructure jws, String signatureAlgorithmFromJws) throws IOException, Exception {
        String kid = jws.getKeyIdHeaderValue();
        String x5t = jws.getX509CertSha1ThumbprintHeaderValue();
        JwKRetriever jwkRetriever = this.createJwkRetriever(signatureAlgorithmFromJws);
        return jwkRetriever.getPublicKeyFromJwk(kid, x5t, "sig", false);
    }

    JwKRetriever createJwkRetriever(String signatureAlgorithmFromJws) throws Exception {
        JwKRetriever jwkRetriever = new JwKRetriever(this.clientId, null, this.remoteJwkData.getJwksUri(), this.jwkSet, this.remoteJwkData.getSslSupport(), false, null, null, signatureAlgorithmFromJws);
        jwkRetriever.httpUtils = new HttpUtils(){
            static final long serialVersionUID = -727949461797227429L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            public HttpGet createHttpGetMethod(String url, List<NameValuePair> commonHeaders) {
                HttpGet request = super.createHttpGetMethod(url, commonHeaders);
                RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(JwsVerificationKeyHelper.this.remoteJwkData.getJwksConnectTimeout()).setSocketTimeout(JwsVerificationKeyHelper.this.remoteJwkData.getJwksReadTimeout()).build();
                request.setConfig(requestConfig);
                return request;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"io.openliberty.security.common.jwt.jws.JwsVerificationKeyHelper$1", 1.class, null, null);
            }
        };
        return jwkRetriever;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.openliberty.security.common.jwt.jws.JwsVerificationKeyHelper", JwsVerificationKeyHelper.class, null, null);
        HashSet<String> supportedAlgorithms = new HashSet<String>();
        supportedAlgorithms.add("RS256");
        supportedAlgorithms.add("RS384");
        supportedAlgorithms.add("RS512");
        supportedAlgorithms.add("HS256");
        supportedAlgorithms.add("HS384");
        supportedAlgorithms.add("HS512");
        supportedAlgorithms.add("ES256");
        supportedAlgorithms.add("ES384");
        supportedAlgorithms.add("ES512");
        SUPPORTED_SIGNATURE_ALGORITHMS = Collections.unmodifiableSet(supportedAlgorithms);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public static class Builder {
        private String clientId;
        @Sensitive
        private ProtectedString clientSecret;
        private RemoteJwkData remoteJwkData;
        private JWKSet jwkSet;
        static final long serialVersionUID = -1457509693717071405L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public Builder clientSecret(@Sensitive ProtectedString clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public Builder remoteJwkData(RemoteJwkData remoteJwkData) {
            this.remoteJwkData = remoteJwkData;
            return this;
        }

        public Builder jwkSet(JWKSet jwkSet) {
            this.jwkSet = jwkSet;
            return this;
        }

        public JwsVerificationKeyHelper build() {
            return new JwsVerificationKeyHelper(this);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.openliberty.security.common.jwt.jws.JwsVerificationKeyHelper$Builder", Builder.class, null, null);
        }
    }
}

