/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.context.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.SecurityService;
import com.ibm.ws.security.authentication.AuthenticationException;
import com.ibm.ws.security.authentication.UnauthenticatedSubjectService;
import com.ibm.ws.security.authentication.helper.AuthenticateUserHelper;
import com.ibm.ws.security.authentication.principals.WSPrincipal;
import com.ibm.ws.security.authentication.utility.SubjectHelper;
import com.ibm.ws.security.context.SubjectManager;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.threadcontext.ThreadContext;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.util.Hashtable;
import java.util.Set;
import javax.security.auth.Subject;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class SecurityContextImpl
implements ThreadContext {
    private static final long serialVersionUID = 2674866355469888259L;
    private static final TraceComponent tc = Tr.register(SecurityContextImpl.class, (String)"security", (String)"com.ibm.ws.security.context.internal.resources.SecurityContextMessages");
    protected static final String DESERIALIZE_LOGINCONTEXT_DEFAULT = "system.DESERIALIZE_CONTEXT";
    private static final String CALLER_PRINCIPAL = "C";
    private static final String INVOCATION_PRINCIPAL = "I";
    private static final String SUBJECTS_ARE_EQUAL = "E";
    private static final String JAAS_LOGIN_CONTEXT = "J";
    private static final String CALLER_SUBJECT_CACHE_KEY = "CK";
    private static final String INVOCATION_SUBJECT_CACHE_KEY = "IK";
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("C", WSPrincipal.class), new ObjectStreamField("I", WSPrincipal.class), new ObjectStreamField("E", Boolean.TYPE), new ObjectStreamField("J", String.class), new ObjectStreamField("CK", String.class), new ObjectStreamField("IK", String.class)};
    private static final String SEC_CONTEXT_UNABLE_TO_SERIALIZE = "SEC_CONTEXT_DESERIALIZE_AUTHN_ERROR";
    protected WSPrincipal invocationPrincipal = null;
    protected WSPrincipal callerPrincipal = null;
    private boolean subjectsAreEqual = false;
    private String jaasLoginContextEntry = null;
    protected transient Subject invocationSubject = null;
    protected transient Subject callerSubject = null;
    private transient Subject prevInvocationSubject = null;
    private transient Subject prevCallerSubject = null;
    private transient SubjectManager subjectManager = null;
    protected transient SubjectHelper subjectHelper = null;
    private String callerSubjectCacheKey = null;
    private String invocationSubjectCacheKey = null;

    @ManualTrace
    public SecurityContextImpl(boolean captureCurrentThreadContext, String jaasLoginContextEntry) {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object[])new Object[]{captureCurrentThreadContext, jaasLoginContextEntry});
        }
        this.jaasLoginContextEntry = jaasLoginContextEntry;
        this.subjectManager = new SubjectManager();
        this.subjectHelper = new SubjectHelper();
        if (captureCurrentThreadContext) {
            this.invocationSubject = this.subjectManager.getInvocationSubject();
            this.callerSubject = this.subjectManager.getCallerSubject();
        }
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"<init>", (Object)new Object[]{"caller/invocation subjects", this.callerSubject, this.invocationSubject});
        }
    }

    /*
     * WARNING - void declaration
     */
    @Trivial
    public ThreadContext clone() {
        try {
            SecurityContextImpl copy = (SecurityContextImpl)super.clone();
            copy.prevCallerSubject = null;
            copy.prevInvocationSubject = null;
            return copy;
        }
        catch (CloneNotSupportedException copy) {
            void x;
            FFDCFilter.processException((Throwable)copy, (String)"com.ibm.ws.security.context.internal.SecurityContextImpl", (String)"204", (Object)this, (Object[])new Object[0]);
            throw new RuntimeException((Throwable)x);
        }
    }

    @Trivial
    public void taskStarting() {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        this.prevInvocationSubject = this.subjectManager.getInvocationSubject();
        this.prevCallerSubject = this.subjectManager.getCallerSubject();
        if (trace && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"previous caller/invocation subjects", (Object[])new Object[]{this.prevCallerSubject, this.prevInvocationSubject});
        }
        this.subjectManager.setInvocationSubject(this.invocationSubject);
        this.subjectManager.setCallerSubject(this.callerSubject);
        if (trace && tc.isDebugEnabled()) {
            if (this.callerSubject == null && this.invocationSubject == null) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"clear", (Object[])new Object[0]);
            } else {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"propagate caller/invocation subjects", (Object[])new Object[]{this.callerSubject, this.invocationSubject});
            }
        }
    }

    @Trivial
    public void taskStopping() {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"restore   caller/invocation subjects", (Object[])new Object[]{this.prevCallerSubject, this.prevInvocationSubject});
        }
        this.subjectManager.setCallerSubject(this.prevCallerSubject);
        this.subjectManager.setInvocationSubject(this.prevInvocationSubject);
    }

    private boolean areSubjectsEqual(Subject subj1, Subject subj2) {
        return subj1 == subj2;
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    private void writeObject(ObjectOutputStream out) throws IOException {
        boolean trace;
        block8: {
            trace = TraceComponent.isAnyTracingEnabled();
            if (trace && tc.isEntryEnabled()) {
                Tr.entry((Object)this, (TraceComponent)tc, (String)"writeObject", (Object[])new Object[]{"caller/invocation subjects:", this.callerSubject, this.invocationSubject, "jaasLoginContextEntry:", this.jaasLoginContextEntry});
            }
            ObjectOutputStream.PutField fields = out.putFields();
            if (this.callerSubject != null && !this.subjectHelper.isUnauthenticated(this.callerSubject)) {
                fields.put(CALLER_PRINCIPAL, this.getWSPrincipal(this.callerSubject));
            }
            this.subjectsAreEqual = this.areSubjectsEqual(this.callerSubject, this.invocationSubject);
            fields.put(SUBJECTS_ARE_EQUAL, this.subjectsAreEqual);
            if (!this.subjectsAreEqual && this.invocationSubject != null && !this.subjectHelper.isUnauthenticated(this.invocationSubject)) {
                fields.put(INVOCATION_PRINCIPAL, this.getWSPrincipal(this.invocationSubject));
            }
            if (this.jaasLoginContextEntry != null) {
                fields.put(JAAS_LOGIN_CONTEXT, this.jaasLoginContextEntry);
            }
            try {
                this.serializeSubjectCacheKey(fields);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.context.internal.SecurityContextImpl", (String)"291", (Object)this, (Object[])new Object[]{out});
                if (tc.isDebugEnabled()) {
                    void e;
                    Tr.debug((TraceComponent)tc, (String)("Unable to serialize Subject Cache Key: " + e.getMessage()), (Object[])new Object[0]);
                }
                if (!tc.isWarningEnabled()) break block8;
                Tr.warning((TraceComponent)tc, (String)SEC_CONTEXT_UNABLE_TO_SERIALIZE, (Object[])new Object[0]);
            }
        }
        out.writeFields();
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"writeObject", (Object)new Object[]{"subjects are equal: ", this.subjectsAreEqual});
        }
    }

    @ManualTrace
    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"readObject", (Object[])new Object[0]);
        }
        ObjectInputStream.GetField fields = in.readFields();
        this.readState(fields);
        this.subjectManager = new SubjectManager();
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"readObject", (Object)new Object[]{"deserialized caller/invocation principals: ", this.callerPrincipal, this.invocationPrincipal, "subjects are equal? ", this.subjectsAreEqual, "jaasLoginContextEntry: ", this.jaasLoginContextEntry});
        }
    }

    private void readState(ObjectInputStream.GetField fields) throws IOException {
        this.callerPrincipal = (WSPrincipal)fields.get(CALLER_PRINCIPAL, null);
        this.subjectsAreEqual = fields.get(SUBJECTS_ARE_EQUAL, false);
        this.invocationPrincipal = !this.subjectsAreEqual ? (WSPrincipal)fields.get(INVOCATION_PRINCIPAL, null) : this.callerPrincipal;
        this.jaasLoginContextEntry = (String)fields.get(JAAS_LOGIN_CONTEXT, null);
        this.callerSubjectCacheKey = (String)fields.get(CALLER_SUBJECT_CACHE_KEY, null);
        this.invocationSubjectCacheKey = (String)fields.get(INVOCATION_SUBJECT_CACHE_KEY, null);
    }

    @FFDCIgnore(value={AuthenticationException.class})
    protected Subject recreateFullSubject(WSPrincipal wsPrincipal, SecurityService securityService, AtomicServiceReference<UnauthenticatedSubjectService> unauthenticatedSubjectServiceRef, String customCacheKey) {
        Subject subject = null;
        if (wsPrincipal != null) {
            String userName = wsPrincipal.getName();
            AuthenticateUserHelper authHelper = new AuthenticateUserHelper();
            if (this.jaasLoginContextEntry == null) {
                this.jaasLoginContextEntry = DESERIALIZE_LOGINCONTEXT_DEFAULT;
            }
            try {
                subject = authHelper.authenticateUser(securityService.getAuthenticationService(), userName, this.jaasLoginContextEntry, customCacheKey);
            }
            catch (AuthenticationException e) {
                Tr.error((TraceComponent)tc, (String)SEC_CONTEXT_UNABLE_TO_SERIALIZE, (Object[])new Object[]{e.getLocalizedMessage()});
            }
        }
        if (subject == null) {
            subject = ((UnauthenticatedSubjectService)unauthenticatedSubjectServiceRef.getService()).getUnauthenticatedSubject();
        }
        return subject;
    }

    protected WSPrincipal getWSPrincipal(Subject subject) throws IOException {
        Set<WSPrincipal> principals;
        WSPrincipal wsPrincipal = null;
        Set<WSPrincipal> set = principals = subject != null ? subject.getPrincipals(WSPrincipal.class) : null;
        if (principals != null && !principals.isEmpty()) {
            if (principals.size() > 1) {
                String principalNames = null;
                for (WSPrincipal principal : principals) {
                    if (principalNames == null) {
                        principalNames = principal.getName();
                        continue;
                    }
                    principalNames = principalNames + ", " + principal.getName();
                }
                throw new IOException(Tr.formatMessage((TraceComponent)tc, (String)"SEC_CONTEXT_DESERIALIZE_TOO_MANY_PRINCIPALS", (Object[])new Object[]{principalNames}));
            }
            wsPrincipal = principals.iterator().next();
        }
        return wsPrincipal;
    }

    protected void recreateFullSubjects(SecurityService securityService, AtomicServiceReference<UnauthenticatedSubjectService> unauthenticatedSubjectServiceRef) {
        this.callerSubject = this.recreateFullSubject(this.callerPrincipal, securityService, unauthenticatedSubjectServiceRef, this.callerSubjectCacheKey);
        this.invocationSubject = !this.subjectsAreEqual ? this.recreateFullSubject(this.invocationPrincipal, securityService, unauthenticatedSubjectServiceRef, this.invocationSubjectCacheKey) : this.callerSubject;
    }

    private void serializeSubjectCacheKey(ObjectOutputStream.PutField fields) throws Exception {
        Hashtable hashtable;
        if (this.callerSubject != null && (hashtable = this.subjectHelper.getHashtableFromSubject(this.callerSubject, new String[]{"com.ibm.wsspi.security.cred.cacheKey"})) != null) {
            this.callerSubjectCacheKey = (String)hashtable.get("com.ibm.wsspi.security.cred.cacheKey");
        }
        if (this.callerSubjectCacheKey != null) {
            fields.put(CALLER_SUBJECT_CACHE_KEY, this.callerSubjectCacheKey);
        }
        if (!this.subjectsAreEqual && this.invocationSubject != null && (hashtable = this.subjectHelper.getHashtableFromSubject(this.invocationSubject, new String[]{"com.ibm.wsspi.security.cred.cacheKey"})) != null) {
            this.invocationSubjectCacheKey = (String)hashtable.get("com.ibm.wsspi.security.cred.cacheKey");
        }
        if (this.invocationSubjectCacheKey != null) {
            fields.put(INVOCATION_SUBJECT_CACHE_KEY, this.invocationSubjectCacheKey);
        }
    }

    @Trivial
    public String toString() {
        StringBuilder sb = new StringBuilder(100).append(this.getClass().getSimpleName()).append('@').append(Integer.toHexString(this.hashCode())).append(' ').append(this.callerSubject == null ? null : this.callerSubject.getPrincipals()).append(' ').append(this.invocationSubject == null ? null : this.invocationSubject.getPrincipals());
        return sb.toString();
    }
}

