/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.injection.producer;

import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import org.jboss.weld.annotated.slim.SlimAnnotatedType;
import org.jboss.weld.construction.api.AroundConstructCallback;
import org.jboss.weld.construction.api.ConstructionHandle;
import org.jboss.weld.context.CreationalContextImpl;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.injection.producer.ForwardingInstantiator;
import org.jboss.weld.injection.producer.Instantiator;
import org.jboss.weld.interceptor.proxy.InterceptionContext;
import org.jboss.weld.interceptor.proxy.InterceptorMethodInvocation;
import org.jboss.weld.interceptor.proxy.WeldInvocationContextImpl;
import org.jboss.weld.interceptor.spi.model.InterceptionModel;
import org.jboss.weld.logging.InterceptorLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.reflection.Reflections;

public class ConstructorInterceptionInstantiator<T>
extends ForwardingInstantiator<T> {
    private final InterceptionModel model;
    private final SlimAnnotatedType<?> annotatedType;

    public ConstructorInterceptionInstantiator(Instantiator<T> delegate, InterceptionModel model, SlimAnnotatedType<?> type) {
        super(delegate);
        this.model = model;
        this.annotatedType = type;
    }

    @Override
    public T newInstance(CreationalContext<T> ctx, BeanManagerImpl manager) {
        CreationalContextImpl weldCtx;
        if (ctx instanceof CreationalContextImpl && !(weldCtx = (CreationalContextImpl)Reflections.cast(ctx)).isConstructorInterceptionSuppressed()) {
            this.registerAroundConstructCallback(weldCtx, manager);
        }
        return this.delegate().newInstance(ctx, manager);
    }

    private void registerAroundConstructCallback(CreationalContextImpl<T> ctx, BeanManagerImpl manager) {
        final InterceptionContext interceptionContext = InterceptionContext.forConstructorInterception(this.model, ctx, manager, this.annotatedType);
        AroundConstructCallback callback = new AroundConstructCallback<T>(){

            @Override
            public T aroundConstruct(final ConstructionHandle<T> handle, AnnotatedConstructor<T> constructor, Object[] parameters, Map<String, Object> data) {
                final AtomicReference target = new AtomicReference();
                List<InterceptorMethodInvocation> chain = interceptionContext.buildInterceptorMethodInvocationsForConstructorInterception();
                WeldInvocationContextImpl invocationContext = new WeldInvocationContextImpl(constructor.getJavaMember(), parameters, data, chain, ConstructorInterceptionInstantiator.this.model.getMemberInterceptorBindings(ConstructorInterceptionInstantiator.this.getConstructor())){

                    @Override
                    protected Object interceptorChainCompleted() throws Exception {
                        Object instance = handle.proceed(this.getParameters(), this.getContextData());
                        target.set(instance);
                        return null;
                    }

                    @Override
                    public Object getTarget() {
                        return target.get();
                    }
                };
                try {
                    invocationContext.proceed();
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new WeldException(e);
                }
                Object instance = target.get();
                if (instance == null) {
                    throw InterceptorLogger.LOG.targetInstanceNotCreated(constructor);
                }
                return instance;
            }
        };
        ctx.registerAroundConstructCallback(callback);
        ctx.setAroundConstructInterceptionContext(interceptionContext);
    }

    public String toString() {
        return "ConstructorInterceptionInstantiator wrapping " + this.delegate();
    }
}

