/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.validation.Path;
import org.apache.bval.jsr.util.NodeImpl;
import org.apache.bval.jsr.util.PathNavigation;

public class PathImpl
implements Path,
Serializable {
    private static final long serialVersionUID = 1L;
    static final String PROPERTY_PATH_SEPARATOR = ".";
    private final List<Path.Node> nodeList = new ArrayList<Path.Node>();

    public static PathImpl createPathFromString(String propertyPath) {
        if (propertyPath == null || propertyPath.length() == 0) {
            return PathImpl.create();
        }
        return PathNavigation.navigateAndReturn(propertyPath, new PathImplBuilder());
    }

    public static PathImpl create() {
        PathImpl path = new PathImpl();
        NodeImpl.BeanNodeImpl node = new NodeImpl.BeanNodeImpl();
        path.addNode(node);
        return path;
    }

    public static PathImpl copy(Path path) {
        return path == null ? null : new PathImpl(path);
    }

    private PathImpl(Path path) {
        for (Object aPath : path) {
            this.nodeList.add(PathImpl.newNode((Path.Node)Path.Node.class.cast(aPath)));
        }
    }

    private static Path.Node newNode(Path.Node cast) {
        if (Path.PropertyNode.class.isInstance(cast)) {
            return new NodeImpl.PropertyNodeImpl(cast);
        }
        if (Path.BeanNode.class.isInstance(cast)) {
            return new NodeImpl.BeanNodeImpl(cast);
        }
        if (Path.MethodNode.class.isInstance(cast)) {
            return new NodeImpl.MethodNodeImpl(cast);
        }
        if (Path.ConstructorNode.class.isInstance(cast)) {
            return new NodeImpl.ConstructorNodeImpl(cast);
        }
        if (Path.ConstructorNode.class.isInstance(cast)) {
            return new NodeImpl.ConstructorNodeImpl(cast);
        }
        if (Path.ReturnValueNode.class.isInstance(cast)) {
            return new NodeImpl.ReturnValueNodeImpl(cast);
        }
        if (Path.ParameterNode.class.isInstance(cast)) {
            return new NodeImpl.ParameterNodeImpl(cast);
        }
        if (Path.CrossParameterNode.class.isInstance(cast)) {
            return new NodeImpl.CrossParameterNodeImpl(cast);
        }
        return new NodeImpl(cast);
    }

    private PathImpl() {
    }

    private PathImpl(List<Path.Node> nodeList) {
        for (Path.Node node : nodeList) {
            this.nodeList.add(new NodeImpl(node));
        }
    }

    public boolean isRootPath() {
        if (this.nodeList.size() != 1) {
            return false;
        }
        Path.Node first = this.nodeList.get(0);
        return !first.isInIterable() && first.getName() == null;
    }

    public PathImpl getPathWithoutLeafNode() {
        ArrayList<Path.Node> nodes = new ArrayList<Path.Node>(this.nodeList);
        PathImpl path = null;
        if (nodes.size() > 1) {
            nodes.remove(nodes.size() - 1);
            path = new PathImpl(nodes);
        }
        return path;
    }

    public void addNode(Path.Node node) {
        if (this.isRootPath()) {
            this.nodeList.set(0, node);
        } else {
            this.nodeList.add(node);
        }
    }

    public void addProperty(String name) {
        NodeImpl leaf;
        if (!this.nodeList.isEmpty() && (leaf = this.getLeafNode()) != null && leaf.isInIterable() && leaf.getName() == null) {
            if (!Path.PropertyNode.class.isInstance(leaf)) {
                NodeImpl.PropertyNodeImpl tmp = new NodeImpl.PropertyNodeImpl(leaf);
                this.removeLeafNode();
                this.addNode(tmp);
                leaf = tmp;
            }
            leaf.setName(name);
            return;
        }
        NodeImpl node = "<cross-parameter>".equals(name) ? new NodeImpl.CrossParameterNodeImpl() : new NodeImpl.PropertyNodeImpl(name);
        this.addNode(node);
    }

    public Path.Node removeLeafNode() {
        if (this.isRootPath() || this.nodeList.size() == 0) {
            throw new IllegalStateException("No nodes in path!");
        }
        try {
            Path.Node node = this.nodeList.remove(this.nodeList.size() - 1);
            return node;
        }
        finally {
            if (this.nodeList.isEmpty()) {
                this.nodeList.add(new NodeImpl((String)null));
            }
        }
    }

    public NodeImpl getLeafNode() {
        if (this.nodeList.size() == 0) {
            return null;
        }
        return (NodeImpl)this.nodeList.get(this.nodeList.size() - 1);
    }

    public Iterator<Path.Node> iterator() {
        return this.nodeList.iterator();
    }

    public boolean isSubPathOf(Path path) {
        if (path instanceof PathImpl && ((PathImpl)path).isRootPath()) {
            return true;
        }
        Iterator pathIter = path.iterator();
        Iterator<Path.Node> thisIter = this.iterator();
        while (pathIter.hasNext()) {
            Path.Node pathNode = (Path.Node)pathIter.next();
            if (!thisIter.hasNext()) {
                return false;
            }
            Path.Node thisNode = thisIter.next();
            if (pathNode.isInIterable()) {
                if (!thisNode.isInIterable()) {
                    return false;
                }
                if (pathNode.getIndex() != null && !pathNode.getIndex().equals(thisNode.getIndex())) {
                    return false;
                }
                if (pathNode.getKey() != null && !pathNode.getKey().equals(thisNode.getKey())) {
                    return false;
                }
            } else if (thisNode.isInIterable()) {
                return false;
            }
            if (pathNode.getName() == null || pathNode.getName().equals(thisNode.getName())) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        Iterator<Path.Node> iterator = this.iterator();
        while (iterator.hasNext()) {
            Path.Node node = iterator.next();
            NodeImpl.appendNode(node, builder);
        }
        return builder.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PathImpl path = (PathImpl)o;
        return !(this.nodeList != null && !this.nodeList.equals(path.nodeList) || this.nodeList == null && path.nodeList != null);
    }

    public int hashCode() {
        return this.nodeList != null ? this.nodeList.hashCode() : 0;
    }

    private static class PathImplBuilder
    implements PathNavigation.Callback<PathImpl> {
        PathImpl result = new PathImpl();

        private PathImplBuilder() {
        }

        @Override
        public void handleProperty(String name) {
            this.result.addProperty(name);
        }

        @Override
        public void handleIndexOrKey(String value) {
            NodeImpl node;
            try {
                node = NodeImpl.atIndex(Integer.parseInt(value));
            }
            catch (NumberFormatException e) {
                node = NodeImpl.atKey(value);
            }
            this.result.addNode(node);
        }

        @Override
        public PathImpl result() {
            if (this.result.nodeList.isEmpty()) {
                throw new IllegalStateException();
            }
            return this.result;
        }

        @Override
        public void handleGenericInIterable() {
            this.result.addNode(NodeImpl.atIndex(null));
        }
    }
}

