/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.core;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ssl.core.WSPKCSInKeyStore;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;

public final class WSPKCSInKeyStoreList {
    private static final TraceComponent tc = Tr.register(WSPKCSInKeyStoreList.class, (String)"SSL", (String)"com.ibm.ws.ssl.resources.ssl");
    private static Vector<WSPKCSInKeyStore> theV = new Vector();

    public synchronized WSPKCSInKeyStore insert(String tokenType, String tokenlib, String tokenPwd, boolean askeystore, String keyStoreProvider) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"insert", (Object[])new Object[]{tokenType, tokenlib, keyStoreProvider});
        }
        WSPKCSInKeyStore pKS = this.insertedAlready(tokenlib);
        boolean already = false;
        if (pKS == null) {
            pKS = new WSPKCSInKeyStore(tokenlib, keyStoreProvider);
        } else {
            already = true;
        }
        if (askeystore) {
            pKS.asKeyStore(tokenType, tokenlib, tokenPwd);
        } else {
            pKS.asTrustStore(tokenType, tokenlib, tokenPwd);
        }
        if (!already) {
            theV.add(pKS);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"insert");
        }
        return pKS;
    }

    public WSPKCSInKeyStore getListElement(String tokenlib) {
        return this.insertedAlready(tokenlib);
    }

    public boolean contains(String tokenlib) {
        return null != this.insertedAlready(tokenlib);
    }

    private WSPKCSInKeyStore insertedAlready(String tokenlib) {
        WSPKCSInKeyStore pKS = null;
        WSPKCSInKeyStore rc = null;
        Enumeration<WSPKCSInKeyStore> e = theV.elements();
        while (null == rc && e.hasMoreElements()) {
            pKS = e.nextElement();
            if (tokenlib.equalsIgnoreCase(pKS.getlibName_key())) {
                rc = pKS;
                continue;
            }
            if (!tokenlib.equalsIgnoreCase(pKS.getlibName_trust())) continue;
            rc = pKS;
        }
        return rc;
    }

    public InputStream openKeyStore(String fileName) throws MalformedURLException, IOException {
        URL urlFile;
        InputStream fis;
        block10: {
            fis = null;
            urlFile = null;
            File kfile = null;
            try {
                kfile = new File(fileName);
            }
            catch (NullPointerException e) {
                throw new IOException();
            }
            try {
                if (kfile.exists()) {
                    if (kfile.length() == 0L) {
                        throw new IOException(fileName);
                    }
                    urlFile = new URL("file:" + kfile.getCanonicalPath());
                    break block10;
                }
                urlFile = new URL(fileName);
            }
            catch (SecurityException e) {
                throw new IOException(fileName);
            }
        }
        fis = urlFile.openStream();
        return fis;
    }
}

