/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.collective.utility.utils;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class CollectiveUtilityTraceFormatter
extends Formatter {
    private static final int dateTimeIndex = 0;
    private static final int threadIdIndex = 1;
    private static final int messageIndex = 2;
    private static final int paramsIndex = 3;
    private static final int throwableIndex = 4;
    private static final MessageFormat messageFormat = new MessageFormat("{0,date,MM/dd/yy hh:mm:ss:SSS z} {1} {2} {3}\n{4}");
    private final String headerPad = CollectiveUtilityTraceFormatter.fixedLenString("");

    @Override
    public String format(LogRecord logRecord) {
        Object[] arguments = new Object[5];
        arguments[0] = new Date(logRecord.getMillis());
        arguments[1] = (long)logRecord.getThreadID();
        arguments[2] = logRecord.getMessage();
        Object[] params = logRecord.getParameters();
        if (params != null) {
            StringBuilder finalString = new StringBuilder();
            for (int i = 0; i < params.length; ++i) {
                finalString = finalString.append("\n" + this.headerPad + params[i]);
            }
            arguments[3] = finalString.toString();
        } else {
            arguments[3] = "";
        }
        if (logRecord.getThrown() != null) {
            StringWriter result = new StringWriter();
            logRecord.getThrown().printStackTrace(new PrintWriter(result));
            arguments[4] = ((Object)result).toString();
        } else {
            arguments[4] = "";
        }
        return messageFormat.format(arguments);
    }

    private static String fixedLenString(String str) {
        int padLen = 30;
        return String.format("%1$" + padLen + "s", str);
    }
}

