/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jmx.connector.server.rest.handlers;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.json.java.JSON;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jmx.connector.server.rest.helpers.ErrorHelper;
import com.ibm.ws.jmx.connector.server.rest.helpers.FileTransferHelper;
import com.ibm.ws.jmx.connector.server.rest.helpers.RESTHelper;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.rest.handler.RESTHandler;
import com.ibm.wsspi.rest.handler.RESTRequest;
import com.ibm.wsspi.rest.handler.RESTResponse;
import com.ibm.wsspi.rest.handler.helper.RESTHandlerMethodNotAllowedError;
import java.io.IOException;
import java.io.InputStream;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={RESTHandler.class}, configurationPolicy=ConfigurationPolicy.IGNORE, immediate=true, property={"service.vendor=IBM", "com.ibm.wsspi.rest.handler.custom.routing=true", "com.ibm.wsspi.rest.handler.context.root=/IBMJMXConnectorREST", "com.ibm.wsspi.rest.handler.root=/file/collection"})
public class FileCollectionHandler
implements RESTHandler {
    public static final TraceComponent tc = Tr.register(FileCollectionHandler.class, (String)"jmx.rest.server.connector", (String)"com.ibm.ws.jmx.connector.server.internal.resources.FileTransferServerMessages");
    private final String KEY_FILE_TRANSFER_HELPER = "fileTransferHelper";
    private transient FileTransferHelper fileTransferHelper;
    private final AtomicServiceReference<FileTransferHelper> fileTransferHelperRef = new AtomicServiceReference("fileTransferHelper");
    static final long serialVersionUID = 554870216770783958L;

    @Activate
    protected void activate(ComponentContext context) {
        this.fileTransferHelperRef.activate(context);
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        this.fileTransferHelperRef.deactivate(context);
    }

    @Reference(name="fileTransferHelper", service=FileTransferHelper.class)
    protected void setFileTransferHelperRef(ServiceReference<FileTransferHelper> ref) {
        this.fileTransferHelperRef.setReference(ref);
    }

    protected void unsetFileTransferHelperRef(ServiceReference<FileTransferHelper> ref) {
        this.fileTransferHelperRef.unsetReference(ref);
    }

    public void handleRequest(RESTRequest request, RESTResponse response) {
        String method = request.getMethod();
        if (!RESTHelper.isPostMethod(method)) {
            throw new RESTHandlerMethodNotAllowedError("POST");
        }
        this.collectionAction(request, response);
    }

    /*
     * WARNING - void declaration
     */
    private void collectionAction(RESTRequest request, RESTResponse response) {
        RESTHelper.ensureConsumesJson(request);
        InputStream is = RESTHelper.getInputStream(request);
        try {
            JSONObject obj = (JSONObject)JSON.parse((InputStream)is);
            JSONArray filesArray = (JSONArray)obj.get((Object)"delete");
            int size = filesArray.size();
            if (size == 0) {
                return;
            }
            FileTransferHelper helper = this.getFileTransferHelper();
            boolean isSingleRouting = RESTHelper.containsSingleRoutingContext(request);
            for (int i = 0; i < size; ++i) {
                String fileToDelete = (String)filesArray.get(i);
                if (isSingleRouting) {
                    helper.routedDeleteInternal(request, fileToDelete, true);
                    continue;
                }
                helper.deleteInternal(fileToDelete, true);
            }
        }
        catch (NullPointerException obj) {
            void e;
            FFDCFilter.processException((Throwable)obj, (String)"com.ibm.ws.jmx.connector.server.rest.handlers.FileCollectionHandler", (String)"127", (Object)this, (Object[])new Object[]{request, response});
            throw ErrorHelper.createRESTHandlerJsonException((Throwable)e, null, 400);
        }
        catch (IOException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jmx.connector.server.rest.handlers.FileCollectionHandler", (String)"129", (Object)this, (Object[])new Object[]{request, response});
            throw ErrorHelper.createRESTHandlerJsonException(e, null, 400);
        }
        response.setStatus(204);
    }

    private synchronized FileTransferHelper getFileTransferHelper() {
        if (this.fileTransferHelper == null) {
            FileTransferHelper fileTransferHelper = this.fileTransferHelper = this.fileTransferHelperRef != null ? (FileTransferHelper)this.fileTransferHelperRef.getService() : null;
            if (this.fileTransferHelper == null) {
                IOException ioe = new IOException(TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.jmx.connector.server.internal.resources.FileTransferServerMessages", (String)"OSGI_SERVICE_ERROR", (Object[])new Object[]{"FileTransferHelper"}, (String)"CWWKX0122E: OSGi service is not available."));
                throw ErrorHelper.createRESTHandlerJsonException(ioe, null, 500);
            }
        }
        return this.fileTransferHelper;
    }
}

