/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.internal.impl;

import com.ibm.websphere.ras.TrConfigurator;
import com.ibm.ws.logging.internal.impl.LoggingConstants;
import java.io.PrintStream;

public class FileLogHeader {
    private final String header;
    private final boolean javaLangInstrument;
    private final boolean trace;
    private final boolean isJSON;

    public FileLogHeader(String header, boolean trace, boolean javaLangInstrument, boolean isJSON) {
        this.header = header;
        this.trace = trace;
        this.javaLangInstrument = javaLangInstrument;
        this.isJSON = isJSON;
    }

    private void process(Processor processor) {
        if (!this.isJSON) {
            processor.println("********************************************************************************");
        }
        processor.print(this.header);
        if (this.trace) {
            processor.println("trace.specification = " + TrConfigurator.getEffectiveTraceSpec());
            if (!this.javaLangInstrument) {
                processor.println("java.lang.instrument = " + this.javaLangInstrument);
            }
        }
        if (!this.isJSON) {
            processor.println("********************************************************************************");
        }
    }

    public void print(PrintStream ps) {
        this.process(new PrintProcessor(ps));
    }

    public long length() {
        LengthProcessor lengthProcessor = new LengthProcessor();
        this.process(lengthProcessor);
        return lengthProcessor.getLength();
    }

    class LengthProcessor
    implements Processor {
        long length;

        LengthProcessor() {
        }

        @Override
        public void print(String str) {
            this.length += (long)str.getBytes().length;
        }

        @Override
        public void println(String str) {
            this.length += (long)(str.getBytes().length + LoggingConstants.nlen);
        }

        long getLength() {
            return this.length;
        }
    }

    class PrintProcessor
    implements Processor {
        final PrintStream ps;

        public PrintProcessor(PrintStream ps) {
            this.ps = ps;
        }

        @Override
        public void println(String str) {
            this.ps.println(str);
        }

        @Override
        public void print(String str) {
            this.ps.print(str);
        }
    }

    static interface Processor {
        public void print(String var1);

        public void println(String var1);
    }
}

