/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.context.beanstore.http;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.context.beanstore.NamingScheme;
import org.jboss.weld.context.beanstore.http.AbstractSessionBeanStore;
import org.jboss.weld.logging.ContextLogger;
import org.jboss.weld.servlet.SessionHolder;

public class LazySessionBeanStore
extends AbstractSessionBeanStore {
    private final HttpServletRequest request;

    public LazySessionBeanStore(HttpServletRequest request, NamingScheme namingScheme, ServiceRegistry serviceRegistry) {
        this(request, namingScheme, true, serviceRegistry);
    }

    public LazySessionBeanStore(HttpServletRequest request, NamingScheme namingScheme, boolean attributeLazyFetchingEnabled, ServiceRegistry serviceRegistry) {
        super(namingScheme, attributeLazyFetchingEnabled, serviceRegistry);
        this.request = request;
        ContextLogger.LOG.loadingBeanStoreMapFromSession((Object)this, (Object)this.getSession(false));
    }

    protected HttpSession getSessionIfExists() {
        return SessionHolder.getSessionIfExists();
    }

    @Override
    protected HttpSession getSession(boolean create) {
        try {
            return SessionHolder.getSession((HttpServletRequest)this.request, (boolean)create);
        }
        catch (IllegalStateException e) {
            this.detach();
            return null;
        }
    }
}

